/*****************************************************************************
 * qt.cpp : Qt plugin for vlc
 *****************************************************************************
 * Copyright (C) 2001 VideoLAN
 * $Id: qt.cpp,v 1.2 2003/03/30 18:14:38 gbazin Exp $
 *
 * Authors: Samuel Hocevar <sam@zoy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

/*****************************************************************************
 * Preamble
 *****************************************************************************/
#include <stdlib.h>                                      /* malloc(), free() */
#include <string.h>

#include <vlc/vlc.h>

/*****************************************************************************
 * External prototypes
 *****************************************************************************/
int  E_(Open)  ( vlc_object_t * );
void E_(Close) ( vlc_object_t * );

/*****************************************************************************
 * Module descriptor
 *****************************************************************************/
vlc_module_begin();
#ifdef WIN32
    int i = 80;
#else
    int i = getenv( "DISPLAY" ) == NULL ? 7 : 80;
#endif
    set_description( _("Qt interface") );
    set_capability( "interface", i );
    set_program( "qvlc" );
    set_callbacks( E_(Open), E_(Close) );
vlc_module_end();

