/* getbits.c, bit level routines                                            */

/*
 * All modifications (mpeg2decode -> mpeg2play) are
 * Copyright (C) 1996, Stefan Eckart. All Rights Reserved.
 */

/* Copyright (C) 1996, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */

extern vdec_thread_t * kludge_vdec;

static __inline__ int Get_Word();
static __inline__ unsigned int Show_Bits(int N);
static __inline__ unsigned int Get_Bits32();
static __inline__ void Flush_Buffer_All();
static __inline__ void Flush_Buffer32();
static __inline__ unsigned int Get_Bits(int N);
static __inline__ void next_start_code();


/* MPEG-1 system layer demultiplexer */

#define Get_Byte() GetByte(&kludge_vdec->bit_stream);

/* extract a 16-bit word from the bitstream buffer */
static __inline__ int Get_Word()
{
  int Val;

  Val = Get_Byte();
  return (Val<<8) | Get_Byte();
}


/* return next n bits (right adjusted) without advancing */

static __inline__ unsigned int Show_Bits(N)
int N;
{
  NeedBits(&kludge_vdec->bit_stream, N);
  return kludge_vdec->bit_stream.fifo.buffer >> (32-N);
}


/* return next bit (could be made faster than Get_Bits(1)) */

#define Get_Bits1() Get_Bits(1)

static __inline__ unsigned int Get_Bits32()
{
    unsigned int val;
    val = Show_Bits(32);
    Flush_Buffer32();
    return val;
}


/* advance by n bits */

#define Flush_Buffer(N) DumpBits(&kludge_vdec->bit_stream, (N));

static __inline__ void Flush_Buffer_All()
{
    DumpBits(&kludge_vdec->bit_stream, kludge_vdec->bit_stream.fifo.i_available & 7);
}


/* return next n bits (right adjusted) */

static __inline__ void Flush_Buffer32()
{
    kludge_vdec->bit_stream.fifo.buffer = 0;
    kludge_vdec->bit_stream.fifo.i_available = 0;
}

static __inline__ unsigned int Get_Bits(N) {
    unsigned int Val;
    Val = Show_Bits(N);
    Flush_Buffer(N);
    return Val;
}

/* align to start of next next_start_code */
static __inline__ void next_start_code()
{
  /* byte align */
  Flush_Buffer_All();
  while (Show_Bits(24)!=0x01L && !kludge_vdec->b_die)
    Flush_Buffer(8);

}
