/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.support.v4.print.PrintHelperKitkat;
import java.io.FileNotFoundException;

public final class PrintHelper {
    public static final int SCALE_MODE_FIT = 1;
    public static final int SCALE_MODE_FILL = 2;
    public static final int COLOR_MODE_MONOCHROME = 1;
    public static final int COLOR_MODE_COLOR = 2;
    PrintHelperVersionImpl mImpl;

    public static boolean systemSupportsPrint() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public PrintHelper(Context context) {
        this.mImpl = PrintHelper.systemSupportsPrint() ? new PrintHelperKitkatImpl(context) : new PrintHelperStubImpl();
    }

    public void setScaleMode(int scaleMode) {
        this.mImpl.setScaleMode(scaleMode);
    }

    public int getScaleMode() {
        return this.mImpl.getScaleMode();
    }

    public void setColorMode(int colorMode) {
        this.mImpl.setColorMode(colorMode);
    }

    public int getColorMode() {
        return this.mImpl.getColorMode();
    }

    public void printBitmap(String jobName, Bitmap bitmap) {
        this.mImpl.printBitmap(jobName, bitmap);
    }

    public void printBitmap(String jobName, Uri imageFile) throws FileNotFoundException {
        this.mImpl.printBitmap(jobName, imageFile);
    }

    private static final class PrintHelperKitkatImpl
    implements PrintHelperVersionImpl {
        private final PrintHelperKitkat printHelper;

        PrintHelperKitkatImpl(Context context) {
            this.printHelper = new PrintHelperKitkat(context);
        }

        public void setScaleMode(int scaleMode) {
            this.printHelper.setScaleMode(scaleMode);
        }

        public int getScaleMode() {
            return this.printHelper.getScaleMode();
        }

        public void setColorMode(int colorMode) {
            this.printHelper.setColorMode(colorMode);
        }

        public int getColorMode() {
            return this.printHelper.getColorMode();
        }

        public void printBitmap(String jobName, Bitmap bitmap) {
            this.printHelper.printBitmap(jobName, bitmap);
        }

        public void printBitmap(String jobName, Uri imageFile) throws FileNotFoundException {
            this.printHelper.printBitmap(jobName, imageFile);
        }
    }

    private static final class PrintHelperStubImpl
    implements PrintHelperVersionImpl {
        int mScaleMode = 2;
        int mColorMode = 2;

        private PrintHelperStubImpl() {
        }

        public void setScaleMode(int scaleMode) {
            this.mScaleMode = scaleMode;
        }

        public int getColorMode() {
            return this.mColorMode;
        }

        public void setColorMode(int colorMode) {
            this.mColorMode = colorMode;
        }

        public int getScaleMode() {
            return this.mScaleMode;
        }

        public void printBitmap(String jobName, Bitmap bitmap) {
        }

        public void printBitmap(String jobName, Uri imageFile) {
        }
    }

    static interface PrintHelperVersionImpl {
        public void setScaleMode(int var1);

        public int getScaleMode();

        public void setColorMode(int var1);

        public int getColorMode();

        public void printBitmap(String var1, Bitmap var2);

        public void printBitmap(String var1, Uri var2) throws FileNotFoundException;
    }
}

