#! /bin/sh

# This script is used to prepare the package for Qt4
#
# 1/ Download the source win32 zip
# 2/ Extrac it
# 3/ Compile Qt
#   * Install mingw
#   * Extract Qt source zipball to a folder *without any space in the name*
#   * copy src/corelib and src/gui
#   * run "cmd"
#   * set QMAKESPEC=win32-g++
#   * configure -static -release -no-qt3support -no-dsp -no-vcproj -platform win32-g++ -no-gif -no-libmng -no-libjpeg -no-style-plastique -no-style-motif -no-style-cde -no-exceptions -no-rtti
#   * make sub-src
#   * copy include/QtCore and include/QtGui
#   * copy lib/libQtCore* lib/libQtGui*

# 4/ Copy the needed files to make the layout like this :
#    (not yet automated)
#   include/
#       qt4/
#          QtCore/
#           QtGui/
#           src/
#               corelib/
#               gui/
#   lib/
#
# 5/ Copy this script in the directory with include/ and lib/
# 6/ Run it with VERSION as argument
# 7/ You now have a qt4-$VERSION-win32-bin.tar.gz in ../

VERSION=$1
echo "[+] Fixing include pathes"
# 1 / Fix the paths in the include files
for file in `find include/qt4/QtCore -type f -name '*h'` `find include/qt4/QtGui -type f -name '*h'`
do
    mv $file $file.tmp
    sed 's,..\/..\/src,..\/src,' $file.tmp > $file
    rm -f $file.tmp
done

# 2/ Remove the source files
echo "[+] Removing source files"
find include/qt4/src/corelib -name "*cpp"|xargs rm
find include/qt4/src/gui -name "*cpp"|xargs rm

# 3/ Create the PC files
echo "[+] Creating pkgconfig files"
mkdir -p lib/pkgconfig
rm -f lib/pkgconfig/QtCore.pc.in
cat > lib/pkgconfig/QtCore.pc.in << EOF
prefix=@@PREFIX@@
exec_prefix=\${prefix}
libdir=\${prefix}/lib
includedir=\${prefix}/include/qt4/QtCore

Name: Qtcore
Description: Qtcore Library
Version: $VERSION
Libs: -Wl,--subsystem,windows -mwindows -L\${libdir} -lQtCore -lrpcrt4 -loleaut32 -lole32 -luuid -lwinspool -lwinmm -lshell32 -lcomctl32 -ladvapi32 -lgdi32 -limm32 -lwsock32  
Cflags:  -I\${prefix}/include/qt4 -I\${includedir} -DQT_NODLL
EOF

rm -f lib/pkgconfig/QtGui.pc.in
cat > lib/pkgconfig/QtGui.pc.in << EOF
prefix=@@PREFIX@@
exec_prefix=\${prefix}
libdir=\${prefix}/lib
includedir=\${prefix}/include/qt4/QtGui

Name: Qtgui
Description: Qtgui Library
Version: $VERSION
Libs: -Wl,--subsystem,windows -mwindows -L\${libdir} -lQtGui -lQtCore -lrpcrt4 -loleaut32 -lole32 -luuid -lwinspool -lwinmm -lshell32 -lcomctl32 -lcomdlg32 -ladvapi32 -lgdi32 -limm32 -lwsock32  
Cflags: -I\${prefix}/include/qt4 -I\${includedir} -DQT_NODLL
EOF

# 4/ Keep the script
echo "[+] Copying scripts"
mkdir -p bin
cp $0 bin/
cp /usr/bin/moc-qt4 bin/moc
cp /usr/bin/uic-qt4 bin/uic
cp /usr/bin/rcc bin/rcc

# 5/ create packages
echo "[+] Creating tarball"
rm -rf qt4-$VERSION-win32-bin
mkdir qt4-$VERSION-win32-bin
cp -r include bin lib qt4-$VERSION-win32-bin
tar cz qt4-$VERSION-win32-bin > qt4-$VERSION-win32-bin.tar.gz
