/* ext-storage-monitor.c generated by valac 0.38.8, the Vala compiler
 * generated from ext-storage-monitor.vala, do not modify */

/* ds-registry.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Stefano Candori <stefano.candori@gmail.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * Based upon a Python implementation:
 *  Copyright © 2009 Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Copyright © 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-engine.h"
#include "zeitgeist-internal.h"
#include <sqlite3.h>
#include "zeitgeist-datamodel.h"
#include "zeitgeist.h"


#define ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR (zeitgeist_remote_storage_monitor_get_type ())
#define ZEITGEIST_REMOTE_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, ZeitgeistRemoteStorageMonitor))
#define ZEITGEIST_IS_REMOTE_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR))
#define ZEITGEIST_REMOTE_STORAGE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, ZeitgeistRemoteStorageMonitorIface))

typedef struct _ZeitgeistRemoteStorageMonitor ZeitgeistRemoteStorageMonitor;
typedef struct _ZeitgeistRemoteStorageMonitorIface ZeitgeistRemoteStorageMonitorIface;

#define ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR_PROXY (zeitgeist_remote_storage_monitor_proxy_get_type ())
enum  {
	ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_AVAILABLE_SIGNAL,
	ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_UNAVAILABLE_SIGNAL,
	ZEITGEIST_REMOTE_STORAGE_MONITOR_NUM_SIGNALS
};
static guint zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_NUM_SIGNALS] = {0};
typedef GDBusProxy ZeitgeistRemoteStorageMonitorProxy;
typedef GDBusProxyClass ZeitgeistRemoteStorageMonitorProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define ZEITGEIST_TYPE_NETWORK_MONITOR (zeitgeist_network_monitor_get_type ())
#define ZEITGEIST_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_NETWORK_MONITOR, ZeitgeistNetworkMonitor))
#define ZEITGEIST_IS_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_NETWORK_MONITOR))
#define ZEITGEIST_NETWORK_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_NETWORK_MONITOR, ZeitgeistNetworkMonitorIface))

typedef struct _ZeitgeistNetworkMonitor ZeitgeistNetworkMonitor;
typedef struct _ZeitgeistNetworkMonitorIface ZeitgeistNetworkMonitorIface;
enum  {
	ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_UP_SIGNAL,
	ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_DOWN_SIGNAL,
	ZEITGEIST_NETWORK_MONITOR_NUM_SIGNALS
};
static guint zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_NUM_SIGNALS] = {0};
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define ZEITGEIST_TYPE_STORAGE_MONITOR (zeitgeist_storage_monitor_get_type ())
#define ZEITGEIST_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitor))
#define ZEITGEIST_STORAGE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitorClass))
#define ZEITGEIST_IS_STORAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_STORAGE_MONITOR))
#define ZEITGEIST_IS_STORAGE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_STORAGE_MONITOR))
#define ZEITGEIST_STORAGE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitorClass))

typedef struct _ZeitgeistStorageMonitor ZeitgeistStorageMonitor;
typedef struct _ZeitgeistStorageMonitorClass ZeitgeistStorageMonitorClass;
typedef struct _ZeitgeistStorageMonitorPrivate ZeitgeistStorageMonitorPrivate;
enum  {
	ZEITGEIST_STORAGE_MONITOR_0_PROPERTY,
	ZEITGEIST_STORAGE_MONITOR_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_storage_monitor_properties[ZEITGEIST_STORAGE_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR (zeitgeist_connman_network_monitor_get_type ())
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR, ZeitgeistConnmanNetworkMonitor))
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR, ZeitgeistConnmanNetworkMonitorClass))
#define ZEITGEIST_IS_CONNMAN_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR))
#define ZEITGEIST_IS_CONNMAN_NETWORK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR))
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR, ZeitgeistConnmanNetworkMonitorClass))

typedef struct _ZeitgeistConnmanNetworkMonitor ZeitgeistConnmanNetworkMonitor;
typedef struct _ZeitgeistConnmanNetworkMonitorClass ZeitgeistConnmanNetworkMonitorClass;

#define ZEITGEIST_TYPE_NM_NETWORK_MONITOR (zeitgeist_nm_network_monitor_get_type ())
#define ZEITGEIST_NM_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_NM_NETWORK_MONITOR, ZeitgeistNMNetworkMonitor))
#define ZEITGEIST_NM_NETWORK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_NM_NETWORK_MONITOR, ZeitgeistNMNetworkMonitorClass))
#define ZEITGEIST_IS_NM_NETWORK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_NM_NETWORK_MONITOR))
#define ZEITGEIST_IS_NM_NETWORK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_NM_NETWORK_MONITOR))
#define ZEITGEIST_NM_NETWORK_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_NM_NETWORK_MONITOR, ZeitgeistNMNetworkMonitorClass))

typedef struct _ZeitgeistNMNetworkMonitor ZeitgeistNMNetworkMonitor;
typedef struct _ZeitgeistNMNetworkMonitorClass ZeitgeistNMNetworkMonitorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistNMNetworkMonitorPrivate ZeitgeistNMNetworkMonitorPrivate;
enum  {
	ZEITGEIST_NM_NETWORK_MONITOR_0_PROPERTY,
	ZEITGEIST_NM_NETWORK_MONITOR_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_nm_network_monitor_properties[ZEITGEIST_NM_NETWORK_MONITOR_NUM_PROPERTIES];
typedef struct _ZeitgeistConnmanNetworkMonitorPrivate ZeitgeistConnmanNetworkMonitorPrivate;
enum  {
	ZEITGEIST_CONNMAN_NETWORK_MONITOR_0_PROPERTY,
	ZEITGEIST_CONNMAN_NETWORK_MONITOR_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_connman_network_monitor_properties[ZEITGEIST_CONNMAN_NETWORK_MONITOR_NUM_PROPERTIES];

struct _ZeitgeistRemoteStorageMonitorIface {
	GTypeInterface parent_iface;
	GVariant* (*get_storages) (ZeitgeistRemoteStorageMonitor* self, GError** error);
};

struct _ZeitgeistNetworkMonitorIface {
	GTypeInterface parent_iface;
	void (*setup) (ZeitgeistNetworkMonitor* self);
};

struct _ZeitgeistStorageMonitor {
	ZeitgeistExtension parent_instance;
	ZeitgeistStorageMonitorPrivate * priv;
};

struct _ZeitgeistStorageMonitorClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistStorageMonitorPrivate {
	ZeitgeistSQLiteDatabase* database;
	sqlite3* db;
	guint registration_id;
	sqlite3_stmt* get_storages_stmt;
	sqlite3_stmt* store_storage_medium_stmt;
	sqlite3_stmt* update_storage_medium_stmt;
	sqlite3_stmt* insert_unavailable_medium_stmt;
	sqlite3_stmt* update_medium_state_stmt;
	ZeitgeistNetworkMonitor* network;
	guint watch_connman;
	guint watch_nm;
};

struct _ZeitgeistNMNetworkMonitor {
	GObject parent_instance;
	ZeitgeistNMNetworkMonitorPrivate * priv;
};

struct _ZeitgeistNMNetworkMonitorClass {
	GObjectClass parent_class;
};

struct _ZeitgeistNMNetworkMonitorPrivate {
	ZeitgeistNetworkManagerDBus* proxy;
};

struct _ZeitgeistConnmanNetworkMonitor {
	GObject parent_instance;
	ZeitgeistConnmanNetworkMonitorPrivate * priv;
};

struct _ZeitgeistConnmanNetworkMonitorClass {
	GObjectClass parent_class;
};

struct _ZeitgeistConnmanNetworkMonitorPrivate {
	ZeitgeistConnmanManagerDBus* proxy;
};


static GType zeitgeist_remote_storage_monitor_type_id = 0;
static GType zeitgeist_network_monitor_type_id = 0;
static gpointer zeitgeist_storage_monitor_parent_class = NULL;
static ZeitgeistRemoteStorageMonitorIface * zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_parent_iface = NULL;
static GType zeitgeist_storage_monitor_type_id = 0;
static gpointer zeitgeist_nm_network_monitor_parent_class = NULL;
static ZeitgeistNetworkMonitorIface * zeitgeist_nm_network_monitor_zeitgeist_network_monitor_parent_iface = NULL;
static GType zeitgeist_nm_network_monitor_type_id = 0;
static gpointer zeitgeist_connman_network_monitor_parent_class = NULL;
static ZeitgeistNetworkMonitorIface * zeitgeist_connman_network_monitor_zeitgeist_network_monitor_parent_iface = NULL;
static GType zeitgeist_connman_network_monitor_type_id = 0;

GType zeitgeist_remote_storage_monitor_proxy_get_type (void) G_GNUC_CONST;
void zeitgeist_remote_storage_monitor_proxy_register_dynamic_type (GTypeModule* module);
guint zeitgeist_remote_storage_monitor_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_storage_monitor_get_type (void) G_GNUC_CONST;
GVariant* zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void zeitgeist_remote_storage_monitor_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_available (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters);
static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_unavailable (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters);
static GVariant* zeitgeist_remote_storage_monitor_proxy_get_storages (ZeitgeistRemoteStorageMonitor* self, GError** error);
static void zeitgeist_remote_storage_monitor_proxy_zeitgeist_remote_storage_monitor_interface_init (ZeitgeistRemoteStorageMonitorIface* iface);
static void _dbus_zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void zeitgeist_remote_storage_monitor_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* zeitgeist_remote_storage_monitor_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean zeitgeist_remote_storage_monitor_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_zeitgeist_remote_storage_monitor_storage_available (GObject* _sender, const gchar* storage_id, GVariant* storage_description, gpointer* _data);
static void _dbus_zeitgeist_remote_storage_monitor_storage_unavailable (GObject* _sender, const gchar* storage_id, gpointer* _data);
static void _zeitgeist_remote_storage_monitor_unregister_object (gpointer user_data);
GType zeitgeist_network_monitor_get_type (void) G_GNUC_CONST;
void zeitgeist_network_monitor_setup (ZeitgeistNetworkMonitor* self);
GVariant* zeitgeist_storage_media_to_variant (const gchar* medium_name, gboolean available, const gchar* icon, const gchar* display_name);
GType zeitgeist_storage_monitor_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_STORAGE_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitorPrivate))
static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_new (void);
static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_construct (GType object_type);
static void zeitgeist_storage_monitor_name_appeared_handler (ZeitgeistStorageMonitor* self, GDBusConnection* connection, const gchar* name, const gchar* name_owner);
ZeitgeistConnmanNetworkMonitor* zeitgeist_connman_network_monitor_new (void);
ZeitgeistConnmanNetworkMonitor* zeitgeist_connman_network_monitor_construct (GType object_type);
GType zeitgeist_connman_network_monitor_get_type (void) G_GNUC_CONST;
ZeitgeistNMNetworkMonitor* zeitgeist_nm_network_monitor_new (void);
ZeitgeistNMNetworkMonitor* zeitgeist_nm_network_monitor_construct (GType object_type);
GType zeitgeist_nm_network_monitor_get_type (void) G_GNUC_CONST;
static void __lambda4_ (ZeitgeistStorageMonitor* self);
void zeitgeist_storage_monitor_add_storage_medium (ZeitgeistStorageMonitor* self, const gchar* medium_name, const gchar* icon, const gchar* display_name);
static void ___lambda4__zeitgeist_network_monitor_on_network_up (ZeitgeistNetworkMonitor* _sender, gpointer self);
static void __lambda5_ (ZeitgeistStorageMonitor* self);
void zeitgeist_storage_monitor_remove_storage_medium (ZeitgeistStorageMonitor* self, const gchar* medium_name);
static void ___lambda5__zeitgeist_network_monitor_on_network_down (ZeitgeistNetworkMonitor* _sender, gpointer self);
static void zeitgeist_storage_monitor_real_unload (ZeitgeistExtension* base);
static void zeitgeist_storage_monitor_prepare_queries (ZeitgeistStorageMonitor* self, GError** error);
static void zeitgeist_storage_monitor_real_pre_insert_events (ZeitgeistExtension* base, GPtrArray* events, const char* sender);
static gchar* zeitgeist_storage_monitor_find_storage_for_uri (ZeitgeistStorageMonitor* self, const gchar* uri);
static gboolean _vala_string_array_contains (const gchar* * stack, int stack_length, const gchar* needle);
static GVariant* zeitgeist_storage_monitor_real_get_storages (ZeitgeistRemoteStorageMonitor* base, GError** error);
static GObject * zeitgeist_storage_monitor_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void zeitgeist_storage_monitor_finalize (GObject * obj);
#define ZEITGEIST_NM_NETWORK_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_NM_NETWORK_MONITOR, ZeitgeistNMNetworkMonitorPrivate))
#define ZEITGEIST_NM_NETWORK_MONITOR_NM_BUS_NAME "org.freedesktop.NetworkManager"
#define ZEITGEIST_NM_NETWORK_MONITOR_NM_IFACE "org.freedesktop.NetworkManager"
#define ZEITGEIST_NM_NETWORK_MONITOR_NM_OBJECT_PATH "/org/freedesktop/NetworkManager"
#define ZEITGEIST_NM_NETWORK_MONITOR_NM_STATE_CONNECTED_PRE_09 3
#define ZEITGEIST_NM_NETWORK_MONITOR_NM_STATE_CONNECTED_POST_09 70
static void zeitgeist_nm_network_monitor_real_setup (ZeitgeistNetworkMonitor* base);
static void zeitgeist_nm_network_monitor_on_state_changed (ZeitgeistNMNetworkMonitor* self, guint32 state);
static void _zeitgeist_nm_network_monitor_on_state_changed_zeitgeist_network_manager_dbus_state_changed (ZeitgeistNetworkManagerDBus* _sender, guint32 state, gpointer self);
static void zeitgeist_nm_network_monitor_finalize (GObject * obj);
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR, ZeitgeistConnmanNetworkMonitorPrivate))
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_BUS_NAME "net.connman"
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_IFACE "net.connman.Manager"
#define ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_OBJECT_PATH "/"
static void zeitgeist_connman_network_monitor_real_setup (ZeitgeistNetworkMonitor* base);
static void zeitgeist_connman_network_monitor_on_state_changed (ZeitgeistConnmanNetworkMonitor* self, const gchar* state);
static void _zeitgeist_connman_network_monitor_on_state_changed_zeitgeist_connman_manager_dbus_state_changed (ZeitgeistConnmanManagerDBus* _sender, const gchar* state, gpointer self);
static void zeitgeist_connman_network_monitor_finalize (GObject * obj);
GType zeitgeist_storage_monitor_init (GTypeModule* module);
GType zeitgeist_remote_storage_monitor_register_type (GTypeModule * module);
GType zeitgeist_storage_monitor_register_type (GTypeModule * module);
GType zeitgeist_network_monitor_register_type (GTypeModule * module);
GType zeitgeist_nm_network_monitor_register_type (GTypeModule * module);
GType zeitgeist_connman_network_monitor_register_type (GTypeModule * module);

static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_result = {-1, "result", "a(sa{sv})"};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_in[] = {NULL};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_out[] = {&_zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_storage_monitor_dbus_method_info_get_storages = {-1, "GetStorages", (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_in), (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_get_storages_out)};
static const GDBusMethodInfo * const _zeitgeist_remote_storage_monitor_dbus_method_info[] = {&_zeitgeist_remote_storage_monitor_dbus_method_info_get_storages, NULL};
static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_id = {-1, "storage_id", "s"};
static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_description = {-1, "storage_description", "a{sv}"};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available[] = {&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_id, &_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available_storage_description, NULL};
static const GDBusSignalInfo _zeitgeist_remote_storage_monitor_dbus_signal_info_storage_available = {-1, "StorageAvailable", (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_available)};
static const GDBusArgInfo _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable_storage_id = {-1, "storage_id", "s"};
static const GDBusArgInfo * const _zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable[] = {&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable_storage_id, NULL};
static const GDBusSignalInfo _zeitgeist_remote_storage_monitor_dbus_signal_info_storage_unavailable = {-1, "StorageUnavailable", (GDBusArgInfo **) (&_zeitgeist_remote_storage_monitor_dbus_arg_info_storage_unavailable)};
static const GDBusSignalInfo * const _zeitgeist_remote_storage_monitor_dbus_signal_info[] = {&_zeitgeist_remote_storage_monitor_dbus_signal_info_storage_available, &_zeitgeist_remote_storage_monitor_dbus_signal_info_storage_unavailable, NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_storage_monitor_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_storage_monitor_dbus_interface_info = {-1, "org.gnome.zeitgeist.StorageMonitor", (GDBusMethodInfo **) (&_zeitgeist_remote_storage_monitor_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_storage_monitor_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_storage_monitor_dbus_property_info)};
static const GDBusInterfaceVTable _zeitgeist_remote_storage_monitor_dbus_interface_vtable = {zeitgeist_remote_storage_monitor_dbus_interface_method_call, zeitgeist_remote_storage_monitor_dbus_interface_get_property, zeitgeist_remote_storage_monitor_dbus_interface_set_property};
static const gchar* ZEITGEIST_STORAGE_MONITOR_network_uri_schemes[9] = {"dav", "davs", "ftp", "http", "https", "mailto", "sftp", "smb", "ssh"};

GVariant* zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return ZEITGEIST_REMOTE_STORAGE_MONITOR_GET_INTERFACE (self)->get_storages (self, error);
}


static void g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), data2);
}


static void zeitgeist_remote_storage_monitor_base_init (ZeitgeistRemoteStorageMonitorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_AVAILABLE_SIGNAL] = g_signal_new ("storage-available", ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
		zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_UNAVAILABLE_SIGNAL] = g_signal_new ("storage-unavailable", ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


GType zeitgeist_remote_storage_monitor_get_type (void) {
	return zeitgeist_remote_storage_monitor_type_id;
}


GType zeitgeist_remote_storage_monitor_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteStorageMonitorIface), (GBaseInitFunc) zeitgeist_remote_storage_monitor_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_remote_storage_monitor_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistRemoteStorageMonitor", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_storage_monitor_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_storage_monitor_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.StorageMonitor");
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_zeitgeist_remote_storage_monitor_dbus_interface_info));
	g_type_set_qdata (zeitgeist_remote_storage_monitor_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_storage_monitor_register_object);
	return zeitgeist_remote_storage_monitor_type_id;
}


G_DEFINE_DYNAMIC_TYPE_EXTENDED (ZeitgeistRemoteStorageMonitorProxy, zeitgeist_remote_storage_monitor_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, zeitgeist_remote_storage_monitor_proxy_zeitgeist_remote_storage_monitor_interface_init) )
static void zeitgeist_remote_storage_monitor_proxy_class_init (ZeitgeistRemoteStorageMonitorProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_storage_monitor_proxy_g_signal;
}


static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_available (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* storage_id = NULL;
	GVariant* _tmp0_;
	GVariant* storage_description = NULL;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	storage_id = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	storage_description = g_variant_iter_next_value (&_arguments_iter);
	g_signal_emit_by_name (self, "storage-available", storage_id, storage_description);
	_g_free0 (storage_id);
	_g_variant_unref0 (storage_description);
}


static void _dbus_handle_zeitgeist_remote_storage_monitor_storage_unavailable (ZeitgeistRemoteStorageMonitor* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* storage_id = NULL;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	storage_id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "storage-unavailable", storage_id);
	_g_free0 (storage_id);
}


static void zeitgeist_remote_storage_monitor_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "StorageAvailable") == 0) {
		_dbus_handle_zeitgeist_remote_storage_monitor_storage_available ((ZeitgeistRemoteStorageMonitor*) proxy, parameters);
	} else if (strcmp (signal_name, "StorageUnavailable") == 0) {
		_dbus_handle_zeitgeist_remote_storage_monitor_storage_unavailable ((ZeitgeistRemoteStorageMonitor*) proxy, parameters);
	}
}


static void zeitgeist_remote_storage_monitor_proxy_class_finalize (ZeitgeistRemoteStorageMonitorProxyClass* klass) {
}


void zeitgeist_remote_storage_monitor_proxy_register_dynamic_type (GTypeModule* module) {
	zeitgeist_remote_storage_monitor_proxy_register_type (module);
}


static void zeitgeist_remote_storage_monitor_proxy_init (ZeitgeistRemoteStorageMonitorProxy* self) {
}


static GVariant* zeitgeist_remote_storage_monitor_proxy_get_storages (ZeitgeistRemoteStorageMonitor* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _result = NULL;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.StorageMonitor", "GetStorages");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result = g_variant_iter_next_value (&_reply_iter);
	g_object_unref (_reply_message);
	return _result;
}


static void zeitgeist_remote_storage_monitor_proxy_zeitgeist_remote_storage_monitor_interface_init (ZeitgeistRemoteStorageMonitorIface* iface) {
	iface->get_storages = zeitgeist_remote_storage_monitor_proxy_get_storages;
}


static void _dbus_zeitgeist_remote_storage_monitor_get_storages (ZeitgeistRemoteStorageMonitor* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = zeitgeist_remote_storage_monitor_get_storages (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void zeitgeist_remote_storage_monitor_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetStorages") == 0) {
		_dbus_zeitgeist_remote_storage_monitor_get_storages (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* zeitgeist_remote_storage_monitor_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean zeitgeist_remote_storage_monitor_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_zeitgeist_remote_storage_monitor_storage_available (GObject* _sender, const gchar* storage_id, GVariant* storage_description, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (storage_id));
	g_variant_builder_add_value (&_arguments_builder, storage_description);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.StorageMonitor", "StorageAvailable", _arguments, NULL);
}


static void _dbus_zeitgeist_remote_storage_monitor_storage_unavailable (GObject* _sender, const gchar* storage_id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (storage_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.zeitgeist.StorageMonitor", "StorageUnavailable", _arguments, NULL);
}


guint zeitgeist_remote_storage_monitor_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_storage_monitor_dbus_interface_info), &_zeitgeist_remote_storage_monitor_dbus_interface_vtable, data, _zeitgeist_remote_storage_monitor_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "storage-available", (GCallback) _dbus_zeitgeist_remote_storage_monitor_storage_available, data);
	g_signal_connect (object, "storage-unavailable", (GCallback) _dbus_zeitgeist_remote_storage_monitor_storage_unavailable, data);
	return result;
}


static void _zeitgeist_remote_storage_monitor_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_zeitgeist_remote_storage_monitor_storage_available, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_zeitgeist_remote_storage_monitor_storage_unavailable, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void zeitgeist_network_monitor_setup (ZeitgeistNetworkMonitor* self) {
	g_return_if_fail (self != NULL);
	ZEITGEIST_NETWORK_MONITOR_GET_INTERFACE (self)->setup (self);
}


static void zeitgeist_network_monitor_base_init (ZeitgeistNetworkMonitorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_UP_SIGNAL] = g_signal_new ("on-network-up", ZEITGEIST_TYPE_NETWORK_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_DOWN_SIGNAL] = g_signal_new ("on-network-down", ZEITGEIST_TYPE_NETWORK_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	}
}


GType zeitgeist_network_monitor_get_type (void) {
	return zeitgeist_network_monitor_type_id;
}


GType zeitgeist_network_monitor_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistNetworkMonitorIface), (GBaseInitFunc) zeitgeist_network_monitor_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_network_monitor_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistNetworkMonitor", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_network_monitor_type_id, G_TYPE_OBJECT);
	return zeitgeist_network_monitor_type_id;
}


GVariant* zeitgeist_storage_media_to_variant (const gchar* medium_name, gboolean available, const gchar* icon, const gchar* display_name) {
	GVariant* result = NULL;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	const gchar* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariant* _tmp22_;
	g_return_val_if_fail (medium_name != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = g_variant_type_new ("(sa{sv})");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = medium_name;
	g_variant_builder_add (vb, "s", _tmp4_, NULL);
	_tmp5_ = g_variant_type_new ("a{sv}");
	_tmp6_ = _tmp5_;
	g_variant_builder_open (vb, _tmp6_);
	_g_variant_type_free0 (_tmp6_);
	{
		GVariantType* _tmp7_;
		GVariantType* _tmp8_;
		gboolean _tmp9_;
		GVariant* _tmp10_;
		GVariant* _tmp11_;
		GVariantType* _tmp12_;
		GVariantType* _tmp13_;
		const gchar* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		GVariantType* _tmp17_;
		GVariantType* _tmp18_;
		const gchar* _tmp19_;
		GVariant* _tmp20_;
		GVariant* _tmp21_;
		_tmp7_ = g_variant_type_new ("{sv}");
		_tmp8_ = _tmp7_;
		g_variant_builder_open (vb, _tmp8_);
		_g_variant_type_free0 (_tmp8_);
		g_variant_builder_add (vb, "s", "available", NULL);
		_tmp9_ = available;
		_tmp10_ = g_variant_new ("b", _tmp9_, NULL);
		g_variant_ref_sink (_tmp10_);
		_tmp11_ = _tmp10_;
		g_variant_builder_add (vb, "v", _tmp11_, NULL);
		_g_variant_unref0 (_tmp11_);
		g_variant_builder_close (vb);
		_tmp12_ = g_variant_type_new ("{sv}");
		_tmp13_ = _tmp12_;
		g_variant_builder_open (vb, _tmp13_);
		_g_variant_type_free0 (_tmp13_);
		g_variant_builder_add (vb, "s", "icon", NULL);
		_tmp14_ = icon;
		_tmp15_ = g_variant_new ("s", _tmp14_, NULL);
		g_variant_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		g_variant_builder_add (vb, "v", _tmp16_, NULL);
		_g_variant_unref0 (_tmp16_);
		g_variant_builder_close (vb);
		_tmp17_ = g_variant_type_new ("{sv}");
		_tmp18_ = _tmp17_;
		g_variant_builder_open (vb, _tmp18_);
		_g_variant_type_free0 (_tmp18_);
		g_variant_builder_add (vb, "s", "display-name", NULL);
		_tmp19_ = display_name;
		_tmp20_ = g_variant_new ("s", _tmp19_, NULL);
		g_variant_ref_sink (_tmp20_);
		_tmp21_ = _tmp20_;
		g_variant_builder_add (vb, "v", _tmp21_, NULL);
		_g_variant_unref0 (_tmp21_);
		g_variant_builder_close (vb);
	}
	g_variant_builder_close (vb);
	_tmp22_ = g_variant_builder_end (vb);
	g_variant_ref_sink (_tmp22_);
	result = _tmp22_;
	_g_variant_builder_unref0 (vb);
	return result;
}


static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_construct (GType object_type) {
	ZeitgeistStorageMonitor * self = NULL;
	self = (ZeitgeistStorageMonitor*) g_object_new (object_type, NULL);
	return self;
}


static ZeitgeistStorageMonitor* zeitgeist_storage_monitor_new (void) {
	return zeitgeist_storage_monitor_construct (ZEITGEIST_TYPE_STORAGE_MONITOR);
}


static void __lambda4_ (ZeitgeistStorageMonitor* self) {
	zeitgeist_storage_monitor_add_storage_medium (self, "net", "stock_internet", "Internet");
}


static void ___lambda4__zeitgeist_network_monitor_on_network_up (ZeitgeistNetworkMonitor* _sender, gpointer self) {
	__lambda4_ ((ZeitgeistStorageMonitor*) self);
}


static void __lambda5_ (ZeitgeistStorageMonitor* self) {
	zeitgeist_storage_monitor_remove_storage_medium (self, "net");
}


static void ___lambda5__zeitgeist_network_monitor_on_network_down (ZeitgeistNetworkMonitor* _sender, gpointer self) {
	__lambda5_ ((ZeitgeistStorageMonitor*) self);
}


static void zeitgeist_storage_monitor_name_appeared_handler (ZeitgeistStorageMonitor* self, GDBusConnection* connection, const gchar* name, const gchar* name_owner) {
	ZeitgeistNetworkMonitor* _tmp0_;
	const gchar* _tmp1_;
	ZeitgeistNetworkMonitor* _tmp5_;
	ZeitgeistNetworkMonitor* _tmp6_;
	ZeitgeistNetworkMonitor* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	_tmp0_ = self->priv->network;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = name;
	if (g_strcmp0 (_tmp1_, "net.connman") == 0) {
		ZeitgeistConnmanNetworkMonitor* _tmp2_;
		_tmp2_ = zeitgeist_connman_network_monitor_new ();
		_g_object_unref0 (self->priv->network);
		self->priv->network = (ZeitgeistNetworkMonitor*) _tmp2_;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = name;
		if (g_strcmp0 (_tmp3_, "org.freedesktop.NetworkManager") == 0) {
			ZeitgeistNMNetworkMonitor* _tmp4_;
			_tmp4_ = zeitgeist_nm_network_monitor_new ();
			_g_object_unref0 (self->priv->network);
			self->priv->network = (ZeitgeistNetworkMonitor*) _tmp4_;
		}
	}
	_tmp5_ = self->priv->network;
	g_signal_connect_object (_tmp5_, "on-network-up", (GCallback) ___lambda4__zeitgeist_network_monitor_on_network_up, self, 0);
	_tmp6_ = self->priv->network;
	g_signal_connect_object (_tmp6_, "on-network-down", (GCallback) ___lambda5__zeitgeist_network_monitor_on_network_down, self, 0);
	_tmp7_ = self->priv->network;
	zeitgeist_network_monitor_setup (_tmp7_);
	_tmp8_ = self->priv->watch_connman;
	g_bus_unwatch_name (_tmp8_);
	_tmp9_ = self->priv->watch_nm;
	g_bus_unwatch_name (_tmp9_);
}


static void zeitgeist_storage_monitor_real_unload (ZeitgeistExtension* base) {
	ZeitgeistStorageMonitor * self;
	guint _tmp5_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistStorageMonitor*) base;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		guint _tmp1_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->registration_id;
		if (_tmp1_ != ((guint) 0)) {
			guint _tmp2_;
			_tmp2_ = self->priv->registration_id;
			g_dbus_connection_unregister_object (connection, _tmp2_);
			self->priv->registration_id = (guint) 0;
		}
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("ext-storage-monitor.vala:217: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = ((GObject*) self)->ref_count;
	g_debug ("ext-storage-monitor.vala:220: %s, this.ref_count = %u", "Zeitgeist.StorageMonitor.unload", _tmp5_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void zeitgeist_storage_monitor_prepare_queries (ZeitgeistStorageMonitor* self, GError** error) {
	ZeitgeistEngine* _tmp0_;
	ZeitgeistEngine* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	ZeitgeistSQLiteDatabase* _tmp5_;
	sqlite3* _tmp6_;
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp7_;
	sqlite3* _tmp8_;
	const gchar* _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_;
	ZeitgeistSQLiteDatabase* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	sqlite3* _tmp15_;
	const gchar* _tmp16_;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_;
	ZeitgeistSQLiteDatabase* _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_;
	sqlite3* _tmp22_;
	const gchar* _tmp23_;
	sqlite3_stmt* _tmp24_ = NULL;
	gint _tmp25_;
	ZeitgeistSQLiteDatabase* _tmp26_;
	gint _tmp27_;
	gchar* _tmp28_;
	sqlite3* _tmp29_;
	const gchar* _tmp30_;
	sqlite3_stmt* _tmp31_ = NULL;
	gint _tmp32_;
	ZeitgeistSQLiteDatabase* _tmp33_;
	gint _tmp34_;
	gchar* _tmp35_;
	sqlite3* _tmp36_;
	const gchar* _tmp37_;
	sqlite3_stmt* _tmp38_ = NULL;
	gint _tmp39_;
	ZeitgeistSQLiteDatabase* _tmp40_;
	gint _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = zeitgeist_extension_get_engine ((ZeitgeistExtension*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp4_;
	_tmp5_ = self->priv->database;
	_tmp6_ = _tmp5_->database;
	self->priv->db = _tmp6_;
	_tmp7_ = g_strdup ("\n" \
"                SELECT value, state, icon, display_name\n" \
"                FROM storage\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp7_;
	_tmp8_ = self->priv->db;
	_tmp9_ = sql;
	_tmp11_ = sqlite3_prepare_v2 (_tmp8_, _tmp9_, -1, &_tmp10_, NULL);
	_sqlite3_finalize0 (self->priv->get_storages_stmt);
	self->priv->get_storages_stmt = _tmp10_;
	rc = _tmp11_;
	_tmp12_ = self->priv->database;
	_tmp13_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp12_, _tmp13_, "ext-storage-monitor.vala:237: Storage retrieval query error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = g_strdup ("\n" \
"                INSERT INTO storage (\n" \
"                    value, state, icon, display_name\n" \
"                ) VALUES (\n" \
"                    ?, ?, ?, ?\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp14_;
	_tmp15_ = self->priv->db;
	_tmp16_ = sql;
	_tmp18_ = sqlite3_prepare_v2 (_tmp15_, _tmp16_, -1, &_tmp17_, NULL);
	_sqlite3_finalize0 (self->priv->store_storage_medium_stmt);
	self->priv->store_storage_medium_stmt = _tmp17_;
	rc = _tmp18_;
	_tmp19_ = self->priv->database;
	_tmp20_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp19_, _tmp20_, "ext-storage-monitor.vala:246: Storage insertion query error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp21_ = g_strdup ("\n" \
"                UPDATE storage SET \n" \
"                state=?, icon=?, display_name=? \n" \
"                WHERE value=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp21_;
	_tmp22_ = self->priv->db;
	_tmp23_ = sql;
	_tmp25_ = sqlite3_prepare_v2 (_tmp22_, _tmp23_, -1, &_tmp24_, NULL);
	_sqlite3_finalize0 (self->priv->update_storage_medium_stmt);
	self->priv->update_storage_medium_stmt = _tmp24_;
	rc = _tmp25_;
	_tmp26_ = self->priv->database;
	_tmp27_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp26_, _tmp27_, "ext-storage-monitor.vala:254: Storage update query error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp28_ = g_strdup ("\n" \
"                INSERT INTO storage (\n" \
"                    state, value\n" \
"                ) VALUES (\n" \
"                    ?, ?\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp28_;
	_tmp29_ = self->priv->db;
	_tmp30_ = sql;
	_tmp32_ = sqlite3_prepare_v2 (_tmp29_, _tmp30_, -1, &_tmp31_, NULL);
	_sqlite3_finalize0 (self->priv->insert_unavailable_medium_stmt);
	self->priv->insert_unavailable_medium_stmt = _tmp31_;
	rc = _tmp32_;
	_tmp33_ = self->priv->database;
	_tmp34_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp33_, _tmp34_, "ext-storage-monitor.vala:263: insert_unavailable_medium_stmt error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp35_ = g_strdup ("\n" \
"                UPDATE storage\n" \
"                SET state=?\n" \
"                WHERE value=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp35_;
	_tmp36_ = self->priv->db;
	_tmp37_ = sql;
	_tmp39_ = sqlite3_prepare_v2 (_tmp36_, _tmp37_, -1, &_tmp38_, NULL);
	_sqlite3_finalize0 (self->priv->update_medium_state_stmt);
	self->priv->update_medium_state_stmt = _tmp38_;
	rc = _tmp39_;
	_tmp40_ = self->priv->database;
	_tmp41_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp40_, _tmp41_, "ext-storage-monitor.vala:272: update_medium_state_stmt error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (sql);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void zeitgeist_storage_monitor_real_pre_insert_events (ZeitgeistExtension* base, GPtrArray* events, const char* sender) {
	ZeitgeistStorageMonitor * self;
	self = (ZeitgeistStorageMonitor*) base;
	g_return_if_fail (events != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = events;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = events;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				if (((ZeitgeistEvent*) _tmp8_) == NULL) {
					continue;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_;
							GPtrArray* _tmp12_;
							gint _tmp13_;
							gconstpointer _tmp14_;
							GPtrArray* _tmp15_;
							GPtrArray* _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							ZeitgeistSubject* subject = NULL;
							GPtrArray* _tmp19_;
							gint _tmp20_;
							gconstpointer _tmp21_;
							GPtrArray* _tmp22_;
							GPtrArray* _tmp23_;
							gint _tmp24_;
							gconstpointer _tmp25_;
							ZeitgeistSubject* _tmp26_;
							ZeitgeistSubject* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							gboolean _tmp30_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = j;
								j = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = j;
							_tmp12_ = events;
							_tmp13_ = i;
							_tmp14_ = g_ptr_array_index (_tmp12_, (guint) _tmp13_);
							_tmp15_ = zeitgeist_event_get_subjects ((ZeitgeistEvent*) _tmp14_);
							_tmp16_ = _tmp15_;
							_tmp17_ = g_ptr_array_get_length (_tmp16_);
							_tmp18_ = _tmp17_;
							if (!(_tmp11_ < _tmp18_)) {
								break;
							}
							_tmp19_ = events;
							_tmp20_ = i;
							_tmp21_ = g_ptr_array_index (_tmp19_, (guint) _tmp20_);
							_tmp22_ = zeitgeist_event_get_subjects ((ZeitgeistEvent*) _tmp21_);
							_tmp23_ = _tmp22_;
							_tmp24_ = j;
							_tmp25_ = g_ptr_array_index (_tmp23_, (guint) _tmp24_);
							_tmp26_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp25_);
							subject = _tmp26_;
							_tmp27_ = subject;
							_tmp28_ = zeitgeist_subject_get_storage (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp30_ = zeitgeist_utils_is_empty_string (_tmp29_);
							if (_tmp30_) {
								ZeitgeistSubject* _tmp31_;
								ZeitgeistSubject* _tmp32_;
								const gchar* _tmp33_;
								const gchar* _tmp34_;
								gchar* _tmp35_;
								gchar* _tmp36_;
								_tmp31_ = subject;
								_tmp32_ = subject;
								_tmp33_ = zeitgeist_subject_get_uri (_tmp32_);
								_tmp34_ = _tmp33_;
								_tmp35_ = zeitgeist_storage_monitor_find_storage_for_uri (self, _tmp34_);
								_tmp36_ = _tmp35_;
								zeitgeist_subject_set_storage (_tmp31_, _tmp36_);
								_g_free0 (_tmp36_);
							}
							_g_object_unref0 (subject);
						}
					}
				}
			}
		}
	}
}


static gboolean _vala_string_array_contains (const gchar* * stack, int stack_length, const gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gchar* zeitgeist_storage_monitor_find_storage_for_uri (ZeitgeistStorageMonitor* self, const gchar* uri) {
	gchar* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* uri_scheme = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_uri_scheme (_tmp2_);
	uri_scheme = _tmp3_;
	_tmp4_ = uri_scheme;
	if (_vala_string_array_contains (ZEITGEIST_STORAGE_MONITOR_network_uri_schemes, G_N_ELEMENTS (ZEITGEIST_STORAGE_MONITOR_network_uri_schemes), _tmp4_)) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("net");
		result = _tmp5_;
		_g_free0 (uri_scheme);
		_g_object_unref0 (file);
		return result;
	}
	_tmp6_ = g_strdup ("unknown");
	result = _tmp6_;
	_g_free0 (uri_scheme);
	_g_object_unref0 (file);
	return result;
}


void zeitgeist_storage_monitor_add_storage_medium (ZeitgeistStorageMonitor* self, const gchar* medium_name, const gchar* icon, const gchar* display_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	sqlite3_stmt* _tmp8_;
	sqlite3_stmt* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GDestroyNotify _tmp12_;
	sqlite3_stmt* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GDestroyNotify _tmp16_;
	sqlite3_stmt* _tmp17_;
	gint _tmp18_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	GVariant* _tmp43_;
	GVariant* _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (medium_name != NULL);
	g_return_if_fail (icon != NULL);
	g_return_if_fail (display_name != NULL);
	_tmp0_ = medium_name;
	_tmp1_ = g_strdup_printf ("VOLUME ADDED: %s", _tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("ext-storage-monitor.vala:370: %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->store_storage_medium_stmt;
	sqlite3_reset (_tmp3_);
	_tmp4_ = self->priv->store_storage_medium_stmt;
	_tmp5_ = medium_name;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = g_free;
	sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
	_tmp8_ = self->priv->store_storage_medium_stmt;
	sqlite3_bind_int (_tmp8_, 2, 1);
	_tmp9_ = self->priv->store_storage_medium_stmt;
	_tmp10_ = icon;
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_free;
	sqlite3_bind_text (_tmp9_, 3, _tmp11_, -1, _tmp12_);
	_tmp13_ = self->priv->store_storage_medium_stmt;
	_tmp14_ = display_name;
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = g_free;
	sqlite3_bind_text (_tmp13_, 4, _tmp15_, -1, _tmp16_);
	_tmp17_ = self->priv->store_storage_medium_stmt;
	_tmp18_ = sqlite3_step (_tmp17_);
	if (_tmp18_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp19_;
		sqlite3_stmt* _tmp20_;
		sqlite3_stmt* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		GDestroyNotify _tmp24_;
		sqlite3_stmt* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		GDestroyNotify _tmp28_;
		sqlite3_stmt* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		GDestroyNotify _tmp32_;
		gint rc = 0;
		sqlite3_stmt* _tmp33_;
		gint _tmp34_;
		_tmp19_ = self->priv->update_storage_medium_stmt;
		sqlite3_reset (_tmp19_);
		_tmp20_ = self->priv->update_storage_medium_stmt;
		sqlite3_bind_int (_tmp20_, 1, 1);
		_tmp21_ = self->priv->update_storage_medium_stmt;
		_tmp22_ = icon;
		_tmp23_ = g_strdup (_tmp22_);
		_tmp24_ = g_free;
		sqlite3_bind_text (_tmp21_, 2, _tmp23_, -1, _tmp24_);
		_tmp25_ = self->priv->update_storage_medium_stmt;
		_tmp26_ = display_name;
		_tmp27_ = g_strdup (_tmp26_);
		_tmp28_ = g_free;
		sqlite3_bind_text (_tmp25_, 3, _tmp27_, -1, _tmp28_);
		_tmp29_ = self->priv->update_storage_medium_stmt;
		_tmp30_ = medium_name;
		_tmp31_ = g_strdup (_tmp30_);
		_tmp32_ = g_free;
		sqlite3_bind_text (_tmp29_, 4, _tmp31_, -1, _tmp32_);
		_tmp33_ = self->priv->update_storage_medium_stmt;
		_tmp34_ = sqlite3_step (_tmp33_);
		rc = _tmp34_;
		{
			ZeitgeistSQLiteDatabase* _tmp35_;
			gint _tmp36_;
			_tmp35_ = self->priv->database;
			_tmp36_ = rc;
			zeitgeist_sq_lite_database_assert_query_success (_tmp35_, _tmp36_, "add_storage_medium", SQLITE_DONE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					goto __catch1_zeitgeist_engine_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally1;
		__catch1_zeitgeist_engine_error:
		{
			GError* e = NULL;
			GError* _tmp37_;
			const gchar* _tmp38_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp37_ = e;
			_tmp38_ = _tmp37_->message;
			g_warning ("ext-storage-monitor.vala:390: Could not add storage medium: %s", _tmp38_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp39_ = medium_name;
	_tmp40_ = medium_name;
	_tmp41_ = icon;
	_tmp42_ = display_name;
	_tmp43_ = zeitgeist_storage_media_to_variant (_tmp40_, TRUE, _tmp41_, _tmp42_);
	_tmp44_ = _tmp43_;
	g_signal_emit ((ZeitgeistRemoteStorageMonitor*) self, zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_AVAILABLE_SIGNAL], 0, _tmp39_, _tmp44_);
	_g_variant_unref0 (_tmp44_);
}


void zeitgeist_storage_monitor_remove_storage_medium (ZeitgeistStorageMonitor* self, const gchar* medium_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	sqlite3_stmt* _tmp9_;
	gint _tmp10_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (medium_name != NULL);
	_tmp0_ = medium_name;
	_tmp1_ = g_strdup_printf ("VOLUME REMOVED: %s", _tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("ext-storage-monitor.vala:399: %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->insert_unavailable_medium_stmt;
	sqlite3_reset (_tmp3_);
	_tmp4_ = self->priv->insert_unavailable_medium_stmt;
	sqlite3_bind_int (_tmp4_, 1, 0);
	_tmp5_ = self->priv->insert_unavailable_medium_stmt;
	_tmp6_ = medium_name;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_free;
	sqlite3_bind_text (_tmp5_, 2, _tmp7_, -1, _tmp8_);
	_tmp9_ = self->priv->insert_unavailable_medium_stmt;
	_tmp10_ = sqlite3_step (_tmp9_);
	if (_tmp10_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp11_;
		sqlite3_stmt* _tmp12_;
		sqlite3_stmt* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		GDestroyNotify _tmp16_;
		gint rc = 0;
		sqlite3_stmt* _tmp17_;
		gint _tmp18_;
		_tmp11_ = self->priv->update_medium_state_stmt;
		sqlite3_reset (_tmp11_);
		_tmp12_ = self->priv->update_medium_state_stmt;
		sqlite3_bind_int (_tmp12_, 1, 0);
		_tmp13_ = self->priv->update_medium_state_stmt;
		_tmp14_ = medium_name;
		_tmp15_ = g_strdup (_tmp14_);
		_tmp16_ = g_free;
		sqlite3_bind_text (_tmp13_, 2, _tmp15_, -1, _tmp16_);
		_tmp17_ = self->priv->update_medium_state_stmt;
		_tmp18_ = sqlite3_step (_tmp17_);
		rc = _tmp18_;
		{
			ZeitgeistSQLiteDatabase* _tmp19_;
			gint _tmp20_;
			_tmp19_ = self->priv->database;
			_tmp20_ = rc;
			zeitgeist_sq_lite_database_assert_query_success (_tmp19_, _tmp20_, "remove_storage_medium", SQLITE_DONE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					goto __catch2_zeitgeist_engine_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally2;
		__catch2_zeitgeist_engine_error:
		{
			GError* e = NULL;
			GError* _tmp21_;
			const gchar* _tmp22_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			g_warning ("ext-storage-monitor.vala:416: Could not remove storage medium: %s", _tmp22_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp23_ = medium_name;
	g_signal_emit ((ZeitgeistRemoteStorageMonitor*) self, zeitgeist_remote_storage_monitor_signals[ZEITGEIST_REMOTE_STORAGE_MONITOR_STORAGE_UNAVAILABLE_SIGNAL], 0, _tmp23_);
}


static GVariant* zeitgeist_storage_monitor_real_get_storages (ZeitgeistRemoteStorageMonitor* base, GError** error) {
	ZeitgeistStorageMonitor * self;
	GVariant* result = NULL;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	gint rc = 0;
	sqlite3_stmt* _tmp4_;
	ZeitgeistSQLiteDatabase* _tmp21_;
	gint _tmp22_;
	GVariantBuilder* _tmp23_;
	GVariant* _tmp24_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistStorageMonitor*) base;
	_tmp0_ = g_variant_type_new ("a(sa{sv})");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = self->priv->get_storages_stmt;
	sqlite3_reset (_tmp4_);
	while (TRUE) {
		sqlite3_stmt* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		const gchar* _tmp8_ = NULL;
		sqlite3_stmt* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		sqlite3_stmt* _tmp12_;
		const gchar* _tmp13_;
		GVariant* medium = NULL;
		sqlite3_stmt* _tmp14_;
		const gchar* _tmp15_;
		sqlite3_stmt* _tmp16_;
		gint _tmp17_;
		GVariant* _tmp18_;
		GVariantBuilder* _tmp19_;
		GVariant* _tmp20_;
		_tmp5_ = self->priv->get_storages_stmt;
		_tmp6_ = sqlite3_step (_tmp5_);
		rc = _tmp6_;
		_tmp7_ = rc;
		if (!(_tmp7_ == SQLITE_ROW)) {
			break;
		}
		_tmp9_ = self->priv->get_storages_stmt;
		_tmp10_ = sqlite3_column_text (_tmp9_, 2);
		_tmp8_ = _tmp10_;
		if (_tmp8_ == NULL) {
			_tmp8_ = "";
		}
		_tmp12_ = self->priv->get_storages_stmt;
		_tmp13_ = sqlite3_column_text (_tmp12_, 3);
		_tmp11_ = _tmp13_;
		if (_tmp11_ == NULL) {
			_tmp11_ = "";
		}
		_tmp14_ = self->priv->get_storages_stmt;
		_tmp15_ = sqlite3_column_text (_tmp14_, 0);
		_tmp16_ = self->priv->get_storages_stmt;
		_tmp17_ = sqlite3_column_int (_tmp16_, 1);
		_tmp18_ = zeitgeist_storage_media_to_variant (_tmp15_, _tmp17_ == 1, _tmp8_, _tmp11_);
		medium = _tmp18_;
		_tmp19_ = vb;
		_tmp20_ = medium;
		g_variant_builder_add_value (_tmp19_, _tmp20_);
		_g_variant_unref0 (medium);
	}
	_tmp21_ = self->priv->database;
	_tmp22_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp21_, _tmp22_, "get_storages", SQLITE_DONE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_builder_unref0 (vb);
			return NULL;
		} else {
			_g_variant_builder_unref0 (vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp23_ = vb;
	_tmp24_ = g_variant_builder_end (_tmp23_);
	g_variant_ref_sink (_tmp24_);
	result = _tmp24_;
	_g_variant_builder_unref0 (vb);
	return result;
}


static void _zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	zeitgeist_storage_monitor_name_appeared_handler ((ZeitgeistStorageMonitor*) self, connection, name, name_owner);
}


static GObject * zeitgeist_storage_monitor_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistStorageMonitor * self;
	guint _tmp6_;
	guint _tmp7_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_storage_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitor);
	{
		zeitgeist_storage_monitor_prepare_queries (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch3_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	goto __finally3;
	__catch3_zeitgeist_engine_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("ext-storage-monitor.vala:136: Storage Monitor couldn't communicate wit" \
"h DB - bye");
		_g_error_free0 (e);
		return obj;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		guint _tmp1_ = 0U;
		GDBusConnection* _tmp2_;
		guint _tmp3_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp2_ = connection;
		_tmp3_ = zeitgeist_remote_storage_monitor_register_object ((ZeitgeistRemoteStorageMonitor*) self, _tmp2_, "/org/gnome/zeitgeist/storagemonitor", &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch4_g_error;
		}
		self->priv->registration_id = _tmp1_;
		_g_object_unref0 (connection);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("ext-storage-monitor.vala:149: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp6_ = g_bus_watch_name_with_closures (G_BUS_TYPE_SYSTEM, "net.connman", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	self->priv->watch_connman = _tmp6_;
	_tmp7_ = g_bus_watch_name_with_closures (G_BUS_TYPE_SYSTEM, "org.freedesktop.NetworkManager", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_storage_monitor_name_appeared_handler_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	self->priv->watch_nm = _tmp7_;
	return obj;
}


static void zeitgeist_storage_monitor_class_init (ZeitgeistStorageMonitorClass * klass) {
	zeitgeist_storage_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistStorageMonitorPrivate));
	((ZeitgeistExtensionClass *) klass)->unload = (void (*) (ZeitgeistExtension *)) zeitgeist_storage_monitor_real_unload;
	((ZeitgeistExtensionClass *) klass)->pre_insert_events = (void (*) (ZeitgeistExtension *, GPtrArray*, const char*)) zeitgeist_storage_monitor_real_pre_insert_events;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_storage_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_storage_monitor_finalize;
}


static void zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_interface_init (ZeitgeistRemoteStorageMonitorIface * iface) {
	zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_storages = (GVariant* (*) (ZeitgeistRemoteStorageMonitor *, GError**)) zeitgeist_storage_monitor_real_get_storages;
}


static void zeitgeist_storage_monitor_instance_init (ZeitgeistStorageMonitor * self) {
	self->priv = ZEITGEIST_STORAGE_MONITOR_GET_PRIVATE (self);
}


static void zeitgeist_storage_monitor_finalize (GObject * obj) {
	ZeitgeistStorageMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_STORAGE_MONITOR, ZeitgeistStorageMonitor);
	_g_object_unref0 (self->priv->database);
	_sqlite3_finalize0 (self->priv->get_storages_stmt);
	_sqlite3_finalize0 (self->priv->store_storage_medium_stmt);
	_sqlite3_finalize0 (self->priv->update_storage_medium_stmt);
	_sqlite3_finalize0 (self->priv->insert_unavailable_medium_stmt);
	_sqlite3_finalize0 (self->priv->update_medium_state_stmt);
	_g_object_unref0 (self->priv->network);
	G_OBJECT_CLASS (zeitgeist_storage_monitor_parent_class)->finalize (obj);
}


GType zeitgeist_storage_monitor_get_type (void) {
	return zeitgeist_storage_monitor_type_id;
}


GType zeitgeist_storage_monitor_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistStorageMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_storage_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistStorageMonitor), 0, (GInstanceInitFunc) zeitgeist_storage_monitor_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_storage_monitor_info = { (GInterfaceInitFunc) zeitgeist_storage_monitor_zeitgeist_remote_storage_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_storage_monitor_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistStorageMonitor", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_storage_monitor_type_id, ZEITGEIST_TYPE_REMOTE_STORAGE_MONITOR, &zeitgeist_remote_storage_monitor_info);
	return zeitgeist_storage_monitor_type_id;
}


ZeitgeistNMNetworkMonitor* zeitgeist_nm_network_monitor_construct (GType object_type) {
	ZeitgeistNMNetworkMonitor * self = NULL;
	self = (ZeitgeistNMNetworkMonitor*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistNMNetworkMonitor* zeitgeist_nm_network_monitor_new (void) {
	return zeitgeist_nm_network_monitor_construct (ZEITGEIST_TYPE_NM_NETWORK_MONITOR);
}


static void _zeitgeist_nm_network_monitor_on_state_changed_zeitgeist_network_manager_dbus_state_changed (ZeitgeistNetworkManagerDBus* _sender, guint32 state, gpointer self) {
	zeitgeist_nm_network_monitor_on_state_changed ((ZeitgeistNMNetworkMonitor*) self, state);
}


static void zeitgeist_nm_network_monitor_real_setup (ZeitgeistNetworkMonitor* base) {
	ZeitgeistNMNetworkMonitor * self;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistNMNetworkMonitor*) base;
	g_debug ("ext-storage-monitor.vala:469: Creating NetworkManager network monitor");
	{
		ZeitgeistNetworkManagerDBus* _tmp0_ = NULL;
		ZeitgeistNetworkManagerDBus* _tmp1_;
		ZeitgeistNetworkManagerDBus* _tmp2_;
		ZeitgeistNetworkManagerDBus* _tmp3_;
		guint32 state = 0U;
		ZeitgeistNetworkManagerDBus* _tmp4_;
		guint32 _tmp5_;
		guint32 _tmp6_;
		_tmp1_ = g_initable_new (ZEITGEIST_TYPE_NETWORK_MANAGER_DBUS_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", ZEITGEIST_NM_NETWORK_MONITOR_NM_BUS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", ZEITGEIST_NM_NETWORK_MONITOR_NM_OBJECT_PATH, "g-interface-name", "org.freedesktop.NetworkManager", "g-interface-info", g_type_get_qdata (ZEITGEIST_TYPE_NETWORK_MANAGER_DBUS, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_tmp0_ = (ZeitgeistNetworkManagerDBus*) _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = _tmp2_;
		_tmp3_ = self->priv->proxy;
		g_signal_connect_object (_tmp3_, "state-changed", (GCallback) _zeitgeist_nm_network_monitor_on_state_changed_zeitgeist_network_manager_dbus_state_changed, self, 0);
		_tmp4_ = self->priv->proxy;
		_tmp5_ = zeitgeist_network_manager_dbus_state (_tmp4_, &_inner_error_);
		state = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			goto __finally5;
		}
		_tmp6_ = state;
		zeitgeist_nm_network_monitor_on_state_changed (self, _tmp6_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally5;
	__catch5_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("ext-storage-monitor.vala:482: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void zeitgeist_nm_network_monitor_on_state_changed (ZeitgeistNMNetworkMonitor* self, guint32 state) {
	guint32 _tmp0_;
	gboolean _tmp1_ = FALSE;
	guint32 _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = state;
	g_debug ("ext-storage-monitor.vala:488: NetworkManager network state: %u", (guint) _tmp0_);
	_tmp2_ = state;
	if (_tmp2_ == ((guint32) ZEITGEIST_NM_NETWORK_MONITOR_NM_STATE_CONNECTED_PRE_09)) {
		_tmp1_ = TRUE;
	} else {
		guint32 _tmp3_;
		_tmp3_ = state;
		_tmp1_ = _tmp3_ == ((guint32) ZEITGEIST_NM_NETWORK_MONITOR_NM_STATE_CONNECTED_POST_09);
	}
	if (_tmp1_) {
		g_signal_emit ((ZeitgeistNetworkMonitor*) self, zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_UP_SIGNAL], 0);
	} else {
		g_signal_emit ((ZeitgeistNetworkMonitor*) self, zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_DOWN_SIGNAL], 0);
	}
}


static void zeitgeist_nm_network_monitor_class_init (ZeitgeistNMNetworkMonitorClass * klass) {
	zeitgeist_nm_network_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistNMNetworkMonitorPrivate));
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_nm_network_monitor_finalize;
}


static void zeitgeist_nm_network_monitor_zeitgeist_network_monitor_interface_init (ZeitgeistNetworkMonitorIface * iface) {
	zeitgeist_nm_network_monitor_zeitgeist_network_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->setup = (void (*) (ZeitgeistNetworkMonitor *)) zeitgeist_nm_network_monitor_real_setup;
}


static void zeitgeist_nm_network_monitor_instance_init (ZeitgeistNMNetworkMonitor * self) {
	self->priv = ZEITGEIST_NM_NETWORK_MONITOR_GET_PRIVATE (self);
}


static void zeitgeist_nm_network_monitor_finalize (GObject * obj) {
	ZeitgeistNMNetworkMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_NM_NETWORK_MONITOR, ZeitgeistNMNetworkMonitor);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (zeitgeist_nm_network_monitor_parent_class)->finalize (obj);
}


GType zeitgeist_nm_network_monitor_get_type (void) {
	return zeitgeist_nm_network_monitor_type_id;
}


GType zeitgeist_nm_network_monitor_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistNMNetworkMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_nm_network_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistNMNetworkMonitor), 0, (GInstanceInitFunc) zeitgeist_nm_network_monitor_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_network_monitor_info = { (GInterfaceInitFunc) zeitgeist_nm_network_monitor_zeitgeist_network_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_nm_network_monitor_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ZeitgeistNMNetworkMonitor", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_nm_network_monitor_type_id, ZEITGEIST_TYPE_NETWORK_MONITOR, &zeitgeist_network_monitor_info);
	return zeitgeist_nm_network_monitor_type_id;
}


ZeitgeistConnmanNetworkMonitor* zeitgeist_connman_network_monitor_construct (GType object_type) {
	ZeitgeistConnmanNetworkMonitor * self = NULL;
	self = (ZeitgeistConnmanNetworkMonitor*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistConnmanNetworkMonitor* zeitgeist_connman_network_monitor_new (void) {
	return zeitgeist_connman_network_monitor_construct (ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR);
}


static void _zeitgeist_connman_network_monitor_on_state_changed_zeitgeist_connman_manager_dbus_state_changed (ZeitgeistConnmanManagerDBus* _sender, const gchar* state, gpointer self) {
	zeitgeist_connman_network_monitor_on_state_changed ((ZeitgeistConnmanNetworkMonitor*) self, state);
}


static void zeitgeist_connman_network_monitor_real_setup (ZeitgeistNetworkMonitor* base) {
	ZeitgeistConnmanNetworkMonitor * self;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistConnmanNetworkMonitor*) base;
	g_debug ("ext-storage-monitor.vala:512: Creating ConnmanNetworkManager network m" \
"onitor");
	{
		ZeitgeistConnmanManagerDBus* _tmp0_ = NULL;
		ZeitgeistConnmanManagerDBus* _tmp1_;
		ZeitgeistConnmanManagerDBus* _tmp2_;
		ZeitgeistConnmanManagerDBus* _tmp3_;
		gchar* state = NULL;
		ZeitgeistConnmanManagerDBus* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = g_initable_new (ZEITGEIST_TYPE_CONNMAN_MANAGER_DBUS_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_BUS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", ZEITGEIST_CONNMAN_NETWORK_MONITOR_CM_OBJECT_PATH, "g-interface-name", "net.connman.Manager", "g-interface-info", g_type_get_qdata (ZEITGEIST_TYPE_CONNMAN_MANAGER_DBUS, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_tmp0_ = (ZeitgeistConnmanManagerDBus*) _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = _tmp2_;
		_tmp3_ = self->priv->proxy;
		g_signal_connect_object (_tmp3_, "state-changed", (GCallback) _zeitgeist_connman_network_monitor_on_state_changed_zeitgeist_connman_manager_dbus_state_changed, self, 0);
		_tmp4_ = self->priv->proxy;
		_tmp5_ = zeitgeist_connman_manager_dbus_get_state (_tmp4_, &_inner_error_);
		state = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			goto __finally6;
		}
		_tmp6_ = state;
		zeitgeist_connman_network_monitor_on_state_changed (self, _tmp6_);
		_g_free0 (state);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally6;
	__catch6_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("ext-storage-monitor.vala:530: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void zeitgeist_connman_network_monitor_on_state_changed (ZeitgeistConnmanNetworkMonitor* self, const gchar* state) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	_tmp0_ = state;
	g_debug ("ext-storage-monitor.vala:536: ConnmanNetworkMonitor network state: %s", _tmp0_);
	_tmp1_ = state;
	if (g_strcmp0 (_tmp1_, "online") == 0) {
		g_signal_emit ((ZeitgeistNetworkMonitor*) self, zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_UP_SIGNAL], 0);
	} else {
		g_signal_emit ((ZeitgeistNetworkMonitor*) self, zeitgeist_network_monitor_signals[ZEITGEIST_NETWORK_MONITOR_ON_NETWORK_DOWN_SIGNAL], 0);
	}
}


static void zeitgeist_connman_network_monitor_class_init (ZeitgeistConnmanNetworkMonitorClass * klass) {
	zeitgeist_connman_network_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistConnmanNetworkMonitorPrivate));
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_connman_network_monitor_finalize;
}


static void zeitgeist_connman_network_monitor_zeitgeist_network_monitor_interface_init (ZeitgeistNetworkMonitorIface * iface) {
	zeitgeist_connman_network_monitor_zeitgeist_network_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->setup = (void (*) (ZeitgeistNetworkMonitor *)) zeitgeist_connman_network_monitor_real_setup;
}


static void zeitgeist_connman_network_monitor_instance_init (ZeitgeistConnmanNetworkMonitor * self) {
	self->priv = ZEITGEIST_CONNMAN_NETWORK_MONITOR_GET_PRIVATE (self);
}


static void zeitgeist_connman_network_monitor_finalize (GObject * obj) {
	ZeitgeistConnmanNetworkMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_CONNMAN_NETWORK_MONITOR, ZeitgeistConnmanNetworkMonitor);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (zeitgeist_connman_network_monitor_parent_class)->finalize (obj);
}


GType zeitgeist_connman_network_monitor_get_type (void) {
	return zeitgeist_connman_network_monitor_type_id;
}


GType zeitgeist_connman_network_monitor_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistConnmanNetworkMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_connman_network_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistConnmanNetworkMonitor), 0, (GInstanceInitFunc) zeitgeist_connman_network_monitor_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_network_monitor_info = { (GInterfaceInitFunc) zeitgeist_connman_network_monitor_zeitgeist_network_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_connman_network_monitor_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ZeitgeistConnmanNetworkMonitor", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_connman_network_monitor_type_id, ZEITGEIST_TYPE_NETWORK_MONITOR, &zeitgeist_network_monitor_info);
	return zeitgeist_connman_network_monitor_type_id;
}


GType zeitgeist_storage_monitor_init (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_remote_storage_monitor_register_type (module);
	zeitgeist_remote_storage_monitor_proxy_register_dynamic_type (module);
	zeitgeist_storage_monitor_register_type (module);
	zeitgeist_network_monitor_register_type (module);
	zeitgeist_nm_network_monitor_register_type (module);
	zeitgeist_connman_network_monitor_register_type (module);
	result = ZEITGEIST_TYPE_STORAGE_MONITOR;
	return result;
}



