/* recent-manager-provider.c generated by valac 0.26.1, the Vala compiler
 * generated from recent-manager-provider.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 * Authored by Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "zeitgeist-datamodel.h"
#include <gio/gio.h>


#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_RECENT_MANAGER_GTK (recent_manager_gtk_get_type ())
#define RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtk))
#define RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))
#define IS_RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_MANAGER_GTK))
#define IS_RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_MANAGER_GTK))
#define RECENT_MANAGER_GTK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))

typedef struct _RecentManagerGtk RecentManagerGtk;
typedef struct _RecentManagerGtkClass RecentManagerGtkClass;
typedef struct _RecentManagerGtkPrivate RecentManagerGtkPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _RecentManagerGtk {
	DataProvider parent_instance;
	RecentManagerGtkPrivate * priv;
};

struct _RecentManagerGtkClass {
	DataProviderClass parent_class;
};

struct _RecentManagerGtkPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	GtkRecentManager* recent_manager;
	guint idle_id;
};


static gpointer recent_manager_gtk_parent_class = NULL;

GType data_provider_get_type (void) G_GNUC_CONST;
GType data_hub_get_type (void) G_GNUC_CONST;
GType recent_manager_gtk_get_type (void) G_GNUC_CONST;
#define RECENT_MANAGER_GTK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkPrivate))
enum  {
	RECENT_MANAGER_GTK_DUMMY_PROPERTY,
	RECENT_MANAGER_GTK_UNIQUE_ID,
	RECENT_MANAGER_GTK_NAME,
	RECENT_MANAGER_GTK_DESCRIPTION,
	RECENT_MANAGER_GTK_DATAHUB,
	RECENT_MANAGER_GTK_ENABLED,
	RECENT_MANAGER_GTK_REGISTER
};
RecentManagerGtk* recent_manager_gtk_new (DataHub* datahub);
RecentManagerGtk* recent_manager_gtk_construct (GType object_type, DataHub* datahub);
static void recent_manager_gtk_real_start (DataProvider* base);
static void recent_manager_gtk_items_changed (RecentManagerGtk* self);
static void _recent_manager_gtk_items_changed_gtk_recent_manager_changed (GtkRecentManager* _sender, gpointer self);
GPtrArray* recent_manager_gtk_get_items (RecentManagerGtk* self);
static void recent_manager_gtk_real_stop (DataProvider* base);
static gboolean ___lambda4_ (RecentManagerGtk* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
DataHub* data_provider_get_datahub (DataProvider* self);
gchar** data_hub_get_data_source_actors (DataHub* self, gboolean only_enabled, int* result_length1);
gchar* utils_get_ooo_desktop_file_for_mimetype (const gchar* mimetype);
gchar* utils_find_desktop_file_for_app (const gchar* app_name, const gchar* mimetype);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
gint64 data_provider_get_last_timestamp (DataProvider* self);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
void data_provider_set_last_timestamp (DataProvider* self, gint64 value);
static GObject * recent_manager_gtk_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void recent_manager_gtk_finalize (GObject* obj);
const gchar* data_provider_get_unique_id (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
static void _vala_recent_manager_gtk_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void data_provider_set_unique_id (DataProvider* self, const gchar* value);
void data_provider_set_name (DataProvider* self, const gchar* value);
void data_provider_set_description (DataProvider* self, const gchar* value);
void data_provider_set_datahub (DataProvider* self, DataHub* value);
void data_provider_set_enabled (DataProvider* self, gboolean value);
void data_provider_set_register (DataProvider* self, gboolean value);
static void _vala_recent_manager_gtk_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RecentManagerGtk* recent_manager_gtk_construct (GType object_type, DataHub* datahub) {
	RecentManagerGtk * self = NULL;
	DataHub* _tmp0_ = NULL;
	g_return_val_if_fail (datahub != NULL, NULL);
	_tmp0_ = datahub;
	self = (RecentManagerGtk*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,recent", "name", "Recently Used Documents", "description", "Logs events from GtkRecentlyUsed", "datahub", _tmp0_, NULL);
	return self;
}


RecentManagerGtk* recent_manager_gtk_new (DataHub* datahub) {
	return recent_manager_gtk_construct (TYPE_RECENT_MANAGER_GTK, datahub);
}


static void _recent_manager_gtk_items_changed_gtk_recent_manager_changed (GtkRecentManager* _sender, gpointer self) {
	recent_manager_gtk_items_changed ((RecentManagerGtk*) self);
}


static void recent_manager_gtk_real_start (DataProvider* base) {
	RecentManagerGtk * self;
	GtkRecentManager* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->recent_manager;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) _recent_manager_gtk_items_changed_gtk_recent_manager_changed, self, 0);
	_tmp1_ = recent_manager_gtk_get_items (self);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp2_);
	_g_ptr_array_unref0 (_tmp2_);
}


static void recent_manager_gtk_real_stop (DataProvider* base) {
	RecentManagerGtk * self;
	GtkRecentManager* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->recent_manager;
	g_signal_parse_name ("changed", gtk_recent_manager_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _recent_manager_gtk_items_changed_gtk_recent_manager_changed, self);
}


static gboolean ___lambda4_ (RecentManagerGtk* self) {
	gboolean result = FALSE;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	_tmp0_ = recent_manager_gtk_get_items (self);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	self->priv->idle_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((RecentManagerGtk*) self);
	return result;
}


static void recent_manager_gtk_items_changed (RecentManagerGtk* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->idle_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->idle_id = _tmp1_;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
	return self ? gtk_recent_info_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _gtk_recent_info_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
	g_list_free (self);
}


GPtrArray* recent_manager_gtk_get_items (RecentManagerGtk* self) {
	GPtrArray* result = NULL;
	GPtrArray* events = NULL;
	GPtrArray* _tmp0_ = NULL;
	gint64 signal_time = 0LL;
	gint64 _tmp1_ = 0LL;
	gchar** ignored_actors = NULL;
	DataHub* _tmp2_ = NULL;
	DataHub* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gint ignored_actors_length1 = 0;
	gint _ignored_actors_size_ = 0;
	GtkRecentManager* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	gint64 _tmp159_ = 0LL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	events = _tmp0_;
	_tmp1_ = zeitgeist_timestamp_from_now ();
	signal_time = _tmp1_;
	_tmp2_ = data_provider_get_datahub ((DataProvider*) self);
	_tmp3_ = _tmp2_;
	_tmp5_ = data_hub_get_data_source_actors (_tmp3_, TRUE, &_tmp4_);
	ignored_actors = _tmp5_;
	ignored_actors_length1 = _tmp4_;
	_ignored_actors_size_ = ignored_actors_length1;
	_tmp6_ = self->priv->recent_manager;
	_tmp7_ = gtk_recent_manager_get_items (_tmp6_);
	{
		GList* ri_collection = NULL;
		GList* ri_it = NULL;
		ri_collection = _tmp7_;
		for (ri_it = ri_collection; ri_it != NULL; ri_it = ri_it->next) {
			GtkRecentInfo* _tmp8_ = NULL;
			GtkRecentInfo* ri = NULL;
			_tmp8_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) ri_it->data);
			ri = _tmp8_;
			{
				GFile* file_obj = NULL;
				GtkRecentInfo* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				GFile* _tmp11_ = NULL;
				gchar* uri = NULL;
				GFile* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				GtkRecentInfo* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp19_ = FALSE;
				GtkRecentInfo* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				gchar* last_app = NULL;
				GtkRecentInfo* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				const gchar* exec_str = NULL;
				guint count = 0U;
				gulong time_ = 0UL;
				gboolean registered = FALSE;
				GtkRecentInfo* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				guint _tmp32_ = 0U;
				gulong _tmp33_ = 0UL;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				gchar** exec = NULL;
				const gchar* _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gchar** _tmp40_ = NULL;
				gint exec_length1 = 0;
				gint _exec_size_ = 0;
				gchar* desktop_file = NULL;
				gboolean _tmp41_ = FALSE;
				gchar** _tmp42_ = NULL;
				gint _tmp42__length1 = 0;
				const gchar* _tmp43_ = NULL;
				const gchar* _tmp66_ = NULL;
				gchar* actor = NULL;
				const gchar* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
				gchar* _tmp74_ = NULL;
				gchar* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
				gchar** _tmp78_ = NULL;
				gint _tmp78__length1 = 0;
				GFile* parent_file = NULL;
				GFile* _tmp79_ = NULL;
				GFile* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				GFile* _tmp82_ = NULL;
				gchar* origin = NULL;
				gchar* _tmp87_ = NULL;
				ZeitgeistSubject* subject = NULL;
				const gchar* _tmp88_ = NULL;
				GtkRecentInfo* _tmp89_ = NULL;
				const gchar* _tmp90_ = NULL;
				const gchar* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				const gchar* _tmp93_ = NULL;
				GtkRecentInfo* _tmp94_ = NULL;
				const gchar* _tmp95_ = NULL;
				const gchar* _tmp96_ = NULL;
				GtkRecentInfo* _tmp97_ = NULL;
				const gchar* _tmp98_ = NULL;
				ZeitgeistSubject* _tmp99_ = NULL;
				ZeitgeistEvent* event = NULL;
				gint64 timestamp = 0LL;
				gboolean log_create = FALSE;
				gboolean log_modify = FALSE;
				gboolean log_access = FALSE;
				GtkRecentInfo* _tmp100_ = NULL;
				gulong _tmp101_ = 0UL;
				GtkRecentInfo* _tmp102_ = NULL;
				gulong _tmp103_ = 0UL;
				GtkRecentInfo* _tmp104_ = NULL;
				gulong _tmp105_ = 0UL;
				GtkRecentInfo* _tmp106_ = NULL;
				gulong _tmp107_ = 0UL;
				gboolean _tmp108_ = FALSE;
				gboolean _tmp125_ = FALSE;
				gboolean _tmp142_ = FALSE;
				_tmp9_ = ri;
				_tmp10_ = gtk_recent_info_get_uri (_tmp9_);
				_tmp11_ = g_file_new_for_uri (_tmp10_);
				file_obj = _tmp11_;
				_tmp12_ = file_obj;
				_tmp13_ = g_file_get_uri (_tmp12_);
				uri = _tmp13_;
				_tmp15_ = ri;
				_tmp16_ = gtk_recent_info_get_private_hint (_tmp15_);
				if (_tmp16_) {
					_tmp14_ = TRUE;
				} else {
					const gchar* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					_tmp17_ = uri;
					_tmp18_ = g_str_has_prefix (_tmp17_, "file:///tmp/");
					_tmp14_ = _tmp18_;
				}
				if (_tmp14_) {
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp20_ = ri;
				_tmp21_ = gtk_recent_info_is_local (_tmp20_);
				if (_tmp21_) {
					GtkRecentInfo* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
					_tmp22_ = ri;
					_tmp23_ = gtk_recent_info_exists (_tmp22_);
					_tmp19_ = !_tmp23_;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp24_ = ri;
				_tmp25_ = gtk_recent_info_last_application (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = string_strip (_tmp26_);
				_tmp28_ = _tmp27_;
				_g_free0 (_tmp26_);
				last_app = _tmp28_;
				_tmp29_ = ri;
				_tmp30_ = last_app;
				_tmp34_ = gtk_recent_info_get_application_info (_tmp29_, _tmp30_, &_tmp31_, &_tmp32_, &_tmp33_);
				exec_str = _tmp31_;
				count = _tmp32_;
				time_ = _tmp33_;
				registered = _tmp34_;
				_tmp35_ = registered;
				if (!_tmp35_) {
					const gchar* _tmp36_ = NULL;
					GtkRecentInfo* _tmp37_ = NULL;
					_tmp36_ = last_app;
					_tmp37_ = ri;
					g_warning ("recent-manager-provider.vala:106: %s was not registered in RecentInfo " \
"item %p", _tmp36_, _tmp37_);
					_g_free0 (last_app);
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp38_ = exec_str;
				_tmp40_ = _tmp39_ = g_strsplit_set (_tmp38_, " \t\n", 2);
				exec = _tmp40_;
				exec_length1 = _vala_array_length (_tmp39_);
				_exec_size_ = exec_length1;
				_tmp42_ = exec;
				_tmp42__length1 = exec_length1;
				_tmp43_ = _tmp42_[0];
				if (g_strcmp0 (_tmp43_, "soffice") == 0) {
					_tmp41_ = TRUE;
				} else {
					gchar** _tmp44_ = NULL;
					gint _tmp44__length1 = 0;
					const gchar* _tmp45_ = NULL;
					_tmp44_ = exec;
					_tmp44__length1 = exec_length1;
					_tmp45_ = _tmp44_[0];
					_tmp41_ = g_strcmp0 (_tmp45_, "ooffice") == 0;
				}
				if (_tmp41_) {
					GtkRecentInfo* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					_tmp46_ = ri;
					_tmp47_ = gtk_recent_info_get_mime_type (_tmp46_);
					_tmp48_ = utils_get_ooo_desktop_file_for_mimetype (_tmp47_);
					_g_free0 (desktop_file);
					desktop_file = _tmp48_;
				} else {
					gchar** _tmp49_ = NULL;
					gint _tmp49__length1 = 0;
					const gchar* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					gboolean _tmp52_ = FALSE;
					const gchar* _tmp53_ = NULL;
					_tmp49_ = exec;
					_tmp49__length1 = exec_length1;
					_tmp50_ = _tmp49_[0];
					_tmp51_ = utils_find_desktop_file_for_app (_tmp50_, NULL);
					_g_free0 (desktop_file);
					desktop_file = _tmp51_;
					_tmp53_ = desktop_file;
					if (_tmp53_ == NULL) {
						gchar** _tmp54_ = NULL;
						gint _tmp54__length1 = 0;
						const gchar* _tmp55_ = NULL;
						gboolean _tmp56_ = FALSE;
						_tmp54_ = exec;
						_tmp54__length1 = exec_length1;
						_tmp55_ = _tmp54_[0];
						_tmp56_ = g_str_has_suffix (_tmp55_, "-bin");
						_tmp52_ = _tmp56_;
					} else {
						_tmp52_ = FALSE;
					}
					if (_tmp52_) {
						gchar** _tmp57_ = NULL;
						gint _tmp57__length1 = 0;
						const gchar* _tmp58_ = NULL;
						gchar** _tmp59_ = NULL;
						gint _tmp59__length1 = 0;
						const gchar* _tmp60_ = NULL;
						gint _tmp61_ = 0;
						gint _tmp62_ = 0;
						gchar* _tmp63_ = NULL;
						gchar* _tmp64_ = NULL;
						gchar* _tmp65_ = NULL;
						_tmp57_ = exec;
						_tmp57__length1 = exec_length1;
						_tmp58_ = _tmp57_[0];
						_tmp59_ = exec;
						_tmp59__length1 = exec_length1;
						_tmp60_ = _tmp59_[0];
						_tmp61_ = strlen (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = string_substring (_tmp58_, (glong) 0, (glong) (_tmp62_ - 4));
						_tmp64_ = _tmp63_;
						_tmp65_ = utils_find_desktop_file_for_app (_tmp64_, NULL);
						_g_free0 (desktop_file);
						desktop_file = _tmp65_;
						_g_free0 (_tmp64_);
					}
				}
				_tmp66_ = desktop_file;
				if (_tmp66_ == NULL) {
					const gchar* _tmp67_ = NULL;
					gchar** _tmp68_ = NULL;
					gint _tmp68__length1 = 0;
					const gchar* _tmp69_ = NULL;
					GtkRecentInfo* _tmp70_ = NULL;
					const gchar* _tmp71_ = NULL;
					_tmp67_ = uri;
					_tmp68_ = exec;
					_tmp68__length1 = exec_length1;
					_tmp69_ = _tmp68_[0];
					_tmp70_ = ri;
					_tmp71_ = gtk_recent_info_get_mime_type (_tmp70_);
					g_debug ("recent-manager-provider.vala:132: Desktop file for \"%s\" was not foun" \
"d, exec: %s, mime_type: %s", _tmp67_, _tmp69_, _tmp71_);
					_g_free0 (desktop_file);
					exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (last_app);
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp72_ = desktop_file;
				_tmp73_ = g_path_get_basename (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strdup_printf ("application://%s", _tmp74_);
				_tmp76_ = _tmp75_;
				_g_free0 (_tmp74_);
				actor = _tmp76_;
				_tmp77_ = actor;
				_tmp78_ = ignored_actors;
				_tmp78__length1 = ignored_actors_length1;
				if (_vala_string_array_contains (_tmp78_, _tmp78__length1, _tmp77_)) {
					_g_free0 (actor);
					_g_free0 (desktop_file);
					exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (last_app);
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp79_ = file_obj;
				_tmp80_ = g_file_get_parent (_tmp79_);
				parent_file = _tmp80_;
				_tmp82_ = parent_file;
				if (_tmp82_ != NULL) {
					GFile* _tmp83_ = NULL;
					gchar* _tmp84_ = NULL;
					_tmp83_ = parent_file;
					_tmp84_ = g_file_get_uri (_tmp83_);
					_g_free0 (_tmp81_);
					_tmp81_ = _tmp84_;
				} else {
					const gchar* _tmp85_ = NULL;
					gchar* _tmp86_ = NULL;
					_tmp85_ = uri;
					_tmp86_ = g_path_get_dirname (_tmp85_);
					_g_free0 (_tmp81_);
					_tmp81_ = _tmp86_;
				}
				_tmp87_ = g_strdup (_tmp81_);
				origin = _tmp87_;
				_tmp88_ = uri;
				_tmp89_ = ri;
				_tmp90_ = gtk_recent_info_get_mime_type (_tmp89_);
				_tmp91_ = zeitgeist_interpretation_for_mimetype (_tmp90_);
				_tmp92_ = uri;
				_tmp93_ = zeitgeist_manifestation_for_uri (_tmp92_);
				_tmp94_ = ri;
				_tmp95_ = gtk_recent_info_get_mime_type (_tmp94_);
				_tmp96_ = origin;
				_tmp97_ = ri;
				_tmp98_ = gtk_recent_info_get_display_name (_tmp97_);
				_tmp99_ = zeitgeist_subject_new_full (_tmp88_, _tmp91_, _tmp93_, _tmp95_, _tmp96_, _tmp98_, "");
				subject = _tmp99_;
				log_create = TRUE;
				log_modify = TRUE;
				log_access = TRUE;
				_tmp100_ = ri;
				_tmp101_ = gtk_recent_info_get_added (_tmp100_);
				_tmp102_ = ri;
				_tmp103_ = gtk_recent_info_get_modified (_tmp102_);
				if (_tmp101_ == _tmp103_) {
					log_modify = FALSE;
				}
				_tmp104_ = ri;
				_tmp105_ = gtk_recent_info_get_modified (_tmp104_);
				_tmp106_ = ri;
				_tmp107_ = gtk_recent_info_get_visited (_tmp106_);
				if (_tmp105_ == _tmp107_) {
					log_access = FALSE;
				}
				_tmp108_ = log_create;
				if (_tmp108_) {
					const gchar* _tmp109_ = NULL;
					ZeitgeistEvent* _tmp110_ = NULL;
					ZeitgeistEvent* _tmp111_ = NULL;
					ZeitgeistSubject* _tmp112_ = NULL;
					GtkRecentInfo* _tmp113_ = NULL;
					gulong _tmp114_ = 0UL;
					gint64 _tmp115_ = 0LL;
					ZeitgeistEvent* _tmp116_ = NULL;
					gint64 _tmp117_ = 0LL;
					gboolean _tmp118_ = FALSE;
					gint64 _tmp119_ = 0LL;
					gint64 _tmp120_ = 0LL;
					gint64 _tmp121_ = 0LL;
					_tmp109_ = actor;
					_tmp110_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, _tmp109_, NULL, NULL, NULL);
					_g_object_unref0 (event);
					event = _tmp110_;
					_tmp111_ = event;
					_tmp112_ = subject;
					zeitgeist_event_add_subject (_tmp111_, _tmp112_);
					_tmp113_ = ri;
					_tmp114_ = gtk_recent_info_get_added (_tmp113_);
					timestamp = (gint64) _tmp114_;
					_tmp115_ = timestamp;
					timestamp = _tmp115_ * 1000;
					_tmp116_ = event;
					_tmp117_ = timestamp;
					zeitgeist_event_set_timestamp (_tmp116_, _tmp117_);
					_tmp119_ = timestamp;
					_tmp120_ = data_provider_get_last_timestamp ((DataProvider*) self);
					_tmp121_ = _tmp120_;
					if (_tmp119_ > _tmp121_) {
						gint64 _tmp122_ = 0LL;
						_tmp122_ = timestamp;
						_tmp118_ = _tmp122_ >= ((gint64) 0);
					} else {
						_tmp118_ = FALSE;
					}
					if (_tmp118_) {
						GPtrArray* _tmp123_ = NULL;
						ZeitgeistEvent* _tmp124_ = NULL;
						_tmp123_ = events;
						_tmp124_ = event;
						event = NULL;
						g_ptr_array_add (_tmp123_, _tmp124_);
					}
				}
				_tmp125_ = log_modify;
				if (_tmp125_) {
					const gchar* _tmp126_ = NULL;
					ZeitgeistEvent* _tmp127_ = NULL;
					ZeitgeistEvent* _tmp128_ = NULL;
					ZeitgeistSubject* _tmp129_ = NULL;
					GtkRecentInfo* _tmp130_ = NULL;
					gulong _tmp131_ = 0UL;
					gint64 _tmp132_ = 0LL;
					ZeitgeistEvent* _tmp133_ = NULL;
					gint64 _tmp134_ = 0LL;
					gboolean _tmp135_ = FALSE;
					gint64 _tmp136_ = 0LL;
					gint64 _tmp137_ = 0LL;
					gint64 _tmp138_ = 0LL;
					_tmp126_ = actor;
					_tmp127_ = zeitgeist_event_new_full (ZEITGEIST_ZG_MODIFY_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, _tmp126_, NULL, NULL, NULL);
					_g_object_unref0 (event);
					event = _tmp127_;
					_tmp128_ = event;
					_tmp129_ = subject;
					zeitgeist_event_add_subject (_tmp128_, _tmp129_);
					_tmp130_ = ri;
					_tmp131_ = gtk_recent_info_get_modified (_tmp130_);
					timestamp = (gint64) _tmp131_;
					_tmp132_ = timestamp;
					timestamp = _tmp132_ * 1000;
					_tmp133_ = event;
					_tmp134_ = timestamp;
					zeitgeist_event_set_timestamp (_tmp133_, _tmp134_);
					_tmp136_ = timestamp;
					_tmp137_ = data_provider_get_last_timestamp ((DataProvider*) self);
					_tmp138_ = _tmp137_;
					if (_tmp136_ > _tmp138_) {
						gint64 _tmp139_ = 0LL;
						_tmp139_ = timestamp;
						_tmp135_ = _tmp139_ >= ((gint64) 0);
					} else {
						_tmp135_ = FALSE;
					}
					if (_tmp135_) {
						GPtrArray* _tmp140_ = NULL;
						ZeitgeistEvent* _tmp141_ = NULL;
						_tmp140_ = events;
						_tmp141_ = event;
						event = NULL;
						g_ptr_array_add (_tmp140_, _tmp141_);
					}
				}
				_tmp142_ = log_access;
				if (_tmp142_) {
					const gchar* _tmp143_ = NULL;
					ZeitgeistEvent* _tmp144_ = NULL;
					ZeitgeistEvent* _tmp145_ = NULL;
					ZeitgeistSubject* _tmp146_ = NULL;
					GtkRecentInfo* _tmp147_ = NULL;
					gulong _tmp148_ = 0UL;
					gint64 _tmp149_ = 0LL;
					ZeitgeistEvent* _tmp150_ = NULL;
					gint64 _tmp151_ = 0LL;
					gboolean _tmp152_ = FALSE;
					gint64 _tmp153_ = 0LL;
					gint64 _tmp154_ = 0LL;
					gint64 _tmp155_ = 0LL;
					_tmp143_ = actor;
					_tmp144_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, _tmp143_, NULL, NULL, NULL);
					_g_object_unref0 (event);
					event = _tmp144_;
					_tmp145_ = event;
					_tmp146_ = subject;
					zeitgeist_event_add_subject (_tmp145_, _tmp146_);
					_tmp147_ = ri;
					_tmp148_ = gtk_recent_info_get_visited (_tmp147_);
					timestamp = (gint64) _tmp148_;
					_tmp149_ = timestamp;
					timestamp = _tmp149_ * 1000;
					_tmp150_ = event;
					_tmp151_ = timestamp;
					zeitgeist_event_set_timestamp (_tmp150_, _tmp151_);
					_tmp153_ = timestamp;
					_tmp154_ = data_provider_get_last_timestamp ((DataProvider*) self);
					_tmp155_ = _tmp154_;
					if (_tmp153_ > _tmp155_) {
						gint64 _tmp156_ = 0LL;
						_tmp156_ = timestamp;
						_tmp152_ = _tmp156_ >= ((gint64) 0);
					} else {
						_tmp152_ = FALSE;
					}
					if (_tmp152_) {
						GPtrArray* _tmp157_ = NULL;
						ZeitgeistEvent* _tmp158_ = NULL;
						_tmp157_ = events;
						_tmp158_ = event;
						event = NULL;
						g_ptr_array_add (_tmp157_, _tmp158_);
					}
				}
				_g_object_unref0 (event);
				_g_object_unref0 (subject);
				_g_free0 (origin);
				_g_free0 (_tmp81_);
				_g_object_unref0 (parent_file);
				_g_free0 (actor);
				_g_free0 (desktop_file);
				exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (last_app);
				_g_free0 (uri);
				_g_object_unref0 (file_obj);
				_gtk_recent_info_unref0 (ri);
			}
		}
		__g_list_free__gtk_recent_info_unref0_0 (ri_collection);
	}
	_tmp159_ = signal_time;
	data_provider_set_last_timestamp ((DataProvider*) self, _tmp159_);
	result = events;
	ignored_actors = (_vala_array_free (ignored_actors, ignored_actors_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static const gchar* recent_manager_gtk_real_get_unique_id (DataProvider* base) {
	const gchar* result;
	RecentManagerGtk* self;
	const gchar* _tmp0_ = NULL;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_unique_id (DataProvider* base, const gchar* value) {
	RecentManagerGtk* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_unique_id);
	self->priv->_unique_id = _tmp1_;
	g_object_notify ((GObject *) self, "unique-id");
}


static const gchar* recent_manager_gtk_real_get_name (DataProvider* base) {
	const gchar* result;
	RecentManagerGtk* self;
	const gchar* _tmp0_ = NULL;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_name (DataProvider* base, const gchar* value) {
	RecentManagerGtk* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static const gchar* recent_manager_gtk_real_get_description (DataProvider* base) {
	const gchar* result;
	RecentManagerGtk* self;
	const gchar* _tmp0_ = NULL;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_description (DataProvider* base, const gchar* value) {
	RecentManagerGtk* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static DataHub* recent_manager_gtk_real_get_datahub (DataProvider* base) {
	DataHub* result;
	RecentManagerGtk* self;
	DataHub* _tmp0_ = NULL;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void recent_manager_gtk_real_set_datahub (DataProvider* base, DataHub* value) {
	RecentManagerGtk* self;
	DataHub* _tmp0_ = NULL;
	DataHub* _tmp1_ = NULL;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_datahub);
	self->priv->_datahub = _tmp1_;
	g_object_notify ((GObject *) self, "datahub");
}


static gboolean recent_manager_gtk_real_get_enabled (DataProvider* base) {
	gboolean result;
	RecentManagerGtk* self;
	gboolean _tmp0_ = FALSE;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_enabled (DataProvider* base, gboolean value) {
	RecentManagerGtk* self;
	gboolean _tmp0_ = FALSE;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	self->priv->_enabled = _tmp0_;
	g_object_notify ((GObject *) self, "enabled");
}


static gboolean recent_manager_gtk_real_get_register (DataProvider* base) {
	gboolean result;
	RecentManagerGtk* self;
	gboolean _tmp0_ = FALSE;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_register;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_register (DataProvider* base, gboolean value) {
	RecentManagerGtk* self;
	gboolean _tmp0_ = FALSE;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	self->priv->_register = _tmp0_;
	g_object_notify ((GObject *) self, "register");
}


static GObject * recent_manager_gtk_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RecentManagerGtk * self;
	GtkRecentManager* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (recent_manager_gtk_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_MANAGER_GTK, RecentManagerGtk);
	_tmp0_ = gtk_recent_manager_get_default ();
	self->priv->recent_manager = _tmp0_;
	return obj;
}


static void recent_manager_gtk_class_init (RecentManagerGtkClass * klass) {
	recent_manager_gtk_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RecentManagerGtkPrivate));
	((DataProviderClass *) klass)->start = recent_manager_gtk_real_start;
	((DataProviderClass *) klass)->stop = recent_manager_gtk_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = recent_manager_gtk_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = recent_manager_gtk_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = recent_manager_gtk_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = recent_manager_gtk_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = recent_manager_gtk_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = recent_manager_gtk_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = recent_manager_gtk_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = recent_manager_gtk_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = recent_manager_gtk_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = recent_manager_gtk_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = recent_manager_gtk_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = recent_manager_gtk_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_recent_manager_gtk_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_recent_manager_gtk_set_property;
	G_OBJECT_CLASS (klass)->constructor = recent_manager_gtk_constructor;
	G_OBJECT_CLASS (klass)->finalize = recent_manager_gtk_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_UNIQUE_ID, g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_DATAHUB, g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_ENABLED, g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_REGISTER, g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void recent_manager_gtk_instance_init (RecentManagerGtk * self) {
	self->priv = RECENT_MANAGER_GTK_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
	self->priv->idle_id = (guint) 0;
}


static void recent_manager_gtk_finalize (GObject* obj) {
	RecentManagerGtk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_MANAGER_GTK, RecentManagerGtk);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	G_OBJECT_CLASS (recent_manager_gtk_parent_class)->finalize (obj);
}


GType recent_manager_gtk_get_type (void) {
	static volatile gsize recent_manager_gtk_type_id__volatile = 0;
	if (g_once_init_enter (&recent_manager_gtk_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RecentManagerGtkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) recent_manager_gtk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RecentManagerGtk), 0, (GInstanceInitFunc) recent_manager_gtk_instance_init, NULL };
		GType recent_manager_gtk_type_id;
		recent_manager_gtk_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "RecentManagerGtk", &g_define_type_info, 0);
		g_once_init_leave (&recent_manager_gtk_type_id__volatile, recent_manager_gtk_type_id);
	}
	return recent_manager_gtk_type_id__volatile;
}


static void _vala_recent_manager_gtk_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RecentManagerGtk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_RECENT_MANAGER_GTK, RecentManagerGtk);
	switch (property_id) {
		case RECENT_MANAGER_GTK_UNIQUE_ID:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_NAME:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_DESCRIPTION:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_DATAHUB:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_ENABLED:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_REGISTER:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_recent_manager_gtk_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RecentManagerGtk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_RECENT_MANAGER_GTK, RecentManagerGtk);
	switch (property_id) {
		case RECENT_MANAGER_GTK_UNIQUE_ID:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_NAME:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_DESCRIPTION:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_DATAHUB:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case RECENT_MANAGER_GTK_ENABLED:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case RECENT_MANAGER_GTK_REGISTER:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



