/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMMemoryInfo.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMMemoryInfoPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_MEMORY_INFO_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_MEMORY_INFO, WebKitDOMMemoryInfoPrivate)

typedef struct _WebKitDOMMemoryInfoPrivate {
    RefPtr<WebCore::MemoryInfo> coreObject;
} WebKitDOMMemoryInfoPrivate;

namespace WebKit {

WebKitDOMMemoryInfo* kit(WebCore::MemoryInfo* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_MEMORY_INFO(ret);

    return wrapMemoryInfo(obj);
}

WebCore::MemoryInfo* core(WebKitDOMMemoryInfo* request)
{
    return request ? static_cast<WebCore::MemoryInfo*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMMemoryInfo* wrapMemoryInfo(WebCore::MemoryInfo* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_MEMORY_INFO(g_object_new(WEBKIT_TYPE_DOM_MEMORY_INFO, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMMemoryInfo, webkit_dom_memory_info, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_TOTAL_JS_HEAP_SIZE,
    PROP_USED_JS_HEAP_SIZE,
    PROP_JS_HEAP_SIZE_LIMIT,
};

static void webkit_dom_memory_info_finalize(GObject* object)
{
    WebKitDOMMemoryInfoPrivate* priv = WEBKIT_DOM_MEMORY_INFO_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMMemoryInfoPrivate();
    G_OBJECT_CLASS(webkit_dom_memory_info_parent_class)->finalize(object);
}

static void webkit_dom_memory_info_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMMemoryInfo* self = WEBKIT_DOM_MEMORY_INFO(object);
    WebCore::MemoryInfo* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TOTAL_JS_HEAP_SIZE: {
        g_value_set_ulong(value, coreSelf->totalJSHeapSize());
        break;
    }
    case PROP_USED_JS_HEAP_SIZE: {
        g_value_set_ulong(value, coreSelf->usedJSHeapSize());
        break;
    }
    case PROP_JS_HEAP_SIZE_LIMIT: {
        g_value_set_ulong(value, coreSelf->jsHeapSizeLimit());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_memory_info_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_memory_info_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMMemoryInfoPrivate* priv = WEBKIT_DOM_MEMORY_INFO_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::MemoryInfo*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_memory_info_class_init(WebKitDOMMemoryInfoClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMMemoryInfoPrivate));
    gobjectClass->constructor = webkit_dom_memory_info_constructor;
    gobjectClass->finalize = webkit_dom_memory_info_finalize;
    gobjectClass->get_property = webkit_dom_memory_info_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TOTAL_JS_HEAP_SIZE,
                                    g_param_spec_ulong("total-js-heap-size", /* name */
                                                           "memory_info_total-js-heap-size", /* short description */
                                                           "read-only  gulong MemoryInfo.total-js-heap-size", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_USED_JS_HEAP_SIZE,
                                    g_param_spec_ulong("used-js-heap-size", /* name */
                                                           "memory_info_used-js-heap-size", /* short description */
                                                           "read-only  gulong MemoryInfo.used-js-heap-size", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_JS_HEAP_SIZE_LIMIT,
                                    g_param_spec_ulong("js-heap-size-limit", /* name */
                                                           "memory_info_js-heap-size-limit", /* short description */
                                                           "read-only  gulong MemoryInfo.js-heap-size-limit", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_memory_info_init(WebKitDOMMemoryInfo* request)
{
    WebKitDOMMemoryInfoPrivate* priv = WEBKIT_DOM_MEMORY_INFO_GET_PRIVATE(request);
    new (priv) WebKitDOMMemoryInfoPrivate();
}

gulong
webkit_dom_memory_info_get_total_js_heap_size(WebKitDOMMemoryInfo* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MEMORY_INFO(self), 0);
    WebCore::MemoryInfo* item = WebKit::core(self);
    gulong result = item->totalJSHeapSize();
    return result;
}

gulong
webkit_dom_memory_info_get_used_js_heap_size(WebKitDOMMemoryInfo* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MEMORY_INFO(self), 0);
    WebCore::MemoryInfo* item = WebKit::core(self);
    gulong result = item->usedJSHeapSize();
    return result;
}

gulong
webkit_dom_memory_info_get_js_heap_size_limit(WebKitDOMMemoryInfo* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MEMORY_INFO(self), 0);
    WebCore::MemoryInfo* item = WebKit::core(self);
    gulong result = item->jsHeapSizeLimit();
    return result;
}

