/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMPerformanceEntry.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPerformanceEntryPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_PERFORMANCE_ENTRY_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_PERFORMANCE_ENTRY, WebKitDOMPerformanceEntryPrivate)

typedef struct _WebKitDOMPerformanceEntryPrivate {
#if ENABLE(PERFORMANCE_TIMELINE)
    RefPtr<WebCore::PerformanceEntry> coreObject;
#endif // ENABLE(PERFORMANCE_TIMELINE)
} WebKitDOMPerformanceEntryPrivate;

#if ENABLE(PERFORMANCE_TIMELINE)

namespace WebKit {

WebKitDOMPerformanceEntry* kit(WebCore::PerformanceEntry* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_PERFORMANCE_ENTRY(ret);

    return wrapPerformanceEntry(obj);
}

WebCore::PerformanceEntry* core(WebKitDOMPerformanceEntry* request)
{
    return request ? static_cast<WebCore::PerformanceEntry*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMPerformanceEntry* wrapPerformanceEntry(WebCore::PerformanceEntry* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_PERFORMANCE_ENTRY(g_object_new(WEBKIT_TYPE_DOM_PERFORMANCE_ENTRY, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(PERFORMANCE_TIMELINE)

G_DEFINE_TYPE(WebKitDOMPerformanceEntry, webkit_dom_performance_entry, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_NAME,
    PROP_ENTRY_TYPE,
    PROP_START_TIME,
    PROP_DURATION,
};

static void webkit_dom_performance_entry_finalize(GObject* object)
{
    WebKitDOMPerformanceEntryPrivate* priv = WEBKIT_DOM_PERFORMANCE_ENTRY_GET_PRIVATE(object);
#if ENABLE(PERFORMANCE_TIMELINE)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(PERFORMANCE_TIMELINE)
    priv->~WebKitDOMPerformanceEntryPrivate();
    G_OBJECT_CLASS(webkit_dom_performance_entry_parent_class)->finalize(object);
}

static void webkit_dom_performance_entry_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(PERFORMANCE_TIMELINE)
    WebKitDOMPerformanceEntry* self = WEBKIT_DOM_PERFORMANCE_ENTRY(object);
    WebCore::PerformanceEntry* coreSelf = WebKit::core(self);
#endif // ENABLE(PERFORMANCE_TIMELINE)
    switch (propertyId) {
    case PROP_NAME: {
#if ENABLE(PERFORMANCE_TIMELINE)
        g_value_take_string(value, convertToUTF8String(coreSelf->name()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
        break;
    }
    case PROP_ENTRY_TYPE: {
#if ENABLE(PERFORMANCE_TIMELINE)
        g_value_take_string(value, convertToUTF8String(coreSelf->entryType()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
        break;
    }
    case PROP_START_TIME: {
#if ENABLE(PERFORMANCE_TIMELINE)
        g_value_set_double(value, coreSelf->startTime());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
        break;
    }
    case PROP_DURATION: {
#if ENABLE(PERFORMANCE_TIMELINE)
        g_value_set_double(value, coreSelf->duration());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_performance_entry_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_performance_entry_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(PERFORMANCE_TIMELINE)
    WebKitDOMPerformanceEntryPrivate* priv = WEBKIT_DOM_PERFORMANCE_ENTRY_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::PerformanceEntry*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(PERFORMANCE_TIMELINE)
    return object;
}

static void webkit_dom_performance_entry_class_init(WebKitDOMPerformanceEntryClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMPerformanceEntryPrivate));
    gobjectClass->constructor = webkit_dom_performance_entry_constructor;
    gobjectClass->finalize = webkit_dom_performance_entry_finalize;
    gobjectClass->get_property = webkit_dom_performance_entry_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "performance_entry_name", /* short description */
                                                           "read-only  gchar* PerformanceEntry.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ENTRY_TYPE,
                                    g_param_spec_string("entry-type", /* name */
                                                           "performance_entry_entry-type", /* short description */
                                                           "read-only  gchar* PerformanceEntry.entry-type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_START_TIME,
                                    g_param_spec_double("start-time", /* name */
                                                           "performance_entry_start-time", /* short description */
                                                           "read-only  gdouble PerformanceEntry.start-time", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXDOUBLE, /* min */
G_MAXDOUBLE, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DURATION,
                                    g_param_spec_double("duration", /* name */
                                                           "performance_entry_duration", /* short description */
                                                           "read-only  gdouble PerformanceEntry.duration", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXDOUBLE, /* min */
G_MAXDOUBLE, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_performance_entry_init(WebKitDOMPerformanceEntry* request)
{
    WebKitDOMPerformanceEntryPrivate* priv = WEBKIT_DOM_PERFORMANCE_ENTRY_GET_PRIVATE(request);
    new (priv) WebKitDOMPerformanceEntryPrivate();
}

gchar*
webkit_dom_performance_entry_get_name(WebKitDOMPerformanceEntry* self)
{
#if ENABLE(PERFORMANCE_TIMELINE)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_ENTRY(self), 0);
    WebCore::PerformanceEntry* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->name());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
    return 0;
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
}

gchar*
webkit_dom_performance_entry_get_entry_type(WebKitDOMPerformanceEntry* self)
{
#if ENABLE(PERFORMANCE_TIMELINE)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_ENTRY(self), 0);
    WebCore::PerformanceEntry* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->entryType());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
    return 0;
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
}

gdouble
webkit_dom_performance_entry_get_start_time(WebKitDOMPerformanceEntry* self)
{
#if ENABLE(PERFORMANCE_TIMELINE)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_ENTRY(self), 0);
    WebCore::PerformanceEntry* item = WebKit::core(self);
    gdouble result = item->startTime();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
    return static_cast<gdouble>(0);
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
}

gdouble
webkit_dom_performance_entry_get_duration(WebKitDOMPerformanceEntry* self)
{
#if ENABLE(PERFORMANCE_TIMELINE)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_ENTRY(self), 0);
    WebCore::PerformanceEntry* item = WebKit::core(self);
    gdouble result = item->duration();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
    return static_cast<gdouble>(0);
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
}

