


#include "config.h"
#include <gabble-enumtypes.h>

/* enumerations from "/usr/src/ports/telepathy-gabble/telepathy-gabble-0.18.4-1.x86_64/src/telepathy-gabble-0.18.4/src/connection.h" */
#include "/usr/src/ports/telepathy-gabble/telepathy-gabble-0.18.4-1.x86_64/src/telepathy-gabble-0.18.4/src/connection.h"
GType
gabble_presence_id_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GABBLE_PRESENCE_OFFLINE, "GABBLE_PRESENCE_OFFLINE", "offline" },
      { GABBLE_PRESENCE_UNKNOWN, "GABBLE_PRESENCE_UNKNOWN", "unknown" },
      { GABBLE_PRESENCE_ERROR, "GABBLE_PRESENCE_ERROR", "error" },
      { GABBLE_PRESENCE_HIDDEN, "GABBLE_PRESENCE_HIDDEN", "hidden" },
      { GABBLE_PRESENCE_XA, "GABBLE_PRESENCE_XA", "xa" },
      { GABBLE_PRESENCE_AWAY, "GABBLE_PRESENCE_AWAY", "away" },
      { GABBLE_PRESENCE_DND, "GABBLE_PRESENCE_DND", "dnd" },
      { GABBLE_PRESENCE_AVAILABLE, "GABBLE_PRESENCE_AVAILABLE", "available" },
      { GABBLE_PRESENCE_CHAT, "GABBLE_PRESENCE_CHAT", "chat" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GabblePresenceId", values);
  }
  return etype;
}
GType
gabble_connection_features_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GABBLE_CONNECTION_FEATURES_NONE, "GABBLE_CONNECTION_FEATURES_NONE", "none" },
      { GABBLE_CONNECTION_FEATURES_GOOGLE_JINGLE_INFO, "GABBLE_CONNECTION_FEATURES_GOOGLE_JINGLE_INFO", "google-jingle-info" },
      { GABBLE_CONNECTION_FEATURES_GOOGLE_ROSTER, "GABBLE_CONNECTION_FEATURES_GOOGLE_ROSTER", "google-roster" },
      { GABBLE_CONNECTION_FEATURES_PRESENCE_INVISIBLE, "GABBLE_CONNECTION_FEATURES_PRESENCE_INVISIBLE", "presence-invisible" },
      { GABBLE_CONNECTION_FEATURES_PRIVACY, "GABBLE_CONNECTION_FEATURES_PRIVACY", "privacy" },
      { GABBLE_CONNECTION_FEATURES_PEP, "GABBLE_CONNECTION_FEATURES_PEP", "pep" },
      { GABBLE_CONNECTION_FEATURES_GOOGLE_MAIL_NOTIFY, "GABBLE_CONNECTION_FEATURES_GOOGLE_MAIL_NOTIFY", "google-mail-notify" },
      { GABBLE_CONNECTION_FEATURES_INVISIBLE, "GABBLE_CONNECTION_FEATURES_INVISIBLE", "invisible" },
      { GABBLE_CONNECTION_FEATURES_GOOGLE_SHARED_STATUS, "GABBLE_CONNECTION_FEATURES_GOOGLE_SHARED_STATUS", "google-shared-status" },
      { GABBLE_CONNECTION_FEATURES_GOOGLE_QUEUE, "GABBLE_CONNECTION_FEATURES_GOOGLE_QUEUE", "google-queue" },
      { GABBLE_CONNECTION_FEATURES_GOOGLE_SETTING, "GABBLE_CONNECTION_FEATURES_GOOGLE_SETTING", "google-setting" },
      { GABBLE_CONNECTION_FEATURES_WLM_JID_LOOKUP, "GABBLE_CONNECTION_FEATURES_WLM_JID_LOOKUP", "wlm-jid-lookup" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GabbleConnectionFeatures", values);
  }
  return etype;
}
GType
gabble_normalize_contact_jid_mode_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GABBLE_JID_ANY, "GABBLE_JID_ANY", "any" },
      { GABBLE_JID_GLOBAL, "GABBLE_JID_GLOBAL", "global" },
      { GABBLE_JID_ROOM_MEMBER, "GABBLE_JID_ROOM_MEMBER", "room-member" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GabbleNormalizeContactJIDMode", values);
  }
  return etype;
}
GType
gabble_connection_alias_source_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { GABBLE_CONNECTION_ALIAS_NONE, "GABBLE_CONNECTION_ALIAS_NONE", "none" },
      { GABBLE_CONNECTION_ALIAS_FROM_JID, "GABBLE_CONNECTION_ALIAS_FROM_JID", "from-jid" },
      { GABBLE_CONNECTION_ALIAS_FROM_VCARD, "GABBLE_CONNECTION_ALIAS_FROM_VCARD", "from-vcard" },
      { GABBLE_CONNECTION_ALIAS_FROM_MUC_RESOURCE, "GABBLE_CONNECTION_ALIAS_FROM_MUC_RESOURCE", "from-muc-resource" },
      { GABBLE_CONNECTION_ALIAS_FROM_CONNMGR, "GABBLE_CONNECTION_ALIAS_FROM_CONNMGR", "from-connmgr" },
      { GABBLE_CONNECTION_ALIAS_FROM_PRESENCE, "GABBLE_CONNECTION_ALIAS_FROM_PRESENCE", "from-presence" },
      { GABBLE_CONNECTION_ALIAS_FROM_ROSTER, "GABBLE_CONNECTION_ALIAS_FROM_ROSTER", "from-roster" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("GabbleConnectionAliasSource", values);
  }
  return etype;
}

/* enumerations from "/usr/src/ports/telepathy-gabble/telepathy-gabble-0.18.4-1.x86_64/src/telepathy-gabble-0.18.4/src/presence.h" */
#include "/usr/src/ports/telepathy-gabble/telepathy-gabble-0.18.4-1.x86_64/src/telepathy-gabble-0.18.4/src/presence.h"
GType
gabble_client_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GFlagsValue values[] = {
      { GABBLE_CLIENT_TYPE_BOT, "GABBLE_CLIENT_TYPE_BOT", "bot" },
      { GABBLE_CLIENT_TYPE_CONSOLE, "GABBLE_CLIENT_TYPE_CONSOLE", "console" },
      { GABBLE_CLIENT_TYPE_GAME, "GABBLE_CLIENT_TYPE_GAME", "game" },
      { GABBLE_CLIENT_TYPE_HANDHELD, "GABBLE_CLIENT_TYPE_HANDHELD", "handheld" },
      { GABBLE_CLIENT_TYPE_PC, "GABBLE_CLIENT_TYPE_PC", "pc" },
      { GABBLE_CLIENT_TYPE_PHONE, "GABBLE_CLIENT_TYPE_PHONE", "phone" },
      { GABBLE_CLIENT_TYPE_WEB, "GABBLE_CLIENT_TYPE_WEB", "web" },
      { GABBLE_CLIENT_TYPE_SMS, "GABBLE_CLIENT_TYPE_SMS", "sms" },
      { 0, NULL, NULL }
    };
    etype = g_flags_register_static ("GabbleClientType", values);
  }
  return etype;
}



