/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLScriptElement.h"

#include "HTMLNames.h"
#include "HTMLScriptElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLScriptElementTableValues[] =
{
    { "text", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementText), (intptr_t)setJSHTMLScriptElementText, NoIntrinsic },
    { "htmlFor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementHtmlFor), (intptr_t)setJSHTMLScriptElementHtmlFor, NoIntrinsic },
    { "event", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementEvent), (intptr_t)setJSHTMLScriptElementEvent, NoIntrinsic },
    { "charset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementCharset), (intptr_t)setJSHTMLScriptElementCharset, NoIntrinsic },
    { "async", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementAsync), (intptr_t)setJSHTMLScriptElementAsync, NoIntrinsic },
    { "defer", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementDefer), (intptr_t)setJSHTMLScriptElementDefer, NoIntrinsic },
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementSrc), (intptr_t)setJSHTMLScriptElementSrc, NoIntrinsic },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementType), (intptr_t)setJSHTMLScriptElementType, NoIntrinsic },
    { "crossOrigin", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementCrossOrigin), (intptr_t)setJSHTMLScriptElementCrossOrigin, NoIntrinsic },
#if ENABLE(CSP_NEXT)
    { "nonce", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementNonce), (intptr_t)setJSHTMLScriptElementNonce, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLScriptElementTable = { 32, 31, JSHTMLScriptElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLScriptElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLScriptElementConstructorTable = { 1, 0, JSHTMLScriptElementConstructorTableValues, 0 };
const ClassInfo JSHTMLScriptElementConstructor::s_info = { "HTMLScriptElementConstructor", &Base::s_info, &JSHTMLScriptElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLScriptElementConstructor) };

JSHTMLScriptElementConstructor::JSHTMLScriptElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLScriptElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLScriptElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLScriptElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElementConstructor, JSDOMWrapper>(exec, &JSHTMLScriptElementConstructorTable, jsCast<JSHTMLScriptElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLScriptElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLScriptElementConstructor, JSDOMWrapper>(exec, &JSHTMLScriptElementConstructorTable, jsCast<JSHTMLScriptElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLScriptElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLScriptElementPrototypeTable = { 1, 0, JSHTMLScriptElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLScriptElementPrototype::s_info = { "HTMLScriptElementPrototype", &Base::s_info, &JSHTMLScriptElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLScriptElementPrototype) };

JSObject* JSHTMLScriptElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLScriptElement>(exec, globalObject);
}

const ClassInfo JSHTMLScriptElement::s_info = { "HTMLScriptElement", &Base::s_info, &JSHTMLScriptElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLScriptElement) };

JSHTMLScriptElement::JSHTMLScriptElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLScriptElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLScriptElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLScriptElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLScriptElementPrototype::create(exec->globalData(), globalObject, JSHTMLScriptElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLScriptElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLScriptElement* thisObject = jsCast<JSHTMLScriptElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLScriptElement, Base>(exec, &JSHTMLScriptElementTable, thisObject, propertyName, slot);
}

bool JSHTMLScriptElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLScriptElement* thisObject = jsCast<JSHTMLScriptElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLScriptElement, Base>(exec, &JSHTMLScriptElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLScriptElementText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->text());
    return result;
}


JSValue jsHTMLScriptElementHtmlFor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::forAttr));
    return result;
}


JSValue jsHTMLScriptElementEvent(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::eventAttr));
    return result;
}


JSValue jsHTMLScriptElementCharset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::charsetAttr));
    return result;
}


JSValue jsHTMLScriptElementAsync(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->async());
    return result;
}


JSValue jsHTMLScriptElementDefer(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::deferAttr));
    return result;
}


JSValue jsHTMLScriptElementSrc(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}


JSValue jsHTMLScriptElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::typeAttr));
    return result;
}


JSValue jsHTMLScriptElementCrossOrigin(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::crossoriginAttr));
    return result;
}


#if ENABLE(CSP_NEXT)
JSValue jsHTMLScriptElementNonce(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::nonceAttr));
    return result;
}

#endif

JSValue jsHTMLScriptElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLScriptElement* domObject = jsCast<JSHTMLScriptElement*>(asObject(slotBase));
    return JSHTMLScriptElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLScriptElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLScriptElement* thisObject = jsCast<JSHTMLScriptElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLScriptElement, Base>(exec, propertyName, value, &JSHTMLScriptElementTable, thisObject, slot);
}

void setJSHTMLScriptElementText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setText(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementHtmlFor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::forAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementEvent(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::eventAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementCharset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::charsetAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementAsync(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setAsync(value.toBoolean(exec));
}


void setJSHTMLScriptElementDefer(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::deferAttr, value.toBoolean(exec));
}


void setJSHTMLScriptElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::srcAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::typeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLScriptElementCrossOrigin(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::crossoriginAttr, valueToStringWithNullCheck(exec, value));
}


#if ENABLE(CSP_NEXT)
void setJSHTMLScriptElementNonce(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLScriptElement* castedThis = jsCast<JSHTMLScriptElement*>(thisObject);
    HTMLScriptElement* impl = static_cast<HTMLScriptElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nonceAttr, valueToStringWithNullCheck(exec, value));
}

#endif

JSValue JSHTMLScriptElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLScriptElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
