/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFETileElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFETileElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFETileElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETileElementIn1), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETileElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETileElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETileElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETileElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETileElementResult), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETileElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETileElementStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETileElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFETileElementTable = { 34, 31, JSSVGFETileElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFETileElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFETileElementConstructorTable = { 1, 0, JSSVGFETileElementConstructorTableValues, 0 };
const ClassInfo JSSVGFETileElementConstructor::s_info = { "SVGFETileElementConstructor", &Base::s_info, &JSSVGFETileElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFETileElementConstructor) };

JSSVGFETileElementConstructor::JSSVGFETileElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFETileElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFETileElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFETileElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFETileElementConstructor, JSDOMWrapper>(exec, &JSSVGFETileElementConstructorTable, jsCast<JSSVGFETileElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFETileElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFETileElementConstructor, JSDOMWrapper>(exec, &JSSVGFETileElementConstructorTable, jsCast<JSSVGFETileElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFETileElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGFETileElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFETileElementPrototypeTable = { 2, 1, JSSVGFETileElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFETileElementPrototype::s_info = { "SVGFETileElementPrototype", &Base::s_info, &JSSVGFETileElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFETileElementPrototype) };

JSObject* JSSVGFETileElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFETileElement>(exec, globalObject);
}

bool JSSVGFETileElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFETileElementPrototype* thisObject = jsCast<JSSVGFETileElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFETileElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGFETileElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFETileElementPrototype* thisObject = jsCast<JSSVGFETileElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFETileElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGFETileElement::s_info = { "SVGFETileElement", &Base::s_info, &JSSVGFETileElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFETileElement) };

JSSVGFETileElement::JSSVGFETileElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFETileElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFETileElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFETileElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFETileElementPrototype::create(exec->globalData(), globalObject, JSSVGFETileElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFETileElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFETileElement* thisObject = jsCast<JSSVGFETileElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFETileElement, Base>(exec, &JSSVGFETileElementTable, thisObject, propertyName, slot);
}

bool JSSVGFETileElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFETileElement* thisObject = jsCast<JSSVGFETileElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFETileElement, Base>(exec, &JSSVGFETileElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFETileElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETileElement* castedThis = jsCast<JSSVGFETileElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETileElement* impl = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETileElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETileElement* castedThis = jsCast<JSSVGFETileElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETileElement* impl = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETileElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETileElement* castedThis = jsCast<JSSVGFETileElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETileElement* impl = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETileElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETileElement* castedThis = jsCast<JSSVGFETileElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETileElement* impl = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETileElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETileElement* castedThis = jsCast<JSSVGFETileElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETileElement* impl = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETileElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETileElement* castedThis = jsCast<JSSVGFETileElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETileElement* impl = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETileElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETileElement* castedThis = jsCast<JSSVGFETileElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETileElement* impl = static_cast<SVGFETileElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETileElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETileElement* castedThis = jsCast<JSSVGFETileElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETileElement* impl = static_cast<SVGFETileElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGFETileElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETileElement* domObject = jsCast<JSSVGFETileElement*>(asObject(slotBase));
    return JSSVGFETileElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFETileElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFETileElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFETileElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFETileElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFETileElement* castedThis = jsCast<JSSVGFETileElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFETileElement::s_info);
    SVGFETileElement* impl = static_cast<SVGFETileElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
