/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSCharsetRule.h"

#include "CSSCharsetRule.h"
#include "KURL.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSCharsetRuleTableValues[] =
{
    { "encoding", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSCharsetRuleEncoding), (intptr_t)setJSCSSCharsetRuleEncoding, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSCharsetRuleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSCharsetRuleTable = { 4, 3, JSCSSCharsetRuleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSCharsetRuleConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSCharsetRuleConstructorTable = { 1, 0, JSCSSCharsetRuleConstructorTableValues, 0 };
const ClassInfo JSCSSCharsetRuleConstructor::s_info = { "CSSCharsetRuleConstructor", &Base::s_info, &JSCSSCharsetRuleConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSCharsetRuleConstructor) };

JSCSSCharsetRuleConstructor::JSCSSCharsetRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSCharsetRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCSSCharsetRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSCharsetRuleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSCharsetRuleConstructor, JSDOMWrapper>(exec, &JSCSSCharsetRuleConstructorTable, jsCast<JSCSSCharsetRuleConstructor*>(cell), propertyName, slot);
}

bool JSCSSCharsetRuleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSCharsetRuleConstructor, JSDOMWrapper>(exec, &JSCSSCharsetRuleConstructorTable, jsCast<JSCSSCharsetRuleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSCharsetRulePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSCharsetRulePrototypeTable = { 1, 0, JSCSSCharsetRulePrototypeTableValues, 0 };
const ClassInfo JSCSSCharsetRulePrototype::s_info = { "CSSCharsetRulePrototype", &Base::s_info, &JSCSSCharsetRulePrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSCharsetRulePrototype) };

JSObject* JSCSSCharsetRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSCharsetRule>(exec, globalObject);
}

const ClassInfo JSCSSCharsetRule::s_info = { "CSSCharsetRule", &Base::s_info, &JSCSSCharsetRuleTable, 0 , CREATE_METHOD_TABLE(JSCSSCharsetRule) };

JSCSSCharsetRule::JSCSSCharsetRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSCharsetRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

void JSCSSCharsetRule::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSCharsetRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSCharsetRulePrototype::create(exec->globalData(), globalObject, JSCSSCharsetRulePrototype::createStructure(exec->globalData(), globalObject, JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSCSSCharsetRule::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSCharsetRule* thisObject = jsCast<JSCSSCharsetRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCSSCharsetRule, Base>(exec, &JSCSSCharsetRuleTable, thisObject, propertyName, slot);
}

bool JSCSSCharsetRule::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSCharsetRule* thisObject = jsCast<JSCSSCharsetRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCSSCharsetRule, Base>(exec, &JSCSSCharsetRuleTable, thisObject, propertyName, descriptor);
}

JSValue jsCSSCharsetRuleEncoding(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSCharsetRule* castedThis = jsCast<JSCSSCharsetRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSCharsetRule* impl = static_cast<CSSCharsetRule*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->encoding());
    return result;
}


JSValue jsCSSCharsetRuleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSCharsetRule* domObject = jsCast<JSCSSCharsetRule*>(asObject(slotBase));
    return JSCSSCharsetRule::getConstructor(exec, domObject->globalObject());
}

void JSCSSCharsetRule::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSCSSCharsetRule* thisObject = jsCast<JSCSSCharsetRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSCSSCharsetRule, Base>(exec, propertyName, value, &JSCSSCharsetRuleTable, thisObject, slot);
}

void setJSCSSCharsetRuleEncoding(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCSSCharsetRule* castedThis = jsCast<JSCSSCharsetRule*>(thisObject);
    CSSCharsetRule* impl = static_cast<CSSCharsetRule*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setEncoding(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


JSValue JSCSSCharsetRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSCharsetRuleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
