#ifndef COST_SPIKESPEC_EVENT_FCN_H
#define COST_SPIKESPEC_EVENT_FCN_H

#include <octave/oct.h>
#include "Permute_event_fcn.h"
#include "Cost_fcn.h"

class Cost_spikespec_event_fcn : public Cost_fcn, protected Permute_event_fcn
{
protected:
  //! If true assumes input is intervals rather than times
  bool inter;
  double fmax;
  octave_idx_type nfreq;

  Matrix sp0r;
  Matrix sp0i;
  Matrix sp0;
public:
  Cost_spikespec_event_fcn (Matrix *input, bool _inter = true, double _fmax = 0,
                            octave_idx_type _nfreq = 0)
  : Permute_event_fcn (input), inter (_inter), fmax (_fmax), nfreq (_nfreq)
  {
  }


  void cost_transform ();
  Matrix cost_inverse () const;
  double cost_full () { return 0; }
  double cost_update (double cmax, bool &accept) { return 0; }

private:
  //! Initializes default parameters and establishes baseline for calculating cost
  void init ();
  void sspect (octave_idx_type nfreq, double fres, Matrix &spr, Matrix &spi,
               Matrix &sp);
};

#endif
