/* midori-settings.c generated by valac 0.38.8, the Vala compiler
 * generated from midori-settings.vala, do not modify */

/*
 Copyright (C) 2008-2013 Christian Dywan <christian@twotoasts.de>
 Copyright (C) 2011 Peter Hatina <phatina@redhat.com>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

#include <glib.h>
#include <glib-object.h>
#include "webkit/webkit.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <libsoup/soup.h>


#define MIDORI_TYPE_WINDOW_STATE (midori_window_state_get_type ())

#define MIDORI_TYPE_SETTINGS (midori_settings_get_type ())
#define MIDORI_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MIDORI_TYPE_SETTINGS, MidoriSettings))
#define MIDORI_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MIDORI_TYPE_SETTINGS, MidoriSettingsClass))
#define MIDORI_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDORI_TYPE_SETTINGS))
#define MIDORI_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDORI_TYPE_SETTINGS))
#define MIDORI_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDORI_TYPE_SETTINGS, MidoriSettingsClass))

typedef struct _MidoriSettings MidoriSettings;
typedef struct _MidoriSettingsClass MidoriSettingsClass;
typedef struct _MidoriSettingsPrivate MidoriSettingsPrivate;
enum  {
	MIDORI_SETTINGS_0_PROPERTY,
	MIDORI_SETTINGS_ENABLE_JAVASCRIPT_PROPERTY,
	MIDORI_SETTINGS_DEFAULT_CHARSET_PROPERTY,
	MIDORI_SETTINGS_ZOOM_TEXT_AND_IMAGES_PROPERTY,
	MIDORI_SETTINGS_REMEMBER_LAST_WINDOW_SIZE_PROPERTY,
	MIDORI_SETTINGS_LAST_WINDOW_WIDTH_PROPERTY,
	MIDORI_SETTINGS_LAST_WINDOW_HEIGHT_PROPERTY,
	MIDORI_SETTINGS_LAST_PANEL_POSITION_PROPERTY,
	MIDORI_SETTINGS_LAST_PANEL_PAGE_PROPERTY,
	MIDORI_SETTINGS_LAST_WEB_SEARCH_PROPERTY,
	MIDORI_SETTINGS_SEARCH_WIDTH_PROPERTY,
	MIDORI_SETTINGS_LAST_INSPECTOR_ATTACHED_PROPERTY,
	MIDORI_SETTINGS_LAST_WINDOW_STATE_PROPERTY,
	MIDORI_SETTINGS_INACTIVITY_RESET_PROPERTY,
	MIDORI_SETTINGS_DEFAULT_THEME_NAME_PROPERTY,
	MIDORI_SETTINGS_THEME_NAME_PROPERTY,
	MIDORI_SETTINGS_BLOCK_URIS_PROPERTY,
	MIDORI_SETTINGS_CUSTOM_TITLE_PROPERTY,
	MIDORI_SETTINGS_LOCATION_ENTRY_SEARCH_PROPERTY,
	MIDORI_SETTINGS_CLEAR_PRIVATE_DATA_PROPERTY,
	MIDORI_SETTINGS_CLEAR_DATA_PROPERTY,
	MIDORI_SETTINGS_COMPACT_SIDEPANEL_PROPERTY,
	MIDORI_SETTINGS_OPEN_PANELS_IN_WINDOWS_PROPERTY,
	MIDORI_SETTINGS_RIGHT_ALIGN_SIDEPANEL_PROPERTY,
	MIDORI_SETTINGS_SHOW_MENUBAR_PROPERTY,
	MIDORI_SETTINGS_SHOW_NAVIGATIONBAR_PROPERTY,
	MIDORI_SETTINGS_SHOW_BOOKMARKBAR_PROPERTY,
	MIDORI_SETTINGS_SHOW_PANEL_PROPERTY,
	MIDORI_SETTINGS_SHOW_STATUSBAR_PROPERTY,
	MIDORI_SETTINGS_SHOW_CRASH_DIALOG_PROPERTY,
	MIDORI_SETTINGS_TOOLBAR_ITEMS_PROPERTY,
	MIDORI_SETTINGS_FIND_WHILE_TYPING_PROPERTY,
	MIDORI_SETTINGS_ZOOM_LEVEL_PROPERTY,
	MIDORI_SETTINGS_OPEN_POPUPS_IN_TABS_PROPERTY,
	MIDORI_SETTINGS_KINETIC_SCROLLING_PROPERTY,
	MIDORI_SETTINGS_MIDDLE_CLICK_OPENS_SELECTION_PROPERTY,
	MIDORI_SETTINGS_FLASH_WINDOW_ON_NEW_BG_TABS_PROPERTY,
	MIDORI_SETTINGS_CLOSE_BUTTONS_ON_TABS_PROPERTY,
	MIDORI_SETTINGS_OPEN_TABS_IN_THE_BACKGROUND_PROPERTY,
	MIDORI_SETTINGS_OPEN_TABS_NEXT_TO_CURRENT_PROPERTY,
	MIDORI_SETTINGS_ALWAYS_SHOW_TABBAR_PROPERTY,
	MIDORI_SETTINGS_HOMEPAGE_PROPERTY,
	MIDORI_SETTINGS_TABHOME_PROPERTY,
	MIDORI_SETTINGS_DOWNLOAD_FOLDER_PROPERTY,
	MIDORI_SETTINGS_TEXT_EDITOR_PROPERTY,
	MIDORI_SETTINGS_NEWS_AGGREGATOR_PROPERTY,
	MIDORI_SETTINGS_HTTP_PROXY_PROPERTY,
	MIDORI_SETTINGS_HTTP_PROXY_PORT_PROPERTY,
	MIDORI_SETTINGS_MAXIMUM_CACHE_SIZE_PROPERTY,
	MIDORI_SETTINGS_STRIP_REFERER_PROPERTY,
	MIDORI_SETTINGS_FIRST_PARTY_COOKIES_ONLY_PROPERTY,
	MIDORI_SETTINGS_MAXIMUM_COOKIE_AGE_PROPERTY,
	MIDORI_SETTINGS_MAXIMUM_HISTORY_AGE_PROPERTY,
	MIDORI_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* midori_settings_properties[MIDORI_SETTINGS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	MIDORI_WINDOW_NORMAL,
	MIDORI_WINDOW_MINIMIZED,
	MIDORI_WINDOW_MAXIMIZED,
	MIDORI_WINDOW_FULLSCREEN
} MidoriWindowState;

struct _MidoriSettings {
	WebKitWebSettings parent_instance;
	MidoriSettingsPrivate * priv;
};

struct _MidoriSettingsClass {
	WebKitWebSettingsClass parent_class;
};

struct _MidoriSettingsPrivate {
	gboolean _zoom_text_and_images;
	gboolean _remember_last_window_size;
	gint _last_window_width;
	gint _last_window_height;
	gint _last_panel_position;
	gint _last_panel_page;
	gint _last_web_search;
	gint _search_width;
	gboolean _last_inspector_attached;
	MidoriWindowState _last_window_state;
	guint _inactivity_reset;
	gchar* default_theme_name_;
	gchar* theme_name_;
	GRegex* block_uris_regex;
	gchar* _custom_title;
	gchar* _location_entry_search;
	gint _clear_private_data;
	gchar* _clear_data;
	gboolean _compact_sidepanel;
	gboolean _open_panels_in_windows;
	gboolean _right_align_sidepanel;
	gboolean _show_menubar;
	gboolean _show_navigationbar;
	gboolean _show_bookmarkbar;
	gboolean _show_panel;
	gboolean _show_statusbar;
	gboolean _show_crash_dialog;
	gchar* _toolbar_items;
	gboolean _find_while_typing;
	gdouble _zoom_level;
	gboolean _open_popups_in_tabs;
	gboolean _kinetic_scrolling;
	gboolean _middle_click_opens_selection;
	gboolean _flash_window_on_new_bg_tabs;
	gboolean _close_buttons_on_tabs;
	gboolean _open_tabs_in_the_background;
	gboolean _open_tabs_next_to_current;
	gboolean _always_show_tabbar;
	gchar* _homepage;
	gchar* _tabhome;
	gchar* _download_folder;
	gchar* _text_editor;
	gchar* _news_aggregator;
	gchar* _http_proxy;
	gint _http_proxy_port;
	gint _maximum_cache_size;
	gboolean _strip_referer;
	gboolean _first_party_cookies_only;
	gint _maximum_cookie_age;
	gint _maximum_history_age;
};


static gpointer midori_settings_parent_class = NULL;

GType midori_window_state_get_type (void) G_GNUC_CONST;
GType midori_settings_get_type (void) G_GNUC_CONST;
#define MIDORI_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MIDORI_TYPE_SETTINGS, MidoriSettingsPrivate))
static gchar* midori_settings_default_download_folder (void);
gboolean midori_settings_delay_saving (MidoriSettings* self, const gchar* property);
MidoriSettings* midori_settings_new (void);
MidoriSettings* midori_settings_construct (GType object_type);
gboolean midori_settings_get_enable_javascript (MidoriSettings* self);
void midori_settings_set_enable_javascript (MidoriSettings* self, gboolean value);
gchar* midori_settings_get_default_charset (MidoriSettings* self);
void midori_settings_set_default_charset (MidoriSettings* self, const gchar* value);
gboolean midori_settings_get_zoom_text_and_images (MidoriSettings* self);
void midori_settings_set_zoom_text_and_images (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_remember_last_window_size (MidoriSettings* self);
void midori_settings_set_remember_last_window_size (MidoriSettings* self, gboolean value);
gint midori_settings_get_last_window_width (MidoriSettings* self);
void midori_settings_set_last_window_width (MidoriSettings* self, gint value);
gint midori_settings_get_last_window_height (MidoriSettings* self);
void midori_settings_set_last_window_height (MidoriSettings* self, gint value);
gint midori_settings_get_last_panel_position (MidoriSettings* self);
void midori_settings_set_last_panel_position (MidoriSettings* self, gint value);
gint midori_settings_get_last_panel_page (MidoriSettings* self);
void midori_settings_set_last_panel_page (MidoriSettings* self, gint value);
gint midori_settings_get_last_web_search (MidoriSettings* self);
void midori_settings_set_last_web_search (MidoriSettings* self, gint value);
gint midori_settings_get_search_width (MidoriSettings* self);
void midori_settings_set_search_width (MidoriSettings* self, gint value);
gboolean midori_settings_get_last_inspector_attached (MidoriSettings* self);
void midori_settings_set_last_inspector_attached (MidoriSettings* self, gboolean value);
MidoriWindowState midori_settings_get_last_window_state (MidoriSettings* self);
void midori_settings_set_last_window_state (MidoriSettings* self, MidoriWindowState value);
guint midori_settings_get_inactivity_reset (MidoriSettings* self);
void midori_settings_set_inactivity_reset (MidoriSettings* self, guint value);
const gchar* midori_settings_get_default_theme_name (MidoriSettings* self);
const gchar* midori_settings_get_theme_name (MidoriSettings* self);
void midori_settings_set_theme_name (MidoriSettings* self, const gchar* value);
const gchar* midori_settings_get_block_uris (MidoriSettings* self);
void midori_settings_set_block_uris (MidoriSettings* self, const gchar* value);
static void _midori_settings_block_uris____lambda21_ (MidoriSettings* self, SoupMessage* msg);
static void _vala_SoupURI_free (SoupURI* self);
static void __midori_settings_block_uris____lambda21__soup_session_request_queued (SoupSession* _sender, SoupMessage* msg, gpointer self);
const gchar* midori_settings_get_custom_title (MidoriSettings* self);
void midori_settings_set_custom_title (MidoriSettings* self, const gchar* value);
const gchar* midori_settings_get_location_entry_search (MidoriSettings* self);
void midori_settings_set_location_entry_search (MidoriSettings* self, const gchar* value);
gint midori_settings_get_clear_private_data (MidoriSettings* self);
void midori_settings_set_clear_private_data (MidoriSettings* self, gint value);
const gchar* midori_settings_get_clear_data (MidoriSettings* self);
void midori_settings_set_clear_data (MidoriSettings* self, const gchar* value);
gboolean midori_settings_get_compact_sidepanel (MidoriSettings* self);
void midori_settings_set_compact_sidepanel (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_open_panels_in_windows (MidoriSettings* self);
void midori_settings_set_open_panels_in_windows (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_right_align_sidepanel (MidoriSettings* self);
void midori_settings_set_right_align_sidepanel (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_show_menubar (MidoriSettings* self);
void midori_settings_set_show_menubar (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_show_navigationbar (MidoriSettings* self);
void midori_settings_set_show_navigationbar (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_show_bookmarkbar (MidoriSettings* self);
void midori_settings_set_show_bookmarkbar (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_show_panel (MidoriSettings* self);
void midori_settings_set_show_panel (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_show_statusbar (MidoriSettings* self);
void midori_settings_set_show_statusbar (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_show_crash_dialog (MidoriSettings* self);
void midori_settings_set_show_crash_dialog (MidoriSettings* self, gboolean value);
const gchar* midori_settings_get_toolbar_items (MidoriSettings* self);
void midori_settings_set_toolbar_items (MidoriSettings* self, const gchar* value);
gboolean midori_settings_get_find_while_typing (MidoriSettings* self);
void midori_settings_set_find_while_typing (MidoriSettings* self, gboolean value);
gdouble midori_settings_get_zoom_level (MidoriSettings* self);
void midori_settings_set_zoom_level (MidoriSettings* self, gdouble value);
gboolean midori_settings_get_open_popups_in_tabs (MidoriSettings* self);
void midori_settings_set_open_popups_in_tabs (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_kinetic_scrolling (MidoriSettings* self);
void midori_settings_set_kinetic_scrolling (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_middle_click_opens_selection (MidoriSettings* self);
void midori_settings_set_middle_click_opens_selection (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_flash_window_on_new_bg_tabs (MidoriSettings* self);
void midori_settings_set_flash_window_on_new_bg_tabs (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_close_buttons_on_tabs (MidoriSettings* self);
void midori_settings_set_close_buttons_on_tabs (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_open_tabs_in_the_background (MidoriSettings* self);
void midori_settings_set_open_tabs_in_the_background (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_open_tabs_next_to_current (MidoriSettings* self);
void midori_settings_set_open_tabs_next_to_current (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_always_show_tabbar (MidoriSettings* self);
void midori_settings_set_always_show_tabbar (MidoriSettings* self, gboolean value);
const gchar* midori_settings_get_homepage (MidoriSettings* self);
void midori_settings_set_homepage (MidoriSettings* self, const gchar* value);
const gchar* midori_settings_get_tabhome (MidoriSettings* self);
void midori_settings_set_tabhome (MidoriSettings* self, const gchar* value);
const gchar* midori_settings_get_download_folder (MidoriSettings* self);
void midori_settings_set_download_folder (MidoriSettings* self, const gchar* value);
const gchar* midori_settings_get_text_editor (MidoriSettings* self);
void midori_settings_set_text_editor (MidoriSettings* self, const gchar* value);
const gchar* midori_settings_get_news_aggregator (MidoriSettings* self);
void midori_settings_set_news_aggregator (MidoriSettings* self, const gchar* value);
const gchar* midori_settings_get_http_proxy (MidoriSettings* self);
void midori_settings_set_http_proxy (MidoriSettings* self, const gchar* value);
gint midori_settings_get_http_proxy_port (MidoriSettings* self);
void midori_settings_set_http_proxy_port (MidoriSettings* self, gint value);
gint midori_settings_get_maximum_cache_size (MidoriSettings* self);
void midori_settings_set_maximum_cache_size (MidoriSettings* self, gint value);
gboolean midori_settings_get_strip_referer (MidoriSettings* self);
void midori_settings_set_strip_referer (MidoriSettings* self, gboolean value);
gboolean midori_settings_get_first_party_cookies_only (MidoriSettings* self);
void midori_settings_set_first_party_cookies_only (MidoriSettings* self, gboolean value);
gint midori_settings_get_maximum_cookie_age (MidoriSettings* self);
void midori_settings_set_maximum_cookie_age (MidoriSettings* self, gint value);
gint midori_settings_get_maximum_history_age (MidoriSettings* self);
void midori_settings_set_maximum_history_age (MidoriSettings* self, gint value);
static void midori_settings_finalize (GObject * obj);
static void _vala_midori_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_midori_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType midori_window_state_get_type (void) {
	static volatile gsize midori_window_state_type_id__volatile = 0;
	if (g_once_init_enter (&midori_window_state_type_id__volatile)) {
		static const GEnumValue values[] = {{MIDORI_WINDOW_NORMAL, "MIDORI_WINDOW_NORMAL", "normal"}, {MIDORI_WINDOW_MINIMIZED, "MIDORI_WINDOW_MINIMIZED", "minimized"}, {MIDORI_WINDOW_MAXIMIZED, "MIDORI_WINDOW_MAXIMIZED", "maximized"}, {MIDORI_WINDOW_FULLSCREEN, "MIDORI_WINDOW_FULLSCREEN", "fullscreen"}, {0, NULL, NULL}};
		GType midori_window_state_type_id;
		midori_window_state_type_id = g_enum_register_static ("MidoriWindowState", values);
		g_once_init_leave (&midori_window_state_type_id__volatile, midori_window_state_type_id);
	}
	return midori_window_state_type_id__volatile;
}


static gchar* midori_settings_default_download_folder (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
#line 162 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp1_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
#line 162 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = _tmp1_;
#line 162 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (_tmp0_ == NULL) {
#line 315 "midori-settings.c"
		const gchar* _tmp2_;
#line 163 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp2_ = g_get_home_dir ();
#line 163 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = _tmp2_;
#line 321 "midori-settings.c"
	}
#line 162 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp3_ = g_strdup (_tmp0_);
#line 162 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp3_;
#line 162 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 329 "midori-settings.c"
}


gboolean midori_settings_delay_saving (MidoriSettings* self, const gchar* property) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp3_;
#line 187 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 187 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (property != NULL, FALSE);
#line 188 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp2_ = property;
#line 188 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp3_ = g_str_has_prefix (_tmp2_, "last-");
#line 188 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (_tmp3_) {
#line 188 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = TRUE;
#line 351 "midori-settings.c"
	} else {
		const gchar* _tmp4_;
#line 189 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp4_ = property;
#line 189 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strcmp0 (_tmp4_, "user-stylesheet-uri") == 0;
#line 358 "midori-settings.c"
	}
#line 188 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (_tmp1_) {
#line 188 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = TRUE;
#line 364 "midori-settings.c"
	} else {
		const gchar* _tmp5_;
		gboolean _tmp6_;
#line 190 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp5_ = property;
#line 190 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp6_ = g_str_has_suffix (_tmp5_, "-width");
#line 190 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = _tmp6_;
#line 374 "midori-settings.c"
	}
#line 188 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 188 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 380 "midori-settings.c"
}


MidoriSettings* midori_settings_construct (GType object_type) {
	MidoriSettings * self = NULL;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self = (MidoriSettings*) g_object_new (object_type, NULL);
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return self;
#line 390 "midori-settings.c"
}


MidoriSettings* midori_settings_new (void) {
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return midori_settings_construct (MIDORI_TYPE_SETTINGS);
#line 397 "midori-settings.c"
}


gboolean midori_settings_get_enable_javascript (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 25 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 26 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_get ((WebKitWebSettings*) self, "enable-scripts", &_tmp0_, NULL);
#line 26 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp1_ = _tmp0_;
#line 26 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp1_;
#line 26 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 415 "midori-settings.c"
}


void midori_settings_set_enable_javascript (MidoriSettings* self, gboolean value) {
	gboolean _tmp0_;
#line 27 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 28 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = value;
#line 28 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_set ((WebKitWebSettings*) self, "enable-scripts", _tmp0_, NULL);
#line 27 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_ENABLE_JAVASCRIPT_PROPERTY]);
#line 429 "midori-settings.c"
}


gchar* midori_settings_get_default_charset (MidoriSettings* self) {
	gchar* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 31 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_get ((WebKitWebSettings*) self, "default-encoding", &_tmp0_, NULL);
#line 32 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp1_ = _tmp0_;
#line 32 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp1_;
#line 32 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 447 "midori-settings.c"
}


void midori_settings_set_default_charset (MidoriSettings* self, const gchar* value) {
	const gchar* _tmp0_;
#line 33 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 34 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = value;
#line 34 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_set ((WebKitWebSettings*) self, "default-encoding", _tmp0_, NULL);
#line 33 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_DEFAULT_CHARSET_PROPERTY]);
#line 461 "midori-settings.c"
}


gboolean midori_settings_get_zoom_text_and_images (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_zoom_text_and_images;
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 476 "midori-settings.c"
}


void midori_settings_set_zoom_text_and_images (MidoriSettings* self, gboolean value) {
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_zoom_text_and_images (self) != value) {
#line 485 "midori-settings.c"
		gboolean _tmp0_;
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_zoom_text_and_images = _tmp0_;
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_ZOOM_TEXT_AND_IMAGES_PROPERTY]);
#line 493 "midori-settings.c"
	}
}


gboolean midori_settings_get_remember_last_window_size (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_remember_last_window_size;
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 509 "midori-settings.c"
}


void midori_settings_set_remember_last_window_size (MidoriSettings* self, gboolean value) {
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_remember_last_window_size (self) != value) {
#line 518 "midori-settings.c"
		gboolean _tmp0_;
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_remember_last_window_size = _tmp0_;
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_REMEMBER_LAST_WINDOW_SIZE_PROPERTY]);
#line 526 "midori-settings.c"
	}
}


gint midori_settings_get_last_window_width (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_last_window_width;
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 542 "midori-settings.c"
}


void midori_settings_set_last_window_width (MidoriSettings* self, gint value) {
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_last_window_width (self) != value) {
#line 551 "midori-settings.c"
		gint _tmp0_;
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_last_window_width = _tmp0_;
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_LAST_WINDOW_WIDTH_PROPERTY]);
#line 559 "midori-settings.c"
	}
}


gint midori_settings_get_last_window_height (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_last_window_height;
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 575 "midori-settings.c"
}


void midori_settings_set_last_window_height (MidoriSettings* self, gint value) {
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_last_window_height (self) != value) {
#line 584 "midori-settings.c"
		gint _tmp0_;
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_last_window_height = _tmp0_;
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_LAST_WINDOW_HEIGHT_PROPERTY]);
#line 592 "midori-settings.c"
	}
}


gint midori_settings_get_last_panel_position (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_last_panel_position;
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 608 "midori-settings.c"
}


void midori_settings_set_last_panel_position (MidoriSettings* self, gint value) {
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_last_panel_position (self) != value) {
#line 617 "midori-settings.c"
		gint _tmp0_;
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_last_panel_position = _tmp0_;
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_LAST_PANEL_POSITION_PROPERTY]);
#line 625 "midori-settings.c"
	}
}


gint midori_settings_get_last_panel_page (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_last_panel_page;
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 641 "midori-settings.c"
}


void midori_settings_set_last_panel_page (MidoriSettings* self, gint value) {
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_last_panel_page (self) != value) {
#line 650 "midori-settings.c"
		gint _tmp0_;
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_last_panel_page = _tmp0_;
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_LAST_PANEL_PAGE_PROPERTY]);
#line 658 "midori-settings.c"
	}
}


gint midori_settings_get_last_web_search (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_last_web_search;
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 674 "midori-settings.c"
}


void midori_settings_set_last_web_search (MidoriSettings* self, gint value) {
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_last_web_search (self) != value) {
#line 683 "midori-settings.c"
		gint _tmp0_;
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_last_web_search = _tmp0_;
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_LAST_WEB_SEARCH_PROPERTY]);
#line 691 "midori-settings.c"
	}
}


gint midori_settings_get_search_width (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_search_width;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 707 "midori-settings.c"
}


void midori_settings_set_search_width (MidoriSettings* self, gint value) {
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_search_width (self) != value) {
#line 716 "midori-settings.c"
		gint _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_search_width = _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_SEARCH_WIDTH_PROPERTY]);
#line 724 "midori-settings.c"
	}
}


gboolean midori_settings_get_last_inspector_attached (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_last_inspector_attached;
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 740 "midori-settings.c"
}


void midori_settings_set_last_inspector_attached (MidoriSettings* self, gboolean value) {
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_last_inspector_attached (self) != value) {
#line 749 "midori-settings.c"
		gboolean _tmp0_;
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_last_inspector_attached = _tmp0_;
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_LAST_INSPECTOR_ATTACHED_PROPERTY]);
#line 757 "midori-settings.c"
	}
}


MidoriWindowState midori_settings_get_last_window_state (MidoriSettings* self) {
	MidoriWindowState result;
	MidoriWindowState _tmp0_;
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_last_window_state;
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 773 "midori-settings.c"
}


void midori_settings_set_last_window_state (MidoriSettings* self, MidoriWindowState value) {
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_last_window_state (self) != value) {
#line 782 "midori-settings.c"
		MidoriWindowState _tmp0_;
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_last_window_state = _tmp0_;
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_LAST_WINDOW_STATE_PROPERTY]);
#line 790 "midori-settings.c"
	}
}


guint midori_settings_get_inactivity_reset (MidoriSettings* self) {
	guint result;
	guint _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_inactivity_reset;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 806 "midori-settings.c"
}


void midori_settings_set_inactivity_reset (MidoriSettings* self, guint value) {
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_inactivity_reset (self) != value) {
#line 815 "midori-settings.c"
		guint _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_inactivity_reset = _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_INACTIVITY_RESET_PROPERTY]);
#line 823 "midori-settings.c"
	}
}


const gchar* midori_settings_get_default_theme_name (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
#line 70 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->default_theme_name_;
#line 71 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (_tmp0_ == NULL) {
#line 838 "midori-settings.c"
		GtkSettings* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = gtk_settings_get_default ();
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_get (_tmp1_, "gtk-theme-name", &_tmp2_, NULL);
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp3_ = _tmp2_;
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->default_theme_name_);
#line 72 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->default_theme_name_ = _tmp3_;
#line 852 "midori-settings.c"
	}
#line 73 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp4_ = self->priv->default_theme_name_;
#line 73 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp4_;
#line 73 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 860 "midori-settings.c"
}


const gchar* midori_settings_get_theme_name (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 77 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 78 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->theme_name_;
#line 78 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 78 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 875 "midori-settings.c"
}


void midori_settings_set_theme_name (MidoriSettings* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 79 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 80 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = midori_settings_get_theme_name (self);
#line 80 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp1_ = _tmp0_;
#line 80 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp2_ = value;
#line 80 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
#line 893 "midori-settings.c"
		const gchar* _tmp3_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GtkSettings* _tmp9_;
		const gchar* _tmp10_;
#line 81 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp3_ = self->priv->default_theme_name_;
#line 81 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		if (_tmp3_ == NULL) {
#line 903 "midori-settings.c"
			GtkSettings* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
#line 82 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
			_tmp4_ = gtk_settings_get_default ();
#line 82 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
			g_object_get (_tmp4_, "gtk-theme-name", &_tmp5_, NULL);
#line 82 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
			_tmp6_ = _tmp5_;
#line 82 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
			_g_free0 (self->priv->default_theme_name_);
#line 82 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
			self->priv->default_theme_name_ = _tmp6_;
#line 917 "midori-settings.c"
		}
#line 83 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp7_ = value;
#line 83 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 83 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->theme_name_);
#line 83 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->theme_name_ = _tmp8_;
#line 84 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp9_ = gtk_settings_get_default ();
#line 84 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp10_ = self->priv->theme_name_;
#line 84 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_set (_tmp9_, "gtk-theme-name", _tmp10_, NULL);
#line 933 "midori-settings.c"
	}
#line 79 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_THEME_NAME_PROPERTY]);
#line 937 "midori-settings.c"
}


const gchar* midori_settings_get_block_uris (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	GRegex* _tmp1_;
#line 90 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp1_ = self->priv->block_uris_regex;
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (_tmp1_ != NULL) {
#line 951 "midori-settings.c"
		GRegex* _tmp2_;
		const gchar* _tmp3_;
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp2_ = self->priv->block_uris_regex;
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp3_ = g_regex_get_pattern (_tmp2_);
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = _tmp3_;
#line 960 "midori-settings.c"
	} else {
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = NULL;
#line 964 "midori-settings.c"
	}
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 91 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 970 "midori-settings.c"
}


static void _vala_SoupURI_free (SoupURI* self) {
#line 99 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 977 "midori-settings.c"
}


static void _midori_settings_block_uris____lambda21_ (MidoriSettings* self, SoupMessage* msg) {
	GRegex* _tmp0_;
	SoupMessage* _tmp1_;
	SoupURI* _tmp2_;
	SoupURI* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
#line 97 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (msg != NULL);
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->block_uris_regex;
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp1_ = msg;
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp2_ = soup_message_get_uri (_tmp1_);
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp3_ = _tmp2_;
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp4_ = soup_uri_to_string (_tmp3_, FALSE);
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp5_ = _tmp4_;
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp6_ = g_regex_match (_tmp0_, _tmp5_, 0, NULL);
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp7_ = _tmp6_;
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (_tmp5_);
#line 98 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (_tmp7_) {
#line 1012 "midori-settings.c"
		SoupMessage* _tmp8_;
		SoupURI* _tmp9_;
		SoupURI* _tmp10_;
#line 99 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp8_ = msg;
#line 99 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp9_ = soup_uri_new ("http://.invalid");
#line 99 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp10_ = _tmp9_;
#line 99 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		soup_message_set_uri (_tmp8_, _tmp10_);
#line 99 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		__vala_SoupURI_free0 (_tmp10_);
#line 1026 "midori-settings.c"
	}
}


static void __midori_settings_block_uris____lambda21__soup_session_request_queued (SoupSession* _sender, SoupMessage* msg, gpointer self) {
#line 97 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_midori_settings_block_uris____lambda21_ ((MidoriSettings*) self, msg);
#line 1034 "midori-settings.c"
}


void midori_settings_set_block_uris (MidoriSettings* self, const gchar* value) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GRegex* _tmp3_;
	GError * _inner_error_ = NULL;
#line 92 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 94 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp1_ = value;
#line 94 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (_tmp1_ == NULL) {
#line 94 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = TRUE;
#line 1051 "midori-settings.c"
	} else {
		const gchar* _tmp2_;
#line 94 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp2_ = value;
#line 94 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 1058 "midori-settings.c"
	}
#line 94 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (_tmp0_) {
#line 95 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		return;
#line 1064 "midori-settings.c"
	}
#line 96 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp3_ = self->priv->block_uris_regex;
#line 96 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (_tmp3_ == NULL) {
#line 1070 "midori-settings.c"
		SoupSession* _tmp4_;
#line 97 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp4_ = webkit_get_default_session ();
#line 97 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_signal_connect_object (_tmp4_, "request-queued", (GCallback) __midori_settings_block_uris____lambda21__soup_session_request_queued, self, 0);
#line 1076 "midori-settings.c"
	}
	{
		GRegex* _tmp5_ = NULL;
		const gchar* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
#line 102 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp6_ = value;
#line 102 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp7_ = g_regex_new (_tmp6_, 0, 0, &_inner_error_);
#line 102 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp5_ = _tmp7_;
#line 102 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1091 "midori-settings.c"
			goto __catch25_g_error;
		}
#line 102 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp8_ = _tmp5_;
#line 102 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp5_ = NULL;
#line 102 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_regex_unref0 (self->priv->block_uris_regex);
#line 102 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->block_uris_regex = _tmp8_;
#line 101 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_regex_unref0 (_tmp5_);
#line 1104 "midori-settings.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 101 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_error_ = _inner_error_;
#line 101 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_inner_error_ = NULL;
#line 105 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp9_ = _error_;
#line 105 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp10_ = _tmp9_->message;
#line 105 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_critical ("midori-settings.vala:105: block-uris: %s", _tmp10_);
#line 101 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_error_free0 (_error_);
#line 1124 "midori-settings.c"
	}
	__finally25:
#line 101 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 101 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 101 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_clear_error (&_inner_error_);
#line 101 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		return;
#line 1135 "midori-settings.c"
	}
#line 92 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_BLOCK_URIS_PROPERTY]);
#line 1139 "midori-settings.c"
}


const gchar* midori_settings_get_custom_title (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_custom_title;
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1154 "midori-settings.c"
}


void midori_settings_set_custom_title (MidoriSettings* self, const gchar* value) {
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_custom_title (self)) != 0) {
#line 1163 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_custom_title);
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_custom_title = _tmp1_;
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_CUSTOM_TITLE_PROPERTY]);
#line 1176 "midori-settings.c"
	}
}


const gchar* midori_settings_get_location_entry_search (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_location_entry_search;
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1192 "midori-settings.c"
}


void midori_settings_set_location_entry_search (MidoriSettings* self, const gchar* value) {
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_location_entry_search (self)) != 0) {
#line 1201 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_location_entry_search);
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_location_entry_search = _tmp1_;
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_LOCATION_ENTRY_SEARCH_PROPERTY]);
#line 1214 "midori-settings.c"
	}
}


gint midori_settings_get_clear_private_data (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_clear_private_data;
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1230 "midori-settings.c"
}


void midori_settings_set_clear_private_data (MidoriSettings* self, gint value) {
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_clear_private_data (self) != value) {
#line 1239 "midori-settings.c"
		gint _tmp0_;
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_clear_private_data = _tmp0_;
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_CLEAR_PRIVATE_DATA_PROPERTY]);
#line 1247 "midori-settings.c"
	}
}


const gchar* midori_settings_get_clear_data (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_clear_data;
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1263 "midori-settings.c"
}


void midori_settings_set_clear_data (MidoriSettings* self, const gchar* value) {
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_clear_data (self)) != 0) {
#line 1272 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_clear_data);
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_clear_data = _tmp1_;
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_CLEAR_DATA_PROPERTY]);
#line 1285 "midori-settings.c"
	}
}


gboolean midori_settings_get_compact_sidepanel (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_compact_sidepanel;
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1301 "midori-settings.c"
}


void midori_settings_set_compact_sidepanel (MidoriSettings* self, gboolean value) {
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_compact_sidepanel (self) != value) {
#line 1310 "midori-settings.c"
		gboolean _tmp0_;
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_compact_sidepanel = _tmp0_;
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_COMPACT_SIDEPANEL_PROPERTY]);
#line 1318 "midori-settings.c"
	}
}


gboolean midori_settings_get_open_panels_in_windows (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_open_panels_in_windows;
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1334 "midori-settings.c"
}


void midori_settings_set_open_panels_in_windows (MidoriSettings* self, gboolean value) {
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_open_panels_in_windows (self) != value) {
#line 1343 "midori-settings.c"
		gboolean _tmp0_;
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_open_panels_in_windows = _tmp0_;
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_OPEN_PANELS_IN_WINDOWS_PROPERTY]);
#line 1351 "midori-settings.c"
	}
}


gboolean midori_settings_get_right_align_sidepanel (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_right_align_sidepanel;
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1367 "midori-settings.c"
}


void midori_settings_set_right_align_sidepanel (MidoriSettings* self, gboolean value) {
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_right_align_sidepanel (self) != value) {
#line 1376 "midori-settings.c"
		gboolean _tmp0_;
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_right_align_sidepanel = _tmp0_;
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_RIGHT_ALIGN_SIDEPANEL_PROPERTY]);
#line 1384 "midori-settings.c"
	}
}


gboolean midori_settings_get_show_menubar (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_show_menubar;
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1400 "midori-settings.c"
}


void midori_settings_set_show_menubar (MidoriSettings* self, gboolean value) {
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_show_menubar (self) != value) {
#line 1409 "midori-settings.c"
		gboolean _tmp0_;
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_show_menubar = _tmp0_;
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_SHOW_MENUBAR_PROPERTY]);
#line 1417 "midori-settings.c"
	}
}


gboolean midori_settings_get_show_navigationbar (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_show_navigationbar;
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1433 "midori-settings.c"
}


void midori_settings_set_show_navigationbar (MidoriSettings* self, gboolean value) {
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_show_navigationbar (self) != value) {
#line 1442 "midori-settings.c"
		gboolean _tmp0_;
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_show_navigationbar = _tmp0_;
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_SHOW_NAVIGATIONBAR_PROPERTY]);
#line 1450 "midori-settings.c"
	}
}


gboolean midori_settings_get_show_bookmarkbar (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_show_bookmarkbar;
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1466 "midori-settings.c"
}


void midori_settings_set_show_bookmarkbar (MidoriSettings* self, gboolean value) {
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_show_bookmarkbar (self) != value) {
#line 1475 "midori-settings.c"
		gboolean _tmp0_;
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_show_bookmarkbar = _tmp0_;
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_SHOW_BOOKMARKBAR_PROPERTY]);
#line 1483 "midori-settings.c"
	}
}


gboolean midori_settings_get_show_panel (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_show_panel;
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1499 "midori-settings.c"
}


void midori_settings_set_show_panel (MidoriSettings* self, gboolean value) {
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_show_panel (self) != value) {
#line 1508 "midori-settings.c"
		gboolean _tmp0_;
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_show_panel = _tmp0_;
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_SHOW_PANEL_PROPERTY]);
#line 1516 "midori-settings.c"
	}
}


gboolean midori_settings_get_show_statusbar (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_show_statusbar;
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1532 "midori-settings.c"
}


void midori_settings_set_show_statusbar (MidoriSettings* self, gboolean value) {
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_show_statusbar (self) != value) {
#line 1541 "midori-settings.c"
		gboolean _tmp0_;
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_show_statusbar = _tmp0_;
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_SHOW_STATUSBAR_PROPERTY]);
#line 1549 "midori-settings.c"
	}
}


gboolean midori_settings_get_show_crash_dialog (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_show_crash_dialog;
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1565 "midori-settings.c"
}


void midori_settings_set_show_crash_dialog (MidoriSettings* self, gboolean value) {
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_show_crash_dialog (self) != value) {
#line 1574 "midori-settings.c"
		gboolean _tmp0_;
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_show_crash_dialog = _tmp0_;
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_SHOW_CRASH_DIALOG_PROPERTY]);
#line 1582 "midori-settings.c"
	}
}


const gchar* midori_settings_get_toolbar_items (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_toolbar_items;
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1598 "midori-settings.c"
}


void midori_settings_set_toolbar_items (MidoriSettings* self, const gchar* value) {
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_toolbar_items (self)) != 0) {
#line 1607 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_toolbar_items);
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_toolbar_items = _tmp1_;
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_TOOLBAR_ITEMS_PROPERTY]);
#line 1620 "midori-settings.c"
	}
}


gboolean midori_settings_get_find_while_typing (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_find_while_typing;
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1636 "midori-settings.c"
}


void midori_settings_set_find_while_typing (MidoriSettings* self, gboolean value) {
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_find_while_typing (self) != value) {
#line 1645 "midori-settings.c"
		gboolean _tmp0_;
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_find_while_typing = _tmp0_;
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_FIND_WHILE_TYPING_PROPERTY]);
#line 1653 "midori-settings.c"
	}
}


gdouble midori_settings_get_zoom_level (MidoriSettings* self) {
	gdouble result;
	gdouble _tmp0_;
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_zoom_level;
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1669 "midori-settings.c"
}


void midori_settings_set_zoom_level (MidoriSettings* self, gdouble value) {
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_zoom_level (self) != value) {
#line 1678 "midori-settings.c"
		gdouble _tmp0_;
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_zoom_level = _tmp0_;
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_ZOOM_LEVEL_PROPERTY]);
#line 1686 "midori-settings.c"
	}
}


gboolean midori_settings_get_open_popups_in_tabs (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_open_popups_in_tabs;
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1702 "midori-settings.c"
}


void midori_settings_set_open_popups_in_tabs (MidoriSettings* self, gboolean value) {
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_open_popups_in_tabs (self) != value) {
#line 1711 "midori-settings.c"
		gboolean _tmp0_;
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_open_popups_in_tabs = _tmp0_;
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_OPEN_POPUPS_IN_TABS_PROPERTY]);
#line 1719 "midori-settings.c"
	}
}


gboolean midori_settings_get_kinetic_scrolling (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_kinetic_scrolling;
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1735 "midori-settings.c"
}


void midori_settings_set_kinetic_scrolling (MidoriSettings* self, gboolean value) {
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_kinetic_scrolling (self) != value) {
#line 1744 "midori-settings.c"
		gboolean _tmp0_;
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_kinetic_scrolling = _tmp0_;
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_KINETIC_SCROLLING_PROPERTY]);
#line 1752 "midori-settings.c"
	}
}


gboolean midori_settings_get_middle_click_opens_selection (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_middle_click_opens_selection;
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1768 "midori-settings.c"
}


void midori_settings_set_middle_click_opens_selection (MidoriSettings* self, gboolean value) {
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_middle_click_opens_selection (self) != value) {
#line 1777 "midori-settings.c"
		gboolean _tmp0_;
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_middle_click_opens_selection = _tmp0_;
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_MIDDLE_CLICK_OPENS_SELECTION_PROPERTY]);
#line 1785 "midori-settings.c"
	}
}


gboolean midori_settings_get_flash_window_on_new_bg_tabs (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_flash_window_on_new_bg_tabs;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1801 "midori-settings.c"
}


void midori_settings_set_flash_window_on_new_bg_tabs (MidoriSettings* self, gboolean value) {
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_flash_window_on_new_bg_tabs (self) != value) {
#line 1810 "midori-settings.c"
		gboolean _tmp0_;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_flash_window_on_new_bg_tabs = _tmp0_;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_FLASH_WINDOW_ON_NEW_BG_TABS_PROPERTY]);
#line 1818 "midori-settings.c"
	}
}


gboolean midori_settings_get_close_buttons_on_tabs (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_close_buttons_on_tabs;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1834 "midori-settings.c"
}


void midori_settings_set_close_buttons_on_tabs (MidoriSettings* self, gboolean value) {
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_close_buttons_on_tabs (self) != value) {
#line 1843 "midori-settings.c"
		gboolean _tmp0_;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_close_buttons_on_tabs = _tmp0_;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_CLOSE_BUTTONS_ON_TABS_PROPERTY]);
#line 1851 "midori-settings.c"
	}
}


gboolean midori_settings_get_open_tabs_in_the_background (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_open_tabs_in_the_background;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1867 "midori-settings.c"
}


void midori_settings_set_open_tabs_in_the_background (MidoriSettings* self, gboolean value) {
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_open_tabs_in_the_background (self) != value) {
#line 1876 "midori-settings.c"
		gboolean _tmp0_;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_open_tabs_in_the_background = _tmp0_;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_OPEN_TABS_IN_THE_BACKGROUND_PROPERTY]);
#line 1884 "midori-settings.c"
	}
}


gboolean midori_settings_get_open_tabs_next_to_current (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_open_tabs_next_to_current;
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1900 "midori-settings.c"
}


void midori_settings_set_open_tabs_next_to_current (MidoriSettings* self, gboolean value) {
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_open_tabs_next_to_current (self) != value) {
#line 1909 "midori-settings.c"
		gboolean _tmp0_;
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_open_tabs_next_to_current = _tmp0_;
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_OPEN_TABS_NEXT_TO_CURRENT_PROPERTY]);
#line 1917 "midori-settings.c"
	}
}


gboolean midori_settings_get_always_show_tabbar (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_always_show_tabbar;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1933 "midori-settings.c"
}


void midori_settings_set_always_show_tabbar (MidoriSettings* self, gboolean value) {
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_always_show_tabbar (self) != value) {
#line 1942 "midori-settings.c"
		gboolean _tmp0_;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_always_show_tabbar = _tmp0_;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_ALWAYS_SHOW_TABBAR_PROPERTY]);
#line 1950 "midori-settings.c"
	}
}


const gchar* midori_settings_get_homepage (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_homepage;
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 1966 "midori-settings.c"
}


void midori_settings_set_homepage (MidoriSettings* self, const gchar* value) {
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_homepage (self)) != 0) {
#line 1975 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_homepage);
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_homepage = _tmp1_;
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_HOMEPAGE_PROPERTY]);
#line 1988 "midori-settings.c"
	}
}


const gchar* midori_settings_get_tabhome (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_tabhome;
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2004 "midori-settings.c"
}


void midori_settings_set_tabhome (MidoriSettings* self, const gchar* value) {
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_tabhome (self)) != 0) {
#line 2013 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_tabhome);
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_tabhome = _tmp1_;
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_TABHOME_PROPERTY]);
#line 2026 "midori-settings.c"
	}
}


const gchar* midori_settings_get_download_folder (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_download_folder;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2042 "midori-settings.c"
}


void midori_settings_set_download_folder (MidoriSettings* self, const gchar* value) {
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_download_folder (self)) != 0) {
#line 2051 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_download_folder);
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_download_folder = _tmp1_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_DOWNLOAD_FOLDER_PROPERTY]);
#line 2064 "midori-settings.c"
	}
}


const gchar* midori_settings_get_text_editor (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_text_editor;
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2080 "midori-settings.c"
}


void midori_settings_set_text_editor (MidoriSettings* self, const gchar* value) {
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_text_editor (self)) != 0) {
#line 2089 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_text_editor);
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_text_editor = _tmp1_;
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_TEXT_EDITOR_PROPERTY]);
#line 2102 "midori-settings.c"
	}
}


const gchar* midori_settings_get_news_aggregator (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_news_aggregator;
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2118 "midori-settings.c"
}


void midori_settings_set_news_aggregator (MidoriSettings* self, const gchar* value) {
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_news_aggregator (self)) != 0) {
#line 2127 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_news_aggregator);
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_news_aggregator = _tmp1_;
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_NEWS_AGGREGATOR_PROPERTY]);
#line 2140 "midori-settings.c"
	}
}


const gchar* midori_settings_get_http_proxy (MidoriSettings* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_http_proxy;
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2156 "midori-settings.c"
}


void midori_settings_set_http_proxy (MidoriSettings* self, const gchar* value) {
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (g_strcmp0 (value, midori_settings_get_http_proxy (self)) != 0) {
#line 2165 "midori-settings.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_g_free0 (self->priv->_http_proxy);
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_http_proxy = _tmp1_;
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_HTTP_PROXY_PROPERTY]);
#line 2178 "midori-settings.c"
	}
}


gint midori_settings_get_http_proxy_port (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_http_proxy_port;
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2194 "midori-settings.c"
}


void midori_settings_set_http_proxy_port (MidoriSettings* self, gint value) {
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_http_proxy_port (self) != value) {
#line 2203 "midori-settings.c"
		gint _tmp0_;
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_http_proxy_port = _tmp0_;
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_HTTP_PROXY_PORT_PROPERTY]);
#line 2211 "midori-settings.c"
	}
}


gint midori_settings_get_maximum_cache_size (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_maximum_cache_size;
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2227 "midori-settings.c"
}


void midori_settings_set_maximum_cache_size (MidoriSettings* self, gint value) {
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_maximum_cache_size (self) != value) {
#line 2236 "midori-settings.c"
		gint _tmp0_;
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_maximum_cache_size = _tmp0_;
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_MAXIMUM_CACHE_SIZE_PROPERTY]);
#line 2244 "midori-settings.c"
	}
}


gboolean midori_settings_get_strip_referer (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_strip_referer;
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2260 "midori-settings.c"
}


void midori_settings_set_strip_referer (MidoriSettings* self, gboolean value) {
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_strip_referer (self) != value) {
#line 2269 "midori-settings.c"
		gboolean _tmp0_;
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_strip_referer = _tmp0_;
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_STRIP_REFERER_PROPERTY]);
#line 2277 "midori-settings.c"
	}
}


gboolean midori_settings_get_first_party_cookies_only (MidoriSettings* self) {
	gboolean result;
	gboolean _tmp0_;
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_first_party_cookies_only;
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2293 "midori-settings.c"
}


void midori_settings_set_first_party_cookies_only (MidoriSettings* self, gboolean value) {
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_first_party_cookies_only (self) != value) {
#line 2302 "midori-settings.c"
		gboolean _tmp0_;
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_first_party_cookies_only = _tmp0_;
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_FIRST_PARTY_COOKIES_ONLY_PROPERTY]);
#line 2310 "midori-settings.c"
	}
}


gint midori_settings_get_maximum_cookie_age (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_maximum_cookie_age;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2326 "midori-settings.c"
}


void midori_settings_set_maximum_cookie_age (MidoriSettings* self, gint value) {
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_maximum_cookie_age (self) != value) {
#line 2335 "midori-settings.c"
		gint _tmp0_;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_maximum_cookie_age = _tmp0_;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_MAXIMUM_COOKIE_AGE_PROPERTY]);
#line 2343 "midori-settings.c"
	}
}


gint midori_settings_get_maximum_history_age (MidoriSettings* self) {
	gint result;
	gint _tmp0_;
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = self->priv->_maximum_history_age;
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	result = _tmp0_;
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	return result;
#line 2359 "midori-settings.c"
}


void midori_settings_set_maximum_history_age (MidoriSettings* self, gint value) {
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_return_if_fail (self != NULL);
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	if (midori_settings_get_maximum_history_age (self) != value) {
#line 2368 "midori-settings.c"
		gint _tmp0_;
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		_tmp0_ = value;
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		self->priv->_maximum_history_age = _tmp0_;
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_object_notify_by_pspec ((GObject *) self, midori_settings_properties[MIDORI_SETTINGS_MAXIMUM_HISTORY_AGE_PROPERTY]);
#line 2376 "midori-settings.c"
	}
}


static void midori_settings_class_init (MidoriSettingsClass * klass) {
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	midori_settings_parent_class = g_type_class_peek_parent (klass);
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_type_class_add_private (klass, sizeof (MidoriSettingsPrivate));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_midori_settings_get_property;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_midori_settings_set_property;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	G_OBJECT_CLASS (klass)->finalize = midori_settings_finalize;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_ENABLE_JAVASCRIPT_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_ENABLE_JAVASCRIPT_PROPERTY] = g_param_spec_boolean ("enable-javascript", "enable-javascript", "enable-javascript", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_DEFAULT_CHARSET_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_DEFAULT_CHARSET_PROPERTY] = g_param_spec_string ("default-charset", "default-charset", "default-charset", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_ZOOM_TEXT_AND_IMAGES_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_ZOOM_TEXT_AND_IMAGES_PROPERTY] = g_param_spec_boolean ("zoom-text-and-images", "zoom-text-and-images", "zoom-text-and-images", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_REMEMBER_LAST_WINDOW_SIZE_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_REMEMBER_LAST_WINDOW_SIZE_PROPERTY] = g_param_spec_boolean ("remember-last-window-size", "remember-last-window-size", "remember-last-window-size", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_LAST_WINDOW_WIDTH_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_LAST_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("last-window-width", "last-window-width", "last-window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_LAST_WINDOW_HEIGHT_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_LAST_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("last-window-height", "last-window-height", "last-window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_LAST_PANEL_POSITION_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_LAST_PANEL_POSITION_PROPERTY] = g_param_spec_int ("last-panel-position", "last-panel-position", "last-panel-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_LAST_PANEL_PAGE_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_LAST_PANEL_PAGE_PROPERTY] = g_param_spec_int ("last-panel-page", "last-panel-page", "last-panel-page", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_LAST_WEB_SEARCH_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_LAST_WEB_SEARCH_PROPERTY] = g_param_spec_int ("last-web-search", "last-web-search", "last-web-search", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_SEARCH_WIDTH_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_SEARCH_WIDTH_PROPERTY] = g_param_spec_int ("search-width", "search-width", "search-width", G_MININT, G_MAXINT, 200, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_LAST_INSPECTOR_ATTACHED_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_LAST_INSPECTOR_ATTACHED_PROPERTY] = g_param_spec_boolean ("last-inspector-attached", "last-inspector-attached", "last-inspector-attached", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_LAST_WINDOW_STATE_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_LAST_WINDOW_STATE_PROPERTY] = g_param_spec_enum ("last-window-state", "last-window-state", "last-window-state", MIDORI_TYPE_WINDOW_STATE, MIDORI_WINDOW_NORMAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_INACTIVITY_RESET_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_INACTIVITY_RESET_PROPERTY] = g_param_spec_uint ("inactivity-reset", "inactivity-reset", "inactivity-reset", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_DEFAULT_THEME_NAME_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_DEFAULT_THEME_NAME_PROPERTY] = g_param_spec_string ("default-theme-name", "default-theme-name", "default-theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_THEME_NAME_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_THEME_NAME_PROPERTY] = g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_BLOCK_URIS_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_BLOCK_URIS_PROPERTY] = g_param_spec_string ("block-uris", "block-uris", "block-uris", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2424 "midori-settings.c"
	/**
	         * Overrides the browser window title if given.
	         * Examples are "Help Viewer" or "L:D_N:application_ID:midori_O:URL"
	         *
	         * Since: 0.5.1
	         **/
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_CUSTOM_TITLE_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_CUSTOM_TITLE_PROPERTY] = g_param_spec_string ("custom-title", "custom-title", "custom-title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_LOCATION_ENTRY_SEARCH_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_LOCATION_ENTRY_SEARCH_PROPERTY] = g_param_spec_string ("location-entry-search", "location-entry-search", "location-entry-search", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_CLEAR_PRIVATE_DATA_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_CLEAR_PRIVATE_DATA_PROPERTY] = g_param_spec_int ("clear-private-data", "clear-private-data", "clear-private-data", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_CLEAR_DATA_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_CLEAR_DATA_PROPERTY] = g_param_spec_string ("clear-data", "clear-data", "clear-data", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_COMPACT_SIDEPANEL_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_COMPACT_SIDEPANEL_PROPERTY] = g_param_spec_boolean ("compact-sidepanel", "compact-sidepanel", "compact-sidepanel", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_OPEN_PANELS_IN_WINDOWS_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_OPEN_PANELS_IN_WINDOWS_PROPERTY] = g_param_spec_boolean ("open-panels-in-windows", "open-panels-in-windows", "open-panels-in-windows", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_RIGHT_ALIGN_SIDEPANEL_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_RIGHT_ALIGN_SIDEPANEL_PROPERTY] = g_param_spec_boolean ("right-align-sidepanel", "right-align-sidepanel", "right-align-sidepanel", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_SHOW_MENUBAR_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_SHOW_MENUBAR_PROPERTY] = g_param_spec_boolean ("show-menubar", "show-menubar", "show-menubar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_SHOW_NAVIGATIONBAR_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_SHOW_NAVIGATIONBAR_PROPERTY] = g_param_spec_boolean ("show-navigationbar", "show-navigationbar", "show-navigationbar", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_SHOW_BOOKMARKBAR_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_SHOW_BOOKMARKBAR_PROPERTY] = g_param_spec_boolean ("show-bookmarkbar", "show-bookmarkbar", "show-bookmarkbar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_SHOW_PANEL_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_SHOW_PANEL_PROPERTY] = g_param_spec_boolean ("show-panel", "show-panel", "show-panel", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_SHOW_STATUSBAR_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_SHOW_STATUSBAR_PROPERTY] = g_param_spec_boolean ("show-statusbar", "show-statusbar", "show-statusbar", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_SHOW_CRASH_DIALOG_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_SHOW_CRASH_DIALOG_PROPERTY] = g_param_spec_boolean ("show-crash-dialog", "show-crash-dialog", "show-crash-dialog", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_TOOLBAR_ITEMS_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_TOOLBAR_ITEMS_PROPERTY] = g_param_spec_string ("toolbar-items", "toolbar-items", "toolbar-items", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_FIND_WHILE_TYPING_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_FIND_WHILE_TYPING_PROPERTY] = g_param_spec_boolean ("find-while-typing", "find-while-typing", "find-while-typing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_ZOOM_LEVEL_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_ZOOM_LEVEL_PROPERTY] = g_param_spec_double ("zoom-level", "zoom-level", "zoom-level", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_OPEN_POPUPS_IN_TABS_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_OPEN_POPUPS_IN_TABS_PROPERTY] = g_param_spec_boolean ("open-popups-in-tabs", "open-popups-in-tabs", "open-popups-in-tabs", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_KINETIC_SCROLLING_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_KINETIC_SCROLLING_PROPERTY] = g_param_spec_boolean ("kinetic-scrolling", "kinetic-scrolling", "kinetic-scrolling", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_MIDDLE_CLICK_OPENS_SELECTION_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_MIDDLE_CLICK_OPENS_SELECTION_PROPERTY] = g_param_spec_boolean ("middle-click-opens-selection", "middle-click-opens-selection", "middle-click-opens-selection", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_FLASH_WINDOW_ON_NEW_BG_TABS_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_FLASH_WINDOW_ON_NEW_BG_TABS_PROPERTY] = g_param_spec_boolean ("flash-window-on-new-bg-tabs", "flash-window-on-new-bg-tabs", "flash-window-on-new-bg-tabs", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_CLOSE_BUTTONS_ON_TABS_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_CLOSE_BUTTONS_ON_TABS_PROPERTY] = g_param_spec_boolean ("close-buttons-on-tabs", "close-buttons-on-tabs", "close-buttons-on-tabs", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_OPEN_TABS_IN_THE_BACKGROUND_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_OPEN_TABS_IN_THE_BACKGROUND_PROPERTY] = g_param_spec_boolean ("open-tabs-in-the-background", "open-tabs-in-the-background", "open-tabs-in-the-background", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_OPEN_TABS_NEXT_TO_CURRENT_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_OPEN_TABS_NEXT_TO_CURRENT_PROPERTY] = g_param_spec_boolean ("open-tabs-next-to-current", "open-tabs-next-to-current", "open-tabs-next-to-current", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_ALWAYS_SHOW_TABBAR_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_ALWAYS_SHOW_TABBAR_PROPERTY] = g_param_spec_boolean ("always-show-tabbar", "always-show-tabbar", "always-show-tabbar", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_HOMEPAGE_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_HOMEPAGE_PROPERTY] = g_param_spec_string ("homepage", "homepage", "homepage", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_TABHOME_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_TABHOME_PROPERTY] = g_param_spec_string ("tabhome", "tabhome", "tabhome", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_DOWNLOAD_FOLDER_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_DOWNLOAD_FOLDER_PROPERTY] = g_param_spec_string ("download-folder", "download-folder", "download-folder", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_TEXT_EDITOR_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_TEXT_EDITOR_PROPERTY] = g_param_spec_string ("text-editor", "text-editor", "text-editor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_NEWS_AGGREGATOR_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_NEWS_AGGREGATOR_PROPERTY] = g_param_spec_string ("news-aggregator", "news-aggregator", "news-aggregator", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_HTTP_PROXY_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_HTTP_PROXY_PROPERTY] = g_param_spec_string ("http-proxy", "http-proxy", "http-proxy", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_HTTP_PROXY_PORT_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_HTTP_PROXY_PORT_PROPERTY] = g_param_spec_int ("http-proxy-port", "http-proxy-port", "http-proxy-port", G_MININT, G_MAXINT, 8080, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_MAXIMUM_CACHE_SIZE_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_MAXIMUM_CACHE_SIZE_PROPERTY] = g_param_spec_int ("maximum-cache-size", "maximum-cache-size", "maximum-cache-size", G_MININT, G_MAXINT, 100, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_STRIP_REFERER_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_STRIP_REFERER_PROPERTY] = g_param_spec_boolean ("strip-referer", "strip-referer", "strip-referer", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_FIRST_PARTY_COOKIES_ONLY_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_FIRST_PARTY_COOKIES_ONLY_PROPERTY] = g_param_spec_boolean ("first-party-cookies-only", "first-party-cookies-only", "first-party-cookies-only", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_MAXIMUM_COOKIE_AGE_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_MAXIMUM_COOKIE_AGE_PROPERTY] = g_param_spec_int ("maximum-cookie-age", "maximum-cookie-age", "maximum-cookie-age", G_MININT, G_MAXINT, 30, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_SETTINGS_MAXIMUM_HISTORY_AGE_PROPERTY, midori_settings_properties[MIDORI_SETTINGS_MAXIMUM_HISTORY_AGE_PROPERTY] = g_param_spec_int ("maximum-history-age", "maximum-history-age", "maximum-history-age", G_MININT, G_MAXINT, 30, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2503 "midori-settings.c"
}


static void midori_settings_instance_init (MidoriSettings * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv = MIDORI_SETTINGS_GET_PRIVATE (self);
#line 37 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_zoom_text_and_images = TRUE;
#line 51 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_remember_last_window_size = TRUE;
#line 52 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_last_window_width = 0;
#line 53 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_last_window_height = 0;
#line 54 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_last_panel_position = 0;
#line 55 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_last_panel_page = 0;
#line 56 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_last_web_search = 0;
#line 59 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_search_width = 200;
#line 61 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_last_inspector_attached = FALSE;
#line 63 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_last_window_state = MIDORI_WINDOW_NORMAL;
#line 66 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_inactivity_reset = (guint) 0;
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->default_theme_name_ = NULL;
#line 75 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->theme_name_ = NULL;
#line 88 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->block_uris_regex = NULL;
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_custom_title = NULL;
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_location_entry_search = NULL;
#line 120 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_clear_private_data = 0;
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_clear_data = NULL;
#line 124 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_compact_sidepanel = FALSE;
#line 126 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_open_panels_in_windows = FALSE;
#line 128 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_right_align_sidepanel = FALSE;
#line 130 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_show_menubar = FALSE;
#line 131 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_show_navigationbar = TRUE;
#line 132 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_show_bookmarkbar = FALSE;
#line 133 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_show_panel = FALSE;
#line 134 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_show_statusbar = TRUE;
#line 136 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_show_crash_dialog = TRUE;
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp0_ = g_strdup ("TabNew,Back,NextForward,ReloadStop,BookmarkAdd,Location,Search,Trash,C" \
"ompactMenu");
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_toolbar_items = _tmp0_;
#line 141 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_find_while_typing = FALSE;
#line 143 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_zoom_level = 1.0;
#line 145 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_open_popups_in_tabs = TRUE;
#line 148 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_kinetic_scrolling = TRUE;
#line 150 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_middle_click_opens_selection = TRUE;
#line 151 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_flash_window_on_new_bg_tabs = FALSE;
#line 153 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_close_buttons_on_tabs = TRUE;
#line 154 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_open_tabs_in_the_background = TRUE;
#line 155 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_open_tabs_next_to_current = TRUE;
#line 157 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_always_show_tabbar = TRUE;
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp1_ = g_strdup ("about:search");
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_homepage = _tmp1_;
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp2_ = g_strdup ("about:dial");
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_tabhome = _tmp2_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_tmp3_ = midori_settings_default_download_folder ();
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_download_folder = _tmp3_;
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_text_editor = NULL;
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_news_aggregator = NULL;
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_http_proxy = NULL;
#line 173 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_http_proxy_port = 8080;
#line 176 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_maximum_cache_size = 100;
#line 178 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_strip_referer = TRUE;
#line 180 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_first_party_cookies_only = TRUE;
#line 182 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_maximum_cookie_age = 30;
#line 184 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self->priv->_maximum_history_age = 30;
#line 2622 "midori-settings.c"
}


static void midori_settings_finalize (GObject * obj) {
	MidoriSettings * self;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MIDORI_TYPE_SETTINGS, MidoriSettings);
#line 68 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->default_theme_name_);
#line 75 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->theme_name_);
#line 88 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_regex_unref0 (self->priv->block_uris_regex);
#line 116 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_custom_title);
#line 118 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_location_entry_search);
#line 122 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_clear_data);
#line 137 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_toolbar_items);
#line 159 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_homepage);
#line 160 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_tabhome);
#line 165 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_download_folder);
#line 166 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_text_editor);
#line 168 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_news_aggregator);
#line 170 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	_g_free0 (self->priv->_http_proxy);
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	G_OBJECT_CLASS (midori_settings_parent_class)->finalize (obj);
#line 2658 "midori-settings.c"
}


GType midori_settings_get_type (void) {
	static volatile gsize midori_settings_type_id__volatile = 0;
	if (g_once_init_enter (&midori_settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MidoriSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) midori_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MidoriSettings), 0, (GInstanceInitFunc) midori_settings_instance_init, NULL };
		GType midori_settings_type_id;
		midori_settings_type_id = g_type_register_static (WEBKIT_TYPE_WEB_SETTINGS, "MidoriSettings", &g_define_type_info, 0);
		g_once_init_leave (&midori_settings_type_id__volatile, midori_settings_type_id);
	}
	return midori_settings_type_id__volatile;
}


static void _vala_midori_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MidoriSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_SETTINGS, MidoriSettings);
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	switch (property_id) {
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_ENABLE_JAVASCRIPT_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_enable_javascript (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_DEFAULT_CHARSET_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_take_string (value, midori_settings_get_default_charset (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_ZOOM_TEXT_AND_IMAGES_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_zoom_text_and_images (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_REMEMBER_LAST_WINDOW_SIZE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_remember_last_window_size (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_WINDOW_WIDTH_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_last_window_width (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_WINDOW_HEIGHT_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_last_window_height (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_PANEL_POSITION_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_last_panel_position (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_PANEL_PAGE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_last_panel_page (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_WEB_SEARCH_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_last_web_search (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SEARCH_WIDTH_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_search_width (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_INSPECTOR_ATTACHED_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_last_inspector_attached (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_WINDOW_STATE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_enum (value, midori_settings_get_last_window_state (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_INACTIVITY_RESET_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_uint (value, midori_settings_get_inactivity_reset (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_DEFAULT_THEME_NAME_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_default_theme_name (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_THEME_NAME_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_theme_name (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_BLOCK_URIS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_block_uris (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_CUSTOM_TITLE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_custom_title (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LOCATION_ENTRY_SEARCH_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_location_entry_search (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_CLEAR_PRIVATE_DATA_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_clear_private_data (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_CLEAR_DATA_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_clear_data (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_COMPACT_SIDEPANEL_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_compact_sidepanel (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_OPEN_PANELS_IN_WINDOWS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_open_panels_in_windows (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_RIGHT_ALIGN_SIDEPANEL_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_right_align_sidepanel (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_MENUBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_show_menubar (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_NAVIGATIONBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_show_navigationbar (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_BOOKMARKBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_show_bookmarkbar (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_PANEL_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_show_panel (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_STATUSBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_show_statusbar (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_CRASH_DIALOG_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_show_crash_dialog (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_TOOLBAR_ITEMS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_toolbar_items (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_FIND_WHILE_TYPING_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_find_while_typing (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_ZOOM_LEVEL_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_double (value, midori_settings_get_zoom_level (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_OPEN_POPUPS_IN_TABS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_open_popups_in_tabs (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_KINETIC_SCROLLING_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_kinetic_scrolling (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_MIDDLE_CLICK_OPENS_SELECTION_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_middle_click_opens_selection (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_FLASH_WINDOW_ON_NEW_BG_TABS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_flash_window_on_new_bg_tabs (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_CLOSE_BUTTONS_ON_TABS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_close_buttons_on_tabs (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_OPEN_TABS_IN_THE_BACKGROUND_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_open_tabs_in_the_background (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_OPEN_TABS_NEXT_TO_CURRENT_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_open_tabs_next_to_current (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_ALWAYS_SHOW_TABBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_always_show_tabbar (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_HOMEPAGE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_homepage (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_TABHOME_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_tabhome (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_DOWNLOAD_FOLDER_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_download_folder (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_TEXT_EDITOR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_text_editor (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_NEWS_AGGREGATOR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_news_aggregator (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_HTTP_PROXY_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_string (value, midori_settings_get_http_proxy (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_HTTP_PROXY_PORT_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_http_proxy_port (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_MAXIMUM_CACHE_SIZE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_maximum_cache_size (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_STRIP_REFERER_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_strip_referer (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_FIRST_PARTY_COOKIES_ONLY_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_boolean (value, midori_settings_get_first_party_cookies_only (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_MAXIMUM_COOKIE_AGE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_maximum_cookie_age (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_MAXIMUM_HISTORY_AGE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		g_value_set_int (value, midori_settings_get_maximum_history_age (self));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 2991 "midori-settings.c"
		default:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 2997 "midori-settings.c"
	}
}


static void _vala_midori_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MidoriSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_SETTINGS, MidoriSettings);
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
	switch (property_id) {
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_ENABLE_JAVASCRIPT_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_enable_javascript (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_DEFAULT_CHARSET_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_default_charset (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_ZOOM_TEXT_AND_IMAGES_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_zoom_text_and_images (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_REMEMBER_LAST_WINDOW_SIZE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_remember_last_window_size (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_WINDOW_WIDTH_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_last_window_width (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_WINDOW_HEIGHT_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_last_window_height (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_PANEL_POSITION_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_last_panel_position (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_PANEL_PAGE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_last_panel_page (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_WEB_SEARCH_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_last_web_search (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SEARCH_WIDTH_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_search_width (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_INSPECTOR_ATTACHED_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_last_inspector_attached (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LAST_WINDOW_STATE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_last_window_state (self, g_value_get_enum (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_INACTIVITY_RESET_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_inactivity_reset (self, g_value_get_uint (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_THEME_NAME_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_theme_name (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_BLOCK_URIS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_block_uris (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_CUSTOM_TITLE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_custom_title (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_LOCATION_ENTRY_SEARCH_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_location_entry_search (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_CLEAR_PRIVATE_DATA_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_clear_private_data (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_CLEAR_DATA_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_clear_data (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_COMPACT_SIDEPANEL_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_compact_sidepanel (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_OPEN_PANELS_IN_WINDOWS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_open_panels_in_windows (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_RIGHT_ALIGN_SIDEPANEL_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_right_align_sidepanel (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_MENUBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_show_menubar (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_NAVIGATIONBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_show_navigationbar (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_BOOKMARKBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_show_bookmarkbar (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_PANEL_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_show_panel (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_STATUSBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_show_statusbar (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_SHOW_CRASH_DIALOG_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_show_crash_dialog (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_TOOLBAR_ITEMS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_toolbar_items (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_FIND_WHILE_TYPING_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_find_while_typing (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_ZOOM_LEVEL_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_zoom_level (self, g_value_get_double (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_OPEN_POPUPS_IN_TABS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_open_popups_in_tabs (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_KINETIC_SCROLLING_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_kinetic_scrolling (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_MIDDLE_CLICK_OPENS_SELECTION_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_middle_click_opens_selection (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_FLASH_WINDOW_ON_NEW_BG_TABS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_flash_window_on_new_bg_tabs (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_CLOSE_BUTTONS_ON_TABS_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_close_buttons_on_tabs (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_OPEN_TABS_IN_THE_BACKGROUND_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_open_tabs_in_the_background (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_OPEN_TABS_NEXT_TO_CURRENT_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_open_tabs_next_to_current (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_ALWAYS_SHOW_TABBAR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_always_show_tabbar (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_HOMEPAGE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_homepage (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_TABHOME_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_tabhome (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_DOWNLOAD_FOLDER_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_download_folder (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_TEXT_EDITOR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_text_editor (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_NEWS_AGGREGATOR_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_news_aggregator (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_HTTP_PROXY_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_http_proxy (self, g_value_get_string (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_HTTP_PROXY_PORT_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_http_proxy_port (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_MAXIMUM_CACHE_SIZE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_maximum_cache_size (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_STRIP_REFERER_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_strip_referer (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_FIRST_PARTY_COOKIES_ONLY_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_first_party_cookies_only (self, g_value_get_boolean (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_MAXIMUM_COOKIE_AGE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_maximum_cookie_age (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		case MIDORI_SETTINGS_MAXIMUM_HISTORY_AGE_PROPERTY:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		midori_settings_set_maximum_history_age (self, g_value_get_int (value));
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 3313 "midori-settings.c"
		default:
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/usr/src/ports/midori/midori-0.5.11-2.x86_64/src/midori-0.5.11/midori/midori-settings.vala"
		break;
#line 3319 "midori-settings.c"
	}
}



