; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test vector intrinsics added with z16.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z16 | FileCheck %s

declare <4 x float> @llvm.s390.vclfnhs(<8 x i16>, i32)
declare <4 x float> @llvm.s390.vclfnls(<8 x i16>, i32)
declare <8 x i16> @llvm.s390.vcrnfs(<4 x float>, <4 x float>, i32)
declare <8 x i16> @llvm.s390.vcfn(<8 x i16>, i32)
declare <8 x i16> @llvm.s390.vcnf(<8 x i16>, i32)

; VCLFNH.
define <4 x float> @test_vclfnhs(<8 x i16> %a) {
; CHECK-LABEL: test_vclfnhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vclfnh %v24, %v24, 2, 0
; CHECK-NEXT:    br %r14
  %res = call <4 x float> @llvm.s390.vclfnhs(<8 x i16> %a, i32 0)
  ret <4 x float> %res
}

; VCLFNL.
define <4 x float> @test_vclfnls(<8 x i16> %a) {
; CHECK-LABEL: test_vclfnls:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vclfnl %v24, %v24, 2, 0
; CHECK-NEXT:    br %r14
  %res = call <4 x float> @llvm.s390.vclfnls(<8 x i16> %a, i32 0)
  ret <4 x float> %res
}

; VCRNF.
define <8 x i16> @test_vcrnfs(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: test_vcrnfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcrnf %v24, %v24, %v26, 0, 2
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vcrnfs(<4 x float> %a, <4 x float> %b, i32 0)
  ret <8 x i16> %res
}

; VCFN.
define <8 x i16> @test_vcfn(<8 x i16> %a) {
; CHECK-LABEL: test_vcfn:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcfn %v24, %v24, 1, 0
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vcfn(<8 x i16> %a, i32 0)
  ret <8 x i16> %res
}

; VCNF.
define <8 x i16> @test_vcnf(<8 x i16> %a) {
; CHECK-LABEL: test_vcnf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcnf %v24, %v24, 0, 1
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vcnf(<8 x i16> %a, i32 0)
  ret <8 x i16> %res
}
