; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefixes=X64

; Test for https://github.com/llvm/llvm-project/issues/123239

define i1 @test_ult_trunc_add(i64 %x) {
; X64-LABEL: test_ult_trunc_add:
; X64:       # %bb.0:
; X64-NEXT:    shrq $48, %rdi
; X64-NEXT:    addl $14, %edi
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    cmpl $3, %eax
; X64-NEXT:    setb %al
; X64-NEXT:    retq
  %add = add i64 %x, 3940649673949184
  %shr = lshr i64 %add, 48
  %conv = trunc i64 %shr to i32
  %res = icmp ult i32 %conv, 3
  ret i1 %res
}

define i1 @test_ult_add(i64 %x) {
; X64-LABEL: test_ult_add:
; X64:       # %bb.0:
; X64-NEXT:    shrq $48, %rdi
; X64-NEXT:    addl $14, %edi
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    cmpl $3, %eax
; X64-NEXT:    setb %al
; X64-NEXT:    retq
  %add = add i64 3940649673949184, %x
  %cmp = icmp ult i64 %add, 844424930131968
  ret i1 %cmp
}

define i1 @test_ugt_trunc_add(i64 %x) {
; X64-LABEL: test_ugt_trunc_add:
; X64:       # %bb.0:
; X64-NEXT:    shrq $48, %rdi
; X64-NEXT:    addl $14, %edi
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    cmpl $4, %eax
; X64-NEXT:    setae %al
; X64-NEXT:    retq
  %add = add i64 %x, 3940649673949184
  %shr = lshr i64 %add, 48
  %conv = trunc i64 %shr to i32
  %res = icmp ugt i32 %conv, 3
  ret i1 %res
}

define i1 @test_ugt_add(i64 %x) {
; X64-LABEL: test_ugt_add:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $3940649673949184, %rax # imm = 0xE000000000000
; X64-NEXT:    addq %rdi, %rax
; X64-NEXT:    movabsq $844424930131968, %rcx # imm = 0x3000000000000
; X64-NEXT:    cmpq %rcx, %rax
; X64-NEXT:    seta %al
; X64-NEXT:    retq
  %add = add i64 3940649673949184, %x
  %cmp = icmp ugt i64 %add, 844424930131968
  ret i1 %cmp
}

define i1 @test_eq_trunc_add(i64 %x) {
; X64-LABEL: test_eq_trunc_add:
; X64:       # %bb.0:
; X64-NEXT:    shrq $48, %rdi
; X64-NEXT:    cmpl $65525, %edi # imm = 0xFFF5
; X64-NEXT:    sete %al
; X64-NEXT:    retq
  %add = add i64 %x, 3940649673949184
  %shr = lshr i64 %add, 48
  %conv = trunc i64 %shr to i32
  %res = icmp eq i32 %conv, 3
  ret i1 %res
}

define i1 @test_eq_add(i64 %x) {
; X64-LABEL: test_eq_add:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $-3096224743817216, %rax # imm = 0xFFF5000000000000
; X64-NEXT:    cmpq %rax, %rdi
; X64-NEXT:    sete %al
; X64-NEXT:    retq
  %add = add i64 3940649673949184, %x
  %cmp = icmp eq i64 %add, 844424930131968
  ret i1 %cmp
}

define i1 @test_ne_trunc_add(i64 %x) {
; X64-LABEL: test_ne_trunc_add:
; X64:       # %bb.0:
; X64-NEXT:    shrq $48, %rdi
; X64-NEXT:    cmpl $65525, %edi # imm = 0xFFF5
; X64-NEXT:    setne %al
; X64-NEXT:    retq
  %add = add i64 %x, 3940649673949184
  %shr = lshr i64 %add, 48
  %conv = trunc i64 %shr to i32
  %res = icmp ne i32 %conv, 3
  ret i1 %res
}

define i1 @test_ne_add(i64 %x) {
; X64-LABEL: test_ne_add:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $-3096224743817216, %rax # imm = 0xFFF5000000000000
; X64-NEXT:    cmpq %rax, %rdi
; X64-NEXT:    setne %al
; X64-NEXT:    retq
  %add = add i64 3940649673949184, %x
  %cmp = icmp ne i64 %add, 844424930131968
  ret i1 %cmp
}

define i32 @test_trunc_add(i64 %x) {
; X64-LABEL: test_trunc_add:
; X64:       # %bb.0:
; X64-NEXT:    shrq $48, %rdi
; X64-NEXT:    addl $14, %edi
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    retq
  %add = add i64 %x, 3940649673949184
  %shr = lshr i64 %add, 48
  %conv = trunc i64 %shr to i32
  ret i32 %conv
}

define i32 @test_trunc_sub(i64 %x) {
; X64-LABEL: test_trunc_sub:
; X64:       # %bb.0:
; X64-NEXT:    shrq $49, %rdi
; X64-NEXT:    leal 32762(%rdi), %eax
; X64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; X64-NEXT:    retq
  %sub = sub i64 %x, 3377699720527872
  %shr = lshr i64 %sub, 49
  %conv = trunc i64 %shr to i32
  ret i32 %conv
}

define i32 @test_trunc_and_1(i64 %x) {
; X64-LABEL: test_trunc_and_1:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $50, %rax
; X64-NEXT:    andl $3, %eax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
  %and = and i64 %x, 3940649673949184
  %shr = lshr i64 %and, 50
  %conv = trunc i64 %shr to i32
  ret i32 %conv
}

define i32 @test_trunc_or_1(i64 %x) {
; X64-LABEL: test_trunc_or_1:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $50, %rax
; X64-NEXT:    orl $3, %eax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
  %or = or i64 %x, 3940649673949184
  %shr = lshr i64 %or, 50
  %conv = trunc i64 %shr to i32
  ret i32 %conv
}

define i32 @test_trunc_xor_1(i64 %x) {
; X64-LABEL: test_trunc_xor_1:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $50, %rax
; X64-NEXT:    xorl $3, %eax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
  %xor = xor i64 %x, 3940649673949184
  %shr = lshr i64 %xor, 50
  %conv = trunc i64 %shr to i32
  ret i32 %conv
}

define i32 @test_trunc_and_2(i64 %x) {
; X64-LABEL: test_trunc_and_2:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $45, %rax
; X64-NEXT:    andl $111, %eax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
  %and = and i64 %x, 3940649673949183
  %shr = lshr i64 %and, 45
  %conv = trunc i64 %shr to i32
  ret i32 %conv
}

define i32 @test_trunc_or_2(i64 %x) {
; X64-LABEL: test_trunc_or_2:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $45, %rax
; X64-NEXT:    orl $111, %eax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
  %or = or i64 %x, 3940649673949183
  %shr = lshr i64 %or, 45
  %conv = trunc i64 %shr to i32
  ret i32 %conv
}

define i32 @test_trunc_xor_2(i64 %x) {
; X64-LABEL: test_trunc_xor_2:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $45, %rax
; X64-NEXT:    xorl $111, %eax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
  %xor = xor i64 %x, 3940649673949183
  %shr = lshr i64 %xor, 45
  %conv = trunc i64 %shr to i32
  ret i32 %conv
}

; Make sure we don't crash on this test case.

define i32 @pr128158(i64 %x) {
; X64-LABEL: pr128158:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movabsq $-4294967296, %rax # imm = 0xFFFFFFFF00000000
; X64-NEXT:    addq %rdi, %rax
; X64-NEXT:    shrq $32, %rax
; X64-NEXT:    .p2align 4
; X64-NEXT:  .LBB16_1: # %for.body
; X64-NEXT:    # =>This Inner Loop Header: Depth=1
; X64-NEXT:    cmpl $9, %eax
; X64-NEXT:    jb .LBB16_1
; X64-NEXT:  # %bb.2: # %exit
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
entry:
  br label %for.body

for.body:
  %add = add i64 %x, -4294967296
  %cmp = icmp ult i64 %add, 38654705664
  br i1 %cmp, label %for.body, label %exit

exit:
  ret i32 0
}

define i64 @pr128309(i64 %x) {
; X64-LABEL: pr128309:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $18114, %eax # imm = 0x46C2
; X64-NEXT:    addl $6, %eax
; X64-NEXT:    andl %edi, %eax
; X64-NEXT:    retq
entry:
  %shl = shl i64 %x, 48
  %and = and i64 %shl, 5098637728136822784
  %add = add i64 %and, 1688849860263936
  %lshr = lshr i64 %add, 48
  %res = and i64 %lshr, %x
  ret i64 %res
}
