; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+amx-int8 -mattr=+avx512f | FileCheck %s --check-prefix=AVX512
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+amx-int8 -mattr=+avx2 | FileCheck %s --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+amx-int8 | FileCheck %s --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+amx-int8 -mattr=+avx512f -O0 | FileCheck %s --check-prefix=AVX512-O0
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+amx-int8 -mattr=+avx2 -O0 | FileCheck %s --check-prefix=AVX2-O0
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+amx-int8 -O0 | FileCheck %s --check-prefix=SSE2-O0

define void @foo(ptr %buf) nounwind {
; AVX512-LABEL: foo:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmovups %zmm0, -{{[0-9]+}}(%rsp)
; AVX512-NEXT:    movb $1, -{{[0-9]+}}(%rsp)
; AVX512-NEXT:    movb $8, -{{[0-9]+}}(%rsp)
; AVX512-NEXT:    movw $32, -{{[0-9]+}}(%rsp)
; AVX512-NEXT:    ldtilecfg -{{[0-9]+}}(%rsp)
; AVX512-NEXT:    movw $32, %ax
; AVX512-NEXT:    movw $8, %cx
; AVX512-NEXT:    tilezero %tmm0
; AVX512-NEXT:    movl $1024, %edx # imm = 0x400
; AVX512-NEXT:    tilestored %tmm0, (%rdi,%rdx)
; AVX512-NEXT:    tilerelease
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX2-LABEL: foo:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovups %ymm0, -{{[0-9]+}}(%rsp)
; AVX2-NEXT:    vmovups %ymm0, -{{[0-9]+}}(%rsp)
; AVX2-NEXT:    movb $1, -{{[0-9]+}}(%rsp)
; AVX2-NEXT:    movb $8, -{{[0-9]+}}(%rsp)
; AVX2-NEXT:    movw $32, -{{[0-9]+}}(%rsp)
; AVX2-NEXT:    ldtilecfg -{{[0-9]+}}(%rsp)
; AVX2-NEXT:    movw $32, %ax
; AVX2-NEXT:    movw $8, %cx
; AVX2-NEXT:    tilezero %tmm0
; AVX2-NEXT:    movl $1024, %edx # imm = 0x400
; AVX2-NEXT:    tilestored %tmm0, (%rdi,%rdx)
; AVX2-NEXT:    tilerelease
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; SSE2-LABEL: foo:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    movups %xmm0, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movups %xmm0, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movups %xmm0, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movups %xmm0, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movb $1, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movb $8, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movw $32, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    ldtilecfg -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    movw $32, %ax
; SSE2-NEXT:    movw $8, %cx
; SSE2-NEXT:    tilezero %tmm0
; SSE2-NEXT:    movl $1024, %edx # imm = 0x400
; SSE2-NEXT:    tilestored %tmm0, (%rdi,%rdx)
; SSE2-NEXT:    tilerelease
; SSE2-NEXT:    retq
;
; AVX512-O0-LABEL: foo:
; AVX512-O0:       # %bb.0: # %entry
; AVX512-O0-NEXT:    pushq %rbp
; AVX512-O0-NEXT:    movq %rsp, %rbp
; AVX512-O0-NEXT:    andq $-1024, %rsp # imm = 0xFC00
; AVX512-O0-NEXT:    subq $3072, %rsp # imm = 0xC00
; AVX512-O0-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX512-O0-NEXT:    vmovups %zmm0, {{[0-9]+}}(%rsp)
; AVX512-O0-NEXT:    movb $1, {{[0-9]+}}(%rsp)
; AVX512-O0-NEXT:    movw $32, %cx
; AVX512-O0-NEXT:    movw $8, %ax
; AVX512-O0-NEXT:    # implicit-def: $al
; AVX512-O0-NEXT:    movb %al, {{[0-9]+}}(%rsp)
; AVX512-O0-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; AVX512-O0-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; AVX512-O0-NEXT:    tilezero %tmm0
; AVX512-O0-NEXT:    movl $64, %esi
; AVX512-O0-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; AVX512-O0-NEXT:    movw $32, %cx
; AVX512-O0-NEXT:    movw $8, %ax
; AVX512-O0-NEXT:    tilestored %tmm0, (%rdx,%rsi)
; AVX512-O0-NEXT:    movl $64, %esi
; AVX512-O0-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; AVX512-O0-NEXT:    movw $32, %cx
; AVX512-O0-NEXT:    movw $8, %ax
; AVX512-O0-NEXT:    # implicit-def: $al
; AVX512-O0-NEXT:    movb %al, {{[0-9]+}}(%rsp)
; AVX512-O0-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; AVX512-O0-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; AVX512-O0-NEXT:    tileloadd (%rdx,%rsi), %tmm0
; AVX512-O0-NEXT:    movl $1024, %edx # imm = 0x400
; AVX512-O0-NEXT:    movw $32, %cx
; AVX512-O0-NEXT:    movw $8, %ax
; AVX512-O0-NEXT:    tilestored %tmm0, (%rdi,%rdx)
; AVX512-O0-NEXT:    movq %rbp, %rsp
; AVX512-O0-NEXT:    popq %rbp
; AVX512-O0-NEXT:    tilerelease
; AVX512-O0-NEXT:    vzeroupper
; AVX512-O0-NEXT:    retq
;
; AVX2-O0-LABEL: foo:
; AVX2-O0:       # %bb.0: # %entry
; AVX2-O0-NEXT:    pushq %rbp
; AVX2-O0-NEXT:    movq %rsp, %rbp
; AVX2-O0-NEXT:    andq $-1024, %rsp # imm = 0xFC00
; AVX2-O0-NEXT:    subq $3072, %rsp # imm = 0xC00
; AVX2-O0-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; AVX2-O0-NEXT:    vmovups %ymm0, {{[0-9]+}}(%rsp)
; AVX2-O0-NEXT:    vmovups %ymm0, {{[0-9]+}}(%rsp)
; AVX2-O0-NEXT:    movb $1, {{[0-9]+}}(%rsp)
; AVX2-O0-NEXT:    movw $32, %cx
; AVX2-O0-NEXT:    movw $8, %ax
; AVX2-O0-NEXT:    # implicit-def: $al
; AVX2-O0-NEXT:    movb %al, {{[0-9]+}}(%rsp)
; AVX2-O0-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; AVX2-O0-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; AVX2-O0-NEXT:    tilezero %tmm0
; AVX2-O0-NEXT:    movl $64, %esi
; AVX2-O0-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; AVX2-O0-NEXT:    movw $32, %cx
; AVX2-O0-NEXT:    movw $8, %ax
; AVX2-O0-NEXT:    tilestored %tmm0, (%rdx,%rsi)
; AVX2-O0-NEXT:    movl $64, %esi
; AVX2-O0-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; AVX2-O0-NEXT:    movw $32, %cx
; AVX2-O0-NEXT:    movw $8, %ax
; AVX2-O0-NEXT:    # implicit-def: $al
; AVX2-O0-NEXT:    movb %al, {{[0-9]+}}(%rsp)
; AVX2-O0-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; AVX2-O0-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; AVX2-O0-NEXT:    tileloadd (%rdx,%rsi), %tmm0
; AVX2-O0-NEXT:    movl $1024, %edx # imm = 0x400
; AVX2-O0-NEXT:    movw $32, %cx
; AVX2-O0-NEXT:    movw $8, %ax
; AVX2-O0-NEXT:    tilestored %tmm0, (%rdi,%rdx)
; AVX2-O0-NEXT:    movq %rbp, %rsp
; AVX2-O0-NEXT:    popq %rbp
; AVX2-O0-NEXT:    tilerelease
; AVX2-O0-NEXT:    vzeroupper
; AVX2-O0-NEXT:    retq
;
; SSE2-O0-LABEL: foo:
; SSE2-O0:       # %bb.0: # %entry
; SSE2-O0-NEXT:    pushq %rbp
; SSE2-O0-NEXT:    movq %rsp, %rbp
; SSE2-O0-NEXT:    andq $-1024, %rsp # imm = 0xFC00
; SSE2-O0-NEXT:    subq $3072, %rsp # imm = 0xC00
; SSE2-O0-NEXT:    xorps %xmm0, %xmm0
; SSE2-O0-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    movups %xmm0, {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    movb $1, {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    movw $32, %cx
; SSE2-O0-NEXT:    movw $8, %ax
; SSE2-O0-NEXT:    # implicit-def: $al
; SSE2-O0-NEXT:    movb %al, {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    tilezero %tmm0
; SSE2-O0-NEXT:    movl $64, %esi
; SSE2-O0-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; SSE2-O0-NEXT:    movw $32, %cx
; SSE2-O0-NEXT:    movw $8, %ax
; SSE2-O0-NEXT:    tilestored %tmm0, (%rdx,%rsi)
; SSE2-O0-NEXT:    movl $64, %esi
; SSE2-O0-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; SSE2-O0-NEXT:    movw $32, %cx
; SSE2-O0-NEXT:    movw $8, %ax
; SSE2-O0-NEXT:    # implicit-def: $al
; SSE2-O0-NEXT:    movb %al, {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    movw %cx, {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; SSE2-O0-NEXT:    tileloadd (%rdx,%rsi), %tmm0
; SSE2-O0-NEXT:    movl $1024, %edx # imm = 0x400
; SSE2-O0-NEXT:    movw $32, %cx
; SSE2-O0-NEXT:    movw $8, %ax
; SSE2-O0-NEXT:    tilestored %tmm0, (%rdi,%rdx)
; SSE2-O0-NEXT:    movq %rbp, %rsp
; SSE2-O0-NEXT:    popq %rbp
; SSE2-O0-NEXT:    tilerelease
; SSE2-O0-NEXT:    retq
entry:
  %t = call x86_amx @llvm.x86.tilezero.internal(i16 8, i16 32)
  call void @llvm.x86.tilestored64.internal(i16 8, i16 32, ptr %buf, i64 1024, x86_amx %t)
  ret void
}

declare x86_amx @llvm.x86.tilezero.internal(i16, i16)
declare void @llvm.x86.tilestored64.internal(i16, i16, ptr, i64, x86_amx)
