/*
 * This file is part of QZeitgeist.
 *
 * Copyright (C) 2011 Trever Fischer <tdfischer@fedoraproject.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef QZEITGEIST_VERSION_H
#define QZEITGEIST_VERSION_H

#define QZEITGEIST_VERSION_MAJOR 0
#define QZEITGEIST_VERSION_MINOR 8
#define QZEITGEIST_VERSION_PATCH 0

#define QZEITGEIST_VERSION \
    ((QZEITGEIST_VERSION_MAJOR << 8) | \
     (QZEITGEIST_VERSION_MINOR << 4) | \
     (QZEITGEIST_VERSION_PATCH))

#define STRINGIZE2(s) #s
#define STRINGIZE(s) STRINGIZE2(s)

#define QZEITGEIST_VERSION_STRING \
    STRINGIZE(QZEITGEIST_VERSION_MAJOR) "." \
    STRINGIZE(QZEITGEIST_VERSION_MINOR) "." \
    STRINGIZE(QZEITGEIST_VERSION_PATCH)

#endif // QZEITGEIST_VERSION_H
