; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt < %s -passes=asan -S | FileCheck %s
; RUN: opt < %s -passes=asan -asan-recover -S | FileCheck %s --check-prefix=RECOV
target datalayout = "e-p:64:64-p1:64:64-p2:32:32-p3:32:32-p4:64:64-p5:32:32-p6:32:32-p7:160:256:256:32-p8:128:128-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64-S32-A5-G1-ni:7:8:9"
target triple = "amdgcn-amd-amdhsa"

define protected amdgpu_kernel void @global_store(ptr addrspace(1) %p, i32 %i) sanitize_address {
; CHECK-LABEL: define protected amdgpu_kernel void @global_store(
; CHECK-SAME: ptr addrspace(1) [[P:%.*]], i32 [[I:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr addrspace(1) [[P]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 3
; CHECK-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 2147450880
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = and i64 [[TMP0]], 7
; CHECK-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 3
; CHECK-NEXT:    [[TMP8:%.*]] = trunc i64 [[TMP7]] to i8
; CHECK-NEXT:    [[TMP9:%.*]] = icmp sge i8 [[TMP8]], [[TMP4]]
; CHECK-NEXT:    [[TMP10:%.*]] = and i1 [[TMP5]], [[TMP9]]
; CHECK-NEXT:    [[TMP11:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP10]])
; CHECK-NEXT:    [[TMP12:%.*]] = icmp ne i64 [[TMP11]], 0
; CHECK-NEXT:    br i1 [[TMP12]], label [[ASAN_REPORT:%.*]], label [[TMP15:%.*]], !prof [[PROF0:![0-9]+]]
; CHECK:       asan.report:
; CHECK-NEXT:    br i1 [[TMP10]], label [[TMP13:%.*]], label [[TMP14:%.*]]
; CHECK:       13:
; CHECK-NEXT:    call void @__asan_report_store4(i64 [[TMP0]]) #[[ATTR5:[0-9]+]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP14]]
; CHECK:       14:
; CHECK-NEXT:    br label [[TMP15]]
; CHECK:       15:
; CHECK-NEXT:    store i32 0, ptr addrspace(1) [[P]], align 4
; CHECK-NEXT:    ret void
;
; RECOV-LABEL: define protected amdgpu_kernel void @global_store(
; RECOV-SAME: ptr addrspace(1) [[P:%.*]], i32 [[I:%.*]]) #[[ATTR0:[0-9]+]] {
; RECOV-NEXT:  entry:
; RECOV-NEXT:    [[TMP0:%.*]] = ptrtoint ptr addrspace(1) [[P]] to i64
; RECOV-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 3
; RECOV-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 2147450880
; RECOV-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; RECOV-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; RECOV-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; RECOV-NEXT:    [[TMP6:%.*]] = and i64 [[TMP0]], 7
; RECOV-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 3
; RECOV-NEXT:    [[TMP8:%.*]] = trunc i64 [[TMP7]] to i8
; RECOV-NEXT:    [[TMP9:%.*]] = icmp sge i8 [[TMP8]], [[TMP4]]
; RECOV-NEXT:    [[TMP10:%.*]] = and i1 [[TMP5]], [[TMP9]]
; RECOV-NEXT:    br i1 [[TMP10]], label [[ASAN_REPORT:%.*]], label [[TMP11:%.*]], !prof [[PROF0:![0-9]+]]
; RECOV:       asan.report:
; RECOV-NEXT:    call void @__asan_report_store4_noabort(i64 [[TMP0]]) #[[ATTR3:[0-9]+]]
; RECOV-NEXT:    br label [[TMP11]]
; RECOV:       11:
; RECOV-NEXT:    store i32 0, ptr addrspace(1) [[P]], align 4
; RECOV-NEXT:    ret void
;
entry:

  store i32 0, ptr addrspace(1) %p, align 4
  ret void
}

define protected amdgpu_kernel void @global_load(ptr addrspace(1) %p, i32 %i) sanitize_address {
; CHECK-LABEL: define protected amdgpu_kernel void @global_load(
; CHECK-SAME: ptr addrspace(1) [[P:%.*]], i32 [[I:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr addrspace(1) [[P]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 3
; CHECK-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 2147450880
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = and i64 [[TMP0]], 7
; CHECK-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 3
; CHECK-NEXT:    [[TMP8:%.*]] = trunc i64 [[TMP7]] to i8
; CHECK-NEXT:    [[TMP9:%.*]] = icmp sge i8 [[TMP8]], [[TMP4]]
; CHECK-NEXT:    [[TMP10:%.*]] = and i1 [[TMP5]], [[TMP9]]
; CHECK-NEXT:    [[TMP11:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP10]])
; CHECK-NEXT:    [[TMP12:%.*]] = icmp ne i64 [[TMP11]], 0
; CHECK-NEXT:    br i1 [[TMP12]], label [[ASAN_REPORT:%.*]], label [[TMP15:%.*]], !prof [[PROF0]]
; CHECK:       asan.report:
; CHECK-NEXT:    br i1 [[TMP10]], label [[TMP13:%.*]], label [[TMP14:%.*]]
; CHECK:       13:
; CHECK-NEXT:    call void @__asan_report_load4(i64 [[TMP0]]) #[[ATTR5]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP14]]
; CHECK:       14:
; CHECK-NEXT:    br label [[TMP15]]
; CHECK:       15:
; CHECK-NEXT:    [[Q:%.*]] = load i32, ptr addrspace(1) [[P]], align 4
; CHECK-NEXT:    ret void
;
; RECOV-LABEL: define protected amdgpu_kernel void @global_load(
; RECOV-SAME: ptr addrspace(1) [[P:%.*]], i32 [[I:%.*]]) #[[ATTR0]] {
; RECOV-NEXT:  entry:
; RECOV-NEXT:    [[TMP0:%.*]] = ptrtoint ptr addrspace(1) [[P]] to i64
; RECOV-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 3
; RECOV-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 2147450880
; RECOV-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; RECOV-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; RECOV-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; RECOV-NEXT:    [[TMP6:%.*]] = and i64 [[TMP0]], 7
; RECOV-NEXT:    [[TMP7:%.*]] = add i64 [[TMP6]], 3
; RECOV-NEXT:    [[TMP8:%.*]] = trunc i64 [[TMP7]] to i8
; RECOV-NEXT:    [[TMP9:%.*]] = icmp sge i8 [[TMP8]], [[TMP4]]
; RECOV-NEXT:    [[TMP10:%.*]] = and i1 [[TMP5]], [[TMP9]]
; RECOV-NEXT:    br i1 [[TMP10]], label [[ASAN_REPORT:%.*]], label [[TMP11:%.*]], !prof [[PROF0]]
; RECOV:       asan.report:
; RECOV-NEXT:    call void @__asan_report_load4_noabort(i64 [[TMP0]]) #[[ATTR3]]
; RECOV-NEXT:    br label [[TMP11]]
; RECOV:       11:
; RECOV-NEXT:    [[Q:%.*]] = load i32, ptr addrspace(1) [[P]], align 4
; RECOV-NEXT:    ret void
;
entry:

  %q = load i32, ptr addrspace(1) %p, align 4
  ret void
}

define protected amdgpu_kernel void @global_store_8(ptr addrspace(1) %p) sanitize_address {
; CHECK-LABEL: define protected amdgpu_kernel void @global_store_8(
; CHECK-SAME: ptr addrspace(1) [[P:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr addrspace(1) [[P]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 3
; CHECK-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 2147450880
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP5]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp ne i64 [[TMP6]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[ASAN_REPORT:%.*]], label [[TMP10:%.*]], !prof [[PROF0]]
; CHECK:       asan.report:
; CHECK-NEXT:    br i1 [[TMP5]], label [[TMP8:%.*]], label [[TMP9:%.*]]
; CHECK:       8:
; CHECK-NEXT:    call void @__asan_report_store8(i64 [[TMP0]]) #[[ATTR5]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP9]]
; CHECK:       9:
; CHECK-NEXT:    br label [[TMP10]]
; CHECK:       10:
; CHECK-NEXT:    store i64 0, ptr addrspace(1) [[P]], align 8
; CHECK-NEXT:    ret void
;
; RECOV-LABEL: define protected amdgpu_kernel void @global_store_8(
; RECOV-SAME: ptr addrspace(1) [[P:%.*]]) #[[ATTR0]] {
; RECOV-NEXT:  entry:
; RECOV-NEXT:    [[TMP0:%.*]] = ptrtoint ptr addrspace(1) [[P]] to i64
; RECOV-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 3
; RECOV-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 2147450880
; RECOV-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; RECOV-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; RECOV-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; RECOV-NEXT:    br i1 [[TMP5]], label [[ASAN_REPORT:%.*]], label [[TMP6:%.*]], !prof [[PROF0]]
; RECOV:       asan.report:
; RECOV-NEXT:    call void @__asan_report_store8_noabort(i64 [[TMP0]]) #[[ATTR3]]
; RECOV-NEXT:    br label [[TMP6]]
; RECOV:       6:
; RECOV-NEXT:    store i64 0, ptr addrspace(1) [[P]], align 8
; RECOV-NEXT:    ret void
;
entry:
  store i64 0, ptr addrspace(1) %p, align 8
  ret void
}

define protected amdgpu_kernel void @global_load_8(ptr addrspace(1) %p) sanitize_address {
; CHECK-LABEL: define protected amdgpu_kernel void @global_load_8(
; CHECK-SAME: ptr addrspace(1) [[P:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr addrspace(1) [[P]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 3
; CHECK-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 2147450880
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = call i64 @llvm.amdgcn.ballot.i64(i1 [[TMP5]])
; CHECK-NEXT:    [[TMP7:%.*]] = icmp ne i64 [[TMP6]], 0
; CHECK-NEXT:    br i1 [[TMP7]], label [[ASAN_REPORT:%.*]], label [[TMP10:%.*]], !prof [[PROF0]]
; CHECK:       asan.report:
; CHECK-NEXT:    br i1 [[TMP5]], label [[TMP8:%.*]], label [[TMP9:%.*]]
; CHECK:       8:
; CHECK-NEXT:    call void @__asan_report_load8(i64 [[TMP0]]) #[[ATTR5]]
; CHECK-NEXT:    call void @llvm.amdgcn.unreachable()
; CHECK-NEXT:    br label [[TMP9]]
; CHECK:       9:
; CHECK-NEXT:    br label [[TMP10]]
; CHECK:       10:
; CHECK-NEXT:    [[Q:%.*]] = load i64, ptr addrspace(1) [[P]], align 8
; CHECK-NEXT:    ret void
;
; RECOV-LABEL: define protected amdgpu_kernel void @global_load_8(
; RECOV-SAME: ptr addrspace(1) [[P:%.*]]) #[[ATTR0]] {
; RECOV-NEXT:  entry:
; RECOV-NEXT:    [[TMP0:%.*]] = ptrtoint ptr addrspace(1) [[P]] to i64
; RECOV-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 3
; RECOV-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], 2147450880
; RECOV-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; RECOV-NEXT:    [[TMP4:%.*]] = load i8, ptr [[TMP3]], align 1
; RECOV-NEXT:    [[TMP5:%.*]] = icmp ne i8 [[TMP4]], 0
; RECOV-NEXT:    br i1 [[TMP5]], label [[ASAN_REPORT:%.*]], label [[TMP6:%.*]], !prof [[PROF0]]
; RECOV:       asan.report:
; RECOV-NEXT:    call void @__asan_report_load8_noabort(i64 [[TMP0]]) #[[ATTR3]]
; RECOV-NEXT:    br label [[TMP6]]
; RECOV:       6:
; RECOV-NEXT:    [[Q:%.*]] = load i64, ptr addrspace(1) [[P]], align 8
; RECOV-NEXT:    ret void
;
entry:
  %q = load i64, ptr addrspace(1) %p, align 8
  ret void
}
