/****************************************************************************
** Shared Class code from reading file 'KDbConnectionData.shared.h'
**
** Created
**      by: The Shared Data Compiler version 0.3
**
** WARNING! All changes made in this file will be lost!
*****************************************************************************/

/* This file is part of the KDE project
   Copyright (C) 2003-2015 Jarosław Staniek <staniek@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KDB_CONNECTION_DATA_H
#define KDB_CONNECTION_DATA_H

#include "kdb_export.h"

#include <QCoreApplication>
#include <QDebug>
#include <QMap>
#include <QSharedData>
#include <QString>

/*! @brief Database specific connection data, e.g. host, port.

 KDbConnection data, once configured, can be later stored for reuse.
*/
/*! @note objects of this class are implicitly shared, what means they have value semantics
          by offering copy-on-write behaviour to maximize resource usage and minimize copying.
          Only a pointer to the data is passed around. See <a href="http://doc.qt.io/qt-5/qshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: operator==, with_from_to_map, implicit
class KDB_EXPORT KDbConnectionData
{
    Q_DECLARE_TR_FUNCTIONS(KDbConnectionData)
public:











    //! @internal data class used to implement implicitly shared class KDbConnectionData.
    //! Provides thread-safe reference counting.
    class KDB_EXPORT Data : public QSharedData
    {
    public:
        Data()
        : port(0)
        , useLocalSocketFile(true)
        , savePassword(false)
        {
        }

        Data(const Data &other)
         : QSharedData(other)
         , databaseName(other.databaseName)
         , caption(other.caption)
         , description(other.description)
         , driverId(other.driverId)
         , userName(other.userName)
         , hostName(other.hostName)
         , port(other.port)
         , useLocalSocketFile(other.useLocalSocketFile)
         , localSocketFileName(other.localSocketFileName)
         , password(other.password)
         , savePassword(other.savePassword)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual Data* clone() const { return new Data(*this); }

        /*! Constructor for Data object, takes attributes saved to map @a map.
        If @a ok is not 0, *ok is set to true on success and to false on failure. @see toMap(). */
        Data(const QMap<QString, QString> &map, bool *ok);

        QMap<QString, QString> toMap() const;

        bool operator==(const Data &other) const {
            return databaseName == other.databaseName
                   && caption == other.caption
                   && description == other.description
                   && driverId == other.driverId
                   && userName == other.userName
                   && hostName == other.hostName
                   && port == other.port
                   && useLocalSocketFile == other.useLocalSocketFile
                   && localSocketFileName == other.localSocketFileName
                   && password == other.password
                   && savePassword == other.savePassword;
        }

        QString databaseName; //!< @see KDbConnectionData::databaseName(), KDbConnectionData::setDatabaseName()
        QString caption; //!< @see KDbConnectionData::caption(), KDbConnectionData::setCaption()
        QString description; //!< @see KDbConnectionData::description(), KDbConnectionData::setDescription()
        QString driverId; //!< @see KDbConnectionData::driverId(), KDbConnectionData::setDriverId()
        QString userName; //!< @see KDbConnectionData::userName(), KDbConnectionData::setUserName()
        QString hostName; //!< @see KDbConnectionData::hostName(), KDbConnectionData::setHostName()
        int port; //!< @see KDbConnectionData::port(), KDbConnectionData::setPort()
        bool useLocalSocketFile; //!< @see KDbConnectionData::useLocalSocketFile(), KDbConnectionData::setUseLocalSocketFile()
        QString localSocketFileName; //!< @see KDbConnectionData::localSocketFileName(), KDbConnectionData::setLocalSocketFileName()
        QString password; //!< @see KDbConnectionData::password(), KDbConnectionData::setPassword()
        bool savePassword; //!< @see KDbConnectionData::savePassword(), KDbConnectionData::setSavePassword()
    };

    KDbConnectionData()
     : d(new Data)
    {
    }

    KDbConnectionData(const KDbConnectionData &other)
     : d(other.d)
    {
    }

    /*! Constructor for KDbConnectionData object, takes attributes saved to map @a map.
         If @a ok is not 0, sets *ok to true on success and to false on failure. @see toMap(). */
    KDbConnectionData(const QMap<QString, QString> &map, bool *ok)
     : d(new Data(map, ok))
    {
    }

    virtual ~KDbConnectionData();

    /*!
    @return database name

    Optional attribute explicitly providing database name.
    If not empty, the database driver will attempt to use the database
    (e.g. with "USE DATABASE" SQL statement).

    For file-based database engines like SQLite, the database name is equal to filename
    (absolute or relative) that should be open. In this case hostName and port is unused.

    Can be empty, in which case if database name is required by the connection,
    after connecting KDbConnection::useDatabase() should be called.
    */
    QString databaseName() const {
        return d->databaseName;
    }

    /*!
    Explicitly sets database name.
    */
    void setDatabaseName(const QString & databaseName) {
        d->databaseName = databaseName;
    }

    /*!
    @return caption of the connection
    Captions are optional for identyfying given connection by name eg. for users.
    */
    QString caption() const {
        return d->caption;
    }

    /*!
    Sets caption of the connection
    */
    void setCaption(const QString & caption) {
        d->caption = caption;
    }

    /*!
    @return additional description for the connection
    */
    QString description() const {
        return d->description;
    }

    /*!
    Sets additional description for the connection
    */
    void setDescription(const QString & description) {
        d->description = description;
    }

    /*!
    @return identifier of the driver.
    ID (unique, not i18n-ed) of driver that is used (or should be used) to
    create a connection. If you pass this KDbConnectionData object to
    KDbDriver::createConnection() to create connection, the @a driverId member
    will be updated with a valid KDb driver ID.
    In other situations the @a driverId member may be used to store information what
    driver should be used to perform connection, before we get an appropriate
    driver object from KDbDriverManager.
    */
    QString driverId() const {
        return d->driverId;
    }

    /*!
    Sets identifier of the driver to use
    */
    void setDriverId(const QString & driverId) {
        d->driverId = driverId;
    }

    /*!
    @return username used for creating connections
    Can be empty.
    */
    QString userName() const {
        return d->userName;
    }

    /*!
    Sets username used for creating connections
    */
    void setUserName(const QString & userName) {
        d->userName = userName;
    }

    /*!
    @return host name used for creating remote connections
    Can be IP number. Can be empty if the connection is not remote.
    If empty, "localhost" is used.
    */
    QString hostName() const {
        return d->hostName;
    }

    /*!
    Sets host name used for creating remote connections
    */
    void setHostName(const QString & hostName) {
        d->hostName = hostName;
    }

    /*!
    The default is 0, what means using the database engine's default port.
    */
    int port() const {
        return d->port;
    }

    /*!
    Sets port used for creating remote connections
    */
    void setPort(int port) {
        d->port = port;
    }

    /*!
    @return true if local socket file should be used instead of TCP/IP port.

    Only meaningful for connections with localhost as server.
    True by default, so local communication can be optimized, and users can avoid problems
    with TCP/IP connections disabled by firewalls.

    If true, @a hostName and @a port will be ignored and @a localSocketFileName() will be used.
    On MS Windows this option is usually ignored and TCP/IP connection to the localhost is performed.
    */
    bool useLocalSocketFile() const {
        return d->useLocalSocketFile;
    }

    /*!
    Sets flag for usage of local socket file. @see useLocalSocketFile()
    */
    void setUseLocalSocketFile(bool useLocalSocketFile) {
        d->useLocalSocketFile = useLocalSocketFile;
    }

    /*!
    @return name of local (named) socket file.

    For local connections only. If empty, it's driver will try to locate existing local socket
    file. Empty by default.
    */
    QString localSocketFileName() const {
        return d->localSocketFileName;
    }

    /*!
    Sets name  of local (named) socket file
    */
    void setLocalSocketFileName(const QString & localSocketFileName) {
        d->localSocketFileName = localSocketFileName;
    }

    /*!
    @return password used for creating connections

    Can be empty string (QString("")) or null (QString()). If it is empty, empty password is passed
    to the connection. If it is null, no password is saved and thereform no password is passed to the connection.
    In the latter case, applications that KDb should ask for the password before performing connection
    if password is required by the connection.
    */
    QString password() const {
        return d->password;
    }

    /*!
    Sets password used for creating connections
    */
    void setPassword(const QString & password) {
        d->password = password;
    }

    /*!
    @return true if the connection's password should be stored in a configuration file for later use.
    False by default, in most cases can be set to true when non-null password is known.
    For instance, this flag can be then shown for a user as a checkbox in the graphical interface.
    */
    bool savePassword() const {
        return d->savePassword;
    }

    /*!
    Sets password-saving flag used to decide if the connection's password should be stored
    in a configuration file for later use
    */
    void setSavePassword(bool savePassword) {
        d->savePassword = savePassword;
    }

    /*! @return map with saved attributes of the KDbConnectionData object.

     @see KDbConnectionData(const QMap<QString, QString>&, bool *).
    */
    QMap<QString, QString> toMap() const {
        return d->toMap();
    }

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KDbConnectionData &other) const {
        return *d == *other.d;
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KDbConnectionData &other) const {
        return !operator==(other);
    }


    //! Used in toUserVisibleString()
    enum UserVisibleStringOption {
        NoUserVisibleStringOption = 0x0,
        AddUserToUserVisibleString = 0x1
    };
    Q_DECLARE_FLAGS(UserVisibleStringOptions, UserVisibleStringOption)

    /*! @return A user-visible string for the connection data
    driverId() is used to know if driver handles server connections. If it's not possible
    to check the driver, defaults to "file" connection.

    Example strings:
     - "myhost.org:12345" if a host and port is specified;
     - "localhost:12345" if only a port and server-based driver is specified;
     - "user@myhost.org:12345" if user is specified too
     - "<file>" if a file-based driver is specified but no filename in the databaseName attribute
     - "file: pathto/mydb.kexi" if a file-based driver is specified and filename
       is specified in the databaseName attribute
     - "<file>" if the driver is unknown or not specified and no databaseName is specified

     User name is added if (@a options & AddUserToUserVisibleString) is true (the default).
    */
    QString toUserVisibleString(UserVisibleStringOptions options = AddUserToUserVisibleString) const;

    /*! @return true if password is needed for performing connection.
    The password has to be provided by the user.
    @note This method needs information about driver ID; it returns false if driverId()
          does not return a valid ID.
    */
    bool isPasswordNeeded() const;

protected:
    QSharedDataPointer<Data> d;
};

Q_DECLARE_OPERATORS_FOR_FLAGS(KDbConnectionData::UserVisibleStringOptions)

//! Sends information about connection data @a data to debug output @a dbg.
KDB_EXPORT QDebug operator<<(QDebug dbg, const KDbConnectionData& data);

#endif
