/* xkblayout.c generated by valac 0.20.1, the Vala compiler
 * generated from xkblayout.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright 2012 Red Hat, Inc.
 * Copyright(c) 2012 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2012 Takao Fujiwara <tfujiwar@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ibus.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_XKB_LAYOUT (xkb_layout_get_type ())
#define XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XKB_LAYOUT, XKBLayout))
#define XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XKB_LAYOUT, XKBLayoutClass))
#define IS_XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XKB_LAYOUT))
#define IS_XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XKB_LAYOUT))
#define XKB_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XKB_LAYOUT, XKBLayoutClass))

typedef struct _XKBLayout XKBLayout;
typedef struct _XKBLayoutClass XKBLayoutClass;
typedef struct _XKBLayoutPrivate XKBLayoutPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecXKBLayout ParamSpecXKBLayout;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _XKBLayout {
	GTypeInstance parent_instance;
	volatile int ref_count;
	XKBLayoutPrivate * priv;
};

struct _XKBLayoutClass {
	GTypeClass parent_class;
	void (*finalize) (XKBLayout *self);
};

struct _XKBLayoutPrivate {
	gchar* m_xkb_command;
	IBusConfig* m_config;
	gchar** m_xkb_latin_layouts;
	gint m_xkb_latin_layouts_length1;
	gint _m_xkb_latin_layouts_size_;
	GPid m_xkb_pid;
	GPid m_xmodmap_pid;
	gchar* m_xmodmap_command;
	gboolean m_use_xmodmap;
	gchar** m_xmodmap_known_files;
	gint m_xmodmap_known_files_length1;
	gint _m_xmodmap_known_files_size_;
	gchar* m_default_layout;
	gchar* m_default_variant;
	gchar* m_default_option;
};

struct _ParamSpecXKBLayout {
	GParamSpec parent_instance;
};


static gpointer xkb_layout_parent_class = NULL;

gpointer xkb_layout_ref (gpointer instance);
void xkb_layout_unref (gpointer instance);
GParamSpec* param_spec_xkb_layout (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_xkb_layout (GValue* value, gpointer v_object);
void value_take_xkb_layout (GValue* value, gpointer v_object);
gpointer value_get_xkb_layout (const GValue* value);
GType xkb_layout_get_type (void) G_GNUC_CONST;
#define XKB_LAYOUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_XKB_LAYOUT, XKBLayoutPrivate))
enum  {
	XKB_LAYOUT_DUMMY_PROPERTY
};
XKBLayout* xkb_layout_new (IBusConfig* config);
XKBLayout* xkb_layout_construct (GType object_type, IBusConfig* config);
static void _vala_array_add25 (gchar*** array, int* length, int* size, gchar* value);
static gchar* xkb_layout_get_output_from_cmdline (XKBLayout* self, const gchar* arg, const gchar* element);
static void _vala_array_add26 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add27 (gchar*** array, int* length, int* size, gchar* value);
static void xkb_layout_set_layout_cb (XKBLayout* self, GPid pid, gint status);
void xkb_layout_set_xmodmap (XKBLayout* self);
static void xkb_layout_set_xmodmap_cb (XKBLayout* self, GPid pid, gint status);
static gchar* xkb_layout_get_fullpath (XKBLayout* self, const gchar* command);
static gchar** xkb_layout_get_xkb_group_layout (XKBLayout* self, const gchar* layout, const gchar* variant, gint layouts_max_length, int* result_length1);
gchar** xkb_layout_get_variant_from_layout (XKBLayout* self, const gchar* layout, int* result_length1);
gchar** xkb_layout_get_option_from_layout (XKBLayout* self, const gchar* layout, int* result_length1);
gchar* xkb_layout_get_layout (XKBLayout* self);
gchar* xkb_layout_get_variant (XKBLayout* self);
gchar* xkb_layout_get_option (XKBLayout* self);
gint* xkb_layout_set_layout (XKBLayout* self, const gchar* _layout, const gchar* _variant, const gchar* _option, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add28 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add29 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add30 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add31 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add32 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add33 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add34 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add35 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add36 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add37 (gchar*** array, int* length, int* size, gchar* value);
static void _xkb_layout_set_layout_cb_gchild_watch_func (GPid pid, gint status, gpointer self);
static void _xkb_layout_set_xmodmap_cb_gchild_watch_func (GPid pid, gint status, gpointer self);
void xkb_layout_reset_layout (XKBLayout* self);
static void xkb_layout_finalize (XKBLayout* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add25 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


XKBLayout* xkb_layout_construct (GType object_type, IBusConfig* config) {
	XKBLayout* self = NULL;
	IBusConfig* _tmp1_;
	IBusConfig* _tmp2_;
	IBusConfig* _tmp3_;
	self = (XKBLayout*) g_type_create_instance (object_type);
	if (!HAVE_IBUS_XKB) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("setxkbmap");
		_g_free0 (self->priv->m_xkb_command);
		self->priv->m_xkb_command = _tmp0_;
	}
	_tmp1_ = config;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->m_config);
	self->priv->m_config = _tmp2_;
	_tmp3_ = config;
	if (_tmp3_ != NULL) {
		IBusConfig* _tmp4_;
		GVariant* _tmp5_ = NULL;
		GVariant* value;
		gboolean _tmp21_;
		_tmp4_ = config;
		_tmp5_ = ibus_config_get_value (_tmp4_, "general", "xkb_latin_layouts");
		value = _tmp5_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					gboolean _tmp7_;
					gboolean _tmp9_ = FALSE;
					GVariant* _tmp10_;
					gboolean _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					GVariant* _tmp16_;
					gint _tmp17_;
					GVariant* _tmp18_ = NULL;
					GVariant* _tmp19_;
					gchar* _tmp20_ = NULL;
					_tmp7_ = _tmp6_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp10_ = value;
					if (_tmp10_ != NULL) {
						gint _tmp11_;
						GVariant* _tmp12_;
						gsize _tmp13_ = 0UL;
						_tmp11_ = i;
						_tmp12_ = value;
						_tmp13_ = g_variant_n_children (_tmp12_);
						_tmp9_ = ((gsize) _tmp11_) < _tmp13_;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp14_ = _tmp9_;
					if (!_tmp14_) {
						break;
					}
					_tmp15_ = self->priv->m_xkb_latin_layouts;
					_tmp15__length1 = self->priv->m_xkb_latin_layouts_length1;
					_tmp16_ = value;
					_tmp17_ = i;
					_tmp18_ = g_variant_get_child_value (_tmp16_, (gsize) _tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = g_variant_dup_string (_tmp19_, NULL);
					_vala_array_add25 (&self->priv->m_xkb_latin_layouts, &self->priv->m_xkb_latin_layouts_length1, &self->priv->_m_xkb_latin_layouts_size_, _tmp20_);
					_g_variant_unref0 (_tmp19_);
				}
			}
		}
		_tmp21_ = self->priv->m_use_xmodmap;
		if (_tmp21_) {
			IBusConfig* _tmp22_;
			GVariant* _tmp23_ = NULL;
			GVariant* _tmp24_;
			gboolean _tmp25_ = FALSE;
			_tmp22_ = config;
			_tmp23_ = ibus_config_get_value (_tmp22_, "general", "use_xmodmap");
			_tmp24_ = _tmp23_;
			_tmp25_ = g_variant_get_boolean (_tmp24_);
			self->priv->m_use_xmodmap = _tmp25_;
			_g_variant_unref0 (_tmp24_);
		}
		_g_variant_unref0 (value);
	}
	return self;
}


XKBLayout* xkb_layout_new (IBusConfig* config) {
	return xkb_layout_construct (TYPE_XKB_LAYOUT, config);
}


static void _vala_array_add26 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add27 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* xkb_layout_get_output_from_cmdline (XKBLayout* self, const gchar* arg, const gchar* element) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** exec_command;
	gint exec_command_length1;
	gint _exec_command_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* standard_output;
	gchar* standard_error;
	gint exit_status;
	gchar* _tmp7_;
	gchar* retval;
	gint _tmp15_;
	const gchar* _tmp23_;
	const gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (arg != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	exec_command = _tmp0_;
	exec_command_length1 = 0;
	_exec_command_size_ = exec_command_length1;
	_tmp1_ = exec_command;
	_tmp1__length1 = exec_command_length1;
	_tmp2_ = self->priv->m_xkb_command;
	_tmp3_ = g_strdup (_tmp2_);
	_vala_array_add26 (&exec_command, &exec_command_length1, &_exec_command_size_, _tmp3_);
	_tmp4_ = exec_command;
	_tmp4__length1 = exec_command_length1;
	_tmp5_ = arg;
	_tmp6_ = g_strdup (_tmp5_);
	_vala_array_add27 (&exec_command, &exec_command_length1, &_exec_command_size_, _tmp6_);
	standard_output = NULL;
	standard_error = NULL;
	exit_status = 0;
	_tmp7_ = g_strdup ("");
	retval = _tmp7_;
	{
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp8_ = exec_command;
		_tmp8__length1 = exec_command_length1;
		g_spawn_sync (NULL, _tmp8_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, &_tmp10_, &_tmp11_, &_inner_error_);
		_g_free0 (standard_output);
		standard_output = _tmp9_;
		_g_free0 (standard_error);
		standard_error = _tmp10_;
		exit_status = _tmp11_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch4_g_spawn_error;
			}
			_g_free0 (retval);
			_g_free0 (standard_error);
			_g_free0 (standard_output);
			exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* err = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "IBUS_ERROR: %s\n", _tmp14_);
		_g_error_free0 (err);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (retval);
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp15_ = exit_status;
	if (_tmp15_ != 0) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		FILE* _tmp21_;
		const gchar* _tmp22_;
		_tmp16_ = standard_error;
		_tmp17_ = g_strdup (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		if (_tmp19_ == NULL) {
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("");
			_g_free0 (_tmp18_);
			_tmp18_ = _tmp20_;
		}
		_tmp21_ = stderr;
		_tmp22_ = _tmp18_;
		fprintf (_tmp21_, "IBUS_ERROR: %s\n", _tmp22_);
		_g_free0 (_tmp18_);
	}
	_tmp23_ = standard_output;
	if (_tmp23_ == NULL) {
		gchar* _tmp24_;
		_tmp24_ = g_strdup ("");
		result = _tmp24_;
		_g_free0 (retval);
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp25_ = standard_output;
	_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp27_;
		line_collection_length1 = _vala_array_length (_tmp26_);
		for (line_it = 0; line_it < _vala_array_length (_tmp26_); line_it = line_it + 1) {
			gchar* _tmp28_;
			gchar* line = NULL;
			_tmp28_ = g_strdup (line_collection[line_it]);
			line = _tmp28_;
			{
				gboolean _tmp29_ = FALSE;
				const gchar* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				const gchar* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gboolean _tmp43_;
				_tmp30_ = element;
				_tmp31_ = strlen (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = line;
				_tmp34_ = strlen (_tmp33_);
				_tmp35_ = _tmp34_;
				if (_tmp32_ <= _tmp35_) {
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gchar* _tmp40_ = NULL;
					gchar* _tmp41_;
					const gchar* _tmp42_;
					_tmp36_ = line;
					_tmp37_ = element;
					_tmp38_ = strlen (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = string_slice (_tmp36_, (glong) 0, (glong) _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = element;
					_tmp29_ = g_strcmp0 (_tmp41_, _tmp42_) == 0;
					_g_free0 (_tmp41_);
				} else {
					_tmp29_ = FALSE;
				}
				_tmp43_ = _tmp29_;
				if (_tmp43_) {
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					const gchar* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					gchar* _tmp51_ = NULL;
					_tmp44_ = line;
					_tmp45_ = element;
					_tmp46_ = strlen (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = line;
					_tmp49_ = strlen (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = string_slice (_tmp44_, (glong) _tmp47_, (glong) _tmp50_);
					_g_free0 (retval);
					retval = _tmp51_;
				}
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = retval;
	_g_free0 (standard_error);
	_g_free0 (standard_output);
	exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void xkb_layout_set_layout_cb (XKBLayout* self, GPid pid, gint status) {
	GPid _tmp0_;
	GPid _tmp1_;
	GPid _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xkb_pid;
	_tmp1_ = pid;
	if (_tmp0_ != _tmp1_) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "IBUS_ERROR: set_layout_cb has another pid\n");
		return;
	}
	_tmp3_ = self->priv->m_xkb_pid;
	g_spawn_close_pid (_tmp3_);
	self->priv->m_xkb_pid = (GPid) (-1);
	xkb_layout_set_xmodmap (self);
}


static void xkb_layout_set_xmodmap_cb (XKBLayout* self, GPid pid, gint status) {
	GPid _tmp0_;
	GPid _tmp1_;
	GPid _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xmodmap_pid;
	_tmp1_ = pid;
	if (_tmp0_ != _tmp1_) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "IBUS_ERROR: set_xmodmap_cb has another pid\n");
		return;
	}
	_tmp3_ = self->priv->m_xmodmap_pid;
	g_spawn_close_pid (_tmp3_);
	self->priv->m_xmodmap_pid = (GPid) (-1);
}


static gchar* xkb_layout_get_fullpath (XKBLayout* self, const gchar* command) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* envpath;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	_tmp0_ = g_getenv ("PATH");
	_tmp1_ = g_strdup (_tmp0_);
	envpath = _tmp1_;
	_tmp2_ = envpath;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 0);
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp4_;
		dir_collection_length1 = _vala_array_length (_tmp3_);
		for (dir_it = 0; dir_it < _vala_array_length (_tmp3_); dir_it = dir_it + 1) {
			gchar* _tmp5_;
			gchar* dir = NULL;
			_tmp5_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* filepath;
				const gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp6_ = dir;
				_tmp7_ = command;
				_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
				filepath = _tmp8_;
				_tmp9_ = filepath;
				_tmp10_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
				if (_tmp10_) {
					result = filepath;
					_g_free0 (dir);
					dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (envpath);
					return result;
				}
				_g_free0 (filepath);
				_g_free0 (dir);
			}
		}
		dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp11_ = g_strdup ("");
	result = _tmp11_;
	_g_free0 (envpath);
	return result;
}


static gchar** xkb_layout_get_xkb_group_layout (XKBLayout* self, const gchar* layout, const gchar* variant, gint layouts_max_length, int* result_length1) {
	gchar** result = NULL;
	gint group_id;
	gint i;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** layouts;
	gint layouts_length1;
	gint _layouts_size_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** variants;
	gint variants_length1;
	gint _variants_size_;
	gchar* _tmp6_;
	gchar* group_layouts;
	gchar* _tmp7_;
	gchar* group_variants;
	gboolean has_variant;
	gboolean include_keymap;
	const gchar* _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp72_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	gint _tmp77_;
	gchar* _tmp78_ = NULL;
	gchar** _tmp79_ = NULL;
	gchar** _tmp80_;
	gint _tmp80__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (layout != NULL, NULL);
	g_return_val_if_fail (variant != NULL, NULL);
	group_id = 0;
	i = 0;
	_tmp0_ = self->priv->m_default_layout;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 0);
	layouts = _tmp2_;
	layouts_length1 = _vala_array_length (_tmp1_);
	_layouts_size_ = layouts_length1;
	_tmp3_ = self->priv->m_default_variant;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ",", 0);
	variants = _tmp5_;
	variants_length1 = _vala_array_length (_tmp4_);
	_variants_size_ = variants_length1;
	_tmp6_ = g_strdup ("");
	group_layouts = _tmp6_;
	_tmp7_ = g_strdup ("");
	group_variants = _tmp7_;
	has_variant = FALSE;
	include_keymap = FALSE;
	{
		gboolean _tmp8_;
		i = 0;
		_tmp8_ = TRUE;
		while (TRUE) {
			gboolean _tmp9_;
			gint _tmp11_;
			gchar** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp25_;
			gchar** _tmp26_;
			gint _tmp26__length1;
			gboolean _tmp39_ = FALSE;
			const gchar* _tmp40_;
			gchar** _tmp41_;
			gint _tmp41__length1;
			gint _tmp42_;
			const gchar* _tmp43_;
			gboolean _tmp48_;
			gchar** _tmp50_;
			gint _tmp50__length1;
			gint _tmp51_;
			const gchar* _tmp52_;
			gint _tmp53_;
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				gint _tmp10_;
				_tmp10_ = i;
				i = _tmp10_ + 1;
			}
			_tmp8_ = FALSE;
			_tmp11_ = i;
			_tmp12_ = layouts;
			_tmp12__length1 = layouts_length1;
			if (!(_tmp11_ < _tmp12__length1)) {
				break;
			}
			_tmp13_ = i;
			_tmp14_ = layouts_max_length;
			if (_tmp13_ >= (_tmp14_ - 1)) {
				break;
			}
			_tmp15_ = i;
			if (_tmp15_ == 0) {
				gchar** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp16_ = layouts;
				_tmp16__length1 = layouts_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				_tmp19_ = g_strdup (_tmp18_);
				_g_free0 (group_layouts);
				group_layouts = _tmp19_;
			} else {
				const gchar* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_ = NULL;
				_tmp20_ = group_layouts;
				_tmp21_ = layouts;
				_tmp21__length1 = layouts_length1;
				_tmp22_ = i;
				_tmp23_ = _tmp21_[_tmp22_];
				_tmp24_ = g_strdup_printf ("%s,%s", _tmp20_, _tmp23_);
				_g_free0 (group_layouts);
				group_layouts = _tmp24_;
			}
			_tmp25_ = i;
			_tmp26_ = variants;
			_tmp26__length1 = variants_length1;
			if (_tmp25_ >= _tmp26__length1) {
				gint _tmp27_;
				gboolean _tmp31_ = FALSE;
				const gchar* _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				gint _tmp34_;
				const gchar* _tmp35_;
				gboolean _tmp37_;
				_tmp27_ = i;
				if (_tmp27_ == 0) {
					gchar* _tmp28_;
					_tmp28_ = g_strdup ("");
					_g_free0 (group_variants);
					group_variants = _tmp28_;
				} else {
					const gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp29_ = group_variants;
					_tmp30_ = g_strconcat (_tmp29_, ",", NULL);
					_g_free0 (group_variants);
					group_variants = _tmp30_;
				}
				_tmp32_ = layout;
				_tmp33_ = layouts;
				_tmp33__length1 = layouts_length1;
				_tmp34_ = i;
				_tmp35_ = _tmp33_[_tmp34_];
				if (g_strcmp0 (_tmp32_, _tmp35_) == 0) {
					const gchar* _tmp36_;
					_tmp36_ = variant;
					_tmp31_ = g_strcmp0 (_tmp36_, "") == 0;
				} else {
					_tmp31_ = FALSE;
				}
				_tmp37_ = _tmp31_;
				if (_tmp37_) {
					gint _tmp38_;
					include_keymap = TRUE;
					_tmp38_ = i;
					group_id = _tmp38_;
				}
				continue;
			}
			_tmp40_ = layout;
			_tmp41_ = layouts;
			_tmp41__length1 = layouts_length1;
			_tmp42_ = i;
			_tmp43_ = _tmp41_[_tmp42_];
			if (g_strcmp0 (_tmp40_, _tmp43_) == 0) {
				const gchar* _tmp44_;
				gchar** _tmp45_;
				gint _tmp45__length1;
				gint _tmp46_;
				const gchar* _tmp47_;
				_tmp44_ = variant;
				_tmp45_ = variants;
				_tmp45__length1 = variants_length1;
				_tmp46_ = i;
				_tmp47_ = _tmp45_[_tmp46_];
				_tmp39_ = g_strcmp0 (_tmp44_, _tmp47_) == 0;
			} else {
				_tmp39_ = FALSE;
			}
			_tmp48_ = _tmp39_;
			if (_tmp48_) {
				gint _tmp49_;
				include_keymap = TRUE;
				_tmp49_ = i;
				group_id = _tmp49_;
			}
			_tmp50_ = variants;
			_tmp50__length1 = variants_length1;
			_tmp51_ = i;
			_tmp52_ = _tmp50_[_tmp51_];
			if (g_strcmp0 (_tmp52_, "") != 0) {
				has_variant = TRUE;
			}
			_tmp53_ = i;
			if (_tmp53_ == 0) {
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				_tmp54_ = variants;
				_tmp54__length1 = variants_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				_tmp57_ = g_strdup (_tmp56_);
				_g_free0 (group_variants);
				group_variants = _tmp57_;
			} else {
				const gchar* _tmp58_;
				gchar** _tmp59_;
				gint _tmp59__length1;
				gint _tmp60_;
				const gchar* _tmp61_;
				gchar* _tmp62_ = NULL;
				_tmp58_ = group_variants;
				_tmp59_ = variants;
				_tmp59__length1 = variants_length1;
				_tmp60_ = i;
				_tmp61_ = _tmp59_[_tmp60_];
				_tmp62_ = g_strdup_printf ("%s,%s", _tmp58_, _tmp61_);
				_g_free0 (group_variants);
				group_variants = _tmp62_;
			}
		}
	}
	_tmp63_ = variant;
	if (g_strcmp0 (_tmp63_, "") != 0) {
		has_variant = TRUE;
	}
	_tmp64_ = include_keymap;
	if (!_tmp64_) {
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		gchar* _tmp67_ = NULL;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_ = NULL;
		gint _tmp71_;
		_tmp65_ = group_layouts;
		_tmp66_ = layout;
		_tmp67_ = g_strdup_printf ("%s,%s", _tmp65_, _tmp66_);
		_g_free0 (group_layouts);
		group_layouts = _tmp67_;
		_tmp68_ = group_variants;
		_tmp69_ = variant;
		_tmp70_ = g_strdup_printf ("%s,%s", _tmp68_, _tmp69_);
		_g_free0 (group_variants);
		group_variants = _tmp70_;
		_tmp71_ = i;
		group_id = _tmp71_;
	}
	_tmp72_ = has_variant;
	if (!_tmp72_) {
		_g_free0 (group_variants);
		group_variants = NULL;
	}
	_tmp73_ = group_layouts;
	_tmp74_ = g_strdup (_tmp73_);
	_tmp75_ = group_variants;
	_tmp76_ = g_strdup (_tmp75_);
	_tmp77_ = group_id;
	_tmp78_ = g_strdup_printf ("%i", _tmp77_);
	_tmp79_ = g_new0 (gchar*, 3 + 1);
	_tmp79_[0] = _tmp74_;
	_tmp79_[1] = _tmp76_;
	_tmp79_[2] = _tmp78_;
	_tmp80_ = _tmp79_;
	_tmp80__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp80__length1;
	}
	result = _tmp80_;
	_g_free0 (group_variants);
	_g_free0 (group_layouts);
	variants = (_vala_array_free (variants, variants_length1, (GDestroyNotify) g_free), NULL);
	layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar** xkb_layout_get_variant_from_layout (XKBLayout* self, const gchar* layout, int* result_length1) {
	gchar** result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint left_bracket;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint right_bracket;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gboolean _tmp8_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar** _tmp31_ = NULL;
	gchar** _tmp32_;
	gint _tmp32__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (layout != NULL, NULL);
	_tmp0_ = layout;
	_tmp1_ = string_index_of (_tmp0_, "(", 0);
	left_bracket = _tmp1_;
	_tmp2_ = layout;
	_tmp3_ = string_index_of (_tmp2_, ")", 0);
	right_bracket = _tmp3_;
	_tmp5_ = left_bracket;
	if (_tmp5_ >= 0) {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = right_bracket;
		_tmp7_ = left_bracket;
		_tmp4_ = _tmp6_ > _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp8_ = _tmp4_;
	if (_tmp8_) {
		const gchar* _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar** _tmp25_ = NULL;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp9_ = layout;
		_tmp10_ = left_bracket;
		_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = layout;
		_tmp14_ = right_bracket;
		_tmp15_ = layout;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = string_slice (_tmp13_, (glong) (_tmp14_ + 1), (glong) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp12_, _tmp19_, NULL);
		_tmp21_ = layout;
		_tmp22_ = left_bracket;
		_tmp23_ = right_bracket;
		_tmp24_ = string_slice (_tmp21_, (glong) (_tmp22_ + 1), (glong) _tmp23_);
		_tmp25_ = g_new0 (gchar*, 2 + 1);
		_tmp25_[0] = _tmp20_;
		_tmp25_[1] = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp26__length1 = 2;
		_g_free0 (_tmp19_);
		_g_free0 (_tmp12_);
		_tmp27_ = _tmp26_;
		_tmp27__length1 = _tmp26__length1;
		if (result_length1) {
			*result_length1 = _tmp27__length1;
		}
		result = _tmp27_;
		return result;
	}
	_tmp28_ = layout;
	_tmp29_ = g_strdup (_tmp28_);
	_tmp30_ = g_strdup ("default");
	_tmp31_ = g_new0 (gchar*, 2 + 1);
	_tmp31_[0] = _tmp29_;
	_tmp31_[1] = _tmp30_;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 2;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	return result;
}


gchar** xkb_layout_get_option_from_layout (XKBLayout* self, const gchar* layout, int* result_length1) {
	gchar** result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint left_bracket;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint right_bracket;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gboolean _tmp8_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar** _tmp31_ = NULL;
	gchar** _tmp32_;
	gint _tmp32__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (layout != NULL, NULL);
	_tmp0_ = layout;
	_tmp1_ = string_index_of (_tmp0_, "[", 0);
	left_bracket = _tmp1_;
	_tmp2_ = layout;
	_tmp3_ = string_index_of (_tmp2_, "]", 0);
	right_bracket = _tmp3_;
	_tmp5_ = left_bracket;
	if (_tmp5_ >= 0) {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = right_bracket;
		_tmp7_ = left_bracket;
		_tmp4_ = _tmp6_ > _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp8_ = _tmp4_;
	if (_tmp8_) {
		const gchar* _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar** _tmp25_ = NULL;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp9_ = layout;
		_tmp10_ = left_bracket;
		_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = layout;
		_tmp14_ = right_bracket;
		_tmp15_ = layout;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = string_slice (_tmp13_, (glong) (_tmp14_ + 1), (glong) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp12_, _tmp19_, NULL);
		_tmp21_ = layout;
		_tmp22_ = left_bracket;
		_tmp23_ = right_bracket;
		_tmp24_ = string_slice (_tmp21_, (glong) (_tmp22_ + 1), (glong) _tmp23_);
		_tmp25_ = g_new0 (gchar*, 2 + 1);
		_tmp25_[0] = _tmp20_;
		_tmp25_[1] = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp26__length1 = 2;
		_g_free0 (_tmp19_);
		_g_free0 (_tmp12_);
		_tmp27_ = _tmp26_;
		_tmp27__length1 = _tmp26__length1;
		if (result_length1) {
			*result_length1 = _tmp27__length1;
		}
		result = _tmp27_;
		return result;
	}
	_tmp28_ = layout;
	_tmp29_ = g_strdup (_tmp28_);
	_tmp30_ = g_strdup ("default");
	_tmp31_ = g_new0 (gchar*, 2 + 1);
	_tmp31_[0] = _tmp29_;
	_tmp31_[1] = _tmp30_;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 2;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	return result;
}


gchar* xkb_layout_get_layout (XKBLayout* self) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (HAVE_IBUS_XKB) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = xkb_layout_get_output_from_cmdline (self, "--get", "layout: ");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = xkb_layout_get_output_from_cmdline (self, "-query", "layout: ");
		result = _tmp1_;
		return result;
	}
}


gchar* xkb_layout_get_variant (XKBLayout* self) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (HAVE_IBUS_XKB) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = xkb_layout_get_output_from_cmdline (self, "--get", "variant: ");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = xkb_layout_get_output_from_cmdline (self, "-query", "variant: ");
		result = _tmp1_;
		return result;
	}
}


gchar* xkb_layout_get_option (XKBLayout* self) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (HAVE_IBUS_XKB) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = xkb_layout_get_output_from_cmdline (self, "--get", "option: ");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = xkb_layout_get_output_from_cmdline (self, "-query", "options: ");
		result = _tmp1_;
		return result;
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add28 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add29 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add30 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add31 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add32 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add33 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add34 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add35 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add36 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add37 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _xkb_layout_set_layout_cb_gchild_watch_func (GPid pid, gint status, gpointer self) {
	xkb_layout_set_layout_cb (self, pid, status);
}


gint* xkb_layout_set_layout (XKBLayout* self, const gchar* _layout, const gchar* _variant, const gchar* _option, int* result_length1) {
	gint* result = NULL;
	const gchar* _tmp0_;
	gint xkb_group_id;
	gint changed_option;
	GPid _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp10_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* layout;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* variant;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* option;
	const gchar* _tmp19_;
	const gchar* _tmp29_;
	gboolean need_us_layout;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gint layouts_max_length;
	gboolean _tmp54_;
	const gchar* _tmp56_;
	const gchar* _tmp58_;
	const gchar* _tmp60_;
	const gchar* _tmp62_;
	const gchar* _tmp83_;
	gboolean _tmp86_ = FALSE;
	const gchar* _tmp87_;
	gboolean _tmp89_;
	gboolean _tmp90_ = FALSE;
	const gchar* _tmp91_;
	gboolean _tmp93_;
	const gchar* _tmp107_;
	gboolean _tmp108_;
	gchar** _tmp114_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp115_;
	gint _tmp115__length1;
	const gchar* _tmp116_;
	gchar* _tmp117_;
	GPid child_pid = 0;
	GPid _tmp153_;
	GPid _tmp154_;
	gint _tmp155_;
	gint _tmp156_;
	gint* _tmp157_ = NULL;
	gint* _tmp158_;
	gint _tmp158__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (_layout != NULL, NULL);
	g_return_val_if_fail (_variant != NULL, NULL);
	g_return_val_if_fail (_option != NULL, NULL);
	_tmp0_ = _layout;
	_vala_assert (_tmp0_ != NULL, "_layout != null");
	xkb_group_id = 0;
	changed_option = 0;
	_tmp1_ = self->priv->m_xkb_pid;
	if (_tmp1_ != ((GPid) (-1))) {
		gint* _tmp2_ = NULL;
		gint* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_new0 (gint, 2);
		_tmp2_[0] = -1;
		_tmp2_[1] = 0;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 2;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp6_ = _layout;
	if (g_strcmp0 (_tmp6_, "default") == 0) {
		const gchar* _tmp7_;
		_tmp7_ = _variant;
		_tmp5_ = g_strcmp0 (_tmp7_, "default") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		const gchar* _tmp9_;
		_tmp9_ = _option;
		_tmp4_ = g_strcmp0 (_tmp9_, "default") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp10_ = _tmp4_;
	if (_tmp10_) {
		gint* _tmp11_ = NULL;
		gint* _tmp12_;
		gint _tmp12__length1;
		_tmp11_ = g_new0 (gint, 2);
		_tmp11_[0] = -1;
		_tmp11_[1] = 0;
		_tmp12_ = _tmp11_;
		_tmp12__length1 = 2;
		if (result_length1) {
			*result_length1 = _tmp12__length1;
		}
		result = _tmp12_;
		return result;
	}
	_tmp13_ = _layout;
	_tmp14_ = g_strdup (_tmp13_);
	layout = _tmp14_;
	_tmp15_ = _variant;
	_tmp16_ = g_strdup (_tmp15_);
	variant = _tmp16_;
	_tmp17_ = _option;
	_tmp18_ = g_strdup (_tmp17_);
	option = _tmp18_;
	_tmp19_ = variant;
	if (g_strcmp0 (_tmp19_, "default") == 0) {
		const gchar* _tmp20_;
		gint _tmp21_ = 0;
		gchar** _tmp22_ = NULL;
		gchar** array;
		gint array_length1;
		gint _array_size_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp20_ = layout;
		_tmp22_ = xkb_layout_get_variant_from_layout (self, _tmp20_, &_tmp21_);
		array = _tmp22_;
		array_length1 = _tmp21_;
		_array_size_ = array_length1;
		_tmp23_ = array;
		_tmp23__length1 = array_length1;
		_tmp24_ = _tmp23_[0];
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 (layout);
		layout = _tmp25_;
		_tmp26_ = array;
		_tmp26__length1 = array_length1;
		_tmp27_ = _tmp26_[1];
		_tmp28_ = g_strdup (_tmp27_);
		_g_free0 (variant);
		variant = _tmp28_;
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp29_ = option;
	if (g_strcmp0 (_tmp29_, "default") == 0) {
		const gchar* _tmp30_;
		gint _tmp31_ = 0;
		gchar** _tmp32_ = NULL;
		gchar** array;
		gint array_length1;
		gint _array_size_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar** _tmp36_;
		gint _tmp36__length1;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp30_ = layout;
		_tmp32_ = xkb_layout_get_option_from_layout (self, _tmp30_, &_tmp31_);
		array = _tmp32_;
		array_length1 = _tmp31_;
		_array_size_ = array_length1;
		_tmp33_ = array;
		_tmp33__length1 = array_length1;
		_tmp34_ = _tmp33_[0];
		_tmp35_ = g_strdup (_tmp34_);
		_g_free0 (layout);
		layout = _tmp35_;
		_tmp36_ = array;
		_tmp36__length1 = array_length1;
		_tmp37_ = _tmp36_[1];
		_tmp38_ = g_strdup (_tmp37_);
		_g_free0 (option);
		option = _tmp38_;
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	}
	need_us_layout = FALSE;
	_tmp39_ = self->priv->m_xkb_latin_layouts;
	_tmp39__length1 = self->priv->m_xkb_latin_layouts_length1;
	{
		gchar** latin_layout_collection = NULL;
		gint latin_layout_collection_length1 = 0;
		gint _latin_layout_collection_size_ = 0;
		gint latin_layout_it = 0;
		latin_layout_collection = _tmp39_;
		latin_layout_collection_length1 = _tmp39__length1;
		for (latin_layout_it = 0; latin_layout_it < _tmp39__length1; latin_layout_it = latin_layout_it + 1) {
			gchar* _tmp40_;
			gchar* latin_layout = NULL;
			_tmp40_ = g_strdup (latin_layout_collection[latin_layout_it]);
			latin_layout = _tmp40_;
			{
				gboolean _tmp41_ = FALSE;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				gboolean _tmp45_;
				gboolean _tmp46_ = FALSE;
				const gchar* _tmp47_;
				gboolean _tmp53_;
				_tmp42_ = layout;
				_tmp43_ = latin_layout;
				if (g_strcmp0 (_tmp42_, _tmp43_) == 0) {
					const gchar* _tmp44_;
					_tmp44_ = variant;
					_tmp41_ = g_strcmp0 (_tmp44_, "eng") != 0;
				} else {
					_tmp41_ = FALSE;
				}
				_tmp45_ = _tmp41_;
				if (_tmp45_) {
					need_us_layout = TRUE;
					_g_free0 (latin_layout);
					break;
				}
				_tmp47_ = variant;
				if (_tmp47_ != NULL) {
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					gchar* _tmp50_ = NULL;
					gchar* _tmp51_;
					const gchar* _tmp52_;
					_tmp48_ = layout;
					_tmp49_ = variant;
					_tmp50_ = g_strdup_printf ("%s(%s)", _tmp48_, _tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = latin_layout;
					_tmp46_ = g_strcmp0 (_tmp51_, _tmp52_) == 0;
					_g_free0 (_tmp51_);
				} else {
					_tmp46_ = FALSE;
				}
				_tmp53_ = _tmp46_;
				if (_tmp53_) {
					need_us_layout = TRUE;
					_g_free0 (latin_layout);
					break;
				}
				_g_free0 (latin_layout);
			}
		}
	}
	layouts_max_length = XKB_LAYOUTS_MAX_LENGTH;
	_tmp54_ = need_us_layout;
	if (_tmp54_) {
		gint _tmp55_;
		_tmp55_ = layouts_max_length;
		layouts_max_length = _tmp55_ - 1;
	}
	_tmp56_ = self->priv->m_default_layout;
	if (g_strcmp0 (_tmp56_, "") == 0) {
		gchar* _tmp57_ = NULL;
		_tmp57_ = xkb_layout_get_layout (self);
		_g_free0 (self->priv->m_default_layout);
		self->priv->m_default_layout = _tmp57_;
	}
	_tmp58_ = self->priv->m_default_variant;
	if (g_strcmp0 (_tmp58_, "") == 0) {
		gchar* _tmp59_ = NULL;
		_tmp59_ = xkb_layout_get_variant (self);
		_g_free0 (self->priv->m_default_variant);
		self->priv->m_default_variant = _tmp59_;
	}
	_tmp60_ = self->priv->m_default_option;
	if (g_strcmp0 (_tmp60_, "") == 0) {
		gchar* _tmp61_ = NULL;
		_tmp61_ = xkb_layout_get_option (self);
		_g_free0 (self->priv->m_default_option);
		self->priv->m_default_option = _tmp61_;
	}
	_tmp62_ = layout;
	if (g_strcmp0 (_tmp62_, "default") == 0) {
		const gchar* _tmp63_;
		gchar* _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp63_ = self->priv->m_default_layout;
		_tmp64_ = g_strdup (_tmp63_);
		_g_free0 (layout);
		layout = _tmp64_;
		_tmp65_ = self->priv->m_default_variant;
		_tmp66_ = g_strdup (_tmp65_);
		_g_free0 (variant);
		variant = _tmp66_;
	} else {
		if (HAVE_IBUS_GKBD) {
			const gchar* _tmp67_;
			const gchar* _tmp69_;
			const gchar* _tmp70_;
			gint _tmp71_;
			gint _tmp72_ = 0;
			gchar** _tmp73_ = NULL;
			gchar** retval;
			gint retval_length1;
			gint _retval_size_;
			gchar** _tmp74_;
			gint _tmp74__length1;
			const gchar* _tmp75_;
			gchar* _tmp76_;
			gchar** _tmp77_;
			gint _tmp77__length1;
			const gchar* _tmp78_;
			gchar* _tmp79_;
			gchar** _tmp80_;
			gint _tmp80__length1;
			const gchar* _tmp81_;
			gint _tmp82_ = 0;
			_tmp67_ = variant;
			if (g_strcmp0 (_tmp67_, "default") == 0) {
				gchar* _tmp68_;
				_tmp68_ = g_strdup ("");
				_g_free0 (variant);
				variant = _tmp68_;
			}
			_tmp69_ = layout;
			_tmp70_ = variant;
			_tmp71_ = layouts_max_length;
			_tmp73_ = xkb_layout_get_xkb_group_layout (self, _tmp69_, _tmp70_, _tmp71_, &_tmp72_);
			retval = _tmp73_;
			retval_length1 = _tmp72_;
			_retval_size_ = retval_length1;
			_tmp74_ = retval;
			_tmp74__length1 = retval_length1;
			_tmp75_ = _tmp74_[0];
			_tmp76_ = g_strdup (_tmp75_);
			_g_free0 (layout);
			layout = _tmp76_;
			_tmp77_ = retval;
			_tmp77__length1 = retval_length1;
			_tmp78_ = _tmp77_[1];
			_tmp79_ = g_strdup (_tmp78_);
			_g_free0 (variant);
			variant = _tmp79_;
			_tmp80_ = retval;
			_tmp80__length1 = retval_length1;
			_tmp81_ = _tmp80_[2];
			_tmp82_ = atoi (_tmp81_);
			xkb_group_id = _tmp82_;
			retval = (_vala_array_free (retval, retval_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	_tmp83_ = layout;
	if (g_strcmp0 (_tmp83_, "") == 0) {
		gint* _tmp84_ = NULL;
		gint* _tmp85_;
		gint _tmp85__length1;
		g_warning ("xkblayout.vala:329: Could not get the correct layout");
		_tmp84_ = g_new0 (gint, 2);
		_tmp84_[0] = -1;
		_tmp84_[1] = 0;
		_tmp85_ = _tmp84_;
		_tmp85__length1 = 2;
		if (result_length1) {
			*result_length1 = _tmp85__length1;
		}
		result = _tmp85_;
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	_tmp87_ = variant;
	if (g_strcmp0 (_tmp87_, "default") == 0) {
		_tmp86_ = TRUE;
	} else {
		const gchar* _tmp88_;
		_tmp88_ = variant;
		_tmp86_ = g_strcmp0 (_tmp88_, "") == 0;
	}
	_tmp89_ = _tmp86_;
	if (_tmp89_) {
		_g_free0 (variant);
		variant = NULL;
	}
	_tmp91_ = option;
	if (g_strcmp0 (_tmp91_, "default") == 0) {
		_tmp90_ = TRUE;
	} else {
		const gchar* _tmp92_;
		_tmp92_ = option;
		_tmp90_ = g_strcmp0 (_tmp92_, "") == 0;
	}
	_tmp93_ = _tmp90_;
	if (_tmp93_) {
		const gchar* _tmp94_;
		gchar* _tmp95_;
		_tmp94_ = self->priv->m_default_option;
		_tmp95_ = g_strdup (_tmp94_);
		_g_free0 (option);
		option = _tmp95_;
	} else {
		const gchar* _tmp96_;
		const gchar* _tmp97_;
		gchar** _tmp98_;
		gchar** _tmp99_ = NULL;
		gchar** _tmp100_;
		gint _tmp100__length1;
		gboolean _tmp101_;
		_tmp96_ = option;
		_tmp97_ = self->priv->m_default_option;
		_tmp99_ = _tmp98_ = g_strsplit (_tmp97_, ",", 0);
		_tmp100_ = _tmp99_;
		_tmp100__length1 = _vala_array_length (_tmp98_);
		_tmp101_ = !_vala_string_array_contains (_tmp100_, _vala_array_length (_tmp98_), _tmp96_);
		_tmp100_ = (_vala_array_free (_tmp100_, _tmp100__length1, (GDestroyNotify) g_free), NULL);
		if (_tmp101_) {
			const gchar* _tmp102_;
			const gchar* _tmp103_;
			gchar* _tmp104_ = NULL;
			_tmp102_ = self->priv->m_default_option;
			_tmp103_ = option;
			_tmp104_ = g_strdup_printf ("%s,%s", _tmp102_, _tmp103_);
			_g_free0 (option);
			option = _tmp104_;
			changed_option = 1;
		} else {
			const gchar* _tmp105_;
			gchar* _tmp106_;
			_tmp105_ = self->priv->m_default_option;
			_tmp106_ = g_strdup (_tmp105_);
			_g_free0 (option);
			option = _tmp106_;
		}
	}
	_tmp107_ = option;
	if (g_strcmp0 (_tmp107_, "") == 0) {
		_g_free0 (option);
		option = NULL;
	}
	_tmp108_ = need_us_layout;
	if (_tmp108_) {
		const gchar* _tmp109_;
		gchar* _tmp110_;
		const gchar* _tmp111_;
		_tmp109_ = layout;
		_tmp110_ = g_strconcat (_tmp109_, ",us", NULL);
		_g_free0 (layout);
		layout = _tmp110_;
		_tmp111_ = variant;
		if (_tmp111_ != NULL) {
			const gchar* _tmp112_;
			gchar* _tmp113_;
			_tmp112_ = variant;
			_tmp113_ = g_strconcat (_tmp112_, ",", NULL);
			_g_free0 (variant);
			variant = _tmp113_;
		}
	}
	_tmp114_ = g_new0 (gchar*, 0 + 1);
	args = _tmp114_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp115_ = args;
	_tmp115__length1 = args_length1;
	_tmp116_ = self->priv->m_xkb_command;
	_tmp117_ = g_strdup (_tmp116_);
	_vala_array_add28 (&args, &args_length1, &_args_size_, _tmp117_);
	if (HAVE_IBUS_XKB) {
		gchar** _tmp118_;
		gint _tmp118__length1;
		gchar* _tmp119_;
		gchar** _tmp120_;
		gint _tmp120__length1;
		const gchar* _tmp121_;
		gchar* _tmp122_;
		const gchar* _tmp123_;
		const gchar* _tmp129_;
		_tmp118_ = args;
		_tmp118__length1 = args_length1;
		_tmp119_ = g_strdup ("--layout");
		_vala_array_add29 (&args, &args_length1, &_args_size_, _tmp119_);
		_tmp120_ = args;
		_tmp120__length1 = args_length1;
		_tmp121_ = layout;
		_tmp122_ = g_strdup (_tmp121_);
		_vala_array_add30 (&args, &args_length1, &_args_size_, _tmp122_);
		_tmp123_ = variant;
		if (_tmp123_ != NULL) {
			gchar** _tmp124_;
			gint _tmp124__length1;
			gchar* _tmp125_;
			gchar** _tmp126_;
			gint _tmp126__length1;
			const gchar* _tmp127_;
			gchar* _tmp128_;
			_tmp124_ = args;
			_tmp124__length1 = args_length1;
			_tmp125_ = g_strdup ("--variant");
			_vala_array_add31 (&args, &args_length1, &_args_size_, _tmp125_);
			_tmp126_ = args;
			_tmp126__length1 = args_length1;
			_tmp127_ = variant;
			_tmp128_ = g_strdup (_tmp127_);
			_vala_array_add32 (&args, &args_length1, &_args_size_, _tmp128_);
		}
		_tmp129_ = option;
		if (_tmp129_ != NULL) {
			gchar** _tmp130_;
			gint _tmp130__length1;
			gchar* _tmp131_;
			gchar** _tmp132_;
			gint _tmp132__length1;
			const gchar* _tmp133_;
			gchar* _tmp134_;
			_tmp130_ = args;
			_tmp130__length1 = args_length1;
			_tmp131_ = g_strdup ("--option");
			_vala_array_add33 (&args, &args_length1, &_args_size_, _tmp131_);
			_tmp132_ = args;
			_tmp132__length1 = args_length1;
			_tmp133_ = option;
			_tmp134_ = g_strdup (_tmp133_);
			_vala_array_add34 (&args, &args_length1, &_args_size_, _tmp134_);
		}
	} else {
		gchar** _tmp135_;
		gint _tmp135__length1;
		const gchar* _tmp136_;
		gchar* _tmp137_;
		const gchar* _tmp138_;
		const gchar* _tmp142_;
		_tmp135_ = args;
		_tmp135__length1 = args_length1;
		_tmp136_ = layout;
		_tmp137_ = g_strdup (_tmp136_);
		_vala_array_add35 (&args, &args_length1, &_args_size_, _tmp137_);
		_tmp138_ = variant;
		if (_tmp138_ != NULL) {
			gchar** _tmp139_;
			gint _tmp139__length1;
			const gchar* _tmp140_;
			gchar* _tmp141_;
			_tmp139_ = args;
			_tmp139__length1 = args_length1;
			_tmp140_ = variant;
			_tmp141_ = g_strdup (_tmp140_);
			_vala_array_add36 (&args, &args_length1, &_args_size_, _tmp141_);
		}
		_tmp142_ = option;
		if (_tmp142_ != NULL) {
			gchar** _tmp143_;
			gint _tmp143__length1;
			const gchar* _tmp144_;
			gchar* _tmp145_;
			_tmp143_ = args;
			_tmp143__length1 = args_length1;
			_tmp144_ = option;
			_tmp145_ = g_strdup (_tmp144_);
			_vala_array_add37 (&args, &args_length1, &_args_size_, _tmp145_);
		}
	}
	{
		gchar** _tmp146_;
		gint _tmp146__length1;
		GPid _tmp147_ = 0;
		_tmp146_ = args;
		_tmp146__length1 = args_length1;
		g_spawn_async (NULL, _tmp146_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp147_, &_inner_error_);
		child_pid = _tmp147_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch5_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally5;
	__catch5_g_spawn_error:
	{
		GError* err = NULL;
		FILE* _tmp148_;
		GError* _tmp149_;
		const gchar* _tmp150_;
		gint* _tmp151_ = NULL;
		gint* _tmp152_;
		gint _tmp152__length1;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp148_ = stderr;
		_tmp149_ = err;
		_tmp150_ = _tmp149_->message;
		fprintf (_tmp148_, "IBUS_ERROR: %s\n", _tmp150_);
		_tmp151_ = g_new0 (gint, 2);
		_tmp151_[0] = -1;
		_tmp151_[1] = 0;
		_tmp152_ = _tmp151_;
		_tmp152__length1 = 2;
		if (result_length1) {
			*result_length1 = _tmp152__length1;
		}
		result = _tmp152_;
		_g_error_free0 (err);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp153_ = child_pid;
	self->priv->m_xkb_pid = _tmp153_;
	_tmp154_ = self->priv->m_xkb_pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp154_, _xkb_layout_set_layout_cb_gchild_watch_func, xkb_layout_ref (self), xkb_layout_unref);
	_tmp155_ = xkb_group_id;
	_tmp156_ = changed_option;
	_tmp157_ = g_new0 (gint, 2);
	_tmp157_[0] = _tmp155_;
	_tmp157_[1] = _tmp156_;
	_tmp158_ = _tmp157_;
	_tmp158__length1 = 2;
	if (result_length1) {
		*result_length1 = _tmp158__length1;
	}
	result = _tmp158_;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
	return result;
}


static void _xkb_layout_set_xmodmap_cb_gchild_watch_func (GPid pid, gint status, gpointer self) {
	xkb_layout_set_xmodmap_cb (self, pid, status);
}


void xkb_layout_set_xmodmap (XKBLayout* self) {
	gboolean _tmp0_;
	GPid _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* xmodmap_cmdpath;
	const gchar* _tmp4_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* homedir;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_use_xmodmap;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->m_xmodmap_pid;
	if (_tmp1_ != ((GPid) (-1))) {
		return;
	}
	_tmp2_ = self->priv->m_xmodmap_command;
	_tmp3_ = xkb_layout_get_fullpath (self, _tmp2_);
	xmodmap_cmdpath = _tmp3_;
	_tmp4_ = xmodmap_cmdpath;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->priv->m_xmodmap_command;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (xmodmap_cmdpath);
		xmodmap_cmdpath = _tmp6_;
	}
	_tmp7_ = g_get_home_dir ();
	_tmp8_ = g_strdup (_tmp7_);
	homedir = _tmp8_;
	_tmp9_ = self->priv->m_xmodmap_known_files;
	_tmp9__length1 = self->priv->m_xmodmap_known_files_length1;
	{
		gchar** xmodmap_file_collection = NULL;
		gint xmodmap_file_collection_length1 = 0;
		gint _xmodmap_file_collection_size_ = 0;
		gint xmodmap_file_it = 0;
		xmodmap_file_collection = _tmp9_;
		xmodmap_file_collection_length1 = _tmp9__length1;
		for (xmodmap_file_it = 0; xmodmap_file_it < _tmp9__length1; xmodmap_file_it = xmodmap_file_it + 1) {
			gchar* _tmp10_;
			gchar* xmodmap_file = NULL;
			_tmp10_ = g_strdup (xmodmap_file_collection[xmodmap_file_it]);
			xmodmap_file = _tmp10_;
			{
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* xmodmap_filepath;
				const gchar* _tmp14_;
				gboolean _tmp15_ = FALSE;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar** _tmp20_ = NULL;
				gchar** args;
				gint args_length1;
				gint _args_size_;
				GPid child_pid = 0;
				GPid _tmp26_;
				GPid _tmp27_;
				_tmp11_ = homedir;
				_tmp12_ = xmodmap_file;
				_tmp13_ = g_build_filename (_tmp11_, _tmp12_, NULL);
				xmodmap_filepath = _tmp13_;
				_tmp14_ = xmodmap_filepath;
				_tmp15_ = g_file_test (_tmp14_, G_FILE_TEST_EXISTS);
				if (!_tmp15_) {
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					continue;
				}
				_tmp16_ = xmodmap_cmdpath;
				_tmp17_ = g_strdup (_tmp16_);
				_tmp18_ = xmodmap_filepath;
				_tmp19_ = g_strdup (_tmp18_);
				_tmp20_ = g_new0 (gchar*, 2 + 1);
				_tmp20_[0] = _tmp17_;
				_tmp20_[1] = _tmp19_;
				args = _tmp20_;
				args_length1 = 2;
				_args_size_ = args_length1;
				{
					gchar** _tmp21_;
					gint _tmp21__length1;
					GPid _tmp22_ = 0;
					_tmp21_ = args;
					_tmp21__length1 = args_length1;
					g_spawn_async (NULL, _tmp21_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp22_, &_inner_error_);
					child_pid = _tmp22_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_SPAWN_ERROR) {
							goto __catch6_g_spawn_error;
						}
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (xmodmap_filepath);
						_g_free0 (xmodmap_file);
						_g_free0 (homedir);
						_g_free0 (xmodmap_cmdpath);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				goto __finally6;
				__catch6_g_spawn_error:
				{
					GError* err = NULL;
					FILE* _tmp23_;
					GError* _tmp24_;
					const gchar* _tmp25_;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp23_ = stderr;
					_tmp24_ = err;
					_tmp25_ = _tmp24_->message;
					fprintf (_tmp23_, "IBUS_ERROR: %s\n", _tmp25_);
					_g_error_free0 (err);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					_g_free0 (homedir);
					_g_free0 (xmodmap_cmdpath);
					return;
				}
				__finally6:
				if (_inner_error_ != NULL) {
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					_g_free0 (homedir);
					_g_free0 (xmodmap_cmdpath);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp26_ = child_pid;
				self->priv->m_xmodmap_pid = _tmp26_;
				_tmp27_ = self->priv->m_xmodmap_pid;
				g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp27_, _xkb_layout_set_xmodmap_cb_gchild_watch_func, xkb_layout_ref (self), xkb_layout_unref);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (xmodmap_filepath);
				_g_free0 (xmodmap_file);
				break;
			}
		}
	}
	_g_free0 (homedir);
	_g_free0 (xmodmap_cmdpath);
}


void xkb_layout_reset_layout (XKBLayout* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = xkb_layout_get_layout (self);
	_g_free0 (self->priv->m_default_layout);
	self->priv->m_default_layout = _tmp0_;
	_tmp1_ = xkb_layout_get_variant (self);
	_g_free0 (self->priv->m_default_variant);
	self->priv->m_default_variant = _tmp1_;
	_tmp2_ = xkb_layout_get_option (self);
	_g_free0 (self->priv->m_default_option);
	self->priv->m_default_option = _tmp2_;
}


static void value_xkb_layout_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_xkb_layout_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		xkb_layout_unref (value->data[0].v_pointer);
	}
}


static void value_xkb_layout_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = xkb_layout_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_xkb_layout_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_xkb_layout_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		XKBLayout* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = xkb_layout_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_xkb_layout_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	XKBLayout** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = xkb_layout_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_xkb_layout (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecXKBLayout* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_XKB_LAYOUT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_xkb_layout (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT), NULL);
	return value->data[0].v_pointer;
}


void value_set_xkb_layout (GValue* value, gpointer v_object) {
	XKBLayout* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_XKB_LAYOUT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		xkb_layout_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xkb_layout_unref (old);
	}
}


void value_take_xkb_layout (GValue* value, gpointer v_object) {
	XKBLayout* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_XKB_LAYOUT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xkb_layout_unref (old);
	}
}


static void xkb_layout_class_init (XKBLayoutClass * klass) {
	xkb_layout_parent_class = g_type_class_peek_parent (klass);
	XKB_LAYOUT_CLASS (klass)->finalize = xkb_layout_finalize;
	g_type_class_add_private (klass, sizeof (XKBLayoutPrivate));
}


static void xkb_layout_instance_init (XKBLayout * self) {
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	self->priv = XKB_LAYOUT_GET_PRIVATE (self);
	_tmp0_ = g_strdup (IBUS_XKB_COMMAND);
	self->priv->m_xkb_command = _tmp0_;
	self->priv->m_config = NULL;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_xkb_latin_layouts = _tmp1_;
	self->priv->m_xkb_latin_layouts_length1 = 0;
	self->priv->_m_xkb_latin_layouts_size_ = self->priv->m_xkb_latin_layouts_length1;
	self->priv->m_xkb_pid = (GPid) (-1);
	self->priv->m_xmodmap_pid = (GPid) (-1);
	_tmp2_ = g_strdup ("xmodmap");
	self->priv->m_xmodmap_command = _tmp2_;
	self->priv->m_use_xmodmap = TRUE;
	_tmp3_ = g_strdup (".xmodmap");
	_tmp4_ = g_strdup (".xmodmaprc");
	_tmp5_ = g_strdup (".Xmodmap");
	_tmp6_ = g_strdup (".Xmodmaprc");
	_tmp7_ = g_new0 (gchar*, 4 + 1);
	_tmp7_[0] = _tmp3_;
	_tmp7_[1] = _tmp4_;
	_tmp7_[2] = _tmp5_;
	_tmp7_[3] = _tmp6_;
	self->priv->m_xmodmap_known_files = _tmp7_;
	self->priv->m_xmodmap_known_files_length1 = 4;
	self->priv->_m_xmodmap_known_files_size_ = self->priv->m_xmodmap_known_files_length1;
	_tmp8_ = g_strdup ("");
	self->priv->m_default_layout = _tmp8_;
	_tmp9_ = g_strdup ("");
	self->priv->m_default_variant = _tmp9_;
	_tmp10_ = g_strdup ("");
	self->priv->m_default_option = _tmp10_;
	self->ref_count = 1;
}


static void xkb_layout_finalize (XKBLayout* obj) {
	XKBLayout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_XKB_LAYOUT, XKBLayout);
	_g_free0 (self->priv->m_xkb_command);
	_g_object_unref0 (self->priv->m_config);
	self->priv->m_xkb_latin_layouts = (_vala_array_free (self->priv->m_xkb_latin_layouts, self->priv->m_xkb_latin_layouts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->m_xmodmap_command);
	self->priv->m_xmodmap_known_files = (_vala_array_free (self->priv->m_xmodmap_known_files, self->priv->m_xmodmap_known_files_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->m_default_layout);
	_g_free0 (self->priv->m_default_variant);
	_g_free0 (self->priv->m_default_option);
}


GType xkb_layout_get_type (void) {
	static volatile gsize xkb_layout_type_id__volatile = 0;
	if (g_once_init_enter (&xkb_layout_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_xkb_layout_init, value_xkb_layout_free_value, value_xkb_layout_copy_value, value_xkb_layout_peek_pointer, "p", value_xkb_layout_collect_value, "p", value_xkb_layout_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (XKBLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xkb_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XKBLayout), 0, (GInstanceInitFunc) xkb_layout_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType xkb_layout_type_id;
		xkb_layout_type_id = g_type_register_fundamental (g_type_fundamental_next (), "XKBLayout", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&xkb_layout_type_id__volatile, xkb_layout_type_id);
	}
	return xkb_layout_type_id__volatile;
}


gpointer xkb_layout_ref (gpointer instance) {
	XKBLayout* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void xkb_layout_unref (gpointer instance) {
	XKBLayout* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		XKB_LAYOUT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



