/* BackendOpenstack.c generated by valac 0.30.2, the Vala compiler
 * generated from BackendOpenstack.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libsecret/secret.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_TOOL_JOB_TYPE_MODE (deja_dup_tool_job_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_OPENSTACK (deja_dup_backend_openstack_get_type ())
#define DEJA_DUP_BACKEND_OPENSTACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_OPENSTACK, DejaDupBackendOpenstack))
#define DEJA_DUP_BACKEND_OPENSTACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_OPENSTACK, DejaDupBackendOpenstackClass))
#define DEJA_DUP_IS_BACKEND_OPENSTACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_OPENSTACK))
#define DEJA_DUP_IS_BACKEND_OPENSTACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_OPENSTACK))
#define DEJA_DUP_BACKEND_OPENSTACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_OPENSTACK, DejaDupBackendOpenstackClass))

typedef struct _DejaDupBackendOpenstack DejaDupBackendOpenstack;
typedef struct _DejaDupBackendOpenstackClass DejaDupBackendOpenstackClass;
typedef struct _DejaDupBackendOpenstackPrivate DejaDupBackendOpenstackPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_CHECKER (deja_dup_checker_get_type ())
#define DEJA_DUP_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupChecker))
#define DEJA_DUP_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))
#define DEJA_DUP_IS_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_IS_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))

typedef struct _DejaDupChecker DejaDupChecker;
typedef struct _DejaDupCheckerClass DejaDupCheckerClass;

#define DEJA_DUP_TYPE_PYTHON_CHECKER (deja_dup_python_checker_get_type ())
#define DEJA_DUP_PYTHON_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonChecker))
#define DEJA_DUP_PYTHON_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonCheckerClass))
#define DEJA_DUP_IS_PYTHON_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER))
#define DEJA_DUP_IS_PYTHON_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_PYTHON_CHECKER))
#define DEJA_DUP_PYTHON_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonCheckerClass))

typedef struct _DejaDupPythonChecker DejaDupPythonChecker;
typedef struct _DejaDupPythonCheckerClass DejaDupPythonCheckerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DEJA_DUP_TYPE_FILTERED_SETTINGS (deja_dup_filtered_settings_get_type ())
#define DEJA_DUP_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettings))
#define DEJA_DUP_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))
#define DEJA_DUP_IS_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_IS_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_FILTERED_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))

typedef struct _DejaDupFilteredSettings DejaDupFilteredSettings;
typedef struct _DejaDupFilteredSettingsClass DejaDupFilteredSettingsClass;

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
typedef struct _DejaDupBackendOpenstackIsReadyData DejaDupBackendOpenstackIsReadyData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendOpenstackGetEnvpData DejaDupBackendOpenstackGetEnvpData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _DejaDupBackendOpenstackGotPasswordReplyData DejaDupBackendOpenstackGotPasswordReplyData;

typedef enum  {
	DEJA_DUP_TOOL_JOB_MODE_INVALID,
	DEJA_DUP_TOOL_JOB_MODE_BACKUP,
	DEJA_DUP_TOOL_JOB_MODE_RESTORE,
	DEJA_DUP_TOOL_JOB_MODE_STATUS,
	DEJA_DUP_TOOL_JOB_MODE_LIST,
	DEJA_DUP_TOOL_JOB_MODE_HISTORY
} DejaDupToolJobMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, gboolean* as_root);
	gchar* (*get_location_pretty) (DejaDupBackend* self);
	void (*is_ready) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*is_ready_finish) (DejaDupBackend* self, GAsyncResult* _res_, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendOpenstack {
	DejaDupBackend parent_instance;
	DejaDupBackendOpenstackPrivate * priv;
};

struct _DejaDupBackendOpenstackClass {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendOpenstackPrivate {
	gchar* settings_id;
	gchar* id;
	gchar* secret_key;
};

struct _DejaDupBackendOpenstackIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendOpenstack* self;
	gchar* when;
	gboolean result;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp0_;
	gchar* authurl;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	DejaDupNetwork* _tmp4_;
	DejaDupNetwork* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
};

struct _DejaDupBackendOpenstackGetEnvpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendOpenstack* self;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp0_;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* authurl;
	DejaDupFilteredSettings* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	SecretSchema* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	GError* e;
	GError * _inner_error_;
};

struct _DejaDupBackendOpenstackGotPasswordReplyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendOpenstack* self;
	GMountOperation* mount_op;
	GMountOperationResult _result_;
	GMountOperationResult _tmp0_;
	GList* _tmp1_;
	const gchar* _tmp2_;
	GMountOperation* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GMountOperation* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GPasswordSave remember;
	GMountOperation* _tmp11_;
	GPasswordSave _tmp12_;
	GPasswordSave _tmp13_;
	GPasswordSave _tmp14_;
	const gchar* _tmp15_;
	GPasswordSave _tmp16_;
	gchar* where;
	gchar* _tmp17_;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp18_;
	gchar* authurl;
	DejaDupFilteredSettings* _tmp19_;
	gchar* _tmp20_;
	gchar* tenant;
	DejaDupFilteredSettings* _tmp21_;
	gchar* _tmp22_;
	SecretSchema* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GError* e;
	GError* _tmp33_;
	const gchar* _tmp34_;
	GError * _inner_error_;
};


static gpointer deja_dup_backend_openstack_parent_class = NULL;

#define DEJA_DUP_OPENSTACK_ROOT "OpenStack"
#define DEJA_DUP_OPENSTACK_USERNAME_KEY "username"
#define DEJA_DUP_OPENSTACK_CONTAINER_KEY "container"
#define DEJA_DUP_OPENSTACK_TENANT_KEY "tenant"
#define DEJA_DUP_OPENSTACK_AUTHURL_KEY "authurl"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_tool_job_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_openstack_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_BACKEND_OPENSTACK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_OPENSTACK, DejaDupBackendOpenstackPrivate))
enum  {
	DEJA_DUP_BACKEND_OPENSTACK_DUMMY_PROPERTY
};
GType deja_dup_checker_get_type (void) G_GNUC_CONST;
DejaDupChecker* deja_dup_backend_openstack_get_checker (void);
GType deja_dup_python_checker_get_type (void) G_GNUC_CONST;
DejaDupPythonChecker* deja_dup_python_checker_get_checker (const gchar* module);
static DejaDupBackend* deja_dup_backend_openstack_real_clone (DejaDupBackend* base);
DejaDupBackendOpenstack* deja_dup_backend_openstack_new (void);
DejaDupBackendOpenstack* deja_dup_backend_openstack_construct (GType object_type);
static gboolean deja_dup_backend_openstack_real_is_native (DejaDupBackend* base);
static GIcon* deja_dup_backend_openstack_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_openstack_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_openstack_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_openstack_real_is_ready_co (DejaDupBackendOpenstackIsReadyData* _data_);
GType deja_dup_filtered_settings_get_type (void) G_GNUC_CONST;
DejaDupFilteredSettings* deja_dup_get_settings (const gchar* subdir);
gchar* deja_dup_get_folder_key (DejaDupFilteredSettings* settings, const gchar* key);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
void deja_dup_network_can_reach (DejaDupNetwork* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean deja_dup_network_can_reach_finish (DejaDupNetwork* self, GAsyncResult* _res_);
static void deja_dup_backend_openstack_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* deja_dup_backend_openstack_real_get_location (DejaDupBackend* base, gboolean* as_root);
void deja_dup_filtered_settings_set_string (DejaDupFilteredSettings* self, const gchar* k, const gchar* v);
static gchar* deja_dup_backend_openstack_real_get_location_pretty (DejaDupBackend* base);
static void deja_dup_backend_openstack_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_openstack_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_openstack_real_get_envp_co (DejaDupBackendOpenstackGetEnvpData* _data_);
static void deja_dup_backend_openstack_got_secret_key (DejaDupBackendOpenstack* self);
static void deja_dup_backend_openstack_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_backend_openstack_ask_password (DejaDupBackendOpenstack* self);
static void deja_dup_backend_openstack_got_password_reply_data_free (gpointer _data);
static void deja_dup_backend_openstack_got_password_reply (DejaDupBackendOpenstack* self, GMountOperation* mount_op, GMountOperationResult _result_, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_openstack_got_password_reply_finish (DejaDupBackendOpenstack* self, GAsyncResult* _res_);
static gboolean deja_dup_backend_openstack_got_password_reply_co (DejaDupBackendOpenstackGotPasswordReplyData* _data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void deja_dup_backend_openstack_got_password_reply_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void _deja_dup_backend_openstack_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static void deja_dup_backend_openstack_finalize (GObject* obj);


DejaDupChecker* deja_dup_backend_openstack_get_checker (void) {
	DejaDupChecker* result = NULL;
	DejaDupPythonChecker* _tmp0_ = NULL;
	_tmp0_ = deja_dup_python_checker_get_checker ("swiftclient");
	result = (DejaDupChecker*) _tmp0_;
	return result;
}


static DejaDupBackend* deja_dup_backend_openstack_real_clone (DejaDupBackend* base) {
	DejaDupBackendOpenstack * self;
	DejaDupBackend* result = NULL;
	DejaDupBackendOpenstack* _tmp0_ = NULL;
	self = (DejaDupBackendOpenstack*) base;
	_tmp0_ = deja_dup_backend_openstack_new ();
	result = (DejaDupBackend*) _tmp0_;
	return result;
}


static gboolean deja_dup_backend_openstack_real_is_native (DejaDupBackend* base) {
	DejaDupBackendOpenstack * self;
	gboolean result = FALSE;
	self = (DejaDupBackendOpenstack*) base;
	result = FALSE;
	return result;
}


static GIcon* deja_dup_backend_openstack_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendOpenstack * self;
	GIcon* result = NULL;
	GThemedIcon* _tmp0_ = NULL;
	self = (DejaDupBackendOpenstack*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-cloud");
	result = (GIcon*) _tmp0_;
	return result;
}


static void deja_dup_backend_openstack_real_is_ready_data_free (gpointer _data) {
	DejaDupBackendOpenstackIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOpenstackIsReadyData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_backend_openstack_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendOpenstack * self;
	DejaDupBackendOpenstackIsReadyData* _data_;
	DejaDupBackendOpenstack* _tmp0_ = NULL;
	self = (DejaDupBackendOpenstack*) base;
	_data_ = g_slice_new0 (DejaDupBackendOpenstackIsReadyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_openstack_real_is_ready);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_openstack_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_openstack_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_openstack_real_is_ready_finish (DejaDupBackend* base, GAsyncResult* _res_, gchar** when) {
	gboolean result;
	DejaDupBackendOpenstackIsReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (when) {
		*when = _data_->when;
	} else {
		_g_free0 (_data_->when);
	}
	_data_->when = NULL;
	result = _data_->result;
	return result;
}


static void deja_dup_backend_openstack_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendOpenstackIsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_openstack_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_openstack_real_is_ready_co (DejaDupBackendOpenstackIsReadyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_get_settings (DEJA_DUP_OPENSTACK_ROOT);
	_data_->settings = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = deja_dup_get_folder_key (_data_->settings, DEJA_DUP_OPENSTACK_AUTHURL_KEY);
	_data_->authurl = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _ ("Backup will begin when a network connection becomes available.");
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_g_free0 (_data_->when);
	_data_->when = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = deja_dup_network_get ();
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_state_ = 1;
	deja_dup_network_can_reach (_data_->_tmp5_, _data_->authurl, deja_dup_backend_openstack_is_ready_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = deja_dup_network_can_reach_finish (_data_->_tmp5_, _data_->_res_);
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_object_unref0 (_data_->_tmp5_);
	_data_->result = _data_->_tmp7_;
	_g_free0 (_data_->authurl);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->authurl);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* deja_dup_backend_openstack_real_get_location (DejaDupBackend* base, gboolean* as_root) {
	DejaDupBackendOpenstack * self;
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* container = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	self = (DejaDupBackendOpenstack*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_OPENSTACK_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = deja_dup_get_folder_key (_tmp1_, DEJA_DUP_OPENSTACK_CONTAINER_KEY);
	container = _tmp2_;
	_tmp3_ = container;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		DejaDupFilteredSettings* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp4_ = g_get_host_name ();
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (container);
		container = _tmp5_;
		_tmp6_ = settings;
		_tmp7_ = container;
		deja_dup_filtered_settings_set_string (_tmp6_, DEJA_DUP_OPENSTACK_CONTAINER_KEY, _tmp7_);
	}
	_tmp8_ = container;
	_tmp9_ = g_strdup_printf ("swift://%s", _tmp8_);
	result = _tmp9_;
	_g_free0 (container);
	_g_object_unref0 (settings);
	return result;
}


static gchar* deja_dup_backend_openstack_real_get_location_pretty (DejaDupBackend* base) {
	DejaDupBackendOpenstack * self;
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* container = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	self = (DejaDupBackendOpenstack*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_OPENSTACK_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_OPENSTACK_CONTAINER_KEY);
	container = _tmp2_;
	_tmp3_ = container;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = _ ("OpenStack Swift");
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_free0 (container);
		_g_object_unref0 (settings);
		return result;
	} else {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = _ ("%s on OpenStack Swift");
		_tmp7_ = container;
		_tmp8_ = g_strdup_printf (_tmp6_, _tmp7_);
		result = _tmp8_;
		_g_free0 (container);
		_g_object_unref0 (settings);
		return result;
	}
	_g_free0 (container);
	_g_object_unref0 (settings);
}


static void deja_dup_backend_openstack_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendOpenstackGetEnvpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOpenstackGetEnvpData, _data_);
}


static void deja_dup_backend_openstack_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendOpenstack * self;
	DejaDupBackendOpenstackGetEnvpData* _data_;
	DejaDupBackendOpenstack* _tmp0_ = NULL;
	self = (DejaDupBackendOpenstack*) base;
	_data_ = g_slice_new0 (DejaDupBackendOpenstackGetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_openstack_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_openstack_real_get_envp_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_openstack_real_get_envp_co (_data_);
}


static void deja_dup_backend_openstack_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendOpenstackGetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_openstack_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendOpenstackGetEnvpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_openstack_real_get_envp_co (_data_);
}


static gboolean deja_dup_backend_openstack_real_get_envp_co (DejaDupBackendOpenstackGetEnvpData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_get_settings (DEJA_DUP_OPENSTACK_ROOT);
	_data_->settings = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->settings;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_settings_get_string ((GSettings*) _data_->_tmp1_, DEJA_DUP_OPENSTACK_USERNAME_KEY);
	_g_free0 (_data_->self->priv->settings_id);
	_data_->self->priv->settings_id = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->settings_id;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp3_ = "";
	} else {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->settings_id;
		_data_->_tmp3_ = _data_->_tmp5_;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup (_data_->_tmp3_);
	_g_free0 (_data_->self->priv->id);
	_data_->self->priv->id = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->settings;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_settings_get_string ((GSettings*) _data_->_tmp7_, DEJA_DUP_OPENSTACK_AUTHURL_KEY);
	_data_->authurl = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->id;
	if (g_strcmp0 (_data_->_tmp10_, "") != 0) {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->self->priv->secret_key;
		_data_->_tmp9_ = _data_->_tmp11_ != NULL;
	} else {
		_data_->_tmp9_ = FALSE;
	}
	if (_data_->_tmp9_) {
		deja_dup_backend_openstack_got_secret_key (_data_->self);
		_g_free0 (_data_->authurl);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->self->priv->id;
	if (g_strcmp0 (_data_->_tmp12_, "") != 0) {
		{
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = SECRET_SCHEMA_COMPAT_NETWORK;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->self->priv->id;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->authurl;
			_data_->_state_ = 1;
			secret_password_lookup (_data_->_tmp14_, NULL, deja_dup_backend_openstack_get_envp_ready, _data_, "user", _data_->_tmp15_, "server", _data_->_tmp16_, "protocol", "https", NULL);
			return FALSE;
			_state_1:
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = secret_password_lookup_finish (_data_->_res_, &_data_->_inner_error_);
			_data_->_tmp13_ = _data_->_tmp17_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch15_g_error;
			}
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->_tmp13_;
			_data_->_tmp13_ = NULL;
			_g_free0 (_data_->self->priv->secret_key);
			_data_->self->priv->secret_key = _data_->_tmp18_;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->self->priv->secret_key;
			if (_data_->_tmp19_ != NULL) {
				deja_dup_backend_openstack_got_secret_key (_data_->self);
				_g_free0 (_data_->_tmp13_);
				_g_free0 (_data_->authurl);
				_g_object_unref0 (_data_->settings);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->_tmp13_);
		}
		goto __finally15;
		__catch15_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->e);
		}
		__finally15:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->authurl);
			_g_object_unref0 (_data_->settings);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	deja_dup_backend_openstack_ask_password (_data_->self);
	_g_free0 (_data_->authurl);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_openstack_got_password_reply_data_free (gpointer _data) {
	DejaDupBackendOpenstackGotPasswordReplyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mount_op);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOpenstackGotPasswordReplyData, _data_);
}


static void deja_dup_backend_openstack_got_password_reply (DejaDupBackendOpenstack* self, GMountOperation* mount_op, GMountOperationResult _result_, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendOpenstackGotPasswordReplyData* _data_;
	DejaDupBackendOpenstack* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	GMountOperation* _tmp2_ = NULL;
	GMountOperationResult _tmp3_ = 0;
	_data_ = g_slice_new0 (DejaDupBackendOpenstackGotPasswordReplyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_openstack_got_password_reply);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_openstack_got_password_reply_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = mount_op;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->mount_op);
	_data_->mount_op = _tmp2_;
	_tmp3_ = _result_;
	_data_->_result_ = _tmp3_;
	deja_dup_backend_openstack_got_password_reply_co (_data_);
}


static void deja_dup_backend_openstack_got_password_reply_finish (DejaDupBackendOpenstack* self, GAsyncResult* _res_) {
	DejaDupBackendOpenstackGotPasswordReplyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void deja_dup_backend_openstack_got_password_reply_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendOpenstackGotPasswordReplyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_openstack_got_password_reply_co (_data_);
}


static gboolean deja_dup_backend_openstack_got_password_reply_co (DejaDupBackendOpenstackGotPasswordReplyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _data_->_result_;
	if (_data_->_tmp0_ != G_MOUNT_OPERATION_HANDLED) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = NULL;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _ ("Permission denied");
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "envp-ready", FALSE, _data_->_tmp1_, _data_->_tmp2_);
		__g_list_free__g_free0_0 (_data_->_tmp1_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->mount_op;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_mount_operation_get_username (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_g_free0 (_data_->self->priv->id);
	_data_->self->priv->id = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->mount_op;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_mount_operation_get_password (_data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
	_g_free0 (_data_->self->priv->secret_key);
	_data_->self->priv->secret_key = _data_->_tmp10_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->mount_op;
	_data_->_tmp12_ = 0;
	_data_->_tmp12_ = g_mount_operation_get_password_save (_data_->_tmp11_);
	_data_->_tmp13_ = 0;
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->remember = _data_->_tmp13_;
	_data_->_tmp14_ = 0;
	_data_->_tmp14_ = _data_->remember;
	if (_data_->_tmp14_ != G_PASSWORD_SAVE_NEVER) {
		_data_->_tmp16_ = 0;
		_data_->_tmp16_ = _data_->remember;
		if (_data_->_tmp16_ == G_PASSWORD_SAVE_FOR_SESSION) {
			_data_->_tmp15_ = SECRET_COLLECTION_SESSION;
		} else {
			_data_->_tmp15_ = SECRET_COLLECTION_DEFAULT;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup (_data_->_tmp15_);
		_data_->where = _data_->_tmp17_;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = deja_dup_get_settings (DEJA_DUP_OPENSTACK_ROOT);
		_data_->settings = _data_->_tmp18_;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->settings;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = deja_dup_get_folder_key (_data_->_tmp19_, DEJA_DUP_OPENSTACK_AUTHURL_KEY);
		_data_->authurl = _data_->_tmp20_;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->settings;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = deja_dup_get_folder_key (_data_->_tmp21_, DEJA_DUP_OPENSTACK_TENANT_KEY);
		_data_->tenant = _data_->_tmp22_;
		{
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = SECRET_SCHEMA_COMPAT_NETWORK;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->where;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->tenant;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->self->priv->id;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->authurl;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = g_strdup_printf ("%s:%s@%s", _data_->_tmp25_, _data_->_tmp26_, _data_->_tmp27_);
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->self->priv->secret_key;
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = _data_->self->priv->id;
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = _data_->authurl;
			_data_->_state_ = 1;
			secret_password_store (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp29_, _data_->_tmp30_, NULL, deja_dup_backend_openstack_got_password_reply_ready, _data_, "user", _data_->_tmp31_, "server", _data_->_tmp32_, "protocol", "https", NULL);
			return FALSE;
			_state_1:
			secret_password_store_finish (_data_->_res_, &_data_->_inner_error_);
			_g_free0 (_data_->_tmp29_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch16_g_error;
			}
		}
		goto __finally16;
		__catch16_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = _data_->e;
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = _data_->_tmp33_->message;
			g_warning ("BackendOpenstack.vala:147: %s\n", _data_->_tmp34_);
			_g_error_free0 (_data_->e);
		}
		__finally16:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->tenant);
			_g_free0 (_data_->authurl);
			_g_object_unref0 (_data_->settings);
			_g_free0 (_data_->where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_free0 (_data_->tenant);
		_g_free0 (_data_->authurl);
		_g_object_unref0 (_data_->settings);
		_g_free0 (_data_->where);
	}
	deja_dup_backend_openstack_got_secret_key (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _deja_dup_backend_openstack_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	deja_dup_backend_openstack_got_password_reply ((DejaDupBackendOpenstack*) self, _sender, _result_, NULL, NULL);
}


static void deja_dup_backend_openstack_ask_password (DejaDupBackendOpenstack* self) {
	GMountOperation* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	GMountOperation* _tmp2_ = NULL;
	GMountOperation* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "reply", (GCallback) _deja_dup_backend_openstack_got_password_reply_g_mount_operation_reply, self, 0);
	_tmp2_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->id;
	g_signal_emit_by_name (_tmp3_, "ask-password", "", _tmp4_, "", (G_ASK_PASSWORD_NEED_PASSWORD | G_ASK_PASSWORD_NEED_USERNAME) | G_ASK_PASSWORD_SAVING_SUPPORTED);
}


static void deja_dup_backend_openstack_got_secret_key (DejaDupBackendOpenstack* self) {
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* tenantName = NULL;
	DejaDupFilteredSettings* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* authurl = NULL;
	DejaDupFilteredSettings* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GList* envp = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_OPENSTACK_ROOT);
	settings = _tmp0_;
	_tmp1_ = self->priv->id;
	_tmp2_ = self->priv->settings_id;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		DejaDupFilteredSettings* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = settings;
		_tmp4_ = self->priv->id;
		deja_dup_filtered_settings_set_string (_tmp3_, DEJA_DUP_OPENSTACK_USERNAME_KEY, _tmp4_);
	}
	_tmp5_ = settings;
	_tmp6_ = g_settings_get_string ((GSettings*) _tmp5_, DEJA_DUP_OPENSTACK_TENANT_KEY);
	tenantName = _tmp6_;
	_tmp7_ = settings;
	_tmp8_ = g_settings_get_string ((GSettings*) _tmp7_, DEJA_DUP_OPENSTACK_AUTHURL_KEY);
	authurl = _tmp8_;
	envp = NULL;
	_tmp9_ = g_strdup_printf ("SWIFT_TENANTNAME=%s", tenantName);
	envp = g_list_append (envp, _tmp9_);
	_tmp10_ = g_strdup_printf ("SWIFT_AUTHURL=%s", authurl);
	envp = g_list_append (envp, _tmp10_);
	_tmp11_ = self->priv->id;
	_tmp12_ = g_strdup_printf ("SWIFT_USERNAME=%s", _tmp11_);
	envp = g_list_append (envp, _tmp12_);
	_tmp13_ = self->priv->secret_key;
	_tmp14_ = g_strdup_printf ("SWIFT_PASSWORD=%s", _tmp13_);
	envp = g_list_append (envp, _tmp14_);
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp, NULL);
	__g_list_free__g_free0_0 (envp);
	_g_free0 (authurl);
	_g_free0 (tenantName);
	_g_object_unref0 (settings);
}


DejaDupBackendOpenstack* deja_dup_backend_openstack_construct (GType object_type) {
	DejaDupBackendOpenstack * self = NULL;
	self = (DejaDupBackendOpenstack*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendOpenstack* deja_dup_backend_openstack_new (void) {
	return deja_dup_backend_openstack_construct (DEJA_DUP_TYPE_BACKEND_OPENSTACK);
}


static void deja_dup_backend_openstack_class_init (DejaDupBackendOpenstackClass * klass) {
	deja_dup_backend_openstack_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendOpenstackPrivate));
	((DejaDupBackendClass *) klass)->clone = deja_dup_backend_openstack_real_clone;
	((DejaDupBackendClass *) klass)->is_native = deja_dup_backend_openstack_real_is_native;
	((DejaDupBackendClass *) klass)->get_icon = deja_dup_backend_openstack_real_get_icon;
	((DejaDupBackendClass *) klass)->is_ready = deja_dup_backend_openstack_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = deja_dup_backend_openstack_real_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_location = deja_dup_backend_openstack_real_get_location;
	((DejaDupBackendClass *) klass)->get_location_pretty = deja_dup_backend_openstack_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->get_envp = deja_dup_backend_openstack_real_get_envp;
	((DejaDupBackendClass *) klass)->get_envp_finish = deja_dup_backend_openstack_real_get_envp_finish;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_openstack_finalize;
}


static void deja_dup_backend_openstack_instance_init (DejaDupBackendOpenstack * self) {
	self->priv = DEJA_DUP_BACKEND_OPENSTACK_GET_PRIVATE (self);
}


static void deja_dup_backend_openstack_finalize (GObject* obj) {
	DejaDupBackendOpenstack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_OPENSTACK, DejaDupBackendOpenstack);
	_g_free0 (self->priv->settings_id);
	_g_free0 (self->priv->id);
	_g_free0 (self->priv->secret_key);
	G_OBJECT_CLASS (deja_dup_backend_openstack_parent_class)->finalize (obj);
}


GType deja_dup_backend_openstack_get_type (void) {
	static volatile gsize deja_dup_backend_openstack_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_openstack_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendOpenstackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_openstack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendOpenstack), 0, (GInstanceInitFunc) deja_dup_backend_openstack_instance_init, NULL };
		GType deja_dup_backend_openstack_type_id;
		deja_dup_backend_openstack_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendOpenstack", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_openstack_type_id__volatile, deja_dup_backend_openstack_type_id);
	}
	return deja_dup_backend_openstack_type_id__volatile;
}



