/* AccountDialog.c generated by valac 0.38.7, the Vala compiler
 * generated from AccountDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <gio/gio.h>
#include <gdk/gdk.h>
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include <cairo.h>
#include <glib/gstdio.h>
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define TYPE_ACCOUNT_DIALOG (account_dialog_get_type ())
#define ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_DIALOG, AccountDialog))
#define ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_DIALOG, AccountDialogClass))
#define IS_ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_DIALOG))
#define IS_ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_DIALOG))
#define ACCOUNT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_DIALOG, AccountDialogClass))

typedef struct _AccountDialog AccountDialog;
typedef struct _AccountDialogClass AccountDialogClass;
typedef struct _AccountDialogPrivate AccountDialogPrivate;

#define TYPE_AVATAR_BANNER_WIDGET (avatar_banner_widget_get_type ())
#define AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget))
#define AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))
#define IS_AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_BANNER_WIDGET))
#define IS_AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_BANNER_WIDGET))
#define AVATAR_BANNER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))

typedef struct _AvatarBannerWidget AvatarBannerWidget;
typedef struct _AvatarBannerWidgetClass AvatarBannerWidgetClass;

#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;

#define TYPE_CROP_WIDGET (crop_widget_get_type ())
#define CROP_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CROP_WIDGET, CropWidget))
#define CROP_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CROP_WIDGET, CropWidgetClass))
#define IS_CROP_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CROP_WIDGET))
#define IS_CROP_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CROP_WIDGET))
#define CROP_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CROP_WIDGET, CropWidgetClass))

typedef struct _CropWidget CropWidget;
typedef struct _CropWidgetClass CropWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
enum  {
	ACCOUNT_DIALOG_0_PROPERTY,
	ACCOUNT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* account_dialog_properties[ACCOUNT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block74Data Block74Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _Block75Data Block75Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block76Data Block76Data;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block77Data Block77Data;

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

struct _AccountDialog {
	GtkWindow parent_instance;
	AccountDialogPrivate * priv;
};

struct _AccountDialogClass {
	GtkWindowClass parent_class;
};

struct _AccountDialogPrivate {
	GtkEntry* name_entry;
	AvatarBannerWidget* avatar_banner_widget;
	GtkStack* delete_stack;
	GtkSwitch* autostart_switch;
	GtkEntry* website_entry;
	CompletionTextView* description_text_view;
	CropWidget* crop_widget;
	GtkStack* content_stack;
	GtkBox* info_box;
	GtkLabel* error_label;
	GtkButton* save_button;
	GtkLabel* description_length_label;
	Account* account;
	gchar* old_user_name;
	gchar* old_description;
	gchar* old_website;
	GdkPixbuf* new_avatar;
	GdkPixbuf* new_banner;
	gint old_width;
	gint old_height;
	gboolean account_was_not_initied;
};

struct _Block74Data {
	int _ref_count_;
	AccountDialog* self;
	Account* account;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block75Data {
	int _ref_count_;
	AccountDialog* self;
	RestProxyCall* call;
};

struct _Block76Data {
	int _ref_count_;
	AccountDialog* self;
	RestProxyCall* call;
};

struct _Block77Data {
	int _ref_count_;
	AccountDialog* self;
	RestProxyCall* call;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer account_dialog_parent_class = NULL;
extern SqlDatabase* corebird_db;

GType account_dialog_get_type (void) G_GNUC_CONST;
GType avatar_banner_widget_get_type (void) G_GNUC_CONST;
GType completion_text_view_get_type (void) G_GNUC_CONST;
GType crop_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define ACCOUNT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACCOUNT_DIALOG, AccountDialogPrivate))
#define ACCOUNT_DIALOG_MAX_DESCRIPTION_LENGTH 160
#define ACCOUNT_DIALOG_PAGE_NORMAL "normal"
#define ACCOUNT_DIALOG_PAGE_DELETE "delete"
AccountDialog* account_dialog_new (Account* account);
AccountDialog* account_dialog_construct (GType object_type, Account* account);
static Block74Data* block74_data_ref (Block74Data* _data74_);
static void block74_data_unref (void * _userdata_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account);
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static void account_dialog_set_transient_data (AccountDialog* self, const gchar* website, const gchar* description);
GSettings* settings_get (void);
static void __lambda133_ (AccountDialog* self, GdkPixbuf* p);
static void ___lambda133__avatar_banner_widget_avatar_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_avatar, gpointer self);
static void __lambda134_ (AccountDialog* self, GdkPixbuf* b);
static void ___lambda134__avatar_banner_widget_banner_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_banner, gpointer self);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
static void ___lambda135_ (Block74Data* _data74_, GObject* obj, GAsyncResult* res);
static void ____lambda135__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean account_dialog_escape_pressed_cb (AccountDialog* self);
static gboolean _account_dialog_escape_pressed_cb_gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static void account_dialog_update_description_length (AccountDialog* self);
static void _account_dialog_update_description_length_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void account_dialog_real_destroy (GtkWidget* base);
void account_uninit (Account* self);
static void account_dialog_delete_button_clicked_cb (AccountDialog* self);
static void _account_dialog_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_save_data (AccountDialog* self);
static Block75Data* block75_data_ref (Block75Data* _data75_);
static void block75_data_unref (void * _userdata_);
static void ___lambda136_ (Block75Data* _data75_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ____lambda136__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block76Data* block76_data_ref (Block76Data* _data76_);
static void block76_data_unref (void * _userdata_);
static void ___lambda137_ (Block76Data* _data76_, GObject* obj, GAsyncResult* res);
void account_set_new_avatar (Account* self, cairo_surface_t* new_avatar);
static void ____lambda137__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block77Data* block77_data_ref (Block77Data* _data77_);
static void block77_data_unref (void * _userdata_);
static void ___lambda138_ (Block77Data* _data77_, GObject* obj, GAsyncResult* res);
static void ____lambda138__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_dialog_delete_confirm_button_clicked_cb (AccountDialog* self);
gchar* dirs_config (const gchar* path);
void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target);
GType corebird_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType main_widget_get_type (void) G_GNUC_CONST;
void main_window_change_account (MainWindow* self, Account* account);
Account* account_query_account_by_id (gint64 id);
void account_remove_account (const gchar* screen_name);
static void _account_dialog_delete_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_delete_cancel_button_clicked_cb (AccountDialog* self);
static void _account_dialog_delete_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_autostart_switch_activate_cb (AccountDialog* self);
static void _account_dialog_autostart_switch_activate_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void account_dialog_show_crop_image_selector (AccountDialog* self);
gdouble crop_widget_get_desired_aspect_ratio (CropWidget* self);
void crop_widget_set_image (CropWidget* self, GdkPixbuf* image);
static void account_dialog_avatar_clicked_cb (AccountDialog* self);
void crop_widget_set_desired_aspect_ratio (CropWidget* self, gdouble value);
void crop_widget_set_min_size (CropWidget* self, gint min_width);
static void _account_dialog_avatar_clicked_cb_avatar_banner_widget_avatar_clicked (AvatarBannerWidget* _sender, gpointer self);
static void account_dialog_banner_clicked_cb (AccountDialog* self);
static void _account_dialog_banner_clicked_cb_avatar_banner_widget_banner_clicked (AvatarBannerWidget* _sender, gpointer self);
static void account_dialog_cancel_button_clicked_cb (AccountDialog* self);
static void _account_dialog_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_save_button_clicked_cb (AccountDialog* self);
GdkPixbuf* crop_widget_get_cropped_image (CropWidget* self);
void avatar_banner_widget_set_avatar (AvatarBannerWidget* self, GdkPixbuf* avatar);
void avatar_banner_widget_set_banner (AvatarBannerWidget* self, GdkPixbuf* banner);
static void _account_dialog_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block74Data* block74_data_ref (Block74Data* _data74_) {
	g_atomic_int_inc (&_data74_->_ref_count_);
	return _data74_;
}


static void block74_data_unref (void * _userdata_) {
	Block74Data* _data74_;
	_data74_ = (Block74Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data74_->_ref_count_)) {
		AccountDialog* self;
		self = _data74_->self;
		_g_object_unref0 (_data74_->account);
		_g_object_unref0 (self);
		g_slice_free (Block74Data, _data74_);
	}
}


static void __lambda133_ (AccountDialog* self, GdkPixbuf* p) {
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (GDK_IS_PIXBUF (p));
	_tmp0_ = p;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->new_avatar);
	self->priv->new_avatar = _tmp1_;
}


static void ___lambda133__avatar_banner_widget_avatar_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_avatar, gpointer self) {
	__lambda133_ ((AccountDialog*) self, new_avatar);
}


static void __lambda134_ (AccountDialog* self, GdkPixbuf* b) {
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (GDK_IS_PIXBUF (b));
	_tmp0_ = b;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->new_banner);
	self->priv->new_banner = _tmp1_;
}


static void ___lambda134__avatar_banner_widget_banner_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_banner, gpointer self) {
	__lambda134_ ((AccountDialog*) self, new_banner);
}


static void ___lambda135_ (Block74Data* _data74_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	Account* _tmp0_;
	const gchar* _tmp1_;
	Account* _tmp2_;
	const gchar* _tmp3_;
	self = _data74_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = _data74_->account;
	_tmp1_ = _tmp0_->website;
	_tmp2_ = _data74_->account;
	_tmp3_ = _tmp2_->description;
	account_dialog_set_transient_data (self, _tmp1_, _tmp3_);
}


static void ____lambda135__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda135_ (self, source_object, res);
	block74_data_unref (self);
}


static gboolean _account_dialog_escape_pressed_cb_gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = account_dialog_escape_pressed_cb ((AccountDialog*) self);
	return result;
}


static void _account_dialog_update_description_length_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	account_dialog_update_description_length ((AccountDialog*) self);
}


AccountDialog* account_dialog_construct (GType object_type, Account* account) {
	AccountDialog * self = NULL;
	Block74Data* _data74_;
	Account* _tmp0_;
	Account* _tmp1_;
	Account* _tmp2_;
	GtkEntry* _tmp3_;
	Account* _tmp4_;
	const gchar* _tmp5_;
	AvatarBannerWidget* _tmp6_;
	Account* _tmp7_;
	CompletionTextView* _tmp8_;
	Account* _tmp9_;
	Account* _tmp10_;
	const gchar* _tmp11_;
	Account* _tmp12_;
	const gchar* _tmp13_;
	GtkSwitch* _tmp14_;
	gchar** startup_accounts = NULL;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gint startup_accounts_length1;
	gint _startup_accounts_size_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GtkSwitch* _tmp25_;
	AvatarBannerWidget* _tmp26_;
	AvatarBannerWidget* _tmp27_;
	Account* _tmp28_;
	OAuthProxy* _tmp29_;
	GtkAccelGroup* ag = NULL;
	GtkAccelGroup* _tmp32_;
	CompletionTextView* _tmp33_;
	GtkTextBuffer* _tmp34_;
	GtkTextBuffer* _tmp35_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_data74_ = g_slice_new0 (Block74Data);
	_data74_->_ref_count_ = 1;
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data74_->account);
	_data74_->account = _tmp1_;
	self = (AccountDialog*) g_object_new (object_type, NULL);
	_data74_->self = g_object_ref (self);
	_tmp2_ = _data74_->account;
	self->priv->account = _tmp2_;
	_tmp3_ = self->priv->name_entry;
	_tmp4_ = _data74_->account;
	_tmp5_ = _tmp4_->name;
	gtk_entry_set_text (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->avatar_banner_widget;
	_tmp7_ = _data74_->account;
	avatar_banner_widget_set_account (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->description_text_view;
	_tmp9_ = _data74_->account;
	completion_text_view_set_account (_tmp8_, _tmp9_);
	_tmp10_ = _data74_->account;
	_tmp11_ = _tmp10_->website;
	_tmp12_ = _data74_->account;
	_tmp13_ = _tmp12_->description;
	account_dialog_set_transient_data (self, _tmp11_, _tmp13_);
	_tmp14_ = self->priv->autostart_switch;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, G_TYPE_OBJECT, GObject));
	_tmp15_ = settings_get ();
	_tmp16_ = _tmp15_;
	_tmp18_ = _tmp17_ = g_settings_get_strv (_tmp16_, "startup-accounts");
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _vala_array_length (_tmp17_);
	_g_object_unref0 (_tmp16_);
	startup_accounts = _tmp19_;
	startup_accounts_length1 = _tmp19__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp20_ = startup_accounts;
	_tmp20__length1 = startup_accounts_length1;
	{
		gchar** acc_collection = NULL;
		gint acc_collection_length1 = 0;
		gint _acc_collection_size_ = 0;
		gint acc_it = 0;
		acc_collection = _tmp20_;
		acc_collection_length1 = _tmp20__length1;
		for (acc_it = 0; acc_it < _tmp20__length1; acc_it = acc_it + 1) {
			const gchar* acc = NULL;
			acc = acc_collection[acc_it];
			{
				const gchar* _tmp21_;
				Account* _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = acc;
				_tmp22_ = self->priv->account;
				_tmp23_ = _tmp22_->screen_name;
				if (g_strcmp0 (_tmp21_, _tmp23_) == 0) {
					GtkSwitch* _tmp24_;
					_tmp24_ = self->priv->autostart_switch;
					gtk_switch_set_active (_tmp24_, TRUE);
					break;
				}
			}
		}
	}
	_tmp25_ = self->priv->autostart_switch;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, G_TYPE_OBJECT, GObject));
	_tmp26_ = self->priv->avatar_banner_widget;
	g_signal_connect_object (_tmp26_, "avatar-changed", (GCallback) ___lambda133__avatar_banner_widget_avatar_changed, self, 0);
	_tmp27_ = self->priv->avatar_banner_widget;
	g_signal_connect_object (_tmp27_, "banner-changed", (GCallback) ___lambda134__avatar_banner_widget_banner_changed, self, 0);
	_tmp28_ = _data74_->account;
	_tmp29_ = _tmp28_->proxy;
	if (_tmp29_ == NULL) {
		Account* _tmp30_;
		Account* _tmp31_;
		self->priv->account_was_not_initied = TRUE;
		_tmp30_ = _data74_->account;
		account_init_proxy (_tmp30_, TRUE, FALSE);
		_tmp31_ = _data74_->account;
		account_query_user_info_by_screen_name (_tmp31_, NULL, ____lambda135__gasync_ready_callback, block74_data_ref (_data74_));
	}
	_tmp32_ = gtk_accel_group_new ();
	ag = _tmp32_;
	gtk_accel_group_connect (ag, (guint) GDK_KEY_Escape, 0, GTK_ACCEL_LOCKED, (GClosure*) ((_account_dialog_escape_pressed_cb_gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) _account_dialog_escape_pressed_cb_gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp33_ = self->priv->description_text_view;
	_tmp34_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_text_view_get_type (), GtkTextView));
	_tmp35_ = _tmp34_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, G_TYPE_OBJECT, GObject), "notify::text", (GCallback) _account_dialog_update_description_length_g_object_notify, self, 0);
	gtk_window_add_accel_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), ag);
	account_dialog_update_description_length (self);
	_g_object_unref0 (ag);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	block74_data_unref (_data74_);
	_data74_ = NULL;
	return self;
}


AccountDialog* account_dialog_new (Account* account) {
	return account_dialog_construct (TYPE_ACCOUNT_DIALOG, account);
}


static void account_dialog_update_description_length (AccountDialog* self) {
	gint length = 0;
	CompletionTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkLabel* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gint _tmp13_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->description_text_view;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "text", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	length = _tmp8_;
	_tmp9_ = self->priv->description_length_label;
	_tmp10_ = length;
	_tmp11_ = g_strdup_printf ("%d/160", _tmp10_);
	_tmp12_ = _tmp11_;
	gtk_label_set_label (_tmp9_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = length;
	if (_tmp13_ > ACCOUNT_DIALOG_MAX_DESCRIPTION_LENGTH) {
		GtkButton* _tmp14_;
		_tmp14_ = self->priv->save_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), FALSE);
	} else {
		GtkButton* _tmp15_;
		_tmp15_ = self->priv->save_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), TRUE);
	}
}


static void account_dialog_real_destroy (GtkWidget* base) {
	AccountDialog * self;
	Account* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ACCOUNT_DIALOG, AccountDialog);
	_tmp0_ = self->priv->account;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->account_was_not_initied;
		if (_tmp1_) {
			Account* _tmp2_;
			_tmp2_ = self->priv->account;
			account_uninit (_tmp2_);
		}
		self->priv->account = NULL;
	}
	GTK_WIDGET_CLASS (account_dialog_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), gtk_widget_get_type (), GtkWidget));
}


static gboolean account_dialog_escape_pressed_cb (AccountDialog* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_ACCOUNT_DIALOG (self), FALSE);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = GDK_EVENT_STOP;
	return result;
}


static void account_dialog_set_transient_data (AccountDialog* self, const gchar* website, const gchar* description) {
	const gchar* _tmp0_ = NULL;
	Account* _tmp1_;
	const gchar* _tmp2_;
	GtkEntry* _tmp3_;
	Account* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	Account* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	Account* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_ = NULL;
	Account* _tmp16_;
	const gchar* _tmp17_;
	CompletionTextView* _tmp18_;
	GtkTextBuffer* _tmp19_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp1_ = self->priv->account;
	_tmp2_ = _tmp1_->website;
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp3_ = self->priv->website_entry;
	gtk_entry_set_text (_tmp3_, _tmp0_);
	_tmp4_ = self->priv->account;
	_tmp5_ = _tmp4_->name;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->old_user_name);
	self->priv->old_user_name = _tmp6_;
	_tmp8_ = self->priv->account;
	_tmp9_ = _tmp8_->website;
	_tmp7_ = _tmp9_;
	if (_tmp7_ == NULL) {
		_tmp7_ = "";
	}
	_tmp10_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->old_website);
	self->priv->old_website = _tmp10_;
	_tmp12_ = self->priv->account;
	_tmp13_ = _tmp12_->description;
	_tmp11_ = _tmp13_;
	if (_tmp11_ == NULL) {
		_tmp11_ = "";
	}
	_tmp14_ = g_strdup (_tmp11_);
	_g_free0 (self->priv->old_description);
	self->priv->old_description = _tmp14_;
	_tmp16_ = self->priv->account;
	_tmp17_ = _tmp16_->description;
	_tmp15_ = _tmp17_;
	if (_tmp15_ == NULL) {
		_tmp15_ = "";
	}
	_tmp18_ = self->priv->description_text_view;
	_tmp19_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_text_view_get_type (), GtkTextView));
	gtk_text_buffer_set_text (_tmp19_, _tmp15_, -1);
}


static void account_dialog_delete_button_clicked_cb (AccountDialog* self) {
	GtkStack* _tmp0_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->delete_stack;
	gtk_stack_set_visible_child_name (_tmp0_, ACCOUNT_DIALOG_PAGE_DELETE);
}


static void _account_dialog_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_delete_button_clicked_cb ((AccountDialog*) self);
}


static Block75Data* block75_data_ref (Block75Data* _data75_) {
	g_atomic_int_inc (&_data75_->_ref_count_);
	return _data75_;
}


static void block75_data_unref (void * _userdata_) {
	Block75Data* _data75_;
	_data75_ = (Block75Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data75_->_ref_count_)) {
		AccountDialog* self;
		self = _data75_->self;
		_g_object_unref0 (_data75_->call);
		_g_object_unref0 (self);
		g_slice_free (Block75Data, _data75_);
	}
}


static void ___lambda136_ (Block75Data* _data75_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	GError * _inner_error_ = NULL;
	self = _data75_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data75_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch97_g_error;
		}
		g_debug ("AccountDialog.vala:167: Profile successfully updated");
	}
	goto __finally97;
	__catch97_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		RestProxyCall* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("AccountDialog.vala:169: %s", _tmp3_);
		_tmp4_ = _data75_->call;
		_tmp5_ = rest_proxy_call_get_payload (_tmp4_);
		utils_show_error_object (_tmp5_, "Could not update profile", 171, "AccountDialog.vala", G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally97:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda136__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda136_ (self, source_object, res);
	block75_data_unref (self);
}


static Block76Data* block76_data_ref (Block76Data* _data76_) {
	g_atomic_int_inc (&_data76_->_ref_count_);
	return _data76_;
}


static void block76_data_unref (void * _userdata_) {
	Block76Data* _data76_;
	_data76_ = (Block76Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data76_->_ref_count_)) {
		AccountDialog* self;
		self = _data76_->self;
		_g_object_unref0 (_data76_->call);
		_g_object_unref0 (self);
		g_slice_free (Block76Data, _data76_);
	}
}


static void ___lambda137_ (Block76Data* _data76_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	cairo_surface_t* s = NULL;
	GdkPixbuf* _tmp4_;
	cairo_surface_t* _tmp5_;
	Account* _tmp6_;
	cairo_surface_t* _tmp7_;
	GError * _inner_error_ = NULL;
	self = _data76_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data76_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch99_g_error;
		}
		g_debug ("AccountDialog.vala:201: Avatar successfully updated");
	}
	goto __finally99;
	__catch99_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data76_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		utils_show_error_object (_tmp3_, "Could not update your avatar", 204, "AccountDialog.vala", G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
		return;
	}
	__finally99:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->priv->new_avatar;
	_tmp5_ = gdk_cairo_surface_create_from_pixbuf (_tmp4_, 1, NULL);
	s = _tmp5_;
	_tmp6_ = self->priv->account;
	_tmp7_ = s;
	account_set_new_avatar (_tmp6_, _tmp7_);
	_cairo_surface_destroy0 (s);
}


static void ____lambda137__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda137_ (self, source_object, res);
	block76_data_unref (self);
}


static Block77Data* block77_data_ref (Block77Data* _data77_) {
	g_atomic_int_inc (&_data77_->_ref_count_);
	return _data77_;
}


static void block77_data_unref (void * _userdata_) {
	Block77Data* _data77_;
	_data77_ = (Block77Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data77_->_ref_count_)) {
		AccountDialog* self;
		self = _data77_->self;
		_g_object_unref0 (_data77_->call);
		_g_object_unref0 (self);
		g_slice_free (Block77Data, _data77_);
	}
}


static void ___lambda138_ (Block77Data* _data77_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	GError * _inner_error_ = NULL;
	self = _data77_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data77_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch101_g_error;
		}
		g_debug ("AccountDialog.vala:234: Banner successfully updated");
	}
	goto __finally101;
	__catch101_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data77_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		utils_show_error_object (_tmp3_, "Could not update your banner", 237, "AccountDialog.vala", G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally101:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda138__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda138_ (self, source_object, res);
	block77_data_unref (self);
}


static void account_dialog_save_data (AccountDialog* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GtkEntry* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean needs_save = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_;
	gboolean needs_init = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_;
	gboolean _tmp27_;
	GdkPixbuf* _tmp65_;
	GdkPixbuf* _tmp83_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp2_ = self->priv->old_user_name;
	_tmp3_ = self->priv->name_entry;
	_tmp4_ = gtk_entry_get_text (_tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp2_, _tmp5_) != 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp6_;
		CompletionTextView* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextBuffer* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp6_ = self->priv->old_description;
		_tmp7_ = self->priv->description_text_view;
		_tmp8_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_text_view_get_type (), GtkTextView));
		_tmp9_ = _tmp8_;
		g_object_get (_tmp9_, "text", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp1_ = g_strcmp0 (_tmp6_, _tmp12_) != 0;
		_g_free0 (_tmp12_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp13_;
		GtkEntry* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp13_ = self->priv->old_website;
		_tmp14_ = self->priv->website_entry;
		_tmp15_ = gtk_entry_get_text (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp0_ = g_strcmp0 (_tmp13_, _tmp16_) != 0;
	}
	needs_save = _tmp0_;
	_tmp19_ = needs_save;
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		GdkPixbuf* _tmp20_;
		_tmp20_ = self->priv->new_avatar;
		_tmp18_ = _tmp20_ != NULL;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		GdkPixbuf* _tmp21_;
		_tmp21_ = self->priv->new_banner;
		_tmp17_ = _tmp21_ != NULL;
	}
	needs_init = _tmp17_;
	_tmp23_ = needs_init;
	if (_tmp23_) {
		Account* _tmp24_;
		OAuthProxy* _tmp25_;
		_tmp24_ = self->priv->account;
		_tmp25_ = _tmp24_->proxy;
		_tmp22_ = _tmp25_ == NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		Account* _tmp26_;
		_tmp26_ = self->priv->account;
		account_init_proxy (_tmp26_, TRUE, FALSE);
	}
	_tmp27_ = needs_save;
	if (_tmp27_) {
		Block75Data* _data75_;
		Account* _tmp28_;
		OAuthProxy* _tmp29_;
		RestProxyCall* _tmp30_;
		RestProxyCall* _tmp31_;
		RestProxyCall* _tmp32_;
		RestProxyCall* _tmp33_;
		GtkEntry* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		RestProxyCall* _tmp37_;
		GtkEntry* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		RestProxyCall* _tmp41_;
		CompletionTextView* _tmp42_;
		GtkTextBuffer* _tmp43_;
		GtkTextBuffer* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		RestProxyCall* _tmp48_;
		Account* _tmp49_;
		GtkEntry* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		Account* _tmp54_;
		CompletionTextView* _tmp55_;
		GtkTextBuffer* _tmp56_;
		GtkTextBuffer* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		Account* _tmp60_;
		GtkEntry* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		_data75_ = g_slice_new0 (Block75Data);
		_data75_->_ref_count_ = 1;
		_data75_->self = g_object_ref (self);
		g_debug ("AccountDialog.vala:157: Saving data...");
		_tmp28_ = self->priv->account;
		_tmp29_ = _tmp28_->proxy;
		_tmp30_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, rest_proxy_get_type (), RestProxy));
		_data75_->call = _tmp30_;
		_tmp31_ = _data75_->call;
		rest_proxy_call_set_function (_tmp31_, "1.1/account/update_profile.json");
		_tmp32_ = _data75_->call;
		rest_proxy_call_set_method (_tmp32_, "POST");
		_tmp33_ = _data75_->call;
		_tmp34_ = self->priv->website_entry;
		_tmp35_ = gtk_entry_get_text (_tmp34_);
		_tmp36_ = _tmp35_;
		rest_proxy_call_add_param (_tmp33_, "url", _tmp36_);
		_tmp37_ = _data75_->call;
		_tmp38_ = self->priv->name_entry;
		_tmp39_ = gtk_entry_get_text (_tmp38_);
		_tmp40_ = _tmp39_;
		rest_proxy_call_add_param (_tmp37_, "name", _tmp40_);
		_tmp41_ = _data75_->call;
		_tmp42_ = self->priv->description_text_view;
		_tmp43_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_text_view_get_type (), GtkTextView));
		_tmp44_ = _tmp43_;
		g_object_get (_tmp44_, "text", &_tmp45_, NULL);
		_tmp46_ = _tmp45_;
		_tmp47_ = _tmp46_;
		rest_proxy_call_add_param (_tmp41_, "description", _tmp47_);
		_g_free0 (_tmp47_);
		_tmp48_ = _data75_->call;
		rest_proxy_call_invoke_async (_tmp48_, NULL, ____lambda136__gasync_ready_callback, block75_data_ref (_data75_));
		_tmp49_ = self->priv->account;
		_tmp50_ = self->priv->name_entry;
		_tmp51_ = gtk_entry_get_text (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup (_tmp52_);
		_g_free0 (_tmp49_->name);
		_tmp49_->name = _tmp53_;
		_tmp54_ = self->priv->account;
		_tmp55_ = self->priv->description_text_view;
		_tmp56_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_text_view_get_type (), GtkTextView));
		_tmp57_ = _tmp56_;
		g_object_get (_tmp57_, "text", &_tmp58_, NULL);
		_tmp59_ = _tmp58_;
		_g_free0 (_tmp54_->description);
		_tmp54_->description = _tmp59_;
		_tmp60_ = self->priv->account;
		_tmp61_ = self->priv->website_entry;
		_tmp62_ = gtk_entry_get_text (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strdup (_tmp63_);
		_g_free0 (_tmp60_->website);
		_tmp60_->website = _tmp64_;
		block75_data_unref (_data75_);
		_data75_ = NULL;
	}
	_tmp65_ = self->priv->new_avatar;
	if (_tmp65_ != NULL) {
		Block76Data* _data76_;
		guint8* buffer = NULL;
		gint buffer_length1 = 0;
		gint _buffer_size_ = 0;
		gchar* b64 = NULL;
		guint8* _tmp71_;
		gint _tmp71__length1;
		gchar* _tmp72_;
		Account* _tmp73_;
		OAuthProxy* _tmp74_;
		RestProxyCall* _tmp75_;
		RestProxyCall* _tmp76_;
		RestProxyCall* _tmp77_;
		RestProxyCall* _tmp78_;
		RestProxyCall* _tmp79_;
		RestProxyCall* _tmp80_;
		const gchar* _tmp81_;
		RestProxyCall* _tmp82_;
		_data76_ = g_slice_new0 (Block76Data);
		_data76_->_ref_count_ = 1;
		_data76_->self = g_object_ref (self);
		g_debug ("AccountDialog.vala:182: Updating avatar...");
		{
			GdkPixbuf* _tmp66_;
			guint8* _tmp67_ = NULL;
			gsize _tmp68_;
			_tmp66_ = self->priv->new_avatar;
			gdk_pixbuf_save_to_buffer (_tmp66_, &_tmp67_, &_tmp68_, "png", &_inner_error_, NULL, NULL);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp67_;
			buffer_length1 = _tmp68_;
			_buffer_size_ = buffer_length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch98_g_error;
			}
		}
		goto __finally98;
		__catch98_g_error:
		{
			GError* e = NULL;
			GError* _tmp69_;
			const gchar* _tmp70_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp69_ = e;
			_tmp70_ = _tmp69_->message;
			g_warning ("AccountDialog.vala:187: %s", _tmp70_);
			_g_error_free0 (e);
			buffer = (g_free (buffer), NULL);
			block76_data_unref (_data76_);
			_data76_ = NULL;
			return;
		}
		__finally98:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			buffer = (g_free (buffer), NULL);
			block76_data_unref (_data76_);
			_data76_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp71_ = buffer;
		_tmp71__length1 = buffer_length1;
		_tmp72_ = g_base64_encode (_tmp71_, _tmp71__length1);
		b64 = _tmp72_;
		_tmp73_ = self->priv->account;
		_tmp74_ = _tmp73_->proxy;
		_tmp75_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, rest_proxy_get_type (), RestProxy));
		_data76_->call = _tmp75_;
		_tmp76_ = _data76_->call;
		rest_proxy_call_set_function (_tmp76_, "1.1/account/update_profile_image.json");
		_tmp77_ = _data76_->call;
		rest_proxy_call_set_method (_tmp77_, "POST");
		_tmp78_ = _data76_->call;
		rest_proxy_call_add_param (_tmp78_, "skip_status", "true");
		_tmp79_ = _data76_->call;
		rest_proxy_call_add_param (_tmp79_, "include_entities", "false");
		_tmp80_ = _data76_->call;
		_tmp81_ = b64;
		rest_proxy_call_add_param (_tmp80_, "image", _tmp81_);
		_tmp82_ = _data76_->call;
		rest_proxy_call_invoke_async (_tmp82_, NULL, ____lambda137__gasync_ready_callback, block76_data_ref (_data76_));
		_g_free0 (b64);
		buffer = (g_free (buffer), NULL);
		block76_data_unref (_data76_);
		_data76_ = NULL;
	}
	_tmp83_ = self->priv->new_banner;
	if (_tmp83_ != NULL) {
		Block77Data* _data77_;
		guint8* buffer = NULL;
		gint buffer_length1 = 0;
		gint _buffer_size_ = 0;
		gchar* b64 = NULL;
		guint8* _tmp89_;
		gint _tmp89__length1;
		gchar* _tmp90_;
		Account* _tmp91_;
		OAuthProxy* _tmp92_;
		RestProxyCall* _tmp93_;
		RestProxyCall* _tmp94_;
		RestProxyCall* _tmp95_;
		RestProxyCall* _tmp96_;
		const gchar* _tmp97_;
		RestProxyCall* _tmp98_;
		_data77_ = g_slice_new0 (Block77Data);
		_data77_->_ref_count_ = 1;
		_data77_->self = g_object_ref (self);
		g_debug ("AccountDialog.vala:215: Updating banner...");
		{
			GdkPixbuf* _tmp84_;
			guint8* _tmp85_ = NULL;
			gsize _tmp86_;
			_tmp84_ = self->priv->new_banner;
			gdk_pixbuf_save_to_buffer (_tmp84_, &_tmp85_, &_tmp86_, "png", &_inner_error_, NULL, NULL);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp85_;
			buffer_length1 = _tmp86_;
			_buffer_size_ = buffer_length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch100_g_error;
			}
		}
		goto __finally100;
		__catch100_g_error:
		{
			GError* e = NULL;
			GError* _tmp87_;
			const gchar* _tmp88_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp87_ = e;
			_tmp88_ = _tmp87_->message;
			g_warning ("AccountDialog.vala:221: %s", _tmp88_);
			_g_error_free0 (e);
			buffer = (g_free (buffer), NULL);
			block77_data_unref (_data77_);
			_data77_ = NULL;
			return;
		}
		__finally100:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			buffer = (g_free (buffer), NULL);
			block77_data_unref (_data77_);
			_data77_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp89_ = buffer;
		_tmp89__length1 = buffer_length1;
		_tmp90_ = g_base64_encode (_tmp89_, _tmp89__length1);
		b64 = _tmp90_;
		_tmp91_ = self->priv->account;
		_tmp92_ = _tmp91_->proxy;
		_tmp93_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, rest_proxy_get_type (), RestProxy));
		_data77_->call = _tmp93_;
		_tmp94_ = _data77_->call;
		rest_proxy_call_set_function (_tmp94_, "1.1/account/update_profile_banner.json");
		_tmp95_ = _data77_->call;
		rest_proxy_call_set_method (_tmp95_, "POST");
		_tmp96_ = _data77_->call;
		_tmp97_ = b64;
		rest_proxy_call_add_param (_tmp96_, "banner", _tmp97_);
		_tmp98_ = _data77_->call;
		rest_proxy_call_invoke_async (_tmp98_, NULL, ____lambda138__gasync_ready_callback, block77_data_ref (_data77_));
		_g_free0 (b64);
		buffer = (g_free (buffer), NULL);
		block77_data_unref (_data77_);
		_data77_ = NULL;
	}
}


static void account_dialog_delete_confirm_button_clicked_cb (AccountDialog* self) {
	gint64 acc_id = 0LL;
	Account* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gint64 _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	SqlDatabase* _tmp23_;
	gint64 _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar** startup_accounts = NULL;
	GSettings* _tmp29_;
	GSettings* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gint startup_accounts_length1;
	gint _startup_accounts_size_;
	Corebird* cb = NULL;
	GApplication* _tmp71_;
	Corebird* _tmp72_;
	GList* windows = NULL;
	Corebird* _tmp73_;
	GList* _tmp74_;
	GtkWindow* account_window = NULL;
	gint n_main_windows = 0;
	GList* _tmp75_;
	gint _tmp86_;
	GtkWindow* _tmp87_;
	Account* acc_to_remove = NULL;
	Account* _tmp91_;
	gint64 _tmp92_;
	Account* _tmp93_;
	Account* _tmp94_;
	Corebird* _tmp95_;
	Account* _tmp96_;
	const gchar* _tmp97_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->account;
	_tmp1_ = _tmp0_->id;
	acc_id = _tmp1_;
	_tmp2_ = acc_id;
	_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("accounts/", _tmp4_, ".db", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = dirs_config (_tmp6_);
	_tmp8_ = _tmp7_;
	g_remove (_tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = acc_id;
	_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat ("accounts/", _tmp11_, ".png", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = dirs_config (_tmp13_);
	_tmp15_ = _tmp14_;
	g_remove (_tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp16_ = acc_id;
	_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("accounts/", _tmp18_, "_small.png", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = dirs_config (_tmp20_);
	_tmp22_ = _tmp21_;
	g_remove (_tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_tmp23_ = corebird_db;
	_tmp24_ = acc_id;
	_tmp25_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("DELETE FROM `accounts` WHERE `id`='", _tmp26_, "';", NULL);
	_tmp28_ = _tmp27_;
	sql_database_exec (_tmp23_, _tmp28_, NULL, NULL);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp29_ = settings_get ();
	_tmp30_ = _tmp29_;
	_tmp32_ = _tmp31_ = g_settings_get_strv (_tmp30_, "startup-accounts");
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _vala_array_length (_tmp31_);
	_g_object_unref0 (_tmp30_);
	startup_accounts = _tmp33_;
	startup_accounts_length1 = _tmp33__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				gint _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				gchar** _tmp38_;
				gint _tmp38__length1;
				gint _tmp39_;
				const gchar* _tmp40_;
				Account* _tmp41_;
				const gchar* _tmp42_;
				if (!_tmp34_) {
					gint _tmp35_;
					_tmp35_ = i;
					i = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp36_ = i;
				_tmp37_ = startup_accounts;
				_tmp37__length1 = startup_accounts_length1;
				if (!(_tmp36_ < _tmp37__length1)) {
					break;
				}
				_tmp38_ = startup_accounts;
				_tmp38__length1 = startup_accounts_length1;
				_tmp39_ = i;
				_tmp40_ = _tmp38_[_tmp39_];
				_tmp41_ = self->priv->account;
				_tmp42_ = _tmp41_->screen_name;
				if (g_strcmp0 (_tmp40_, _tmp42_) == 0) {
					gchar** sa_new = NULL;
					gchar** _tmp43_;
					gint _tmp43__length1;
					gchar** _tmp44_;
					gint sa_new_length1;
					gint _sa_new_size_;
					GSettings* _tmp68_;
					GSettings* _tmp69_;
					gchar** _tmp70_;
					gint _tmp70__length1;
					_tmp43_ = startup_accounts;
					_tmp43__length1 = startup_accounts_length1;
					_tmp44_ = g_new0 (gchar*, (_tmp43__length1 - 1) + 1);
					sa_new = _tmp44_;
					sa_new_length1 = _tmp43__length1 - 1;
					_sa_new_size_ = sa_new_length1;
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp45_ = FALSE;
							_tmp45_ = TRUE;
							while (TRUE) {
								gint _tmp47_;
								gint _tmp48_;
								gchar** _tmp49_;
								gint _tmp49__length1;
								gint _tmp50_;
								gchar** _tmp51_;
								gint _tmp51__length1;
								gint _tmp52_;
								const gchar* _tmp53_;
								gchar* _tmp54_;
								gchar* _tmp55_;
								if (!_tmp45_) {
									gint _tmp46_;
									_tmp46_ = i;
									i = _tmp46_ + 1;
								}
								_tmp45_ = FALSE;
								_tmp47_ = x;
								_tmp48_ = i;
								if (!(_tmp47_ < _tmp48_)) {
									break;
								}
								_tmp49_ = sa_new;
								_tmp49__length1 = sa_new_length1;
								_tmp50_ = x;
								_tmp51_ = startup_accounts;
								_tmp51__length1 = startup_accounts_length1;
								_tmp52_ = x;
								_tmp53_ = _tmp51_[_tmp52_];
								_tmp54_ = g_strdup (_tmp53_);
								_g_free0 (_tmp49_[_tmp50_]);
								_tmp49_[_tmp50_] = _tmp54_;
								_tmp55_ = _tmp49_[_tmp50_];
							}
						}
					}
					{
						gint x = 0;
						gint _tmp56_;
						_tmp56_ = i;
						x = _tmp56_ + 1;
						{
							gboolean _tmp57_ = FALSE;
							_tmp57_ = TRUE;
							while (TRUE) {
								gint _tmp59_;
								gchar** _tmp60_;
								gint _tmp60__length1;
								gchar** _tmp61_;
								gint _tmp61__length1;
								gint _tmp62_;
								gchar** _tmp63_;
								gint _tmp63__length1;
								gint _tmp64_;
								const gchar* _tmp65_;
								gchar* _tmp66_;
								gchar* _tmp67_;
								if (!_tmp57_) {
									gint _tmp58_;
									_tmp58_ = x;
									x = _tmp58_ + 1;
								}
								_tmp57_ = FALSE;
								_tmp59_ = x;
								_tmp60_ = startup_accounts;
								_tmp60__length1 = startup_accounts_length1;
								if (!(_tmp59_ < _tmp60__length1)) {
									break;
								}
								_tmp61_ = sa_new;
								_tmp61__length1 = sa_new_length1;
								_tmp62_ = x;
								_tmp63_ = startup_accounts;
								_tmp63__length1 = startup_accounts_length1;
								_tmp64_ = x;
								_tmp65_ = _tmp63_[_tmp64_];
								_tmp66_ = g_strdup (_tmp65_);
								_g_free0 (_tmp61_[_tmp62_]);
								_tmp61_[_tmp62_] = _tmp66_;
								_tmp67_ = _tmp61_[_tmp62_];
							}
						}
					}
					_tmp68_ = settings_get ();
					_tmp69_ = _tmp68_;
					_tmp70_ = sa_new;
					_tmp70__length1 = sa_new_length1;
					g_settings_set_strv (_tmp69_, "startup-accounts", _tmp70_);
					_g_object_unref0 (_tmp69_);
					sa_new = (_vala_array_free (sa_new, sa_new_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	_tmp71_ = g_application_get_default ();
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, TYPE_COREBIRD, Corebird));
	cb = _tmp72_;
	_tmp73_ = cb;
	_tmp74_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, gtk_application_get_type (), GtkApplication));
	windows = _tmp74_;
	account_window = NULL;
	n_main_windows = 0;
	_tmp75_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp75_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp76_;
			GtkWindow* win = NULL;
			_tmp76_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp76_;
			{
				GtkWindow* _tmp77_;
				_tmp77_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, TYPE_MAIN_WINDOW)) {
					gint _tmp78_;
					GtkWindow* _tmp79_;
					Account* _tmp80_;
					gint64 _tmp81_;
					Account* _tmp82_;
					gint64 _tmp83_;
					_tmp78_ = n_main_windows;
					n_main_windows = _tmp78_ + 1;
					_tmp79_ = win;
					_tmp80_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp81_ = _tmp80_->id;
					_tmp82_ = self->priv->account;
					_tmp83_ = _tmp82_->id;
					if (_tmp81_ == _tmp83_) {
						GtkWindow* _tmp84_;
						GtkWindow* _tmp85_;
						_tmp84_ = win;
						_tmp85_ = _g_object_ref0 (_tmp84_);
						_g_object_unref0 (account_window);
						account_window = _tmp85_;
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp86_ = n_main_windows;
	g_debug ("AccountDialog.vala:286: Open main windows: %d", _tmp86_);
	_tmp87_ = account_window;
	if (_tmp87_ != NULL) {
		gint _tmp88_;
		_tmp88_ = n_main_windows;
		if (_tmp88_ > 1) {
			GtkWindow* _tmp89_;
			_tmp89_ = account_window;
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, gtk_widget_get_type (), GtkWidget));
		} else {
			GtkWindow* _tmp90_;
			_tmp90_ = account_window;
			main_window_change_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, TYPE_MAIN_WINDOW, MainWindow), NULL);
		}
	}
	_tmp91_ = self->priv->account;
	_tmp92_ = _tmp91_->id;
	_tmp93_ = account_query_account_by_id (_tmp92_);
	_tmp94_ = _g_object_ref0 (_tmp93_);
	acc_to_remove = _tmp94_;
	_tmp95_ = cb;
	g_signal_emit_by_name (_tmp95_, "account-removed", acc_to_remove);
	_tmp96_ = self->priv->account;
	_tmp97_ = _tmp96_->screen_name;
	account_remove_account (_tmp97_);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (acc_to_remove);
	_g_object_unref0 (account_window);
	_g_object_unref0 (cb);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


static void _account_dialog_delete_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_delete_confirm_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_delete_cancel_button_clicked_cb (AccountDialog* self) {
	GtkStack* _tmp0_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->delete_stack;
	gtk_stack_set_visible_child_name (_tmp0_, ACCOUNT_DIALOG_PAGE_NORMAL);
}


static void _account_dialog_delete_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_delete_cancel_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_autostart_switch_activate_cb (AccountDialog* self) {
	gboolean active = FALSE;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar** startup_accounts = NULL;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint startup_accounts_length1;
	gint _startup_accounts_size_;
	gboolean _tmp8_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->autostart_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	active = _tmp2_;
	_tmp3_ = settings_get ();
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "startup-accounts");
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_object_unref0 (_tmp4_);
	startup_accounts = _tmp7_;
	startup_accounts_length1 = _tmp7__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp8_ = active;
	if (_tmp8_) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		gchar** new_startup_accounts = NULL;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gchar** _tmp14_;
		gint new_startup_accounts_length1;
		gint _new_startup_accounts_size_;
		gint i = 0;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gchar** _tmp23_;
		gint _tmp23__length1;
		Account* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GSettings* _tmp28_;
		GSettings* _tmp29_;
		gchar** _tmp30_;
		gint _tmp30__length1;
		_tmp9_ = startup_accounts;
		_tmp9__length1 = startup_accounts_length1;
		{
			gchar** acc_collection = NULL;
			gint acc_collection_length1 = 0;
			gint _acc_collection_size_ = 0;
			gint acc_it = 0;
			acc_collection = _tmp9_;
			acc_collection_length1 = _tmp9__length1;
			for (acc_it = 0; acc_it < _tmp9__length1; acc_it = acc_it + 1) {
				const gchar* acc = NULL;
				acc = acc_collection[acc_it];
				{
					const gchar* _tmp10_;
					Account* _tmp11_;
					const gchar* _tmp12_;
					_tmp10_ = acc;
					_tmp11_ = self->priv->account;
					_tmp12_ = _tmp11_->screen_name;
					if (g_strcmp0 (_tmp10_, _tmp12_) == 0) {
						startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
				}
			}
		}
		_tmp13_ = startup_accounts;
		_tmp13__length1 = startup_accounts_length1;
		_tmp14_ = g_new0 (gchar*, (_tmp13__length1 + 1) + 1);
		new_startup_accounts = _tmp14_;
		new_startup_accounts_length1 = _tmp13__length1 + 1;
		_new_startup_accounts_size_ = new_startup_accounts_length1;
		i = 0;
		_tmp15_ = startup_accounts;
		_tmp15__length1 = startup_accounts_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp15_;
			s_collection_length1 = _tmp15__length1;
			for (s_it = 0; s_it < _tmp15__length1; s_it = s_it + 1) {
				const gchar* s = NULL;
				s = s_collection[s_it];
				{
					gchar** _tmp16_;
					gint _tmp16__length1;
					gint _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gint _tmp21_;
					_tmp16_ = new_startup_accounts;
					_tmp16__length1 = new_startup_accounts_length1;
					_tmp17_ = i;
					_tmp18_ = s;
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (_tmp16_[_tmp17_]);
					_tmp16_[_tmp17_] = _tmp19_;
					_tmp20_ = _tmp16_[_tmp17_];
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
			}
		}
		_tmp22_ = new_startup_accounts;
		_tmp22__length1 = new_startup_accounts_length1;
		_tmp23_ = new_startup_accounts;
		_tmp23__length1 = new_startup_accounts_length1;
		_tmp24_ = self->priv->account;
		_tmp25_ = _tmp24_->screen_name;
		_tmp26_ = g_strdup (_tmp25_);
		_g_free0 (_tmp22_[_tmp23__length1 - 1]);
		_tmp22_[_tmp23__length1 - 1] = _tmp26_;
		_tmp27_ = _tmp22_[_tmp23__length1 - 1];
		_tmp28_ = settings_get ();
		_tmp29_ = _tmp28_;
		_tmp30_ = new_startup_accounts;
		_tmp30__length1 = new_startup_accounts_length1;
		g_settings_set_strv (_tmp29_, "startup-accounts", _tmp30_);
		_g_object_unref0 (_tmp29_);
		new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gchar** new_startup_accounts = NULL;
		gchar** _tmp31_;
		gint _tmp31__length1;
		gchar** _tmp32_;
		gint new_startup_accounts_length1;
		gint _new_startup_accounts_size_;
		gint i = 0;
		gchar** _tmp33_;
		gint _tmp33__length1;
		GSettings* _tmp43_;
		GSettings* _tmp44_;
		gchar** _tmp45_;
		gint _tmp45__length1;
		_tmp31_ = startup_accounts;
		_tmp31__length1 = startup_accounts_length1;
		_tmp32_ = g_new0 (gchar*, (_tmp31__length1 - 1) + 1);
		new_startup_accounts = _tmp32_;
		new_startup_accounts_length1 = _tmp31__length1 - 1;
		_new_startup_accounts_size_ = new_startup_accounts_length1;
		i = 0;
		_tmp33_ = startup_accounts;
		_tmp33__length1 = startup_accounts_length1;
		{
			gchar** acc_collection = NULL;
			gint acc_collection_length1 = 0;
			gint _acc_collection_size_ = 0;
			gint acc_it = 0;
			acc_collection = _tmp33_;
			acc_collection_length1 = _tmp33__length1;
			for (acc_it = 0; acc_it < _tmp33__length1; acc_it = acc_it + 1) {
				const gchar* acc = NULL;
				acc = acc_collection[acc_it];
				{
					const gchar* _tmp34_;
					Account* _tmp35_;
					const gchar* _tmp36_;
					_tmp34_ = acc;
					_tmp35_ = self->priv->account;
					_tmp36_ = _tmp35_->screen_name;
					if (g_strcmp0 (_tmp34_, _tmp36_) != 0) {
						gchar** _tmp37_;
						gint _tmp37__length1;
						gint _tmp38_;
						const gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gint _tmp42_;
						_tmp37_ = new_startup_accounts;
						_tmp37__length1 = new_startup_accounts_length1;
						_tmp38_ = i;
						_tmp39_ = acc;
						_tmp40_ = g_strdup (_tmp39_);
						_g_free0 (_tmp37_[_tmp38_]);
						_tmp37_[_tmp38_] = _tmp40_;
						_tmp41_ = _tmp37_[_tmp38_];
						_tmp42_ = i;
						i = _tmp42_ + 1;
					}
				}
			}
		}
		_tmp43_ = settings_get ();
		_tmp44_ = _tmp43_;
		_tmp45_ = new_startup_accounts;
		_tmp45__length1 = new_startup_accounts_length1;
		g_settings_set_strv (_tmp44_, "startup-accounts", _tmp45_);
		_g_object_unref0 (_tmp44_);
		new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	}
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


static void _account_dialog_autostart_switch_activate_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	account_dialog_autostart_switch_activate_cb ((AccountDialog*) self);
}


static void account_dialog_show_crop_image_selector (AccountDialog* self) {
	GtkFileChooserNative* filechooser = NULL;
	GtkFileChooserNative* _tmp0_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp1_;
	GtkFileFilter* _tmp2_;
	GtkFileFilter* _tmp3_;
	GtkFileChooserNative* _tmp4_;
	GtkFileFilter* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = gtk_file_chooser_native_new (_ ("Select Banner Image"), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Open"), _ ("Cancel"));
	filechooser = _tmp0_;
	_tmp1_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp1_);
	filter = _tmp1_;
	_tmp2_ = filter;
	gtk_file_filter_add_mime_type (_tmp2_, "image/png");
	_tmp3_ = filter;
	gtk_file_filter_add_mime_type (_tmp3_, "image/jpeg");
	_tmp4_ = filechooser;
	_tmp5_ = filter;
	gtk_file_chooser_set_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), _tmp5_);
	_tmp6_ = filechooser;
	_tmp7_ = gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_NATIVE_DIALOG, GtkNativeDialog));
	if (_tmp7_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* selected_file = NULL;
		GtkFileChooserNative* _tmp8_;
		gchar* _tmp9_;
		GdkPixbuf* image = NULL;
		gint min_width = 0;
		gint min_height = 0;
		CropWidget* _tmp16_;
		gdouble _tmp17_;
		gdouble _tmp18_;
		gboolean _tmp19_ = FALSE;
		GdkPixbuf* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp8_ = filechooser;
		_tmp9_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
		selected_file = _tmp9_;
		image = NULL;
		{
			GdkPixbuf* _tmp10_ = NULL;
			const gchar* _tmp11_;
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
			_tmp11_ = selected_file;
			_tmp12_ = gdk_pixbuf_new_from_file (_tmp11_, &_inner_error_);
			_tmp10_ = _tmp12_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch102_g_error;
			}
			_tmp13_ = _tmp10_;
			_tmp10_ = NULL;
			_g_object_unref0 (image);
			image = _tmp13_;
			_g_object_unref0 (_tmp10_);
		}
		goto __finally102;
		__catch102_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_warning ("AccountDialog.vala:360: %s", _tmp15_);
			_g_error_free0 (e);
			_g_object_unref0 (image);
			_g_free0 (selected_file);
			_g_object_unref0 (filter);
			_g_object_unref0 (filechooser);
			return;
		}
		__finally102:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (image);
			_g_free0 (selected_file);
			_g_object_unref0 (filter);
			_g_object_unref0 (filechooser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		min_width = 200;
		min_height = 100;
		_tmp16_ = self->priv->crop_widget;
		_tmp17_ = crop_widget_get_desired_aspect_ratio (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == 1.0) {
			min_width = 48;
			min_height = 48;
		}
		_tmp20_ = image;
		_tmp21_ = gdk_pixbuf_get_width (_tmp20_);
		_tmp22_ = min_width;
		if (_tmp21_ >= _tmp22_) {
			GdkPixbuf* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_tmp23_ = image;
			_tmp24_ = gdk_pixbuf_get_height (_tmp23_);
			_tmp25_ = min_height;
			_tmp19_ = _tmp24_ >= _tmp25_;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			CropWidget* _tmp26_;
			GdkPixbuf* _tmp27_;
			GtkButton* _tmp28_;
			_tmp26_ = self->priv->crop_widget;
			_tmp27_ = image;
			crop_widget_set_image (_tmp26_, _tmp27_);
			_tmp28_ = self->priv->save_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), TRUE);
		} else {
			gchar* error_str = NULL;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			const gchar* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			const gchar* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			GtkLabel* _tmp48_;
			const gchar* _tmp49_;
			GtkStack* _tmp50_;
			GtkLabel* _tmp51_;
			GtkButton* _tmp52_;
			_tmp29_ = g_strdup ("");
			error_str = _tmp29_;
			_tmp30_ = error_str;
			_tmp31_ = g_strconcat (_ ("Image does not meet minimum size requirements:"), "\n", NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp30_, _tmp32_, NULL);
			_g_free0 (error_str);
			error_str = _tmp33_;
			_g_free0 (_tmp32_);
			_tmp34_ = error_str;
			_tmp35_ = min_width;
			_tmp36_ = min_width;
			_tmp37_ = g_strdup_printf (ngettext ("Minimum width: %d pixel", "Minimum width: %d pixels", (gulong) _tmp35_), _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strconcat (_tmp38_, "\n", NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp34_, _tmp40_, NULL);
			_g_free0 (error_str);
			error_str = _tmp41_;
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_tmp42_ = error_str;
			_tmp43_ = min_height;
			_tmp44_ = min_height;
			_tmp45_ = g_strdup_printf (ngettext ("Minimum height: %d pixel", "Minimum height: %d pixels", (gulong) _tmp43_), _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strconcat (_tmp42_, _tmp46_, NULL);
			_g_free0 (error_str);
			error_str = _tmp47_;
			_g_free0 (_tmp46_);
			_tmp48_ = self->priv->error_label;
			_tmp49_ = error_str;
			gtk_label_set_label (_tmp48_, _tmp49_);
			_tmp50_ = self->priv->content_stack;
			_tmp51_ = self->priv->error_label;
			gtk_stack_set_visible_child (_tmp50_, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_widget_get_type (), GtkWidget));
			_tmp52_ = self->priv->save_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_widget_get_type (), GtkWidget), FALSE);
			_g_free0 (error_str);
		}
		_g_object_unref0 (image);
		_g_free0 (selected_file);
	} else {
		GtkStack* _tmp53_;
		GtkBox* _tmp54_;
		_tmp53_ = self->priv->content_stack;
		_tmp54_ = self->priv->info_box;
		gtk_stack_set_visible_child (_tmp53_, G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget));
	}
	_g_object_unref0 (filter);
	_g_object_unref0 (filechooser);
}


static void account_dialog_avatar_clicked_cb (AccountDialog* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CropWidget* _tmp2_;
	CropWidget* _tmp3_;
	CropWidget* _tmp4_;
	CropWidget* _tmp5_;
	GtkStack* _tmp6_;
	CropWidget* _tmp7_;
	GtkButton* _tmp8_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	gtk_window_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp0_, &_tmp1_);
	self->priv->old_width = _tmp0_;
	self->priv->old_height = _tmp1_;
	gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 400, 400);
	_tmp2_ = self->priv->crop_widget;
	crop_widget_set_image (_tmp2_, NULL);
	_tmp3_ = self->priv->crop_widget;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), -1, 400);
	_tmp4_ = self->priv->crop_widget;
	crop_widget_set_desired_aspect_ratio (_tmp4_, 1.0);
	_tmp5_ = self->priv->crop_widget;
	crop_widget_set_min_size (_tmp5_, 48);
	_tmp6_ = self->priv->content_stack;
	_tmp7_ = self->priv->crop_widget;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	account_dialog_show_crop_image_selector (self);
	_tmp8_ = self->priv->save_button;
	gtk_button_set_label (_tmp8_, _ ("Pick"));
}


static void _account_dialog_avatar_clicked_cb_avatar_banner_widget_avatar_clicked (AvatarBannerWidget* _sender, gpointer self) {
	account_dialog_avatar_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_banner_clicked_cb (AccountDialog* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CropWidget* _tmp2_;
	CropWidget* _tmp3_;
	CropWidget* _tmp4_;
	CropWidget* _tmp5_;
	GtkStack* _tmp6_;
	CropWidget* _tmp7_;
	GtkButton* _tmp8_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	gtk_window_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp0_, &_tmp1_);
	self->priv->old_width = _tmp0_;
	self->priv->old_height = _tmp1_;
	gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 700, 350);
	_tmp2_ = self->priv->crop_widget;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), 700, 350);
	_tmp3_ = self->priv->crop_widget;
	crop_widget_set_image (_tmp3_, NULL);
	_tmp4_ = self->priv->crop_widget;
	crop_widget_set_desired_aspect_ratio (_tmp4_, 2.0);
	_tmp5_ = self->priv->crop_widget;
	crop_widget_set_min_size (_tmp5_, 200);
	_tmp6_ = self->priv->content_stack;
	_tmp7_ = self->priv->crop_widget;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	account_dialog_show_crop_image_selector (self);
	_tmp8_ = self->priv->save_button;
	gtk_button_set_label (_tmp8_, _ ("Pick"));
}


static void _account_dialog_banner_clicked_cb_avatar_banner_widget_banner_clicked (AvatarBannerWidget* _sender, gpointer self) {
	account_dialog_banner_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_cancel_button_clicked_cb (AccountDialog* self) {
	gboolean _tmp0_ = FALSE;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	CropWidget* _tmp4_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp1_ = self->priv->content_stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->crop_widget;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		_tmp0_ = TRUE;
	} else {
		GtkStack* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		GtkLabel* _tmp8_;
		_tmp5_ = self->priv->content_stack;
		_tmp6_ = gtk_stack_get_visible_child (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->error_label;
		_tmp0_ = _tmp7_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget);
	}
	if (_tmp0_) {
		gint _tmp9_;
		gint _tmp10_;
		GtkStack* _tmp11_;
		GtkBox* _tmp12_;
		GtkButton* _tmp13_;
		_tmp9_ = self->priv->old_width;
		_tmp10_ = self->priv->old_height;
		gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp9_, _tmp10_);
		self->priv->old_width = 0;
		self->priv->old_height = 0;
		_tmp11_ = self->priv->content_stack;
		_tmp12_ = self->priv->info_box;
		gtk_stack_set_visible_child (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
		_tmp13_ = self->priv->save_button;
		gtk_button_set_label (_tmp13_, _ ("Save"));
	} else {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}


static void _account_dialog_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_cancel_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_save_button_clicked_cb (AccountDialog* self) {
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	CropWidget* _tmp3_;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->content_stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->crop_widget;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		GdkPixbuf* new_pixbuf = NULL;
		CropWidget* _tmp4_;
		GdkPixbuf* _tmp5_;
		CropWidget* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		GtkButton* _tmp20_;
		GtkStack* _tmp21_;
		GtkBox* _tmp22_;
		_tmp4_ = self->priv->crop_widget;
		_tmp5_ = crop_widget_get_cropped_image (_tmp4_);
		new_pixbuf = _tmp5_;
		_tmp6_ = self->priv->crop_widget;
		_tmp7_ = crop_widget_get_desired_aspect_ratio (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ == 1.0) {
			AvatarBannerWidget* _tmp9_;
			GdkPixbuf* _tmp10_;
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			_tmp9_ = self->priv->avatar_banner_widget;
			_tmp10_ = new_pixbuf;
			avatar_banner_widget_set_avatar (_tmp9_, _tmp10_);
			_tmp11_ = new_pixbuf;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (self->priv->new_avatar);
			self->priv->new_avatar = _tmp12_;
		} else {
			CropWidget* _tmp13_;
			gdouble _tmp14_;
			gdouble _tmp15_;
			_tmp13_ = self->priv->crop_widget;
			_tmp14_ = crop_widget_get_desired_aspect_ratio (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == 2.0) {
				AvatarBannerWidget* _tmp16_;
				GdkPixbuf* _tmp17_;
				GdkPixbuf* _tmp18_;
				GdkPixbuf* _tmp19_;
				_tmp16_ = self->priv->avatar_banner_widget;
				_tmp17_ = new_pixbuf;
				avatar_banner_widget_set_banner (_tmp16_, _tmp17_);
				_tmp18_ = new_pixbuf;
				_tmp19_ = _g_object_ref0 (_tmp18_);
				_g_object_unref0 (self->priv->new_banner);
				self->priv->new_banner = _tmp19_;
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp20_ = self->priv->save_button;
		gtk_button_set_label (_tmp20_, _ ("Save"));
		_tmp21_ = self->priv->content_stack;
		_tmp22_ = self->priv->info_box;
		gtk_stack_set_visible_child (_tmp21_, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (new_pixbuf);
	} else {
		account_dialog_save_data (self);
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}


static void _account_dialog_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_save_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_class_init (AccountDialogClass * klass) {
	gint AccountDialog_private_offset;
	account_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AccountDialogPrivate));
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget *)) account_dialog_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = account_dialog_finalize;
	AccountDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/account-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_banner_widget", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, avatar_banner_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_stack", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, delete_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "autostart_switch", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, autostart_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "website_entry", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, website_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_text_view", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, description_text_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "crop_widget", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, crop_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_stack", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, content_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_box", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, info_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, error_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, save_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_length_label", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, description_length_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_button_clicked_cb", G_CALLBACK(_account_dialog_delete_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_confirm_button_clicked_cb", G_CALLBACK(_account_dialog_delete_confirm_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_cancel_button_clicked_cb", G_CALLBACK(_account_dialog_delete_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "autostart_switch_activate_cb", G_CALLBACK(_account_dialog_autostart_switch_activate_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "avatar_clicked_cb", G_CALLBACK(_account_dialog_avatar_clicked_cb_avatar_banner_widget_avatar_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "banner_clicked_cb", G_CALLBACK(_account_dialog_banner_clicked_cb_avatar_banner_widget_banner_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_button_clicked_cb", G_CALLBACK(_account_dialog_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "save_button_clicked_cb", G_CALLBACK(_account_dialog_save_button_clicked_cb_gtk_button_clicked));
}


static void account_dialog_instance_init (AccountDialog * self) {
	self->priv = ACCOUNT_DIALOG_GET_PRIVATE (self);
	self->priv->new_avatar = NULL;
	self->priv->new_banner = NULL;
	self->priv->old_width = 0;
	self->priv->old_height = 0;
	self->priv->account_was_not_initied = FALSE;
	g_type_ensure (TYPE_AVATAR_BANNER_WIDGET);
	g_type_ensure (TYPE_COMPLETION_TEXT_VIEW);
	g_type_ensure (TYPE_CROP_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void account_dialog_finalize (GObject * obj) {
	AccountDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACCOUNT_DIALOG, AccountDialog);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->avatar_banner_widget);
	_g_object_unref0 (self->priv->delete_stack);
	_g_object_unref0 (self->priv->autostart_switch);
	_g_object_unref0 (self->priv->website_entry);
	_g_object_unref0 (self->priv->description_text_view);
	_g_object_unref0 (self->priv->crop_widget);
	_g_object_unref0 (self->priv->content_stack);
	_g_object_unref0 (self->priv->info_box);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->save_button);
	_g_object_unref0 (self->priv->description_length_label);
	_g_free0 (self->priv->old_user_name);
	_g_free0 (self->priv->old_description);
	_g_free0 (self->priv->old_website);
	_g_object_unref0 (self->priv->new_avatar);
	_g_object_unref0 (self->priv->new_banner);
	G_OBJECT_CLASS (account_dialog_parent_class)->finalize (obj);
}


GType account_dialog_get_type (void) {
	static volatile gsize account_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&account_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountDialog), 0, (GInstanceInitFunc) account_dialog_instance_init, NULL };
		GType account_dialog_type_id;
		account_dialog_type_id = g_type_register_static (gtk_window_get_type (), "AccountDialog", &g_define_type_info, 0);
		g_once_init_leave (&account_dialog_type_id__volatile, account_dialog_type_id);
	}
	return account_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



