/* MentionsTimeline.c generated by valac 0.38.7, the Vala compiler
 * generated from MentionsTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbMessageReceiver.h"
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include "CbUserStream.h"
#include <json-glib/json-glib.h>
#include "rest/oauth-proxy.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbTweet.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;

#define TYPE_MENTIONS_TIMELINE (mentions_timeline_get_type ())
#define MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimeline))
#define MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))
#define IS_MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENTIONS_TIMELINE))
#define IS_MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENTIONS_TIMELINE))
#define MENTIONS_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))

typedef struct _MentionsTimeline MentionsTimeline;
typedef struct _MentionsTimelineClass MentionsTimelineClass;
typedef struct _MentionsTimelinePrivate MentionsTimelinePrivate;
enum  {
	MENTIONS_TIMELINE_0_PROPERTY,
	MENTIONS_TIMELINE_FUNCTION_PROPERTY,
	MENTIONS_TIMELINE_NUM_PROPERTIES
};
static GParamSpec* mentions_timeline_properties[MENTIONS_TIMELINE_NUM_PROPERTIES];
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	MainWindow* main_window;
	TweetListBox* tweet_list;
	Account* account;
	BadgeRadioButton* radio_button;
	guint tweet_remove_timeout;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, CbBundle* args);
	void (*on_leave) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_radio_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

struct _MentionsTimeline {
	DefaultTimeline parent_instance;
	MentionsTimelinePrivate * priv;
};

struct _MentionsTimelineClass {
	DefaultTimelineClass parent_class;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer mentions_timeline_parent_class = NULL;
static CbMessageReceiverInterface * mentions_timeline_cb_message_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
GType mentions_timeline_get_type (void) G_GNUC_CONST;
MentionsTimeline* mentions_timeline_new (gint id, Account* account);
MentionsTimeline* mentions_timeline_construct (GType object_type, gint id, Account* account);
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
static void mentions_timeline_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root);
static void mentions_timeline_add_tweet (MentionsTimeline* self, JsonNode* root_node);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void default_timeline_mark_seen (DefaultTimeline* self, gint64 id);
CbTweetState default_timeline_get_rt_flags (DefaultTimeline* self, CbTweet* t);
gboolean account_filter_matches (Account* self, CbTweet* t);
gboolean account_blocked_or_muted (Account* self, gint64 user_id);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
gboolean default_timeline_scroll_up (DefaultTimeline* self, CbTweet* t);
gint default_timeline_get_unread_count (DefaultTimeline* self);
void default_timeline_set_unread_count (DefaultTimeline* self, gint value);
gboolean settings_notify_new_mentions (void);
gchar* utils_unescape_html (const gchar* input);
Account* account_query_account_by_id (gint64 id);
static GVariant* _variant_new1 (gint64 value);
static GVariant* _variant_new2 (gint64 value);
static GVariant* _variant_new3 (gint64 value);
static gchar* mentions_timeline_real_get_title (DefaultTimeline* base);
static void mentions_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void _vala_mentions_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


MentionsTimeline* mentions_timeline_construct (GType object_type, gint id, Account* account) {
	MentionsTimeline * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	TweetListBox* _tmp2_;
	Account* _tmp3_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = id;
	self = (MentionsTimeline*) default_timeline_construct (object_type, _tmp0_);
	_tmp1_ = account;
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account = _tmp1_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	return self;
}


MentionsTimeline* mentions_timeline_new (gint id, Account* account) {
	return mentions_timeline_construct (TYPE_MENTIONS_TIMELINE, id, account);
}


static void mentions_timeline_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root) {
	MentionsTimeline * self;
	CbStreamMessageType _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == CB_STREAM_MESSAGE_TWEET) {
		JsonNode* _tmp1_;
		_tmp1_ = root;
		mentions_timeline_add_tweet (self, _tmp1_);
	} else {
		CbStreamMessageType _tmp2_;
		_tmp2_ = type;
		if (_tmp2_ == CB_STREAM_MESSAGE_DELETE) {
			gint64 id = 0LL;
			JsonNode* _tmp3_;
			JsonObject* _tmp4_;
			JsonObject* _tmp5_;
			JsonObject* _tmp6_;
			gint64 _tmp7_;
			gint64 _tmp8_;
			_tmp3_ = root;
			_tmp4_ = json_node_get_object (_tmp3_);
			_tmp5_ = json_object_get_object_member (_tmp4_, "delete");
			_tmp6_ = json_object_get_object_member (_tmp5_, "status");
			_tmp7_ = json_object_get_int_member (_tmp6_, "id");
			id = _tmp7_;
			_tmp8_ = id;
			default_timeline_delete_tweet (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp8_);
		} else {
			CbStreamMessageType _tmp9_;
			_tmp9_ = type;
			if (_tmp9_ == CB_STREAM_MESSAGE_EVENT_FAVORITE) {
				gint64 id = 0LL;
				JsonNode* _tmp10_;
				JsonObject* _tmp11_;
				JsonObject* _tmp12_;
				gint64 _tmp13_;
				gint64 _tmp14_;
				_tmp10_ = root;
				_tmp11_ = json_node_get_object (_tmp10_);
				_tmp12_ = json_object_get_object_member (_tmp11_, "target_object");
				_tmp13_ = json_object_get_int_member (_tmp12_, "id");
				id = _tmp13_;
				_tmp14_ = id;
				default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp14_, TRUE);
			} else {
				CbStreamMessageType _tmp15_;
				_tmp15_ = type;
				if (_tmp15_ == CB_STREAM_MESSAGE_EVENT_UNFAVORITE) {
					gint64 id = 0LL;
					JsonNode* _tmp16_;
					JsonObject* _tmp17_;
					JsonObject* _tmp18_;
					gint64 _tmp19_;
					gint64 _tmp20_;
					_tmp16_ = root;
					_tmp17_ = json_node_get_object (_tmp16_);
					_tmp18_ = json_object_get_object_member (_tmp17_, "target_object");
					_tmp19_ = json_object_get_int_member (_tmp18_, "id");
					id = _tmp19_;
					_tmp20_ = id;
					default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp20_, FALSE);
				}
			}
		}
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static GVariant* _variant_new1 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static GVariant* _variant_new2 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static GVariant* _variant_new3 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static void mentions_timeline_add_tweet (MentionsTimeline* self, JsonNode* root_node) {
	JsonObject* root = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* author = NULL;
	JsonObject* _tmp3_;
	JsonObject* _tmp4_;
	JsonObject* _tmp5_;
	gboolean _tmp6_ = FALSE;
	JsonObject* _tmp7_;
	gint64 _tmp8_;
	Account* _tmp9_;
	gint64 _tmp10_;
	JsonObject* _tmp15_;
	const gchar* _tmp16_;
	Account* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	g_return_if_fail (IS_MENTIONS_TIMELINE (self));
	g_return_if_fail (root_node != NULL);
	_tmp0_ = root_node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	root = _tmp2_;
	_tmp3_ = root;
	_tmp4_ = json_object_get_object_member (_tmp3_, "user");
	_tmp5_ = _json_object_ref0 (_tmp4_);
	author = _tmp5_;
	_tmp7_ = author;
	_tmp8_ = json_object_get_int_member (_tmp7_, "id");
	_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp10_ = _tmp9_->id;
	if (_tmp8_ == _tmp10_) {
		JsonObject* _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = root;
		_tmp12_ = json_object_get_null_member (_tmp11_, "in_reply_to_status_id");
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		JsonObject* _tmp13_;
		gint64 _tmp14_;
		_tmp13_ = root;
		_tmp14_ = json_object_get_int_member (_tmp13_, "in_reply_to_status_id");
		default_timeline_mark_seen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp14_);
		_json_object_unref0 (author);
		_json_object_unref0 (root);
		return;
	}
	_tmp15_ = root;
	_tmp16_ = json_object_get_string_member (_tmp15_, "text");
	_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp18_ = _tmp17_->screen_name;
	_tmp19_ = g_strconcat ("@", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = string_contains (_tmp16_, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	if (_tmp22_) {
		GDateTime* now = NULL;
		GDateTime* _tmp23_;
		CbTweet* t = NULL;
		CbTweet* _tmp24_;
		CbTweet* _tmp25_;
		JsonNode* _tmp26_;
		Account* _tmp27_;
		gint64 _tmp28_;
		GDateTime* _tmp29_;
		CbTweet* _tmp30_;
		gint64 _tmp31_;
		Account* _tmp32_;
		gint64 _tmp33_;
		gboolean _tmp34_ = FALSE;
		CbTweet* _tmp35_;
		CbMiniTweet* _tmp36_;
		Account* _tmp39_;
		CbTweet* _tmp40_;
		gboolean _tmp41_;
		Account* _tmp42_;
		CbTweet* _tmp43_;
		gint64 _tmp44_;
		gboolean _tmp45_;
		CbTweet* _tmp46_;
		TweetListBox* _tmp47_;
		CbTweetModel* _tmp48_;
		CbTweet* _tmp49_;
		CbTweet* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gboolean _tmp53_;
		_tmp23_ = g_date_time_new_now_local ();
		now = _tmp23_;
		_tmp24_ = cb_tweet_new ();
		t = _tmp24_;
		_tmp25_ = t;
		_tmp26_ = root_node;
		_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp28_ = _tmp27_->id;
		_tmp29_ = now;
		cb_tweet_load_from_json (_tmp25_, _tmp26_, _tmp28_, _tmp29_);
		_tmp30_ = t;
		_tmp31_ = cb_tweet_get_user_id (_tmp30_);
		_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp33_ = _tmp32_->id;
		if (_tmp31_ == _tmp33_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp35_ = t;
		_tmp36_ = _tmp35_->retweeted_tweet;
		if (_tmp36_ != NULL) {
			CbTweet* _tmp37_;
			CbTweetState _tmp38_;
			_tmp37_ = t;
			_tmp38_ = default_timeline_get_rt_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp37_);
			_tmp34_ = _tmp38_ > 0;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp39_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp40_ = t;
		_tmp41_ = account_filter_matches (_tmp39_, _tmp40_);
		if (_tmp41_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp42_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp43_ = t;
		_tmp44_ = cb_tweet_get_user_id (_tmp43_);
		_tmp45_ = account_blocked_or_muted (_tmp42_, _tmp44_);
		if (_tmp45_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TOP);
		_tmp46_ = t;
		cb_tweet_set_seen (_tmp46_, FALSE);
		_tmp47_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
		_tmp48_ = _tmp47_->model;
		_tmp49_ = t;
		cb_tweet_model_add (_tmp48_, _tmp49_);
		_tmp50_ = t;
		default_timeline_scroll_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp50_);
		_tmp51_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
		_tmp52_ = _tmp51_;
		default_timeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp52_ + 1);
		_tmp53_ = settings_notify_new_mentions ();
		if (_tmp53_) {
			gchar* text = NULL;
			CbTweet* _tmp54_;
			CbMiniTweet* _tmp55_;
			CbTweet* _tmp64_;
			gint64 _tmp65_;
			Account* _tmp66_;
			_tmp54_ = t;
			_tmp55_ = _tmp54_->retweeted_tweet;
			if (_tmp55_ != NULL) {
				CbTweet* _tmp56_;
				CbMiniTweet* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				_tmp56_ = t;
				_tmp57_ = _tmp56_->retweeted_tweet;
				_tmp58_ = (*_tmp57_).text;
				_tmp59_ = utils_unescape_html (_tmp58_);
				_g_free0 (text);
				text = _tmp59_;
			} else {
				CbTweet* _tmp60_;
				CbMiniTweet _tmp61_;
				const gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp60_ = t;
				_tmp61_ = _tmp60_->source_tweet;
				_tmp62_ = _tmp61_.text;
				_tmp63_ = utils_unescape_html (_tmp62_);
				_g_free0 (text);
				text = _tmp63_;
			}
			_tmp64_ = t;
			_tmp65_ = cb_tweet_get_user_id (_tmp64_);
			_tmp66_ = account_query_account_by_id (_tmp65_);
			if (_tmp66_ == NULL) {
				gchar* summary = NULL;
				CbTweet* _tmp67_;
				const gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				Account* _tmp71_;
				const gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* id = NULL;
				Account* _tmp75_;
				gint64 _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				GVariant* tuple = NULL;
				Account* _tmp81_;
				gint64 _tmp82_;
				GVariant* _tmp83_;
				CbTweet* _tmp84_;
				gint64 _tmp85_;
				GVariant* _tmp86_;
				GVariant** _tmp87_;
				GVariant** _tmp88_;
				gint _tmp88__length1;
				GVariant* _tmp89_;
				GVariant* _tmp90_;
				GNotification* notification = NULL;
				const gchar* _tmp91_;
				GNotification* _tmp92_;
				GNotification* _tmp93_;
				const gchar* _tmp94_;
				GNotification* _tmp95_;
				Account* _tmp96_;
				gint64 _tmp97_;
				GVariant* _tmp98_;
				GNotification* _tmp99_;
				GVariant* _tmp100_;
				GNotification* _tmp101_;
				GVariant* _tmp102_;
				CbTweet* _tmp103_;
				const gchar* _tmp104_;
				gchar* _tmp105_;
				GApplication* _tmp106_;
				const gchar* _tmp107_;
				GNotification* _tmp108_;
				_tmp67_ = t;
				_tmp68_ = cb_tweet_get_user_name (_tmp67_);
				_tmp69_ = utils_unescape_html (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
				_tmp72_ = _tmp71_->name;
				_tmp73_ = g_strdup_printf (_ ("%s mentioned %s"), _tmp70_, _tmp72_);
				_tmp74_ = _tmp73_;
				_g_free0 (_tmp70_);
				summary = _tmp74_;
				_tmp75_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
				_tmp76_ = _tmp75_->id;
				_tmp77_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = g_strdup_printf ("%s-%s", _tmp78_, "mention");
				_tmp80_ = _tmp79_;
				_g_free0 (_tmp78_);
				id = _tmp80_;
				_tmp81_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
				_tmp82_ = _tmp81_->id;
				_tmp83_ = _variant_new1 (_tmp82_);
				_tmp84_ = t;
				_tmp85_ = _tmp84_->id;
				_tmp86_ = _variant_new2 (_tmp85_);
				_tmp87_ = g_new0 (GVariant*, 2 + 1);
				_tmp87_[0] = _tmp83_;
				_tmp87_[1] = _tmp86_;
				_tmp88_ = _tmp87_;
				_tmp88__length1 = 2;
				_tmp89_ = g_variant_new_tuple (_tmp88_, 2);
				g_variant_ref_sink (_tmp89_);
				_tmp90_ = _tmp89_;
				_tmp88_ = (_vala_array_free (_tmp88_, _tmp88__length1, (GDestroyNotify) g_variant_unref), NULL);
				tuple = _tmp90_;
				_tmp91_ = summary;
				_tmp92_ = g_notification_new (_tmp91_);
				notification = _tmp92_;
				_tmp93_ = notification;
				_tmp94_ = text;
				g_notification_set_body (_tmp93_, _tmp94_);
				_tmp95_ = notification;
				_tmp96_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
				_tmp97_ = _tmp96_->id;
				_tmp98_ = _variant_new3 (_tmp97_);
				g_notification_set_default_action_and_target_value (_tmp95_, "app.show-window", _tmp98_);
				_g_variant_unref0 (_tmp98_);
				_tmp99_ = notification;
				_tmp100_ = tuple;
				g_notification_add_button_with_target_value (_tmp99_, "Mark read", "app.mark-read", _tmp100_);
				_tmp101_ = notification;
				_tmp102_ = tuple;
				g_notification_add_button_with_target_value (_tmp101_, "Reply", "app.reply-to-tweet", _tmp102_);
				_tmp103_ = t;
				_tmp104_ = id;
				_tmp105_ = g_strdup (_tmp104_);
				_g_free0 (_tmp103_->notification_id);
				_tmp103_->notification_id = _tmp105_;
				_tmp106_ = g_application_get_default ();
				_tmp107_ = id;
				_tmp108_ = notification;
				g_application_send_notification (_tmp106_, _tmp107_, _tmp108_);
				_g_object_unref0 (notification);
				_g_variant_unref0 (tuple);
				_g_free0 (id);
				_g_free0 (summary);
			}
			_g_free0 (text);
		}
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
	}
	_json_object_unref0 (author);
	_json_object_unref0 (root);
}


static gchar* mentions_timeline_real_get_title (DefaultTimeline* base) {
	MentionsTimeline * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	_tmp0_ = g_strdup (_ ("Mentions"));
	result = _tmp0_;
	return result;
}


static void mentions_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group) {
	MentionsTimeline * self;
	GtkRadioButton* _tmp0_;
	BadgeRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = badge_radio_button_new (_tmp0_, "corebird-mentions-symbolic", _ ("Mentions"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button = _tmp1_;
}


static const gchar* mentions_timeline_real_get_function (DefaultTimeline* base) {
	const gchar* result;
	MentionsTimeline* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	result = "1.1/statuses/mentions_timeline.json";
	return result;
}


static void mentions_timeline_class_init (MentionsTimelineClass * klass) {
	mentions_timeline_parent_class = g_type_class_peek_parent (klass);
	((DefaultTimelineClass *) klass)->get_title = (gchar* (*) (DefaultTimeline *)) mentions_timeline_real_get_title;
	((DefaultTimelineClass *) klass)->create_radio_button = (void (*) (DefaultTimeline *, GtkRadioButton*)) mentions_timeline_real_create_radio_button;
	DEFAULT_TIMELINE_CLASS (klass)->get_function = mentions_timeline_real_get_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_mentions_timeline_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENTIONS_TIMELINE_FUNCTION_PROPERTY, mentions_timeline_properties[MENTIONS_TIMELINE_FUNCTION_PROPERTY] = g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void mentions_timeline_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	mentions_timeline_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) mentions_timeline_real_stream_message_received;
}


static void mentions_timeline_instance_init (MentionsTimeline * self) {
}


GType mentions_timeline_get_type (void) {
	static volatile gsize mentions_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&mentions_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MentionsTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mentions_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MentionsTimeline), 0, (GInstanceInitFunc) mentions_timeline_instance_init, NULL };
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) mentions_timeline_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType mentions_timeline_type_id;
		mentions_timeline_type_id = g_type_register_static (TYPE_DEFAULT_TIMELINE, "MentionsTimeline", &g_define_type_info, 0);
		g_type_add_interface_static (mentions_timeline_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&mentions_timeline_type_id__volatile, mentions_timeline_type_id);
	}
	return mentions_timeline_type_id__volatile;
}


static void _vala_mentions_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MentionsTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	switch (property_id) {
		case MENTIONS_TIMELINE_FUNCTION_PROPERTY:
		g_value_set_string (value, default_timeline_get_function (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



