; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqccmp -verify-machineinstrs < %s \
; RUN: | FileCheck %s -check-prefixes=RV32IXQCCMP
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqccmp -verify-machineinstrs \
; RUN:  -frame-pointer=all < %s | FileCheck %s -check-prefixes=RV32IXQCCMP-WITH-FP
; RUN: llc -mtriple=riscv64 -mattr=+experimental-xqccmp -verify-machineinstrs < %s \
; RUN: | FileCheck %s -check-prefixes=RV64IXQCCMP
; RUN: llc -mtriple=riscv64 -mattr=+experimental-xqccmp -verify-machineinstrs \
; RUN:  -frame-pointer=all < %s | FileCheck %s -check-prefixes=RV64IXQCCMP-WITH-FP

@var = global [32 x i32] zeroinitializer

; This function tests that RISCVRegisterInfo::getCalleeSavedRegs returns
; something appropriate.

define void @callee() {
; RV32IXQCCMP-LABEL: callee:
; RV32IXQCCMP:       # %bb.0:
; RV32IXQCCMP-NEXT:    qc.cm.push {ra, s0-s11}, -96
; RV32IXQCCMP-NEXT:    .cfi_def_cfa_offset 96
; RV32IXQCCMP-NEXT:    .cfi_offset ra, -4
; RV32IXQCCMP-NEXT:    .cfi_offset s0, -8
; RV32IXQCCMP-NEXT:    .cfi_offset s1, -12
; RV32IXQCCMP-NEXT:    .cfi_offset s2, -16
; RV32IXQCCMP-NEXT:    .cfi_offset s3, -20
; RV32IXQCCMP-NEXT:    .cfi_offset s4, -24
; RV32IXQCCMP-NEXT:    .cfi_offset s5, -28
; RV32IXQCCMP-NEXT:    .cfi_offset s6, -32
; RV32IXQCCMP-NEXT:    .cfi_offset s7, -36
; RV32IXQCCMP-NEXT:    .cfi_offset s8, -40
; RV32IXQCCMP-NEXT:    .cfi_offset s9, -44
; RV32IXQCCMP-NEXT:    .cfi_offset s10, -48
; RV32IXQCCMP-NEXT:    .cfi_offset s11, -52
; RV32IXQCCMP-NEXT:    lui t0, %hi(var)
; RV32IXQCCMP-NEXT:    lw a0, %lo(var)(t0)
; RV32IXQCCMP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, %lo(var+4)(t0)
; RV32IXQCCMP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, %lo(var+8)(t0)
; RV32IXQCCMP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, %lo(var+12)(t0)
; RV32IXQCCMP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    addi a5, t0, %lo(var)
; RV32IXQCCMP-NEXT:    lw a0, 16(a5)
; RV32IXQCCMP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 20(a5)
; RV32IXQCCMP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw t4, 24(a5)
; RV32IXQCCMP-NEXT:    lw t5, 28(a5)
; RV32IXQCCMP-NEXT:    lw t6, 32(a5)
; RV32IXQCCMP-NEXT:    lw s2, 36(a5)
; RV32IXQCCMP-NEXT:    lw s3, 40(a5)
; RV32IXQCCMP-NEXT:    lw s4, 44(a5)
; RV32IXQCCMP-NEXT:    lw s5, 48(a5)
; RV32IXQCCMP-NEXT:    lw s6, 52(a5)
; RV32IXQCCMP-NEXT:    lw s7, 56(a5)
; RV32IXQCCMP-NEXT:    lw s8, 60(a5)
; RV32IXQCCMP-NEXT:    lw s9, 64(a5)
; RV32IXQCCMP-NEXT:    lw s10, 68(a5)
; RV32IXQCCMP-NEXT:    lw s11, 72(a5)
; RV32IXQCCMP-NEXT:    lw ra, 76(a5)
; RV32IXQCCMP-NEXT:    lw s1, 80(a5)
; RV32IXQCCMP-NEXT:    lw t3, 84(a5)
; RV32IXQCCMP-NEXT:    lw t2, 88(a5)
; RV32IXQCCMP-NEXT:    lw t1, 92(a5)
; RV32IXQCCMP-NEXT:    lw a7, 112(a5)
; RV32IXQCCMP-NEXT:    lw s0, 116(a5)
; RV32IXQCCMP-NEXT:    lw a3, 120(a5)
; RV32IXQCCMP-NEXT:    lw a0, 124(a5)
; RV32IXQCCMP-NEXT:    lw a6, 96(a5)
; RV32IXQCCMP-NEXT:    lw a4, 100(a5)
; RV32IXQCCMP-NEXT:    lw a2, 104(a5)
; RV32IXQCCMP-NEXT:    lw a1, 108(a5)
; RV32IXQCCMP-NEXT:    sw a0, 124(a5)
; RV32IXQCCMP-NEXT:    sw a3, 120(a5)
; RV32IXQCCMP-NEXT:    sw s0, 116(a5)
; RV32IXQCCMP-NEXT:    sw a7, 112(a5)
; RV32IXQCCMP-NEXT:    sw a1, 108(a5)
; RV32IXQCCMP-NEXT:    sw a2, 104(a5)
; RV32IXQCCMP-NEXT:    sw a4, 100(a5)
; RV32IXQCCMP-NEXT:    sw a6, 96(a5)
; RV32IXQCCMP-NEXT:    sw t1, 92(a5)
; RV32IXQCCMP-NEXT:    sw t2, 88(a5)
; RV32IXQCCMP-NEXT:    sw t3, 84(a5)
; RV32IXQCCMP-NEXT:    sw s1, 80(a5)
; RV32IXQCCMP-NEXT:    sw ra, 76(a5)
; RV32IXQCCMP-NEXT:    sw s11, 72(a5)
; RV32IXQCCMP-NEXT:    sw s10, 68(a5)
; RV32IXQCCMP-NEXT:    sw s9, 64(a5)
; RV32IXQCCMP-NEXT:    sw s8, 60(a5)
; RV32IXQCCMP-NEXT:    sw s7, 56(a5)
; RV32IXQCCMP-NEXT:    sw s6, 52(a5)
; RV32IXQCCMP-NEXT:    sw s5, 48(a5)
; RV32IXQCCMP-NEXT:    sw s4, 44(a5)
; RV32IXQCCMP-NEXT:    sw s3, 40(a5)
; RV32IXQCCMP-NEXT:    sw s2, 36(a5)
; RV32IXQCCMP-NEXT:    sw t6, 32(a5)
; RV32IXQCCMP-NEXT:    sw t5, 28(a5)
; RV32IXQCCMP-NEXT:    sw t4, 24(a5)
; RV32IXQCCMP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 20(a5)
; RV32IXQCCMP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 16(a5)
; RV32IXQCCMP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, %lo(var+12)(t0)
; RV32IXQCCMP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, %lo(var+8)(t0)
; RV32IXQCCMP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, %lo(var+4)(t0)
; RV32IXQCCMP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, %lo(var)(t0)
; RV32IXQCCMP-NEXT:    qc.cm.popret {ra, s0-s11}, 96
;
; RV32IXQCCMP-WITH-FP-LABEL: callee:
; RV32IXQCCMP-WITH-FP:       # %bb.0:
; RV32IXQCCMP-WITH-FP-NEXT:    qc.cm.pushfp {ra, s0-s11}, -96
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 96
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -4
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -8
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s1, -12
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s2, -16
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s3, -20
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s4, -24
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s5, -28
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s6, -32
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s7, -36
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s8, -40
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s9, -44
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s10, -48
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s11, -52
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV32IXQCCMP-WITH-FP-NEXT:    lui t1, %hi(var)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var)(t1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -68(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+4)(t1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -72(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+8)(t1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -76(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+12)(t1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -80(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    addi a5, t1, %lo(var)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 16(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -84(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 20(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -88(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 24(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -92(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw t5, 28(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw t6, 32(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s2, 36(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s3, 40(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s4, 44(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s5, 48(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s6, 52(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s7, 56(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s8, 60(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s9, 64(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s10, 68(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s11, 72(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw ra, 76(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw t4, 80(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw t3, 84(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw t2, 88(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s1, 92(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw t0, 112(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a4, 116(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a3, 120(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 124(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a7, 96(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a6, 100(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a2, 104(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a1, 108(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 124(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a3, 120(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a4, 116(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw t0, 112(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a1, 108(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a2, 104(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a6, 100(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a7, 96(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s1, 92(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw t2, 88(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw t3, 84(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw t4, 80(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw ra, 76(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s11, 72(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s10, 68(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s9, 64(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s8, 60(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s7, 56(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s6, 52(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s5, 48(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s4, 44(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s3, 40(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s2, 36(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw t6, 32(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    sw t5, 28(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -92(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 24(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -88(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 20(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -84(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 16(a5)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -80(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+12)(t1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -76(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+8)(t1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -72(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+4)(t1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -68(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var)(t1)
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 96
; RV32IXQCCMP-WITH-FP-NEXT:    qc.cm.popret {ra, s0-s11}, 96
;
; RV64IXQCCMP-LABEL: callee:
; RV64IXQCCMP:       # %bb.0:
; RV64IXQCCMP-NEXT:    qc.cm.push {ra, s0-s11}, -160
; RV64IXQCCMP-NEXT:    .cfi_def_cfa_offset 160
; RV64IXQCCMP-NEXT:    .cfi_offset ra, -8
; RV64IXQCCMP-NEXT:    .cfi_offset s0, -16
; RV64IXQCCMP-NEXT:    .cfi_offset s1, -24
; RV64IXQCCMP-NEXT:    .cfi_offset s2, -32
; RV64IXQCCMP-NEXT:    .cfi_offset s3, -40
; RV64IXQCCMP-NEXT:    .cfi_offset s4, -48
; RV64IXQCCMP-NEXT:    .cfi_offset s5, -56
; RV64IXQCCMP-NEXT:    .cfi_offset s6, -64
; RV64IXQCCMP-NEXT:    .cfi_offset s7, -72
; RV64IXQCCMP-NEXT:    .cfi_offset s8, -80
; RV64IXQCCMP-NEXT:    .cfi_offset s9, -88
; RV64IXQCCMP-NEXT:    .cfi_offset s10, -96
; RV64IXQCCMP-NEXT:    .cfi_offset s11, -104
; RV64IXQCCMP-NEXT:    lui t0, %hi(var)
; RV64IXQCCMP-NEXT:    lw a0, %lo(var)(t0)
; RV64IXQCCMP-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, %lo(var+4)(t0)
; RV64IXQCCMP-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, %lo(var+8)(t0)
; RV64IXQCCMP-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, %lo(var+12)(t0)
; RV64IXQCCMP-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    addi a5, t0, %lo(var)
; RV64IXQCCMP-NEXT:    lw a0, 16(a5)
; RV64IXQCCMP-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 20(a5)
; RV64IXQCCMP-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw t4, 24(a5)
; RV64IXQCCMP-NEXT:    lw t5, 28(a5)
; RV64IXQCCMP-NEXT:    lw t6, 32(a5)
; RV64IXQCCMP-NEXT:    lw s2, 36(a5)
; RV64IXQCCMP-NEXT:    lw s3, 40(a5)
; RV64IXQCCMP-NEXT:    lw s4, 44(a5)
; RV64IXQCCMP-NEXT:    lw s5, 48(a5)
; RV64IXQCCMP-NEXT:    lw s6, 52(a5)
; RV64IXQCCMP-NEXT:    lw s7, 56(a5)
; RV64IXQCCMP-NEXT:    lw s8, 60(a5)
; RV64IXQCCMP-NEXT:    lw s9, 64(a5)
; RV64IXQCCMP-NEXT:    lw s10, 68(a5)
; RV64IXQCCMP-NEXT:    lw s11, 72(a5)
; RV64IXQCCMP-NEXT:    lw ra, 76(a5)
; RV64IXQCCMP-NEXT:    lw s1, 80(a5)
; RV64IXQCCMP-NEXT:    lw t3, 84(a5)
; RV64IXQCCMP-NEXT:    lw t2, 88(a5)
; RV64IXQCCMP-NEXT:    lw t1, 92(a5)
; RV64IXQCCMP-NEXT:    lw a7, 112(a5)
; RV64IXQCCMP-NEXT:    lw s0, 116(a5)
; RV64IXQCCMP-NEXT:    lw a3, 120(a5)
; RV64IXQCCMP-NEXT:    lw a0, 124(a5)
; RV64IXQCCMP-NEXT:    lw a6, 96(a5)
; RV64IXQCCMP-NEXT:    lw a4, 100(a5)
; RV64IXQCCMP-NEXT:    lw a2, 104(a5)
; RV64IXQCCMP-NEXT:    lw a1, 108(a5)
; RV64IXQCCMP-NEXT:    sw a0, 124(a5)
; RV64IXQCCMP-NEXT:    sw a3, 120(a5)
; RV64IXQCCMP-NEXT:    sw s0, 116(a5)
; RV64IXQCCMP-NEXT:    sw a7, 112(a5)
; RV64IXQCCMP-NEXT:    sw a1, 108(a5)
; RV64IXQCCMP-NEXT:    sw a2, 104(a5)
; RV64IXQCCMP-NEXT:    sw a4, 100(a5)
; RV64IXQCCMP-NEXT:    sw a6, 96(a5)
; RV64IXQCCMP-NEXT:    sw t1, 92(a5)
; RV64IXQCCMP-NEXT:    sw t2, 88(a5)
; RV64IXQCCMP-NEXT:    sw t3, 84(a5)
; RV64IXQCCMP-NEXT:    sw s1, 80(a5)
; RV64IXQCCMP-NEXT:    sw ra, 76(a5)
; RV64IXQCCMP-NEXT:    sw s11, 72(a5)
; RV64IXQCCMP-NEXT:    sw s10, 68(a5)
; RV64IXQCCMP-NEXT:    sw s9, 64(a5)
; RV64IXQCCMP-NEXT:    sw s8, 60(a5)
; RV64IXQCCMP-NEXT:    sw s7, 56(a5)
; RV64IXQCCMP-NEXT:    sw s6, 52(a5)
; RV64IXQCCMP-NEXT:    sw s5, 48(a5)
; RV64IXQCCMP-NEXT:    sw s4, 44(a5)
; RV64IXQCCMP-NEXT:    sw s3, 40(a5)
; RV64IXQCCMP-NEXT:    sw s2, 36(a5)
; RV64IXQCCMP-NEXT:    sw t6, 32(a5)
; RV64IXQCCMP-NEXT:    sw t5, 28(a5)
; RV64IXQCCMP-NEXT:    sw t4, 24(a5)
; RV64IXQCCMP-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 20(a5)
; RV64IXQCCMP-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 16(a5)
; RV64IXQCCMP-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, %lo(var+12)(t0)
; RV64IXQCCMP-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, %lo(var+8)(t0)
; RV64IXQCCMP-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, %lo(var+4)(t0)
; RV64IXQCCMP-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, %lo(var)(t0)
; RV64IXQCCMP-NEXT:    qc.cm.popret {ra, s0-s11}, 160
;
; RV64IXQCCMP-WITH-FP-LABEL: callee:
; RV64IXQCCMP-WITH-FP:       # %bb.0:
; RV64IXQCCMP-WITH-FP-NEXT:    qc.cm.pushfp {ra, s0-s11}, -160
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 160
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -8
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -16
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s1, -24
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s2, -32
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s3, -40
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s4, -48
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s5, -56
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s6, -64
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s7, -72
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s8, -80
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s9, -88
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s10, -96
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s11, -104
; RV64IXQCCMP-WITH-FP-NEXT:    addi sp, sp, -16
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 176
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV64IXQCCMP-WITH-FP-NEXT:    lui t1, %hi(var)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var)(t1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -120(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+4)(t1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -128(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+8)(t1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -136(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+12)(t1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -144(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    addi a5, t1, %lo(var)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 16(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -152(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 20(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -160(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 24(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -168(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw t5, 28(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw t6, 32(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s2, 36(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s3, 40(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s4, 44(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s5, 48(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s6, 52(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s7, 56(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s8, 60(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s9, 64(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s10, 68(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s11, 72(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw ra, 76(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw t4, 80(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw t3, 84(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw t2, 88(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s1, 92(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw t0, 112(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a4, 116(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a3, 120(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 124(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a7, 96(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a6, 100(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a2, 104(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a1, 108(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 124(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw a3, 120(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw a4, 116(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw t0, 112(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw a1, 108(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw a2, 104(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw a6, 100(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw a7, 96(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s1, 92(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw t2, 88(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw t3, 84(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw t4, 80(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw ra, 76(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s11, 72(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s10, 68(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s9, 64(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s8, 60(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s7, 56(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s6, 52(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s5, 48(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s4, 44(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s3, 40(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s2, 36(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw t6, 32(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    sw t5, 28(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -168(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 24(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -160(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 20(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -152(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 16(a5)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -144(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+12)(t1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -136(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+8)(t1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -128(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+4)(t1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -120(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var)(t1)
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 176
; RV64IXQCCMP-WITH-FP-NEXT:    addi sp, sp, 16
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 160
; RV64IXQCCMP-WITH-FP-NEXT:    qc.cm.popret {ra, s0-s11}, 160
  %val = load [32 x i32], ptr @var
  store volatile [32 x i32] %val, ptr @var
  ret void
}

; This function tests that RISCVRegisterInfo::getCallPreservedMask returns
; something appropriate.

define void @caller() {
; RV32IXQCCMP-LABEL: caller:
; RV32IXQCCMP:       # %bb.0:
; RV32IXQCCMP-NEXT:    qc.cm.push {ra, s0-s11}, -112
; RV32IXQCCMP-NEXT:    .cfi_def_cfa_offset 112
; RV32IXQCCMP-NEXT:    .cfi_offset ra, -4
; RV32IXQCCMP-NEXT:    .cfi_offset s0, -8
; RV32IXQCCMP-NEXT:    .cfi_offset s1, -12
; RV32IXQCCMP-NEXT:    .cfi_offset s2, -16
; RV32IXQCCMP-NEXT:    .cfi_offset s3, -20
; RV32IXQCCMP-NEXT:    .cfi_offset s4, -24
; RV32IXQCCMP-NEXT:    .cfi_offset s5, -28
; RV32IXQCCMP-NEXT:    .cfi_offset s6, -32
; RV32IXQCCMP-NEXT:    .cfi_offset s7, -36
; RV32IXQCCMP-NEXT:    .cfi_offset s8, -40
; RV32IXQCCMP-NEXT:    .cfi_offset s9, -44
; RV32IXQCCMP-NEXT:    .cfi_offset s10, -48
; RV32IXQCCMP-NEXT:    .cfi_offset s11, -52
; RV32IXQCCMP-NEXT:    addi sp, sp, -48
; RV32IXQCCMP-NEXT:    .cfi_def_cfa_offset 160
; RV32IXQCCMP-NEXT:    lui s0, %hi(var)
; RV32IXQCCMP-NEXT:    lw a0, %lo(var)(s0)
; RV32IXQCCMP-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, %lo(var+4)(s0)
; RV32IXQCCMP-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, %lo(var+8)(s0)
; RV32IXQCCMP-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, %lo(var+12)(s0)
; RV32IXQCCMP-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    addi s1, s0, %lo(var)
; RV32IXQCCMP-NEXT:    lw a0, 16(s1)
; RV32IXQCCMP-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 20(s1)
; RV32IXQCCMP-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 24(s1)
; RV32IXQCCMP-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 28(s1)
; RV32IXQCCMP-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 32(s1)
; RV32IXQCCMP-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 36(s1)
; RV32IXQCCMP-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 40(s1)
; RV32IXQCCMP-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 44(s1)
; RV32IXQCCMP-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 48(s1)
; RV32IXQCCMP-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 52(s1)
; RV32IXQCCMP-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 56(s1)
; RV32IXQCCMP-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 60(s1)
; RV32IXQCCMP-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 64(s1)
; RV32IXQCCMP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 68(s1)
; RV32IXQCCMP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 72(s1)
; RV32IXQCCMP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 76(s1)
; RV32IXQCCMP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 80(s1)
; RV32IXQCCMP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw a0, 84(s1)
; RV32IXQCCMP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    lw s4, 88(s1)
; RV32IXQCCMP-NEXT:    lw s5, 92(s1)
; RV32IXQCCMP-NEXT:    lw s6, 96(s1)
; RV32IXQCCMP-NEXT:    lw s7, 100(s1)
; RV32IXQCCMP-NEXT:    lw s8, 104(s1)
; RV32IXQCCMP-NEXT:    lw s9, 108(s1)
; RV32IXQCCMP-NEXT:    lw s10, 112(s1)
; RV32IXQCCMP-NEXT:    lw s11, 116(s1)
; RV32IXQCCMP-NEXT:    lw s2, 120(s1)
; RV32IXQCCMP-NEXT:    lw s3, 124(s1)
; RV32IXQCCMP-NEXT:    call callee
; RV32IXQCCMP-NEXT:    sw s3, 124(s1)
; RV32IXQCCMP-NEXT:    sw s2, 120(s1)
; RV32IXQCCMP-NEXT:    sw s11, 116(s1)
; RV32IXQCCMP-NEXT:    sw s10, 112(s1)
; RV32IXQCCMP-NEXT:    sw s9, 108(s1)
; RV32IXQCCMP-NEXT:    sw s8, 104(s1)
; RV32IXQCCMP-NEXT:    sw s7, 100(s1)
; RV32IXQCCMP-NEXT:    sw s6, 96(s1)
; RV32IXQCCMP-NEXT:    sw s5, 92(s1)
; RV32IXQCCMP-NEXT:    sw s4, 88(s1)
; RV32IXQCCMP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 84(s1)
; RV32IXQCCMP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 80(s1)
; RV32IXQCCMP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 76(s1)
; RV32IXQCCMP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 72(s1)
; RV32IXQCCMP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 68(s1)
; RV32IXQCCMP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 64(s1)
; RV32IXQCCMP-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 60(s1)
; RV32IXQCCMP-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 56(s1)
; RV32IXQCCMP-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 52(s1)
; RV32IXQCCMP-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 48(s1)
; RV32IXQCCMP-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 44(s1)
; RV32IXQCCMP-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 40(s1)
; RV32IXQCCMP-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 36(s1)
; RV32IXQCCMP-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 32(s1)
; RV32IXQCCMP-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 28(s1)
; RV32IXQCCMP-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 24(s1)
; RV32IXQCCMP-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 20(s1)
; RV32IXQCCMP-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, 16(s1)
; RV32IXQCCMP-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, %lo(var+12)(s0)
; RV32IXQCCMP-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, %lo(var+8)(s0)
; RV32IXQCCMP-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, %lo(var+4)(s0)
; RV32IXQCCMP-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    sw a0, %lo(var)(s0)
; RV32IXQCCMP-NEXT:    addi sp, sp, 48
; RV32IXQCCMP-NEXT:    .cfi_def_cfa_offset 112
; RV32IXQCCMP-NEXT:    qc.cm.popret {ra, s0-s11}, 112
;
; RV32IXQCCMP-WITH-FP-LABEL: caller:
; RV32IXQCCMP-WITH-FP:       # %bb.0:
; RV32IXQCCMP-WITH-FP-NEXT:    qc.cm.pushfp {ra, s0-s11}, -112
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 112
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -4
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -8
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s1, -12
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s2, -16
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s3, -20
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s4, -24
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s5, -28
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s6, -32
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s7, -36
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s8, -40
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s9, -44
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s10, -48
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s11, -52
; RV32IXQCCMP-WITH-FP-NEXT:    addi sp, sp, -48
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 160
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV32IXQCCMP-WITH-FP-NEXT:    lui s6, %hi(var)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var)(s6)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -68(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+4)(s6)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -72(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+8)(s6)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -76(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+12)(s6)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -80(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    addi s1, s6, %lo(var)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 16(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -84(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 20(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -88(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 24(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -92(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 28(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -96(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 32(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -100(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 36(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -104(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 40(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -108(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 44(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -112(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 48(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -116(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 52(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -120(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 56(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -124(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 60(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -128(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 64(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -132(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 68(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -136(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 72(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -140(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 76(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -144(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 80(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -148(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 84(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -152(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, 88(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, -156(s0) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    lw s8, 92(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s9, 96(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s10, 100(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s11, 104(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s2, 108(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s3, 112(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s4, 116(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s5, 120(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw s7, 124(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    call callee
; RV32IXQCCMP-WITH-FP-NEXT:    sw s7, 124(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s5, 120(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s4, 116(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s3, 112(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s2, 108(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s11, 104(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s10, 100(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s9, 96(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    sw s8, 92(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -156(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 88(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -152(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 84(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -148(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 80(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -144(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 76(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -140(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 72(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -136(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 68(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -132(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 64(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -128(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 60(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -124(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 56(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -120(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 52(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -116(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 48(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -112(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 44(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -108(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 40(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -104(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 36(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -100(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 32(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -96(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 28(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -92(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 24(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -88(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 20(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -84(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 16(s1)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -80(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+12)(s6)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -76(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+8)(s6)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -72(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+4)(s6)
; RV32IXQCCMP-WITH-FP-NEXT:    lw a0, -68(s0) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var)(s6)
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 160
; RV32IXQCCMP-WITH-FP-NEXT:    addi sp, sp, 48
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 112
; RV32IXQCCMP-WITH-FP-NEXT:    qc.cm.popret {ra, s0-s11}, 112
;
; RV64IXQCCMP-LABEL: caller:
; RV64IXQCCMP:       # %bb.0:
; RV64IXQCCMP-NEXT:    qc.cm.push {ra, s0-s11}, -160
; RV64IXQCCMP-NEXT:    .cfi_def_cfa_offset 160
; RV64IXQCCMP-NEXT:    .cfi_offset ra, -8
; RV64IXQCCMP-NEXT:    .cfi_offset s0, -16
; RV64IXQCCMP-NEXT:    .cfi_offset s1, -24
; RV64IXQCCMP-NEXT:    .cfi_offset s2, -32
; RV64IXQCCMP-NEXT:    .cfi_offset s3, -40
; RV64IXQCCMP-NEXT:    .cfi_offset s4, -48
; RV64IXQCCMP-NEXT:    .cfi_offset s5, -56
; RV64IXQCCMP-NEXT:    .cfi_offset s6, -64
; RV64IXQCCMP-NEXT:    .cfi_offset s7, -72
; RV64IXQCCMP-NEXT:    .cfi_offset s8, -80
; RV64IXQCCMP-NEXT:    .cfi_offset s9, -88
; RV64IXQCCMP-NEXT:    .cfi_offset s10, -96
; RV64IXQCCMP-NEXT:    .cfi_offset s11, -104
; RV64IXQCCMP-NEXT:    addi sp, sp, -128
; RV64IXQCCMP-NEXT:    .cfi_def_cfa_offset 288
; RV64IXQCCMP-NEXT:    lui s0, %hi(var)
; RV64IXQCCMP-NEXT:    lw a0, %lo(var)(s0)
; RV64IXQCCMP-NEXT:    sd a0, 168(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, %lo(var+4)(s0)
; RV64IXQCCMP-NEXT:    sd a0, 160(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, %lo(var+8)(s0)
; RV64IXQCCMP-NEXT:    sd a0, 152(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, %lo(var+12)(s0)
; RV64IXQCCMP-NEXT:    sd a0, 144(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    addi s1, s0, %lo(var)
; RV64IXQCCMP-NEXT:    lw a0, 16(s1)
; RV64IXQCCMP-NEXT:    sd a0, 136(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 20(s1)
; RV64IXQCCMP-NEXT:    sd a0, 128(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 24(s1)
; RV64IXQCCMP-NEXT:    sd a0, 120(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 28(s1)
; RV64IXQCCMP-NEXT:    sd a0, 112(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 32(s1)
; RV64IXQCCMP-NEXT:    sd a0, 104(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 36(s1)
; RV64IXQCCMP-NEXT:    sd a0, 96(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 40(s1)
; RV64IXQCCMP-NEXT:    sd a0, 88(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 44(s1)
; RV64IXQCCMP-NEXT:    sd a0, 80(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 48(s1)
; RV64IXQCCMP-NEXT:    sd a0, 72(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 52(s1)
; RV64IXQCCMP-NEXT:    sd a0, 64(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 56(s1)
; RV64IXQCCMP-NEXT:    sd a0, 56(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 60(s1)
; RV64IXQCCMP-NEXT:    sd a0, 48(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 64(s1)
; RV64IXQCCMP-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 68(s1)
; RV64IXQCCMP-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 72(s1)
; RV64IXQCCMP-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 76(s1)
; RV64IXQCCMP-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 80(s1)
; RV64IXQCCMP-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw a0, 84(s1)
; RV64IXQCCMP-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    lw s4, 88(s1)
; RV64IXQCCMP-NEXT:    lw s5, 92(s1)
; RV64IXQCCMP-NEXT:    lw s6, 96(s1)
; RV64IXQCCMP-NEXT:    lw s7, 100(s1)
; RV64IXQCCMP-NEXT:    lw s8, 104(s1)
; RV64IXQCCMP-NEXT:    lw s9, 108(s1)
; RV64IXQCCMP-NEXT:    lw s10, 112(s1)
; RV64IXQCCMP-NEXT:    lw s11, 116(s1)
; RV64IXQCCMP-NEXT:    lw s2, 120(s1)
; RV64IXQCCMP-NEXT:    lw s3, 124(s1)
; RV64IXQCCMP-NEXT:    call callee
; RV64IXQCCMP-NEXT:    sw s3, 124(s1)
; RV64IXQCCMP-NEXT:    sw s2, 120(s1)
; RV64IXQCCMP-NEXT:    sw s11, 116(s1)
; RV64IXQCCMP-NEXT:    sw s10, 112(s1)
; RV64IXQCCMP-NEXT:    sw s9, 108(s1)
; RV64IXQCCMP-NEXT:    sw s8, 104(s1)
; RV64IXQCCMP-NEXT:    sw s7, 100(s1)
; RV64IXQCCMP-NEXT:    sw s6, 96(s1)
; RV64IXQCCMP-NEXT:    sw s5, 92(s1)
; RV64IXQCCMP-NEXT:    sw s4, 88(s1)
; RV64IXQCCMP-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 84(s1)
; RV64IXQCCMP-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 80(s1)
; RV64IXQCCMP-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 76(s1)
; RV64IXQCCMP-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 72(s1)
; RV64IXQCCMP-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 68(s1)
; RV64IXQCCMP-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 64(s1)
; RV64IXQCCMP-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 60(s1)
; RV64IXQCCMP-NEXT:    ld a0, 56(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 56(s1)
; RV64IXQCCMP-NEXT:    ld a0, 64(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 52(s1)
; RV64IXQCCMP-NEXT:    ld a0, 72(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 48(s1)
; RV64IXQCCMP-NEXT:    ld a0, 80(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 44(s1)
; RV64IXQCCMP-NEXT:    ld a0, 88(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 40(s1)
; RV64IXQCCMP-NEXT:    ld a0, 96(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 36(s1)
; RV64IXQCCMP-NEXT:    ld a0, 104(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 32(s1)
; RV64IXQCCMP-NEXT:    ld a0, 112(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 28(s1)
; RV64IXQCCMP-NEXT:    ld a0, 120(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 24(s1)
; RV64IXQCCMP-NEXT:    ld a0, 128(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 20(s1)
; RV64IXQCCMP-NEXT:    ld a0, 136(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, 16(s1)
; RV64IXQCCMP-NEXT:    ld a0, 144(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, %lo(var+12)(s0)
; RV64IXQCCMP-NEXT:    ld a0, 152(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, %lo(var+8)(s0)
; RV64IXQCCMP-NEXT:    ld a0, 160(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, %lo(var+4)(s0)
; RV64IXQCCMP-NEXT:    ld a0, 168(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    sw a0, %lo(var)(s0)
; RV64IXQCCMP-NEXT:    addi sp, sp, 128
; RV64IXQCCMP-NEXT:    .cfi_def_cfa_offset 160
; RV64IXQCCMP-NEXT:    qc.cm.popret {ra, s0-s11}, 160
;
; RV64IXQCCMP-WITH-FP-LABEL: caller:
; RV64IXQCCMP-WITH-FP:       # %bb.0:
; RV64IXQCCMP-WITH-FP-NEXT:    qc.cm.pushfp {ra, s0-s11}, -160
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 160
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -8
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -16
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s1, -24
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s2, -32
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s3, -40
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s4, -48
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s5, -56
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s6, -64
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s7, -72
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s8, -80
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s9, -88
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s10, -96
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s11, -104
; RV64IXQCCMP-WITH-FP-NEXT:    addi sp, sp, -144
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 304
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV64IXQCCMP-WITH-FP-NEXT:    lui s6, %hi(var)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var)(s6)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -120(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+4)(s6)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -128(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+8)(s6)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -136(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, %lo(var+12)(s6)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -144(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    addi s1, s6, %lo(var)
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 16(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -152(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 20(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -160(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 24(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -168(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 28(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -176(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 32(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -184(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 36(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -192(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 40(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -200(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 44(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -208(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 48(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -216(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 52(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -224(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 56(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -232(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 60(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -240(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 64(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -248(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 68(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -256(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 72(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -264(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 76(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -272(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 80(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -280(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 84(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -288(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw a0, 88(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, -296(s0) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    lw s8, 92(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s9, 96(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s10, 100(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s11, 104(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s2, 108(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s3, 112(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s4, 116(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s5, 120(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    lw s7, 124(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    call callee
; RV64IXQCCMP-WITH-FP-NEXT:    sw s7, 124(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s5, 120(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s4, 116(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s3, 112(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s2, 108(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s11, 104(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s10, 100(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s9, 96(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    sw s8, 92(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -296(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 88(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -288(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 84(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -280(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 80(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -272(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 76(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -264(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 72(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -256(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 68(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -248(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 64(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -240(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 60(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -232(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 56(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -224(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 52(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -216(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 48(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -208(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 44(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -200(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 40(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -192(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 36(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -184(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 32(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -176(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 28(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -168(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 24(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -160(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 20(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -152(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, 16(s1)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -144(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+12)(s6)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -136(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+8)(s6)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -128(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var+4)(s6)
; RV64IXQCCMP-WITH-FP-NEXT:    ld a0, -120(s0) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    sw a0, %lo(var)(s6)
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 304
; RV64IXQCCMP-WITH-FP-NEXT:    addi sp, sp, 144
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 160
; RV64IXQCCMP-WITH-FP-NEXT:    qc.cm.popret {ra, s0-s11}, 160
  %val = load [32 x i32], ptr @var
  call void @callee()
  store volatile [32 x i32] %val, ptr @var
  ret void
}

; This function tests if the stack size is correctly calculated when
; callee-saved registers are not a sequential list from $ra
define void @foo() {
; RV32IXQCCMP-LABEL: foo:
; RV32IXQCCMP:       # %bb.0: # %entry
; RV32IXQCCMP-NEXT:    qc.cm.push {ra, s0-s4}, -32
; RV32IXQCCMP-NEXT:    .cfi_def_cfa_offset 32
; RV32IXQCCMP-NEXT:    .cfi_offset s4, -24
; RV32IXQCCMP-NEXT:    #APP
; RV32IXQCCMP-NEXT:    li s4, 0
; RV32IXQCCMP-NEXT:    #NO_APP
; RV32IXQCCMP-NEXT:    qc.cm.popret {ra, s0-s4}, 32
;
; RV32IXQCCMP-WITH-FP-LABEL: foo:
; RV32IXQCCMP-WITH-FP:       # %bb.0: # %entry
; RV32IXQCCMP-WITH-FP-NEXT:    qc.cm.pushfp {ra, s0-s4}, -32
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 32
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -4
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -8
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s4, -24
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV32IXQCCMP-WITH-FP-NEXT:    #APP
; RV32IXQCCMP-WITH-FP-NEXT:    li s4, 0
; RV32IXQCCMP-WITH-FP-NEXT:    #NO_APP
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 32
; RV32IXQCCMP-WITH-FP-NEXT:    qc.cm.popret {ra, s0-s4}, 32
;
; RV64IXQCCMP-LABEL: foo:
; RV64IXQCCMP:       # %bb.0: # %entry
; RV64IXQCCMP-NEXT:    qc.cm.push {ra, s0-s4}, -48
; RV64IXQCCMP-NEXT:    .cfi_def_cfa_offset 48
; RV64IXQCCMP-NEXT:    .cfi_offset s4, -48
; RV64IXQCCMP-NEXT:    #APP
; RV64IXQCCMP-NEXT:    li s4, 0
; RV64IXQCCMP-NEXT:    #NO_APP
; RV64IXQCCMP-NEXT:    qc.cm.popret {ra, s0-s4}, 48
;
; RV64IXQCCMP-WITH-FP-LABEL: foo:
; RV64IXQCCMP-WITH-FP:       # %bb.0: # %entry
; RV64IXQCCMP-WITH-FP-NEXT:    qc.cm.pushfp {ra, s0-s4}, -48
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 48
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -8
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -16
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s4, -48
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV64IXQCCMP-WITH-FP-NEXT:    #APP
; RV64IXQCCMP-WITH-FP-NEXT:    li s4, 0
; RV64IXQCCMP-WITH-FP-NEXT:    #NO_APP
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 48
; RV64IXQCCMP-WITH-FP-NEXT:    qc.cm.popret {ra, s0-s4}, 48
entry:
  tail call void asm sideeffect "li s4, 0", "~{s4}"()
  ret void
}

; Check .cfi_offset of s11 is correct for Zcmp.
define void @bar() {
; RV32IXQCCMP-LABEL: bar:
; RV32IXQCCMP:       # %bb.0: # %entry
; RV32IXQCCMP-NEXT:    qc.cm.push {ra, s0-s11}, -64
; RV32IXQCCMP-NEXT:    .cfi_def_cfa_offset 64
; RV32IXQCCMP-NEXT:    .cfi_offset s11, -52
; RV32IXQCCMP-NEXT:    #APP
; RV32IXQCCMP-NEXT:    li s11, 0
; RV32IXQCCMP-NEXT:    #NO_APP
; RV32IXQCCMP-NEXT:    qc.cm.popret {ra, s0-s11}, 64
;
; RV32IXQCCMP-WITH-FP-LABEL: bar:
; RV32IXQCCMP-WITH-FP:       # %bb.0: # %entry
; RV32IXQCCMP-WITH-FP-NEXT:    qc.cm.pushfp {ra, s0-s11}, -64
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 64
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -4
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -8
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s11, -52
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV32IXQCCMP-WITH-FP-NEXT:    #APP
; RV32IXQCCMP-WITH-FP-NEXT:    li s11, 0
; RV32IXQCCMP-WITH-FP-NEXT:    #NO_APP
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 64
; RV32IXQCCMP-WITH-FP-NEXT:    qc.cm.popret {ra, s0-s11}, 64
;
; RV64IXQCCMP-LABEL: bar:
; RV64IXQCCMP:       # %bb.0: # %entry
; RV64IXQCCMP-NEXT:    qc.cm.push {ra, s0-s11}, -112
; RV64IXQCCMP-NEXT:    .cfi_def_cfa_offset 112
; RV64IXQCCMP-NEXT:    .cfi_offset s11, -104
; RV64IXQCCMP-NEXT:    #APP
; RV64IXQCCMP-NEXT:    li s11, 0
; RV64IXQCCMP-NEXT:    #NO_APP
; RV64IXQCCMP-NEXT:    qc.cm.popret {ra, s0-s11}, 112
;
; RV64IXQCCMP-WITH-FP-LABEL: bar:
; RV64IXQCCMP-WITH-FP:       # %bb.0: # %entry
; RV64IXQCCMP-WITH-FP-NEXT:    qc.cm.pushfp {ra, s0-s11}, -112
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 112
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -8
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -16
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s11, -104
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV64IXQCCMP-WITH-FP-NEXT:    #APP
; RV64IXQCCMP-WITH-FP-NEXT:    li s11, 0
; RV64IXQCCMP-WITH-FP-NEXT:    #NO_APP
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 112
; RV64IXQCCMP-WITH-FP-NEXT:    qc.cm.popret {ra, s0-s11}, 112
entry:
  tail call void asm sideeffect "li s11, 0", "~{s11}"()
  ret void
}

define void @varargs(...) {
; RV32IXQCCMP-LABEL: varargs:
; RV32IXQCCMP:       # %bb.0:
; RV32IXQCCMP-NEXT:    addi sp, sp, -48
; RV32IXQCCMP-NEXT:    .cfi_def_cfa_offset 48
; RV32IXQCCMP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IXQCCMP-NEXT:    .cfi_offset ra, -36
; RV32IXQCCMP-NEXT:    sw a4, 32(sp)
; RV32IXQCCMP-NEXT:    sw a5, 36(sp)
; RV32IXQCCMP-NEXT:    sw a6, 40(sp)
; RV32IXQCCMP-NEXT:    sw a7, 44(sp)
; RV32IXQCCMP-NEXT:    sw a0, 16(sp)
; RV32IXQCCMP-NEXT:    sw a1, 20(sp)
; RV32IXQCCMP-NEXT:    sw a2, 24(sp)
; RV32IXQCCMP-NEXT:    sw a3, 28(sp)
; RV32IXQCCMP-NEXT:    call callee
; RV32IXQCCMP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IXQCCMP-NEXT:    .cfi_restore ra
; RV32IXQCCMP-NEXT:    addi sp, sp, 48
; RV32IXQCCMP-NEXT:    .cfi_def_cfa_offset 0
; RV32IXQCCMP-NEXT:    ret
;
; RV32IXQCCMP-WITH-FP-LABEL: varargs:
; RV32IXQCCMP-WITH-FP:       # %bb.0:
; RV32IXQCCMP-WITH-FP-NEXT:    addi sp, sp, -48
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 48
; RV32IXQCCMP-WITH-FP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -36
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -40
; RV32IXQCCMP-WITH-FP-NEXT:    addi s0, sp, 16
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 32
; RV32IXQCCMP-WITH-FP-NEXT:    sw a4, 16(s0)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a5, 20(s0)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a6, 24(s0)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a7, 28(s0)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a0, 0(s0)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a1, 4(s0)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a2, 8(s0)
; RV32IXQCCMP-WITH-FP-NEXT:    sw a3, 12(s0)
; RV32IXQCCMP-WITH-FP-NEXT:    call callee
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 48
; RV32IXQCCMP-WITH-FP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_restore ra
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_restore s0
; RV32IXQCCMP-WITH-FP-NEXT:    addi sp, sp, 48
; RV32IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 0
; RV32IXQCCMP-WITH-FP-NEXT:    ret
;
; RV64IXQCCMP-LABEL: varargs:
; RV64IXQCCMP:       # %bb.0:
; RV64IXQCCMP-NEXT:    addi sp, sp, -80
; RV64IXQCCMP-NEXT:    .cfi_def_cfa_offset 80
; RV64IXQCCMP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IXQCCMP-NEXT:    .cfi_offset ra, -72
; RV64IXQCCMP-NEXT:    sd a4, 48(sp)
; RV64IXQCCMP-NEXT:    sd a5, 56(sp)
; RV64IXQCCMP-NEXT:    sd a6, 64(sp)
; RV64IXQCCMP-NEXT:    sd a7, 72(sp)
; RV64IXQCCMP-NEXT:    sd a0, 16(sp)
; RV64IXQCCMP-NEXT:    sd a1, 24(sp)
; RV64IXQCCMP-NEXT:    sd a2, 32(sp)
; RV64IXQCCMP-NEXT:    sd a3, 40(sp)
; RV64IXQCCMP-NEXT:    call callee
; RV64IXQCCMP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IXQCCMP-NEXT:    .cfi_restore ra
; RV64IXQCCMP-NEXT:    addi sp, sp, 80
; RV64IXQCCMP-NEXT:    .cfi_def_cfa_offset 0
; RV64IXQCCMP-NEXT:    ret
;
; RV64IXQCCMP-WITH-FP-LABEL: varargs:
; RV64IXQCCMP-WITH-FP:       # %bb.0:
; RV64IXQCCMP-WITH-FP-NEXT:    addi sp, sp, -80
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 80
; RV64IXQCCMP-WITH-FP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset ra, -72
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_offset s0, -80
; RV64IXQCCMP-WITH-FP-NEXT:    addi s0, sp, 16
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 64
; RV64IXQCCMP-WITH-FP-NEXT:    sd a4, 32(s0)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a5, 40(s0)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a6, 48(s0)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a7, 56(s0)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a0, 0(s0)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a1, 8(s0)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a2, 16(s0)
; RV64IXQCCMP-WITH-FP-NEXT:    sd a3, 24(s0)
; RV64IXQCCMP-WITH-FP-NEXT:    call callee
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa sp, 80
; RV64IXQCCMP-WITH-FP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_restore ra
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_restore s0
; RV64IXQCCMP-WITH-FP-NEXT:    addi sp, sp, 80
; RV64IXQCCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 0
; RV64IXQCCMP-WITH-FP-NEXT:    ret
  call void @callee()
  ret void
}
