; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=zEC12 -verify-machineinstrs \
; RUN:   | FileCheck %s --check-prefix=NOVEC
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z16 -verify-machineinstrs \
; RUN:   | FileCheck %s  --check-prefix=VECTOR

declare void @foo(ptr)

; Test an alloca.
define half @f1() {
; NOVEC-LABEL: f1:
; NOVEC:       # %bb.0:
; NOVEC-NEXT:    stmg %r14, %r15, 112(%r15)
; NOVEC-NEXT:    .cfi_offset %r14, -48
; NOVEC-NEXT:    .cfi_offset %r15, -40
; NOVEC-NEXT:    aghi %r15, -168
; NOVEC-NEXT:    .cfi_def_cfa_offset 328
; NOVEC-NEXT:    la %r2, 166(%r15)
; NOVEC-NEXT:    brasl %r14, foo@PLT
; NOVEC-NEXT:    lgh %r0, 166(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f0, %r0
; NOVEC-NEXT:    # kill: def $f0h killed $f0h killed $f0d
; NOVEC-NEXT:    lmg %r14, %r15, 280(%r15)
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: f1:
; VECTOR:       # %bb.0:
; VECTOR-NEXT:    stmg %r14, %r15, 112(%r15)
; VECTOR-NEXT:    .cfi_offset %r14, -48
; VECTOR-NEXT:    .cfi_offset %r15, -40
; VECTOR-NEXT:    aghi %r15, -168
; VECTOR-NEXT:    .cfi_def_cfa_offset 328
; VECTOR-NEXT:    la %r2, 166(%r15)
; VECTOR-NEXT:    brasl %r14, foo@PLT
; VECTOR-NEXT:    vlreph %v0, 166(%r15)
; VECTOR-NEXT:    lmg %r14, %r15, 280(%r15)
; VECTOR-NEXT:    br %r14
  %ptr = alloca half
  call void @foo(ptr %ptr)
  %orig = load half, ptr %ptr
  ret half %orig
}

; Test accessing a half element of an aggregate type.
%s.half = type { half, half, half, half, half }
define half @f2(ptr %P) {
; NOVEC-LABEL: f2:
; NOVEC:       # %bb.0:
; NOVEC-NEXT:    lgh %r0, 6(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f0, %r0
; NOVEC-NEXT:    # kill: def $f0h killed $f0h killed $f0d
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: f2:
; VECTOR:       # %bb.0:
; VECTOR-NEXT:    vlreph %v0, 6(%r2)
; VECTOR-NEXT:    br %r14
  %gep = getelementptr inbounds %s.half, ptr %P, i64 0, i32 3
  %res = load half, ptr %gep
  ret half %res
}
