; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-min-jump-table-entries=4 < %s | FileCheck %s \
; RUN:   --check-prefix=CHECK-R
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-use-absolute-jumptables -ppc-min-jump-table-entries=4 \
; RUN:   -ppc-asm-full-reg-names < %s | FileCheck %s \
; RUN:   --check-prefix=CHECK-A-LE
; RUN: llc -verify-machineinstrs -target-abi=elfv2 -mtriple=powerpc64-- \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-min-jump-table-entries=4 < %s | FileCheck %s \
; RUN:   --check-prefix=CHECK-R
; RUN: llc -verify-machineinstrs -target-abi=elfv2 -mtriple=powerpc64-- \
; RUN:   -mcpu=pwr10 -ppc-use-absolute-jumptables -ppc-min-jump-table-entries=4 \
; RUN:   -ppc-asm-full-reg-names < %s | FileCheck %s \
; RUN:   --check-prefix=CHECK-A-BE


; This test checks for getting relative and absolute jump table base address
; using PC Relative addressing.

define dso_local signext i32 @jumptable(i32 signext %param) {
; CHECK-R-LABEL: jumptable:
; CHECK-R:       # %bb.0: # %entry
; CHECK-R-NEXT:    addi r4, r3, -1
; CHECK-R-NEXT:    cmplwi r4, 19
; CHECK-R-NEXT:    bgt cr0, .LBB0_3
; CHECK-R-NEXT:  # %bb.1: # %entry
; CHECK-R-NEXT:    rldic r4, r4, 2, 30
; CHECK-R-NEXT:    paddi r5, 0, .LJTI0_0@PCREL, 1
; CHECK-R-NEXT:    lwax r4, r5, r4
; CHECK-R-NEXT:    add r4, r5, r4
; CHECK-R-NEXT:    mtctr r4
; CHECK-R-NEXT:    bctr
; CHECK-R-NEXT:  .LBB0_2: # %sw.bb1
; CHECK-R-NEXT:    li r3, 4
; CHECK-R-NEXT:    blr
; CHECK-R-NEXT:  .LBB0_3: # %sw.default
; CHECK-R-NEXT:    li r3, -1
; CHECK-R-NEXT:  .LBB0_4: # %return
; CHECK-R-NEXT:    blr
; CHECK-R-NEXT:  .LBB0_5: # %sw.bb2
; CHECK-R-NEXT:    li r3, 9
; CHECK-R-NEXT:    blr
; CHECK-R-NEXT:  .LBB0_6: # %sw.bb3
; CHECK-R-NEXT:    li r3, 16
; CHECK-R-NEXT:    blr
; CHECK-R-NEXT:  .LBB0_7: # %sw.bb4
; CHECK-R-NEXT:    li r3, 400
; CHECK-R-NEXT:    blr
;
; CHECK-A-LE-LABEL: jumptable:
; CHECK-A-LE:       # %bb.0: # %entry
; CHECK-A-LE-NEXT:    addi r4, r3, -1
; CHECK-A-LE-NEXT:    cmplwi r4, 19
; CHECK-A-LE-NEXT:    bgt cr0, .LBB0_3
; CHECK-A-LE-NEXT:  # %bb.1: # %entry
; CHECK-A-LE-NEXT:    rldic r4, r4, 3, 29
; CHECK-A-LE-NEXT:    paddi r5, 0, .LJTI0_0@PCREL, 1
; CHECK-A-LE-NEXT:    ldx r4, r5, r4
; CHECK-A-LE-NEXT:    mtctr r4
; CHECK-A-LE-NEXT:    bctr
; CHECK-A-LE-NEXT:  .LBB0_2: # %sw.bb1
; CHECK-A-LE-NEXT:    li r3, 4
; CHECK-A-LE-NEXT:    blr
; CHECK-A-LE-NEXT:  .LBB0_3: # %sw.default
; CHECK-A-LE-NEXT:    li r3, -1
; CHECK-A-LE-NEXT:  .LBB0_4: # %return
; CHECK-A-LE-NEXT:    blr
; CHECK-A-LE-NEXT:  .LBB0_5: # %sw.bb2
; CHECK-A-LE-NEXT:    li r3, 9
; CHECK-A-LE-NEXT:    blr
; CHECK-A-LE-NEXT:  .LBB0_6: # %sw.bb3
; CHECK-A-LE-NEXT:    li r3, 16
; CHECK-A-LE-NEXT:    blr
; CHECK-A-LE-NEXT:  .LBB0_7: # %sw.bb4
; CHECK-A-LE-NEXT:    li r3, 400
; CHECK-A-LE-NEXT:    blr
;
; CHECK-A-BE-LABEL: jumptable:
; CHECK-A-BE:       # %bb.0: # %entry
; CHECK-A-BE-NEXT:    addi r4, r3, -1
; CHECK-A-BE-NEXT:    cmplwi r4, 19
; CHECK-A-BE-NEXT:    bgt cr0, .LBB0_3
; CHECK-A-BE-NEXT:  # %bb.1: # %entry
; CHECK-A-BE-NEXT:    rldic r4, r4, 2, 30
; CHECK-A-BE-NEXT:    paddi r5, 0, .LJTI0_0@PCREL, 1
; CHECK-A-BE-NEXT:    lwax r4, r5, r4
; CHECK-A-BE-NEXT:    mtctr r4
; CHECK-A-BE-NEXT:    bctr
; CHECK-A-BE-NEXT:  .LBB0_2: # %sw.bb1
; CHECK-A-BE-NEXT:    li r3, 4
; CHECK-A-BE-NEXT:    blr
; CHECK-A-BE-NEXT:  .LBB0_3: # %sw.default
; CHECK-A-BE-NEXT:    li r3, -1
; CHECK-A-BE-NEXT:  .LBB0_4: # %return
; CHECK-A-BE-NEXT:    blr
; CHECK-A-BE-NEXT:  .LBB0_5: # %sw.bb2
; CHECK-A-BE-NEXT:    li r3, 9
; CHECK-A-BE-NEXT:    blr
; CHECK-A-BE-NEXT:  .LBB0_6: # %sw.bb3
; CHECK-A-BE-NEXT:    li r3, 16
; CHECK-A-BE-NEXT:    blr
; CHECK-A-BE-NEXT:  .LBB0_7: # %sw.bb4
; CHECK-A-BE-NEXT:    li r3, 400
; CHECK-A-BE-NEXT:    blr


entry:
  switch i32 %param, label %sw.default [
    i32 1, label %return
    i32 2, label %sw.bb1
    i32 3, label %sw.bb2
    i32 4, label %sw.bb3
    i32 20, label %sw.bb4
  ]

sw.bb1:                                           ; preds = %entry
  br label %return

sw.bb2:                                           ; preds = %entry
  br label %return

sw.bb3:                                           ; preds = %entry
  br label %return

sw.bb4:                                           ; preds = %entry
  br label %return

sw.default:                                       ; preds = %entry
  br label %return

return:  ; preds = %entry, %sw.default, %sw.bb4, %sw.bb3, %sw.bb2, %sw.bb1
  %retval.0 = phi i32 [ -1, %sw.default ], [ 400, %sw.bb4 ], [ 16, %sw.bb3 ],
                      [ 9, %sw.bb2 ], [ 4, %sw.bb1 ], [ %param, %entry ]
  ret i32 %retval.0
}
