; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-I,RV32,RV32I
; RUN: llc -mtriple=riscv64 < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-I,RV64,RV64I
; RUN: llc -mtriple=riscv32 -mattr=+zbb < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-ZBB,RV32,RV32ZBB
; RUN: llc -mtriple=riscv64 -mattr=+zbb < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-ZBB,RV64,RV64ZBB

; TODO: Should we convert these to X ^ ((X ^ Y) & M) form when Zbb isn't
; present?

define i8 @out8(i8 %x, i8 %y, i8 %mask) {
; CHECK-I-LABEL: out8:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    not a2, a2
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: out8:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %mx = and i8 %x, %mask
  %notmask = xor i8 %mask, -1
  %my = and i8 %y, %notmask
  %r = or i8 %mx, %my
  ret i8 %r
}

define i16 @out16(i16 %x, i16 %y, i16 %mask) {
; CHECK-I-LABEL: out16:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    not a2, a2
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: out16:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %mx = and i16 %x, %mask
  %notmask = xor i16 %mask, -1
  %my = and i16 %y, %notmask
  %r = or i16 %mx, %my
  ret i16 %r
}

define i32 @out32(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: out32:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    not a2, a2
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: out32:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %mx = and i32 %x, %mask
  %notmask = xor i32 %mask, -1
  %my = and i32 %y, %notmask
  %r = or i32 %mx, %my
  ret i32 %r
}

define i64 @out64(i64 %x, i64 %y, i64 %mask) {
; RV32I-LABEL: out64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    not a4, a4
; RV32I-NEXT:    not a5, a5
; RV32I-NEXT:    and a3, a3, a5
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV64I-LABEL: out64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    not a2, a2
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: out64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    and a1, a1, a5
; RV32ZBB-NEXT:    and a0, a0, a4
; RV32ZBB-NEXT:    andn a3, a3, a5
; RV32ZBB-NEXT:    andn a2, a2, a4
; RV32ZBB-NEXT:    or a0, a0, a2
; RV32ZBB-NEXT:    or a1, a1, a3
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: out64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    and a0, a0, a2
; RV64ZBB-NEXT:    andn a1, a1, a2
; RV64ZBB-NEXT:    or a0, a0, a1
; RV64ZBB-NEXT:    ret
  %mx = and i64 %x, %mask
  %notmask = xor i64 %mask, -1
  %my = and i64 %y, %notmask
  %r = or i64 %mx, %my
  ret i64 %r
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; These tests should produce the same output as the corresponding out* test
; when the Zbb extension is enabled.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

define i8 @in8(i8 %x, i8 %y, i8 %mask) {
; CHECK-I-LABEL: in8:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in8:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i8 %x, %y
  %n1 = and i8 %n0, %mask
  %r = xor i8 %n1, %y
  ret i8 %r
}

define i16 @in16(i16 %x, i16 %y, i16 %mask) {
; CHECK-I-LABEL: in16:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in16:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i16 %x, %y
  %n1 = and i16 %n0, %mask
  %r = xor i16 %n1, %y
  ret i16 %r
}

define i32 @in32(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in32:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in32:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, %y
  ret i32 %r
}

define i64 @in64(i64 %x, i64 %y, i64 %mask) {
; RV32I-LABEL: in64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    xor a0, a0, a2
; RV32I-NEXT:    xor a1, a1, a3
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    xor a0, a0, a2
; RV32I-NEXT:    xor a1, a1, a3
; RV32I-NEXT:    ret
;
; RV64I-LABEL: in64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: in64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    andn a2, a2, a4
; RV32ZBB-NEXT:    and a0, a0, a4
; RV32ZBB-NEXT:    andn a3, a3, a5
; RV32ZBB-NEXT:    and a1, a1, a5
; RV32ZBB-NEXT:    or a0, a0, a2
; RV32ZBB-NEXT:    or a1, a1, a3
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: in64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    andn a1, a1, a2
; RV64ZBB-NEXT:    and a0, a0, a2
; RV64ZBB-NEXT:    or a0, a0, a1
; RV64ZBB-NEXT:    ret
  %n0 = xor i64 %x, %y
  %n1 = and i64 %n0, %mask
  %r = xor i64 %n1, %y
  ret i64 %r
}

; ============================================================================ ;
; Commutativity tests.
; ============================================================================ ;

define i32 @in_commutativity_0_0_1(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_commutativity_0_0_1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a2, a0
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_commutativity_0_0_1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %mask, %n0 ; swapped
  %r = xor i32 %n1, %y
  ret i32 %r
}

define i32 @in_commutativity_0_1_0(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_commutativity_0_1_0:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    xor a0, a1, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_commutativity_0_1_0:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %y, %n1 ; swapped
  ret i32 %r
}

define i32 @in_commutativity_0_1_1(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_commutativity_0_1_1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a2, a0
; CHECK-I-NEXT:    xor a0, a1, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_commutativity_0_1_1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %mask, %n0 ; swapped
  %r = xor i32 %y, %n1 ; swapped
  ret i32 %r
}

define i32 @in_commutativity_1_0_0(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_commutativity_1_0_0:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a1, a0, a1
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    xor a0, a1, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_commutativity_1_0_0:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a0, a2
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, %x ; %x instead of %y
  ret i32 %r
}

define i32 @in_commutativity_1_0_1(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_commutativity_1_0_1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a1, a0, a1
; CHECK-I-NEXT:    and a1, a2, a1
; CHECK-I-NEXT:    xor a0, a1, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_commutativity_1_0_1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a0, a2
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %mask, %n0 ; swapped
  %r = xor i32 %n1, %x ; %x instead of %y
  ret i32 %r
}

define i32 @in_commutativity_1_1_0(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_commutativity_1_1_0:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a1, a0, a1
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_commutativity_1_1_0:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a0, a2
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %x, %n1 ; swapped, %x instead of %y
  ret i32 %r
}

define i32 @in_commutativity_1_1_1(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_commutativity_1_1_1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a1, a0, a1
; CHECK-I-NEXT:    and a1, a2, a1
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_commutativity_1_1_1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a0, a2
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %mask, %n0 ; swapped
  %r = xor i32 %x, %n1 ; swapped, %x instead of %y
  ret i32 %r
}

; ============================================================================ ;
; Y is an 'and' too.
; ============================================================================ ;

define i32 @in_complex_y0(i32 %x, i32 %y_hi, i32 %y_low, i32 %mask) {
; CHECK-I-LABEL: in_complex_y0:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a0, a3
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_complex_y0:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a3
; CHECK-ZBB-NEXT:    andn a1, a1, a3
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %y = and i32 %y_hi, %y_low
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, %y
  ret i32 %r
}

define i32 @in_complex_y1(i32 %x, i32 %y_hi, i32 %y_low, i32 %mask) {
; CHECK-I-LABEL: in_complex_y1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a0, a3
; CHECK-I-NEXT:    xor a0, a1, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_complex_y1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a3
; CHECK-ZBB-NEXT:    andn a1, a1, a3
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %y = and i32 %y_hi, %y_low
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %y, %n1
  ret i32 %r
}

; ============================================================================ ;
; M is an 'xor' too.
; ============================================================================ ;

define i32 @in_complex_m0(i32 %x, i32 %y, i32 %m_a, i32 %m_b) {
; CHECK-I-LABEL: in_complex_m0:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a2, a2, a3
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_complex_m0:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    xor a2, a2, a3
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %mask = xor i32 %m_a, %m_b
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, %y
  ret i32 %r
}

define i32 @in_complex_m1(i32 %x, i32 %y, i32 %m_a, i32 %m_b) {
; CHECK-I-LABEL: in_complex_m1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xor a2, a2, a3
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a2, a0
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_complex_m1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    xor a2, a2, a3
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %mask = xor i32 %m_a, %m_b
  %n0 = xor i32 %x, %y
  %n1 = and i32 %mask, %n0
  %r = xor i32 %n1, %y
  ret i32 %r
}

; ============================================================================ ;
; Both Y and M are complex.
; ============================================================================ ;

define i32 @in_complex_y0_m0(i32 %x, i32 %y_hi, i32 %y_low, i32 %m_a, i32 %m_b) {
; CHECK-I-LABEL: in_complex_y0_m0:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    xor a3, a3, a4
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a0, a3
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_complex_y0_m0:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    xor a3, a3, a4
; CHECK-ZBB-NEXT:    andn a1, a1, a3
; CHECK-ZBB-NEXT:    and a0, a0, a3
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %y = and i32 %y_hi, %y_low
  %mask = xor i32 %m_a, %m_b
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, %y
  ret i32 %r
}

define i32 @in_complex_y1_m0(i32 %x, i32 %y_hi, i32 %y_low, i32 %m_a, i32 %m_b) {
; CHECK-I-LABEL: in_complex_y1_m0:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    xor a3, a3, a4
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a0, a3
; CHECK-I-NEXT:    xor a0, a1, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_complex_y1_m0:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    xor a3, a3, a4
; CHECK-ZBB-NEXT:    andn a1, a1, a3
; CHECK-ZBB-NEXT:    and a0, a0, a3
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %y = and i32 %y_hi, %y_low
  %mask = xor i32 %m_a, %m_b
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %y, %n1
  ret i32 %r
}

define i32 @in_complex_y0_m1(i32 %x, i32 %y_hi, i32 %y_low, i32 %m_a, i32 %m_b) {
; CHECK-I-LABEL: in_complex_y0_m1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    xor a3, a3, a4
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a3, a0
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_complex_y0_m1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    xor a3, a3, a4
; CHECK-ZBB-NEXT:    andn a1, a1, a3
; CHECK-ZBB-NEXT:    and a0, a0, a3
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %y = and i32 %y_hi, %y_low
  %mask = xor i32 %m_a, %m_b
  %n0 = xor i32 %x, %y
  %n1 = and i32 %mask, %n0
  %r = xor i32 %n1, %y
  ret i32 %r
}

define i32 @in_complex_y1_m1(i32 %x, i32 %y_hi, i32 %y_low, i32 %m_a, i32 %m_b) {
; CHECK-I-LABEL: in_complex_y1_m1:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    xor a3, a3, a4
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    and a0, a3, a0
; CHECK-I-NEXT:    xor a0, a1, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_complex_y1_m1:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a1, a2
; CHECK-ZBB-NEXT:    xor a3, a3, a4
; CHECK-ZBB-NEXT:    andn a1, a1, a3
; CHECK-ZBB-NEXT:    and a0, a0, a3
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %y = and i32 %y_hi, %y_low
  %mask = xor i32 %m_a, %m_b
  %n0 = xor i32 %x, %y
  %n1 = and i32 %mask, %n0
  %r = xor i32 %y, %n1
  ret i32 %r
}

; ============================================================================ ;
; Various cases with %x and/or %y being a constant
; ============================================================================ ;

define i32 @out_constant_varx_mone(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: out_constant_varx_mone:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a1, a2
; CHECK-I-NEXT:    and a0, a2, a0
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: out_constant_varx_mone:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a0, a2, a0
; CHECK-ZBB-NEXT:    orn a0, a0, a2
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %mx = and i32 %mask, %x
  %my = and i32 %notmask, -1
  %r = or i32 %mx, %my
  ret i32 %r
}

define i32 @in_constant_varx_mone(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_constant_varx_mone:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a0, a0
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    not a0, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_constant_varx_mone:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a2, a0
; CHECK-ZBB-NEXT:    not a0, a0
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, -1 ; %x
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, -1
  ret i32 %r
}

; This is not a canonical form. Testing for completeness only.
define i32 @out_constant_varx_mone_invmask(i32 %x, i32 %y, i32 %mask) {
; CHECK-LABEL: out_constant_varx_mone_invmask:
; CHECK:       # %bb.0:
; CHECK-NEXT:    or a0, a0, a2
; CHECK-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %mx = and i32 %notmask, %x
  %my = and i32 %mask, -1
  %r = or i32 %mx, %my
  ret i32 %r
}

; This is not a canonical form. Testing for completeness only.
define i32 @in_constant_varx_mone_invmask(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_constant_varx_mone_invmask:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a1, a2
; CHECK-I-NEXT:    not a0, a0
; CHECK-I-NEXT:    and a0, a0, a1
; CHECK-I-NEXT:    not a0, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_constant_varx_mone_invmask:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    not a0, a0
; CHECK-ZBB-NEXT:    andn a0, a0, a2
; CHECK-ZBB-NEXT:    not a0, a0
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %n0 = xor i32 %x, -1 ; %x
  %n1 = and i32 %n0, %notmask
  %r = xor i32 %n1, -1
  ret i32 %r
}

define i32 @out_constant_varx_42(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: out_constant_varx_42:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a1, a2
; CHECK-I-NEXT:    and a0, a2, a0
; CHECK-I-NEXT:    andi a1, a1, 42
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: out_constant_varx_42:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a0, a2, a0
; CHECK-ZBB-NEXT:    li a1, 42
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %mx = and i32 %mask, %x
  %my = and i32 %notmask, 42
  %r = or i32 %mx, %my
  ret i32 %r
}

define i32 @in_constant_varx_42(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_constant_varx_42:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xori a0, a0, 42
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    xori a0, a0, 42
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_constant_varx_42:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a2, a0
; CHECK-ZBB-NEXT:    ori a1, a2, 42
; CHECK-ZBB-NEXT:    andn a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 %x, 42 ; %x
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, 42
  ret i32 %r
}

; This is not a canonical form. Testing for completeness only.
define i32 @out_constant_varx_42_invmask(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: out_constant_varx_42_invmask:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a1, a2
; CHECK-I-NEXT:    and a0, a1, a0
; CHECK-I-NEXT:    andi a1, a2, 42
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: out_constant_varx_42_invmask:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a0, a2
; CHECK-ZBB-NEXT:    andi a1, a2, 42
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %mx = and i32 %notmask, %x
  %my = and i32 %mask, 42
  %r = or i32 %mx, %my
  ret i32 %r
}

; This is not a canonical form. Testing for completeness only.
define i32 @in_constant_varx_42_invmask(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_constant_varx_42_invmask:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a1, a2
; CHECK-I-NEXT:    xori a0, a0, 42
; CHECK-I-NEXT:    and a0, a0, a1
; CHECK-I-NEXT:    xori a0, a0, 42
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_constant_varx_42_invmask:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a0, a2
; CHECK-ZBB-NEXT:    andi a1, a2, 42
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %n0 = xor i32 %x, 42 ; %x
  %n1 = and i32 %n0, %notmask
  %r = xor i32 %n1, 42
  ret i32 %r
}

define i32 @out_constant_mone_vary(i32 %x, i32 %y, i32 %mask) {
; CHECK-LABEL: out_constant_mone_vary:
; CHECK:       # %bb.0:
; CHECK-NEXT:    or a0, a1, a2
; CHECK-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %mx = and i32 %mask, -1
  %my = and i32 %notmask, %y
  %r = or i32 %mx, %my
  ret i32 %r
}

define i32 @in_constant_mone_vary(i32 %x, i32 %y, i32 %mask) {
; CHECK-LABEL: in_constant_mone_vary:
; CHECK:       # %bb.0:
; CHECK-NEXT:    or a0, a2, a1
; CHECK-NEXT:    ret
  %n0 = xor i32 -1, %y ; %x
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, %y
  ret i32 %r
}

; This is not a canonical form. Testing for completeness only.
define i32 @out_constant_mone_vary_invmask(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: out_constant_mone_vary_invmask:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a0, a2
; CHECK-I-NEXT:    and a1, a2, a1
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: out_constant_mone_vary_invmask:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a1, a2, a1
; CHECK-ZBB-NEXT:    orn a0, a1, a2
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %mx = and i32 %notmask, -1
  %my = and i32 %mask, %y
  %r = or i32 %mx, %my
  ret i32 %r
}

; This is not a canonical form. Testing for completeness only.
define i32 @in_constant_mone_vary_invmask(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_constant_mone_vary_invmask:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a0, a2
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_constant_mone_vary_invmask:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    orn a0, a1, a2
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %n0 = xor i32 -1, %y ; %x
  %n1 = and i32 %n0, %notmask
  %r = xor i32 %n1, %y
  ret i32 %r
}

define i32 @out_constant_42_vary(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: out_constant_42_vary:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a0, a2
; CHECK-I-NEXT:    andi a2, a2, 42
; CHECK-I-NEXT:    and a0, a0, a1
; CHECK-I-NEXT:    or a0, a2, a0
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: out_constant_42_vary:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andi a0, a2, 42
; CHECK-ZBB-NEXT:    andn a1, a1, a2
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %mx = and i32 %mask, 42
  %my = and i32 %notmask, %y
  %r = or i32 %mx, %my
  ret i32 %r
}

define i32 @in_constant_42_vary(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_constant_42_vary:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    xori a0, a1, 42
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_constant_42_vary:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a1, a2
; CHECK-ZBB-NEXT:    andi a1, a2, 42
; CHECK-ZBB-NEXT:    or a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %n0 = xor i32 42, %y ; %x
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, %y
  ret i32 %r
}

; This is not a canonical form. Testing for completeness only.
define i32 @out_constant_42_vary_invmask(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: out_constant_42_vary_invmask:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a0, a2
; CHECK-I-NEXT:    andi a0, a0, 42
; CHECK-I-NEXT:    and a1, a2, a1
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: out_constant_42_vary_invmask:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    li a0, 42
; CHECK-ZBB-NEXT:    andn a0, a0, a2
; CHECK-ZBB-NEXT:    and a1, a2, a1
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %mx = and i32 %notmask, 42
  %my = and i32 %mask, %y
  %r = or i32 %mx, %my
  ret i32 %r
}

; This is not a canonical form. Testing for completeness only.
define i32 @in_constant_42_vary_invmask(i32 %x, i32 %y, i32 %mask) {
; CHECK-I-LABEL: in_constant_42_vary_invmask:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    not a0, a2
; CHECK-I-NEXT:    xori a2, a1, 42
; CHECK-I-NEXT:    and a0, a2, a0
; CHECK-I-NEXT:    xor a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: in_constant_42_vary_invmask:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    andn a0, a2, a1
; CHECK-ZBB-NEXT:    ori a1, a2, 42
; CHECK-ZBB-NEXT:    andn a0, a1, a0
; CHECK-ZBB-NEXT:    ret
  %notmask = xor i32 %mask, -1
  %n0 = xor i32 42, %y ; %x
  %n1 = and i32 %n0, %notmask
  %r = xor i32 %n1, %y
  ret i32 %r
}

; ============================================================================ ;
; Negative tests. Should not be folded.
; ============================================================================ ;

; Multi-use tests.
declare void @use32(i32) nounwind
define i32 @in_multiuse_A(i32 %x, i32 %y, i32 %z, i32 %mask) nounwind {
; RV32-LABEL: in_multiuse_A:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32-NEXT:    mv s0, a1
; RV32-NEXT:    xor a0, a0, a1
; RV32-NEXT:    and s1, a0, a3
; RV32-NEXT:    mv a0, s1
; RV32-NEXT:    call use32
; RV32-NEXT:    xor a0, s1, s0
; RV32-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: in_multiuse_A:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -32
; RV64-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64-NEXT:    mv s0, a1
; RV64-NEXT:    xor a0, a0, a1
; RV64-NEXT:    and s1, a0, a3
; RV64-NEXT:    mv a0, s1
; RV64-NEXT:    call use32
; RV64-NEXT:    xor a0, s1, s0
; RV64-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64-NEXT:    addi sp, sp, 32
; RV64-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  call void @use32(i32 %n1)
  %r = xor i32 %n1, %y
  ret i32 %r
}

define i32 @in_multiuse_B(i32 %x, i32 %y, i32 %z, i32 %mask) nounwind {
; RV32-LABEL: in_multiuse_B:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32-NEXT:    mv s0, a1
; RV32-NEXT:    xor a0, a0, a1
; RV32-NEXT:    and s1, a0, a3
; RV32-NEXT:    call use32
; RV32-NEXT:    xor a0, s1, s0
; RV32-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: in_multiuse_B:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -32
; RV64-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64-NEXT:    mv s0, a1
; RV64-NEXT:    xor a0, a0, a1
; RV64-NEXT:    and s1, a0, a3
; RV64-NEXT:    call use32
; RV64-NEXT:    xor a0, s1, s0
; RV64-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64-NEXT:    addi sp, sp, 32
; RV64-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  call void @use32(i32 %n0)
  %r = xor i32 %n1, %y
  ret i32 %r
}

; Various bad variants
define i32 @n0_badmask(i32 %x, i32 %y, i32 %mask, i32 %mask2) {
; CHECK-I-LABEL: n0_badmask:
; CHECK-I:       # %bb.0:
; CHECK-I-NEXT:    and a0, a0, a2
; CHECK-I-NEXT:    not a2, a3
; CHECK-I-NEXT:    and a1, a1, a2
; CHECK-I-NEXT:    or a0, a0, a1
; CHECK-I-NEXT:    ret
;
; CHECK-ZBB-LABEL: n0_badmask:
; CHECK-ZBB:       # %bb.0:
; CHECK-ZBB-NEXT:    and a0, a0, a2
; CHECK-ZBB-NEXT:    andn a1, a1, a3
; CHECK-ZBB-NEXT:    or a0, a0, a1
; CHECK-ZBB-NEXT:    ret
  %mx = and i32 %x, %mask
  %notmask = xor i32 %mask2, -1 ; %mask2 instead of %mask
  %my = and i32 %y, %notmask
  %r = or i32 %mx, %my
  ret i32 %r
}

define i32 @n0_badxor(i32 %x, i32 %y, i32 %mask) {
; CHECK-LABEL: n0_badxor:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and a0, a0, a2
; CHECK-NEXT:    xori a2, a2, 1
; CHECK-NEXT:    and a1, a1, a2
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    ret
  %mx = and i32 %x, %mask
  %notmask = xor i32 %mask, 1 ; instead of -1
  %my = and i32 %y, %notmask
  %r = or i32 %mx, %my
  ret i32 %r
}

define i32 @n1_thirdvar(i32 %x, i32 %y, i32 %z, i32 %mask) {
; CHECK-LABEL: n1_thirdvar:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xor a0, a0, a1
; CHECK-NEXT:    and a0, a0, a3
; CHECK-NEXT:    xor a0, a0, a2
; CHECK-NEXT:    ret
  %n0 = xor i32 %x, %y
  %n1 = and i32 %n0, %mask
  %r = xor i32 %n1, %z ; instead of %y
  ret i32 %r
}
